/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.param;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.fm.rpt.liquid.param.LiquidBaseParamRelation;

public class LiquidFlowIODetailParamRelation
extends LiquidBaseParamRelation {
    public void dataChange(String paramName) throws Exception {
        super.dataChange(paramName);
        if (paramName.equals("queryType")) {
            this.setQueryTypeChecked();
        } else if (paramName.equals("currency")) {
            this.paramRelationHelper.checkCurrencyHasExchangeRate(this.currentCompany, this.baseCurrency, (KDBizPromptBox)this.getComponent(paramName));
        }
    }

    protected void companyOnChange() throws BOSException, Exception {
        super.companyOnChange();
        this.setQueryTypesDefaultCheck();
    }

    private void setQueryTypeChecked() {
        KDCheckBox[] chkQueryTypes = (KDCheckBox[])this.getComponent("queryType");
        if (chkQueryTypes[0].isFocusOwner()) {
            chkQueryTypes[1].setSelected(!chkQueryTypes[0].isSelected());
        } else if (chkQueryTypes[1].isFocusOwner()) {
            chkQueryTypes[0].setSelected(!chkQueryTypes[1].isSelected());
        }
    }

    private boolean checkDateRange() {
        KDDatePicker dpkBeginDate = (KDDatePicker)this.getComponent("beginDate");
        KDDatePicker dpkEndDate = (KDDatePicker)this.getComponent("endDate");
        return this.paramRelationHelper.checkDateRange(dpkBeginDate, dpkEndDate);
    }

    public boolean confirmFilterBefore() throws Exception {
        if (!this.checkBeginAndEndDate() || !this.checkDateRange()) {
            return false;
        }
        this.setIsDiffYearParam();
        return super.confirmFilterBefore();
    }

    protected void initComponentParams() throws Exception {
        super.initComponentParams();
        KDBizPromptBox flowItemF7 = (KDBizPromptBox)this.getComponent("flowItem");
        this.paramRelationHelper.initFundFlowItemF7(flowItemF7, true, null);
        this.setQueryTypesDefaultCheck();
        this.deleteEmptyItem("staticUnit");
    }

    private void setQueryTypesDefaultCheck() throws EASBizException, BOSException {
        boolean isIsBizUnit = false;
        if (this.isOrgUnion()) {
            String companyId = this.getComponentValue("companyUnion");
            isIsBizUnit = LiquidCompanyHelper.isOrgLeaf(null, (String)companyId);
        } else {
            KDBizPromptBox companyF7 = (KDBizPromptBox)this.getComponent("company");
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)companyF7.getValue();
            isIsBizUnit = companyOrgUnitInfo.isIsBizUnit();
        }
        this.setComponentVisible("queryType", null, !isIsBizUnit, true);
        KDCheckBox chkVirtualCompany = (KDCheckBox)this.getComponent("isVirtualCompany");
        chkVirtualCompany.setSelected(!isIsBizUnit, false);
        if (isIsBizUnit) {
            KDCheckBox[] chkQueryTypes;
            for (KDCheckBox kdCheckBox : chkQueryTypes = (KDCheckBox[])this.getComponent("queryType")) {
                DefObj value = (DefObj)kdCheckBox.getUserObject();
                kdCheckBox.setSelected("2".equals(value.getName()));
            }
        }
    }
}

