/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.param;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.rpt.common.RptHelper;
import com.kingdee.eas.fm.rpt.liquid.param.LiquidBaseParamRelation;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import java.util.Date;

public class LiquidStockDetailParamRelation
extends LiquidBaseParamRelation {
    private static final int MAX_PERIOD_COUNT = 31;

    protected boolean isOneStyle() {
        return false;
    }

    protected boolean isOrgUnion() {
        return false;
    }

    public void dataChange(String paramName) throws Exception {
        super.dataChange(paramName);
        if (paramName.equals("queryCycle") || paramName.equals("beginDate") || paramName.equals("endDate")) {
            this.setBeginAndEndDate(paramName, false);
        } else if (paramName.equals("queryFields")) {
            KDCheckBox[] chkQueryFields = (KDCheckBox[])this.getComponent("queryFields");
            this.setQueryFieldsChecked(chkQueryFields, false);
        } else if (paramName.equals("showParams")) {
            KDCheckBox[] showParams = (KDCheckBox[])this.getComponent("showParams");
            this.setOnChangeBalance(showParams, false);
            this.setOnChangeShowBaseCurrency(showParams, false);
        } else if (paramName.equals("currency")) {
            this.paramRelationHelper.checkCurrencyHasExchangeRate(this.currentCompany, this.baseCurrency, (KDBizPromptBox)this.getComponent(paramName));
        }
    }

    private void setQueryFieldsChecked(KDCheckBox[] chkQueryFields, boolean isInit) {
        boolean isSelected = false;
        for (KDCheckBox kdCheckBox : chkQueryFields) {
            DefObj value = (DefObj)kdCheckBox.getUserObject();
            if ("1".equals(value.getName())) {
                if (!isInit && !kdCheckBox.isFocusOwner()) {
                    return;
                }
                isSelected = kdCheckBox.isSelected();
                continue;
            }
            if (!"4".equals(value.getName())) continue;
            if (isSelected) {
                kdCheckBox.setSelected(true, false);
            }
            kdCheckBox.setEnabled(!isSelected);
        }
    }

    private void setBeginAndEndDate(String paramName, boolean isInit) throws Exception {
        BgPeriodInfo bgPeriodInfo;
        String queryCycleString = this.getComponentValue("queryCycle");
        if ("-1".equals(queryCycleString)) {
            return;
        }
        int queryCycle = Integer.parseInt(queryCycleString);
        KDDatePicker dpkBeginDate = (KDDatePicker)this.getComponent("beginDate");
        KDDatePicker dpkEndDate = (KDDatePicker)this.getComponent("endDate");
        if (paramName.equals("queryCycle") && !isInit) {
            dpkBeginDate.setValue((Object)DateUtil.getDayBegin(), false);
            dpkEndDate.setValue((Object)DateUtil.getDayBegin(), false);
        }
        try {
            this.paramRelationHelper.setBeginAndEndDate(paramName, dpkBeginDate, dpkEndDate, queryCycle);
        }
        catch (LiquidException e) {
            if (!isInit) {
                RptHelper.handleException(e);
            }
            this.setComponentValue("queryCycle", "-1", true);
            dpkBeginDate.setValue((Object)DateUtil.getDayBegin(), false);
            dpkEndDate.setValue((Object)dpkBeginDate.getSqlDate(), false);
        }
        if (isInit && (bgPeriodInfo = LiquidHelper.getBgPeriodInfoByDateAndCycle(null, (Date)dpkEndDate.getSqlDate(), (int)queryCycle)) != null) {
            dpkEndDate.setValue((Object)bgPeriodInfo.getEndDate(), false);
        }
    }

    private void setOnChangeShowBaseCurrency(KDCheckBox[] showParams, boolean isInit) {
        KDCheckBox[] chkDemensions;
        boolean isSelected = false;
        for (KDCheckBox kdCheckBox : showParams) {
            DefObj value = (DefObj)kdCheckBox.getUserObject();
            if (!"1".equals(value.getName())) continue;
            if (!isInit && !kdCheckBox.isFocusOwner()) {
                return;
            }
            isSelected = kdCheckBox.isSelected();
            break;
        }
        for (KDCheckBox kdCheckBox : chkDemensions = (KDCheckBox[])this.getComponent("dimensions")) {
            DefObj value = (DefObj)kdCheckBox.getUserObject();
            if (!"1".equals(value.getName())) continue;
            if (isSelected) {
                kdCheckBox.setSelected(true, false);
            }
            kdCheckBox.setEnabled(!isSelected);
            break;
        }
    }

    private void setOnChangeBalance(KDCheckBox[] showParams, boolean isInit) {
        KDCheckBox[] chkQueryFields;
        boolean isBalanceChangenaly = true;
        for (KDCheckBox kdCheckBox : showParams) {
            DefObj value = (DefObj)kdCheckBox.getUserObject();
            if (!"2".equals(value.getName())) continue;
            if (!isInit && !kdCheckBox.isFocusOwner()) {
                return;
            }
            isBalanceChangenaly = kdCheckBox.isSelected();
            break;
        }
        for (KDCheckBox kdCheckBox : chkQueryFields = (KDCheckBox[])this.getComponent("queryFields")) {
            kdCheckBox.setEnabled(!isBalanceChangenaly);
            if (!isBalanceChangenaly) continue;
            DefObj value = (DefObj)kdCheckBox.getUserObject();
            kdCheckBox.setSelected("4".equals(value.getName()), false);
        }
    }

    private boolean checkMaxPeriodCount() throws BOSException, EASBizException {
        String queryCycleString = this.getComponentValue("queryCycle");
        if (EmptyUtil.isEmpty((String)queryCycleString)) {
            return true;
        }
        Date beginDate = DateUtil.stringToDate((String)this.getComponentValue("beginDate"));
        Date endDate = DateUtil.stringToDate((String)this.getComponentValue("endDate"));
        int queryCycle = Integer.parseInt(queryCycleString);
        return this.paramRelationHelper.checkMaxPeriodCount(queryCycle, beginDate, endDate, 31);
    }

    public boolean confirmFilterBefore() throws Exception {
        if (!this.checkBeginAndEndDate() || !this.checkMaxPeriodCount()) {
            return false;
        }
        this.setAmountFields();
        return super.confirmFilterBefore();
    }

    private void setAmountFields() {
        KDTextField txtAmountFields = (KDTextField)this.getComponent("amountFields");
        StringBuffer amountFields = new StringBuffer();
        KDCheckBox[] queryFields = (KDCheckBox[])this.getComponent("queryFields");
        int length = queryFields.length;
        for (int i = 1; i < length; ++i) {
            if (!queryFields[i].isSelected()) continue;
            if (amountFields.length() > 0) {
                amountFields.append("0xx1xx");
            }
            amountFields.append(queryFields[i].getText());
        }
        if (amountFields.length() > 0) {
            amountFields.append("0xx1xx");
        }
        txtAmountFields.setText(amountFields.toString());
    }

    protected void initComponentParams() throws Exception {
        super.initComponentParams();
        KDBizPromptBox bankF7 = (KDBizPromptBox)this.getComponent("bank");
        bankF7.setDisplayFormat("$number$-$name$");
        this.deleteEmptyItem("queryCycle");
        this.paramRelationHelper.addSelfCustomItem((KDComboBox)this.getComponent("queryCycle"));
        this.setBeginAndEndDate("beginDate", true);
        this.setOnCheckChangeTred();
        KDCheckBox[] showParams = (KDCheckBox[])this.getComponent("showParams");
        this.setOnChangeBalance(showParams, true);
        this.setOnChangeShowBaseCurrency(showParams, true);
        KDCheckBox[] chkQueryFields = (KDCheckBox[])this.getComponent("queryFields");
        this.setQueryFieldsChecked(chkQueryFields, true);
        this.deleteEmptyItem("staticUnit");
    }

    private void setOnCheckChangeTred() {
        KDCheckBox chkChangeTred = (KDCheckBox)this.getComponent("isChangeTred");
        boolean isChangeTred = chkChangeTred.isSelected();
        if (isChangeTred) {
            KDCheckBox[] showParams;
            this.setComponentVisible("dimensions", null, false, true);
            this.setComponentVisible("queryFields", null, false, true);
            for (KDCheckBox kdCheckBox : showParams = (KDCheckBox[])this.getComponent("showParams")) {
                String value = ((DefObj)kdCheckBox.getUserObject()).getName();
                if (!"2".equals(value) && !"1".equals(value)) continue;
                kdCheckBox.setVisible(false);
            }
        }
    }
}

