/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.sl.LoanContractAdjustCollection;
import com.kingdee.eas.fm.sl.LoanContractAdjustFactory;
import com.kingdee.eas.fm.sl.LoanContractAdjustInfo;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractAdjustEditUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanContractAdjustEditUI
extends AbstractLoanContractAdjustEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractAdjustEditUI.class);
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        super.loadFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.disposeUIWindow();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractAdjustFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.setdisplayStyle();
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    public void setdisplayStyle() {
        SLUtils.setNumberKdtextFieldStyle(this.txtAdjustSeq);
        SLUtils.setNumberKdtextFieldStyle(this.txtYearDays);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtAdjustYieldRate, SLUtils.maxValue, Constants.ZERO, 10);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtAdjustPenAccrualRate, Constants.ONE_HUNDRED, Constants.ZERO, 5);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAdjustYieldRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAdjustPenAccrualRate);
        this.pkAdjustDate.setSupportedEmpty(false);
    }

    protected IObjectValue createNewData() {
        LoanContractAdjustInfo info = new LoanContractAdjustInfo();
        info.setCompany(this.currentCompany);
        info.setCreator(this.userinfo);
        info.setAdjustDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (this.getUIContext().get("LoanContractAdjustID") != null) {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("LoanContractAdjustID");
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("contractNum"));
                LoanContractInfo contractInfo = LoanContractFactory.getRemoteInstance().getLoanContractInfo(pk, sic);
                if (contractInfo != null) {
                    this.resetLoanContractAdjustSeq(info, contractInfo);
                    info.setSourceBillNum(contractInfo);
                    info.setLoanContractNum(contractInfo.getContractNum());
                    info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
                    info.setYearDays(360);
                    info.setAdjustYieldRate(Constants.ZERO);
                    info.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
                    info.setAdjustPenAccrualRate(Constants.ZERO);
                    String summary = "\u94f6\u56e2\u8d37\u6b3e" + contractInfo.getContractNum() + "\u7b2c" + info.getAdjustSeq() + "\u6b21\u8c03\u606f";
                    info.setSummary(summary);
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return info;
    }

    private void resetLoanContractAdjustSeq(LoanContractAdjustInfo info, LoanContractInfo contractInfo) {
        int newAdjustSeq = 1;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adjustSeq"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillNum", (Object)contractInfo.getId().toString()));
        view.setFilter(filter);
        try {
            LoanContractAdjustCollection colls = LoanContractAdjustFactory.getRemoteInstance().getLoanContractAdjustCollection(view);
            if (colls != null) {
                newAdjustSeq = colls.size() + 1;
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        info.setAdjustSeq(newAdjustSeq);
    }

    public static void show(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"LoanContractAdjustID", (Object)pk);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanContractAdjustEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    protected void comboIntRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"40_AdjustYieldRate"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"41_AdjustYieldRate"));
        } else {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"41_AdjustYieldRate"));
        }
    }

    @Override
    protected void comboPenAccrualType_actionPerformed(ActionEvent e) throws Exception {
        PenAccrualTypeEnum penTtpe = (PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem();
        if (penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.txtAdjustPenAccrualRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"43_adjustDailyrate"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.txtAdjustPenAccrualRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"42_adjustPenerate"));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("summary"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("sourceBillNum.id"));
        sic.add(new SelectorItemInfo("sourceBillNum.number"));
        sic.add(new SelectorItemInfo("isUsed"));
        sic.add(new SelectorItemInfo("loanContractNum"));
        sic.add(new SelectorItemInfo("adjustSeq"));
        sic.add(new SelectorItemInfo("adjustDate"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("adjustYieldRate"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("adjustPenAccrualRate"));
        return sic;
    }
}

