/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.sl.LoanContractAdjustFactory;
import com.kingdee.eas.fm.sl.LoanContractAdjustInfo;
import com.kingdee.eas.fm.sl.LoanContractCollection;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractAdjustUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanContractAdjustUI
extends AbstractLoanContractAdjustUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractAdjustUI.class);
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private EntityViewInfo evi = null;
    private FilterItemInfo currencyFilter = null;
    private static Map hm = new HashMap();
    private Set createdIntReceivedID;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        LoanContractAdjustInfo info = new LoanContractAdjustInfo();
        info.setCompany(this.CURRENT_COMPANY);
        LoanContractInfo sourceInfo = (LoanContractInfo)this.prmtSourceBillNum.getValue();
        if (sourceInfo != null) {
            info.setLoanContractNum(sourceInfo.getNumber());
        }
        info.setSourceBillNum(sourceInfo);
        info.setAdjustDate(this.pkAdjustDate.getSqlDate());
        info.setIntRateTypeExpression((IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem());
        info.setYearDays(this.txtYearDays.getIntegerValue());
        info.setAdjustYieldRate(this.txtAdjustYieldRate.getBigDecimalValue());
        info.setPenAccrualType((PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem());
        info.setAdjustPenAccrualRate(this.txtAdjustPenAccrualRate.getBigDecimalValue());
        info.setIsUsed(false);
        hm = LoanContractAdjustFactory.getRemoteInstance().adjust(info);
        this.createdIntReceivedID = (Set)hm.get("createdIdSet");
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"270_LoanAdjustInterestUI"));
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    private LoanContractInfo getLoanContractInfoByNumber(String number) throws Exception {
        if (number == null) {
            return null;
        }
        LoanContractInfo resInfo = null;
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        sic.add(new SelectorItemInfo("id"));
        viewC.setFilter(filter);
        viewC.setSelector(sic);
        LoanContractCollection colls = LoanContractFactory.getRemoteInstance().getLoanContractCollection(viewC);
        if (colls != null && colls.size() > 0) {
            resInfo = colls.get(0);
        }
        return resInfo;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        this.destroyWindow();
    }

    public void onLoad() throws Exception {
        SLUtils.setNumberKdtextFieldStyle(this.txtYearDays);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtAdjustYieldRate, SLUtils.maxValue, Constants.ZERO, 10);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtAdjustPenAccrualRate, Constants.ONE_HUNDRED, Constants.ZERO, 5);
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.evi = this.getLoanContractFilter();
        this.prmtSourceBillNum.setEntityViewInfo(this.evi);
        CurrencyUtil.fillCombCurrency((KDComboBox)this.prmtCurrency);
        this.prmtCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        this.txtYearDays.setValue((Object)new Integer(360));
        this.txtAdjustYieldRate.setValue((Object)Constants.ZERO);
        this.txtAdjustPenAccrualRate.setValue((Object)Constants.ZERO);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAdjustYieldRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAdjustPenAccrualRate);
    }

    @Override
    protected void comboIntRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"40_AdjustYieldRate"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"41_AdjustYieldRate"));
        } else {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"41_AdjustYieldRate"));
        }
    }

    @Override
    protected void comboPenAccrualType_actionPerformed(ActionEvent e) throws Exception {
        PenAccrualTypeEnum penTtpe = (PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem();
        if (penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.txtAdjustPenAccrualRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"43_adjustDailyrate"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.txtAdjustPenAccrualRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"42_adjustPenerate"));
        }
    }

    public static Map showLoanAdjustInterestUI(CoreUI ui) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        Map returnValue = new HashMap();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanContractAdjustUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        returnValue = ((LoanContractAdjustUI)uiWindow.getUIObject()).getReturnValue();
        return returnValue;
    }

    public Map getReturnValue() {
        return hm;
    }

    @Override
    protected void prmtCurrency_itemStateChanged(ItemEvent e) throws Exception {
        Object currencyObj;
        super.prmtCurrency_itemStateChanged(e);
        if (this.currencyFilter != null) {
            if (this.evi.getFilter().getFilterItems().contains(this.currencyFilter)) {
                this.evi.getFilter().getFilterItems().remove(this.currencyFilter);
            }
            this.currencyFilter.clear();
        }
        if ((currencyObj = this.prmtCurrency.getSelectedItem()) != null && currencyObj instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)currencyObj;
            this.currencyFilter = new FilterItemInfo("Currency.id", (Object)currency.getId().toString(), CompareType.EQUALS);
            this.evi.getFilter().getFilterItems().add(this.currencyFilter);
        }
        this.prmtSourceBillNum.setEntityViewInfo(this.evi);
        this.prmtSourceBillNum.setValue(null);
    }

    @Override
    public void prmtSourceBillNum_willShow(SelectorEvent e) {
        this.evi = this.getLoanContractFilter();
        Object currencyObj = this.prmtCurrency.getSelectedItem();
        if (currencyObj != null && currencyObj instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)currencyObj;
            this.currencyFilter = new FilterItemInfo("Currency.id", (Object)currency.getId().toString(), CompareType.EQUALS);
            this.evi.getFilter().getFilterItems().add(this.currencyFilter);
        }
        this.prmtSourceBillNum.setEntityViewInfo(this.evi);
    }

    protected EntityViewInfo getLoanContractFilter() {
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(new FilterInfo());
        String companyId = this.CURRENT_COMPANY.getId().toString();
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("totalBalance", (Object)Constants.ZERO, CompareType.GREATER));
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("IntRateType.id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ="));
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS));
        return evi2;
    }

    private Map getReturnValueWithMsg() {
        return hm;
    }
}

