/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.LoanContractRepayFactory;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractRepayListUI;
import com.kingdee.eas.fm.sl.client.LoanContractRepayEditUI;
import com.kingdee.eas.fm.sl.client.LoanContractRepayFilterParam;
import com.kingdee.eas.fm.sl.client.LoanContractRepayFilterUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LoanContractRepayListUI
extends AbstractLoanContractRepayListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractRepayListUI.class);
    private LoanContractRepayFilterUI filterUI;
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.setBtnDisplayInBizUnit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setBtnDisplayInBizUnit() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        this.menuEdit.setVisible(!isBizUnit);
        this.menuBiz.setVisible(!isBizUnit);
        this.actionEdit.setVisible(!isBizUnit);
        this.actionRemove.setVisible(!isBizUnit);
        this.actionAudit.setVisible(!isBizUnit);
        this.actionAntiAudit.setVisible(!isBizUnit);
        this.actionGenPay.setVisible(!isBizUnit);
        this.actionVoucher.setEnabled(!isBizUnit);
        this.actionVoucher.setVisible(!isBizUnit);
        this.actionDelVoucher.setEnabled(!isBizUnit);
        this.actionDelVoucher.setVisible(!isBizUnit);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionGenPay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionGenPay.setEnabled(true);
        this.actionAddNew.setVisible(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractRepayFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return LoanContractRepayEditUI.class.getName();
    }

    protected IObjectValue createNewData() {
        LoanContractRepayInfo objectValue = new LoanContractRepayInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanContractRepayFilterUI();
        }
        return this.filterUI;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        LoanContractRepayInfo info;
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        if (SLUtils.existsDestBillSet(billId)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u4fee\u6539");
            SysUtil.abort();
        }
        if (!(info = (LoanContractRepayInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(billId))).getStatus().equals((Object)FsBillStatusEnum.SUBMIT)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u4fee\u6539");
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected boolean isMutiRemove() {
        return false;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        LoanContractRepayInfo info = (LoanContractRepayInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info != null && info.getStatus() == FsBillStatusEnum.AUDIT) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"15_SubmitStatus_can_audit");
        }
        LoanContractRepayFactory.getRemoteInstance().audit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractRepayInfo info = (LoanContractRepayInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getStatus() != FsBillStatusEnum.AUDIT) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"16_Audit_not_relation_can_unAudit");
        }
        LoanContractRepayFactory.getRemoteInstance().antiAudit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionGenPay_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSelectOneItem((CoreUI)this, this.tblMain);
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractRepayInfo info = (LoanContractRepayInfo)this.getBizInterface().getValue((IObjectPK)pk);
        this.checkGenPay(info);
        this.actionCreateTo_actionPerformed(e);
        this.refreshList();
    }

    private void checkGenPay(LoanContractRepayInfo info) {
        if (info != null && (info.getStatus() != FsBillStatusEnum.AUDIT || info.isIsGenPay())) {
            MsgBox.showWarning((String)"\u5df2\u5ba1\u6279\u7684\u4e14\u672a\u751f\u6210\u4ed8\u6b3e\u5355\u7684\u8bb0\u5f55\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355");
            SysUtil.abort();
        }
    }

    private void checkSelectOneItem(CoreUI ui, KDTable table) {
        int size = KDTableUtil.getSelectedRowCount((KDTable)this.tblMain);
        if (size > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5355\u7b14\u8bb0\u5f55\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355");
            SysUtil.abort();
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LoanContractRepayFilterParam param = (LoanContractRepayFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new String[]{"loanAmount", "RepayAmount", "LocalAmount", "TotalAddAmount", "Balance", "Interest", "Repayment"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected boolean isVoucherVisible() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        return !isBizUnit;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractRepayInfo info = (LoanContractRepayInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.isFivouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (e == null) {
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                String rateExpression;
                row = LoanContractRepayListUI.this.tblMain.getRow(i);
                currencyId = (String)row.getCell("Currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"loanAmount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"RepayAmount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"TotalAddAmount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Balance", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Interest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Repayment", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"TotalAddAmount", (String)currencyId);
                }
                if (row.getCell("Rate").getValue() != null) {
                    row.getCell("Rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
                if (row.getCell("intRateTypeExpression").getValue() != null && (rateExpression = row.getCell("intRateTypeExpression").getValue().toString()) != null) {
                    if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                        row.getCell("Rate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!%");
                    } else {
                        row.getCell("Rate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!\u2030");
                    }
                }
                if (row.getCell("LocalCurExRate").getValue() != null) {
                    row.getCell("LocalCurExRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row.getCell("LocalCurExRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)6));
                }
                if (row.getCell("RepaySeq").getValue() != null) {
                    row.getCell("RepaySeq").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
                if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"LocalAmount", (String)baseCurrency);
            }
        }
    }
}

