/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryCollection;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanFetchEditUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LoanFetchEditUI
extends AbstractLoanFetchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanFetchEditUI.class);
    private static final BigDecimal maxValue = new BigDecimal("9999999999999");
    private static final BigDecimal minValue = Constants.ZERO;
    private static final BigDecimal largeMaxValue = new BigDecimal("99999999999999999999999999");
    private static boolean isFirstEnter = false;
    private CurrencyInfo currencyInfo = null;
    private boolean isCreateFrom = false;
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    private Date BizDate = new Date();
    private boolean isNeedChange = false;
    private boolean isFirstFetchItem = false;

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("TargetBill", "LoanFetch");
        ctx.put("isCreateLoanFetch", "isCreateLoanFetch");
        this.getBillEdit().createFrom(null, ctx);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyComps(e);
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyComps(e);
        super.actionSubmit_actionPerformed(e);
    }

    private void removeTotalRow_LoanBankEntry() {
        int index = this.findLoanBankEntry();
        if (index != -1) {
            this.kdtLoanBankEntry.removeRow(index);
        }
    }

    private void resetTotalRow_LoanBankEntry() {
        if (this.kdtLoanBankEntry.getRowCount() == 0) {
            return;
        }
        this.addTotalRow_LoanBankEntry();
        int idx = this.findLoanBankEntry();
        if (idx != -1) {
            IRow totalRow = this.kdtLoanBankEntry.getRow(idx);
            totalRow.getCell("promiseProportion").setValue((Object)this.calculateLoanBankEntry("promiseProportion"));
            totalRow.getCell("promiseLoanAmount").setValue((Object)this.calculateLoanBankEntry("promiseLoanAmount"));
        }
    }

    private BigDecimal calculateLoanBankEntry(String key) {
        int rowCount = this.kdtLoanBankEntry.getRowCount();
        BigDecimal sum = Constants.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtLoanBankEntry.getRow(i);
            if (row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) continue;
            sum = FMHelper.add((BigDecimal)sum, (BigDecimal)((BigDecimal)row.getCell(key).getValue()));
        }
        return sum;
    }

    private int findLoanBankEntry() {
        int rowCount = this.kdtLoanBankEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kdtLoanBankEntry.getRow(i);
            if (!row.getStyleAttributes().getBackground().equals(new Color(0xF6F6B6))) continue;
            return i;
        }
        return -1;
    }

    private void addTotalRow_LoanBankEntry() {
        int idx = this.findLoanBankEntry();
        if (idx == -1) {
            IRow totalRow = this.kdtLoanBankEntry.addRow();
            totalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            totalRow.getStyleAttributes().setLocked(true);
            totalRow.getCell(0).setValue((Object)"\u5408\u8ba1");
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanFetchFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        LoanFetchInfo info = new LoanFetchInfo();
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(this.userinfo);
        info.setCompany(this.currentCompany);
        info.setBizDate(new Date());
        info.setLoanPromiseAmount(Constants.ZERO);
        info.setNotFetchAmount(Constants.ZERO);
        info.setLocalCurExRate(Constants.ONE);
        info.setAmount(Constants.ZERO);
        info.setBalance(Constants.ZERO);
        info.setAmountLocalCur(Constants.ZERO);
        info.setFetchSeq(1);
        info.setIssueDate(new Date());
        info.setExpiredDate(new Date());
        info.setHorizon(Constants.ZERO);
        info.setIntRateType(this.getIntRateTypeInfo());
        info.setFloatAction(FloatActionEnum.BASEINTRATE_FLOAT);
        info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
        info.setBasePoints(Constants.ZERO);
        info.setFirstRateAdjustDate(new Date());
        info.setRateAdjustPeriod(0);
        info.setYearDays(360);
        info.setYieldRate(Constants.ZERO);
        info.setPenAccrualRate(Constants.ZERO);
        info.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        info.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.notassure);
        info.setStatus(FsBillStatusEnum.SAVE);
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        this.verifyCompsWhenNotNll(e);
    }

    private void verifyComps(ActionEvent e) throws Exception {
        int loanBankCount = this.kdtLoanBankEntry.getRowCount();
        BigDecimal totalPropertion = Constants.ZERO;
        BigDecimal totalPromiseAmount = Constants.ZERO;
        BigDecimal fetchAmount = this.txtAmount.getBigDecimalValue();
        CurrencyInfo cur = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        if (loanBankCount > 0) {
            totalPropertion = (BigDecimal)this.kdtLoanBankEntry.getRow(loanBankCount - 1).getCell("promiseProportion").getValue();
            totalPropertion = totalPropertion.setScale(cur.getPrecision(), 4);
            totalPromiseAmount = (BigDecimal)this.kdtLoanBankEntry.getRow(loanBankCount - 1).getCell("promiseLoanAmount").getValue();
            totalPromiseAmount = totalPromiseAmount.setScale(cur.getPrecision(), 4);
            if (loanBankCount > 1 && totalPropertion.compareTo(Constants.ONE_HUNDRED) != 0) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8d37\u6b3e\u884c\u5206\u5f55\u63d0\u6b3e\u6bd4\u4f8b\u4e4b\u548c\u5e94\u7b49\u4e8e100%");
                SysUtil.abort();
            }
            if (loanBankCount > 1 && totalPromiseAmount.compareTo(fetchAmount) != 0) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8d37\u6b3e\u884c\u5206\u5f55\u8d37\u6b3e\u989d\u4e4b\u548c\u5e94\u7b49\u4e8e\u672c\u6b21\u63d0\u6b3e\u989d");
                SysUtil.abort();
            }
        }
    }

    private void verifyCompsWhenNotNll(ActionEvent e) throws Exception {
        if (!FMHelper.isEmpty((Object)this.txtAmount.getBigDecimalValue())) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        }
        if (!FMHelper.isEmpty((Object)this.txtBalance.getBigDecimalValue())) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtBalance);
        }
        if (!FMHelper.isEmpty((Object)this.txtAmount.getBigDecimalValue())) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        BigDecimal txtAmountValue = this.txtAmount.getBigDecimalValue();
        if (!FMHelper.isEmpty((Object)txtAmountValue)) {
            FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        java.sql.Date issueDate = this.pkIssueDate.getSqlDate();
        java.sql.Date expireDate = this.pkExpiredDate.getSqlDate();
        if (!(FMHelper.isEmpty((Object)issueDate) || FMHelper.isEmpty((Object)expireDate) || expireDate.after(issueDate))) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u8d77\u59cb\u65e5");
            this.pkIssueDate.requestFocus(true);
            SysUtil.abort();
        }
        if (this.pkFirstRateAdjustDate.isEnabled() && !FMHelper.isEmpty((Object)this.pkFirstRateAdjustDate.getValue())) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkFirstRateAdjustDate);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        this.checkLoanBankNotNull();
    }

    private void checkLoanBankNotNull() {
        int len = this.kdtLoanBankEntry.getRowCount();
        if (len > 0) {
            for (int i = 0; i < len - 1; ++i) {
                IRow row = this.kdtLoanBankEntry.getRow(i);
                FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtLoanBankEntry, (IRow)row, (String)"lenderProperty");
                FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtLoanBankEntry, (IRow)row, (String)"loanBank");
                FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtLoanBankEntry, (IRow)row, (String)"promiseProportion");
                FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtLoanBankEntry, (IRow)row, (String)"promiseLoanAmount");
                if (FMHelper.isEmpty((Object)row.getCell("CreditCurrency").getValue())) continue;
                FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtLoanBankEntry, (IRow)row, (String)"CreditCurExRate");
                FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.kdtLoanBankEntry, (IRow)row, (String)"CreditAmount");
            }
        }
    }

    protected IntRateTypeInfo getIntRateTypeInfo() {
        IntRateTypeInfo ifInfo = null;
        try {
            ifInfo = IntRateTypeFactory.getRemoteInstance().getIntRateTypeInfo((IObjectPK)new ObjectUuidPK("lJlpCQEQEADgAAc+wKgSjiR9knQ="));
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return ifInfo;
    }

    @Override
    public void loadFields() {
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.editData != null) {
            this.currentCompany = this.editData.getCompany();
        }
        if (!isFirstEnter) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        }
        this.combGTInputMode.setSelectedItem((Object)this.editData.getGuaranteeTypeInputMode());
        this.prmtMainGT.setData((Object)this.editData.getGaranteeType());
        super.loadFields();
        super.loadEntrysFields((FinancingBillInfo)this.editData);
        this.loadEntrysFieldsStyle();
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.editData.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.currentCompany.getBaseCurrency());
        }
        this.currencyInfo = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        this.loadLoanBankEntrysFieldsStyle();
        this.isCreateFrom = false;
        this.loadKdtableDisplayStauts();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.setExtendStyle(this.editData);
        this.pkFirstRateAdjustDate.setEnabled(false);
    }

    protected void loadKdtableDisplayStauts() {
        GuaranteeTypeInputModeEnum gtimEnum = (GuaranteeTypeInputModeEnum)this.combGTInputMode.getSelectedItem();
        GuaranteeTypePropertyEnum gtpEnum = null;
        if (!(gtimEnum == null || gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.other) || gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.mix) || gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.notassure))) {
            if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.assure)) {
                gtpEnum = GuaranteeTypePropertyEnum.assure;
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelGuara);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, true);
                this.kDTabbedPaneEntry.setEnabledAt(2, false);
                this.kDTabbedPaneEntry.setEnabledAt(3, false);
                this.kDTabbedPaneEntry.setEnabledAt(4, false);
                this.kDTabbedPaneEntry.setEnabledAt(5, false);
                this.kDPledge.removeRows();
                this.kDImpawn.removeRows();
                this.kDCredit.removeRows();
                this.kDOther.removeRows();
            } else if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.pledge)) {
                gtpEnum = GuaranteeTypePropertyEnum.pledge;
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelPledge);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, false);
                this.kDTabbedPaneEntry.setEnabledAt(2, true);
                this.kDTabbedPaneEntry.setEnabledAt(3, false);
                this.kDTabbedPaneEntry.setEnabledAt(4, false);
                this.kDTabbedPaneEntry.setEnabledAt(5, false);
                this.kdGuara.removeRows();
                this.kDImpawn.removeRows();
                this.kDCredit.removeRows();
                this.kDOther.removeRows();
            } else if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.impawn)) {
                gtpEnum = GuaranteeTypePropertyEnum.impawn;
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelImpawn);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, false);
                this.kDTabbedPaneEntry.setEnabledAt(2, false);
                this.kDTabbedPaneEntry.setEnabledAt(3, true);
                this.kDTabbedPaneEntry.setEnabledAt(4, false);
                this.kDTabbedPaneEntry.setEnabledAt(5, false);
                this.kdGuara.removeRows();
                this.kDPledge.removeRows();
                this.kDCredit.removeRows();
                this.kDOther.removeRows();
            } else if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.credit)) {
                gtpEnum = GuaranteeTypePropertyEnum.credit;
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelCredit);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, false);
                this.kDTabbedPaneEntry.setEnabledAt(2, false);
                this.kDTabbedPaneEntry.setEnabledAt(3, false);
                this.kDTabbedPaneEntry.setEnabledAt(4, true);
                this.kDTabbedPaneEntry.setEnabledAt(5, false);
                this.kdGuara.removeRows();
                this.kDPledge.removeRows();
                this.kDImpawn.removeRows();
                this.kDOther.removeRows();
            }
        } else {
            if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.other)) {
                gtpEnum = GuaranteeTypePropertyEnum.other;
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelOther);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, false);
                this.kDTabbedPaneEntry.setEnabledAt(2, false);
                this.kDTabbedPaneEntry.setEnabledAt(3, false);
                this.kDTabbedPaneEntry.setEnabledAt(4, false);
                this.kDTabbedPaneEntry.setEnabledAt(5, true);
                this.kdGuara.removeRows();
                this.kDPledge.removeRows();
                this.kDImpawn.removeRows();
                this.kDCredit.removeRows();
            } else if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.mix)) {
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelBank);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, true);
                this.kDTabbedPaneEntry.setEnabledAt(2, true);
                this.kDTabbedPaneEntry.setEnabledAt(3, true);
                this.kDTabbedPaneEntry.setEnabledAt(4, true);
                this.kDTabbedPaneEntry.setEnabledAt(5, true);
            } else if (gtimEnum != null && gtimEnum.equals((Object)GuaranteeTypeInputModeEnum.notassure)) {
                this.kDTabbedPaneEntry.setSelectedComponent((Component)this.kDPanelBank);
                this.kDTabbedPaneEntry.setEnabledAt(0, true);
                this.kDTabbedPaneEntry.setEnabledAt(1, false);
                this.kDTabbedPaneEntry.setEnabledAt(2, false);
                this.kDTabbedPaneEntry.setEnabledAt(3, false);
                this.kDTabbedPaneEntry.setEnabledAt(4, false);
                this.kDTabbedPaneEntry.setEnabledAt(5, false);
                this.kdGuara.removeRows();
                this.kDPledge.removeRows();
                this.kDImpawn.removeRows();
                this.kDCredit.removeRows();
                this.kDOther.removeRows();
            }
            this.prmtMainGT.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        this.removeTotalRow_LoanBankEntry();
        super.storeFields();
        super.storeEntrysFields((FinancingBillInfo)this.editData);
        if (!isFirstEnter) {
            this.resetTotalRow_LoanBankEntry();
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        BigDecimal orgAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal extRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (FMHelper.isEmpty((Object)extRate)) {
            extRate = Constants.ONE;
        }
        if (extRate.compareTo(Constants.ZERO) < 0) {
            this.txtLocalCurExRate.requestFocus();
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"30_LocalCurRateMustMoreZero");
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtAmountLocalCur, (Number)FMHelper.getLocalAmount((BigDecimal)orgAmount, (BigDecimal)extRate));
        if (FMBillBigDecimalUtil.ge((Object)this.txtAmountLocalCur.getBigDecimalValue(), (Object)FMBillBigDecimalUtil.MAX_VALUE)) {
            this.txtAmount.setValue((Object)Constants.ZERO);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"34_NeedModifyFetchAmount");
        }
    }

    public void onLoad() throws Exception {
        this.initialize();
        this.onlyOneTransfer();
        super.onLoad();
        this.displayStatus();
    }

    private void initialize() throws Exception {
        this.kdGuara.checkParsed();
        this.kDPledge.checkParsed();
        this.kDImpawn.checkParsed();
        this.kDCredit.checkParsed();
        this.kDOther.checkParsed();
        this.kdtLoanBankEntry.checkParsed();
    }

    protected void onlyOneTransfer() throws Exception {
        this.initLoanFetchHeader();
        this.iniKDPanle();
        this.initAllEntryFiels();
        this.setCreateToDataDisplay();
    }

    protected void initAllEntryFiels() throws Exception {
        this.initLoanBankTable();
    }

    protected void initLoanBankTable() throws BOSException, EASBizException {
        this.kdtLoanBankEntry.removeRows();
        this.kdtLoanBankEntry.refresh();
        KDBizPromptBox lenderProperty = new KDBizPromptBox();
        lenderProperty.setQueryInfo("com.kingdee.eas.fm.sl.app.LenderPropertyQuery");
        lenderProperty.setDisplay(true);
        lenderProperty.setRequired(true);
        lenderProperty.setVisible(true);
        lenderProperty.setDisplayFormat("$name$");
        lenderProperty.setCommitFormat("$number$");
        lenderProperty.setEditable(false);
        lenderProperty.setEditFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isEnabled", (Object)Boolean.TRUE));
        lenderProperty.setEntityViewInfo(evi);
        this.kdtLoanBankEntry.getColumn("lenderProperty").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)lenderProperty));
        KDBizPromptBox lenderBank = new KDBizPromptBox();
        lenderBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.BankQuery");
        lenderBank.setDisplay(true);
        lenderBank.setVisible(true);
        lenderBank.setDisplayFormat("$name$");
        lenderBank.setCommitFormat("$number$");
        lenderBank.setEditFormat("$number$");
        this.kdtLoanBankEntry.getColumn("loanBank").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)lenderBank));
        KDFormattedTextField txtPromiseProportion = new KDFormattedTextField();
        txtPromiseProportion.setDataType(1);
        txtPromiseProportion.setHorizontalAlignment(4);
        txtPromiseProportion.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        txtPromiseProportion.setMinimumValue((Comparable)minValue);
        this.kdtLoanBankEntry.getColumn("promiseProportion").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPromiseProportion));
        this.kdtLoanBankEntry.getColumn("promiseProportion").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtpromiseLoanAmount = new KDFormattedTextField();
        txtpromiseLoanAmount.setDataType(1);
        txtpromiseLoanAmount.setHorizontalAlignment(4);
        txtpromiseLoanAmount.setMaximumValue((Comparable)maxValue);
        txtpromiseLoanAmount.setMinimumValue((Comparable)minValue);
        this.kdtLoanBankEntry.getColumn("promiseLoanAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtpromiseLoanAmount));
        KDBizPromptBox creditLimitBox = new KDBizPromptBox();
        creditLimitBox.setQueryInfo("com.kingdee.eas.fm.fin.app.F7CreditLimitQuery");
        creditLimitBox.setDisplay(true);
        creditLimitBox.setDisplayFormat("$number$");
        creditLimitBox.setCommitFormat("$number$");
        creditLimitBox.setEditFormat("$number$");
        creditLimitBox.setVisible(true);
        ObjectValueRender creditLimitReader = new ObjectValueRender();
        creditLimitReader.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtLoanBankEntry.getColumn("CreditLimit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)creditLimitBox));
        this.kdtLoanBankEntry.getColumn("CreditLimit").setRenderer((IBasicRender)creditLimitReader);
        KDFormattedTextField txtCreditCurExRate = new KDFormattedTextField();
        txtCreditCurExRate.setDataType(1);
        txtCreditCurExRate.setHorizontalAlignment(4);
        txtCreditCurExRate.setRemoveingZeroInDispaly(false);
        txtCreditCurExRate.setValue((Object)Constants.ZERO);
        txtCreditCurExRate.setPrecision(5);
        this.kdtLoanBankEntry.getColumn("CreditCurExRate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCreditCurExRate));
        KDFormattedTextField txtCreditAmount = new KDFormattedTextField();
        txtCreditAmount.setDataType(1);
        txtCreditAmount.setHorizontalAlignment(4);
        txtCreditAmount.setRemoveingZeroInDispaly(false);
        txtCreditAmount.setPrecision(5);
        txtCreditAmount.setValue((Object)Constants.ZERO);
        this.kdtLoanBankEntry.getColumn("CreditAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCreditAmount));
        KDTextField remark = new KDTextField();
        remark.setMaxLength(200);
        this.kdtLoanBankEntry.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)remark));
    }

    private void displayStatus() {
        this.actionAuditResult.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.menuItemSave.setVisible(true);
        }
    }

    protected void initLoanFetchHeader() throws Exception {
        if (this.getUIContext().get("company") != null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        this.prmtCreator.setDisplayFormat("$name$");
        this.prmtCreator.setEditable(false);
        this.pkCreateDate.setEditable(false);
        this.pkBizDate.setSupportedEmpty(false);
        this.pkIssueDate.setSupportedEmpty(false);
        this.txtYearDays.setHorizontalAlignment(4);
        this.txtRateAdjustPeriod.setHorizontalAlignment(4);
        this.txtLoanPromiseAmount.setRemoveingZeroInDispaly(false);
        this.txtLoanPromiseAmount.setMinimumValue((Comparable)minValue);
        this.txtNotFetchAmount.setMinimumValue((Comparable)minValue);
        this.txtLoanPromiseAmount.setMaximumValue((Comparable)largeMaxValue);
        this.txtNotFetchAmount.setMaximumValue((Comparable)largeMaxValue);
        this.txtAmount.setMinimumValue((Comparable)minValue);
        this.txtAmount.setMaximumValue((Comparable)maxValue);
        this.txtAmountLocalCur.setRemoveingZeroInDispaly(false);
        this.txtNotFetchAmount.setRemoveingZeroInDispaly(false);
        this.txtYieldRate.setRemoveingZeroInDispaly(false);
        this.txtPenAccrualRate.setRemoveingZeroInDispaly(false);
        this.txtBasePoints.setRemoveingZeroInDispaly(false);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtBalance.setRemoveingZeroInDispaly(false);
        this.txtLocalCurExRate.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtBalance.setHorizontalAlignment(4);
        this.txtLocalCurExRate.setHorizontalAlignment(4);
        this.txtLoanPromiseAmount.setHorizontalAlignment(4);
        this.txtAmountLocalCur.setHorizontalAlignment(4);
        this.txtNotFetchAmount.setHorizontalAlignment(4);
        this.txtBasePoints.setHorizontalAlignment(4);
        this.txtYieldRate.setHorizontalAlignment(4);
        this.txtPenAccrualRate.setHorizontalAlignment(4);
        this.fetchAmountCap.setHorizontalAlignment(4);
        this.txtFetchSeq.setHorizontalAlignment(4);
        this.txtPenAccrualRate.setPrecision(10);
        this.txtBasePoints.setPrecision(2);
        this.txtYieldRate.setPrecision(10);
        this.txtHorizon.setPrecision(1);
        this.txtHorizon.setHorizontalAlignment(4);
        this.txtHorizon.setRemoveingZeroInDispaly(false);
        this.prmtType.setQueryInfo("com.kingdee.eas.fm.fin.app.FinancingProductsQuery");
        this.prmtType.setDisplayFormat("$name$");
        this.prmtType.setEditFormat("$number$");
        this.prmtType.setCommitFormat("$number$");
        this.prmtType.setRequired(true);
        FinUtils.initCurrencyComboBox((KDComboBox)this.kDComboBoxCurrency);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        this.setPrecesionByCurrency(currencyInfo, new KDFormattedTextField[]{this.txtLocalCurExRate, this.txtLoanPromiseAmount, this.txtAmountLocalCur, this.txtNotFetchAmount, this.txtAmount, this.txtBalance});
        this.prmtIntRateType.setQueryInfo("com.kingdee.eas.fm.im.AllIntRateTypeQuery");
        this.prmtIntRateType.setDisplayFormat("$name$");
        this.prmtIntRateType.setEditFormat("$number$");
        this.prmtIntRateType.setCommitFormat("$number$");
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.prmtPayIntMode.setQueryInfo("com.kingdee.eas.fm.im.IntSchemeHaveSelfSetQuery");
        this.prmtPayIntMode.setDisplayFormat("$name$");
        this.prmtPayIntMode.setEditFormat("$number$");
        this.prmtPayIntMode.setCommitFormat("$number$");
        this.prmtReciveAccount.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        this.prmtReciveAccount.setEntityViewInfo(evi);
        this.prmtReciveAccount.setDisplayFormat("$number$ $name$");
        this.prmtReciveAccount.setEditFormat("$number$");
        this.prmtReciveAccount.setCommitFormat("$number$");
        this.prmtOppositeAccountView.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        EntityViewInfo vi = new EntityViewInfo();
        vi.setFilter(new FilterInfo());
        if (this.currentCompany.getAccountTable() != null) {
            vi.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        }
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        this.prmtOppositeAccountView.setEntityViewInfo(vi);
        this.prmtOppositeAccountView.setDisplayFormat("$name$");
        this.prmtOppositeAccountView.setEditFormat("$number$");
        this.prmtOppositeAccountView.setCommitFormat("$number$");
        this.txtAmountLocalCur.setEnabled(false);
        this.fetchAmountCap.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.pkCreateDate.setEnabled(false);
        this.prmtCompany.setEnabled(false);
    }

    public void setPrecesionByCurrency(CurrencyInfo info, KDFormattedTextField[] inputArray) {
        if (info == null) {
            return;
        }
        int precesion = info.getPrecision();
        if (!FMHelper.isEmpty((Object[])inputArray) && inputArray.length > 0) {
            int arraySize = inputArray.length;
            for (int i = 0; i < arraySize; ++i) {
                inputArray[i].setPrecision(precesion);
            }
        }
    }

    protected void iniKDPanle() throws Exception {
        this.kDTabbedPaneEntry.removeAll();
        this.kDTabbedPaneEntry.add((Component)this.kDPanelBank, (Object)this.resHelper.getString("kDPanelBank.constraints"));
        this.kDTabbedPaneEntry.add((Component)this.kDPanelGuara, (Object)this.resHelper.getString("kDPanelGuara.constraints"));
        this.kDTabbedPaneEntry.add((Component)this.kDPanelPledge, (Object)this.resHelper.getString("kDPanelPledge.constraints"));
        this.kDTabbedPaneEntry.add((Component)this.kDPanelImpawn, (Object)this.resHelper.getString("kDPanelImpawn.constraints"));
        this.kDTabbedPaneEntry.add((Component)this.kDPanelCredit, (Object)this.resHelper.getString("kDPanelCredit.constraints"));
        this.kDTabbedPaneEntry.add((Component)this.kDPanelOther, (Object)this.resHelper.getString("kDPanelOther.constraints"));
        int height = 278;
        this.kDPanelBank.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 990, height));
        this.kDPanelGuara.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 990, height));
        this.kDPanelPledge.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 990, height));
        this.kDPanelImpawn.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 990, height));
        this.kDPanelCredit.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 990, height));
        this.kDPanelOther.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 990, height));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddInLoanBank.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveInLoanBank.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddInLoanBank.setVisible(false);
        this.btnRemoveInLoanBank.setVisible(false);
        this.btnAddInGuara.setVisible(false);
        this.btnRemoveInGuara.setVisible(false);
        this.btnAddInPledge.setVisible(false);
        this.btnRemoveInPledge.setVisible(false);
        this.btnAddInImpawn.setVisible(false);
        this.btnRemoveInImpawn.setVisible(false);
        this.btnAddInCredit.setVisible(false);
        this.btnRemoveInCredit.setVisible(false);
        this.btnAddInOther.setVisible(false);
        this.btnRemoveInOther.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("AmountLocalCur"));
        sic.add(new SelectorItemInfo("RepamentType"));
        sic.add(new SelectorItemInfo("IntRateType.*"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("floatAction"));
        sic.add(new SelectorItemInfo("BasePoints"));
        sic.add(new SelectorItemInfo("firstRateAdjustDate"));
        sic.add(new SelectorItemInfo("rateAdjustPeriod"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("YieldRate"));
        sic.add(new SelectorItemInfo("payIntMode.*"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("firstFetchDate"));
        sic.add(new SelectorItemInfo("loanPurpose"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.accountTable.id"));
        sic.add(new SelectorItemInfo("sourcebillid"));
        sic.add(new SelectorItemInfo("loanBankEntry.*"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("reciveAccount.number"));
        sic.add(new SelectorItemInfo("fetchSeq"));
        sic.add(new SelectorItemInfo("reciveAccount.name"));
        sic.add(new SelectorItemInfo("loanPromiseAmount"));
        sic.add(new SelectorItemInfo("notFetchAmount"));
        sic.add(new SelectorItemInfo("loanContractNo"));
        sic.add(new SelectorItemInfo("lastCalDate"));
        sic.add(new SelectorItemInfo("lastFetchDate"));
        sic.add(new SelectorItemInfo("oppositeAccountView.number"));
        sic.add(new SelectorItemInfo("oppositeAccountView.name"));
        sic.add(new SelectorItemInfo("loanBankEntry.promiseProportion"));
        sic.add(new SelectorItemInfo("loanBankEntry.promiseLoanAmount"));
        sic.add(new SelectorItemInfo("loanBankEntry.number"));
        sic.add(new SelectorItemInfo("loanBankEntry.CreditCurExRate"));
        sic.add(new SelectorItemInfo("loanBankEntry.CreditAmount"));
        sic.add(new SelectorItemInfo("loanBankEntry.CreditLimit.*"));
        sic.add(new SelectorItemInfo("loanBankEntry.CreditLimit.number"));
        sic.add(new SelectorItemInfo("loanBankEntry.CreditCurrency.*"));
        sic.add(new SelectorItemInfo("loanBankEntry.CreditCurrency.number"));
        sic.add(new SelectorItemInfo("loanBankEntry.LenderProperty.*"));
        sic.add(new SelectorItemInfo("loanBankEntry.LenderProperty.number"));
        sic.add(new SelectorItemInfo("loanBankEntry.Bank.*"));
        sic.add(new SelectorItemInfo("loanBankEntry.Bank.number"));
        sic.add(new SelectorItemInfo("loanBankEntry.remark"));
        sic.add(new SelectorItemInfo("loanBankEntry.sourceBillId"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("GaranteeType.*"));
        sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.currency.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeCustomer.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.*"));
        return sic;
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        try {
            if (this.getBOTPViewStatus() == 1 && this.getOprtState().equals(OprtState.ADDNEW) && dataObject != null) {
                LoanFetchInfo loanFetchInfo = (LoanFetchInfo)dataObject;
                String sourceBillId = loanFetchInfo.getSourceBillId();
                if (sourceBillId == null) {
                    return;
                }
                this.removeNullLoanBankEntry(loanFetchInfo);
                this.isCreateFrom = true;
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
                SelectorItemCollection sic = super.getSelectors();
                sic.add(new SelectorItemInfo("Type.*"));
                sic.add(new SelectorItemInfo("LocalCurExRate"));
                sic.add(new SelectorItemInfo("Remark"));
                sic.add(new SelectorItemInfo("AmountLocalCur"));
                sic.add(new SelectorItemInfo("outBgItemNumber"));
                sic.add(new SelectorItemInfo("outBgItemName"));
                sic.add(new SelectorItemInfo("outBgItemId"));
                sic.add(new SelectorItemInfo("RepamentType"));
                sic.add(new SelectorItemInfo("IntRateType.*"));
                sic.add(new SelectorItemInfo("contractNum"));
                sic.add(new SelectorItemInfo("contractName"));
                sic.add(new SelectorItemInfo("Amount"));
                sic.add(new SelectorItemInfo("Balance"));
                sic.add(new SelectorItemInfo("Horizon"));
                sic.add(new SelectorItemInfo("floatAction"));
                sic.add(new SelectorItemInfo("BasePoints"));
                sic.add(new SelectorItemInfo("firstRateAdjustDate"));
                sic.add(new SelectorItemInfo("rateAdjustPeriod"));
                sic.add(new SelectorItemInfo("intRateTypeExpression"));
                sic.add(new SelectorItemInfo("yearDays"));
                sic.add(new SelectorItemInfo("YieldRate"));
                sic.add(new SelectorItemInfo("payIntMode.*"));
                sic.add(new SelectorItemInfo("payIntMode.number"));
                sic.add(new SelectorItemInfo("payIntMode.name"));
                sic.add(new SelectorItemInfo("penAccrualType"));
                sic.add(new SelectorItemInfo("project.*"));
                sic.add(new SelectorItemInfo("firstFetchDate"));
                sic.add(new SelectorItemInfo("loanPurpose"));
                sic.add(new SelectorItemInfo("penAccrualRate"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("sourcebillid"));
                sic.add(new SelectorItemInfo("Currency.*"));
                sic.add(new SelectorItemInfo("Currency.number"));
                sic.add(new SelectorItemInfo("Currency.name"));
                sic.add(new SelectorItemInfo("createTime"));
                sic.add(new SelectorItemInfo("historyBill"));
                sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
                sic.add(new SelectorItemInfo("GaranteeType.*"));
                sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
                sic.add(new SelectorItemInfo("guaranteeEntrys.currency.*"));
                sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeCustomer.*"));
                sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.*"));
                sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.*"));
                LoanContractInfo loanContractInfo = LoanContractFactory.getRemoteInstance().getLoanContractInfo((IObjectPK)new ObjectUuidPK(loanFetchInfo.getSourceBillId()), sic);
                this.setDefaultValue(loanFetchInfo, loanContractInfo);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void removeNullLoanBankEntry(LoanFetchInfo loanFetchInfo) {
        if (FMHelper.isEmpty((CoreBaseInfo)loanFetchInfo)) {
            return;
        }
        LoanFetchOfLenderEntryCollection entryCollection = loanFetchInfo.getLoanBankEntry();
        if (!FMHelper.isEmpty((AbstractObjectCollection)entryCollection)) {
            for (int i = 0; i < entryCollection.size(); ++i) {
                LoanFetchOfLenderEntryInfo loanBankInfo = entryCollection.get(i);
                if (loanBankInfo == null || !FMHelper.isEmpty((CoreBaseInfo)loanBankInfo.getLenderProperty())) continue;
                loanFetchInfo.getLoanBankEntry().clear();
                this.kdtLoanBankEntry.removeRow(i);
                break;
            }
        }
    }

    private void setCreateToDataDisplay() {
        this.txtLoanContractNo.setEnabled(false);
        this.prmtType.setEnabled(false);
        this.txtLoanPromiseAmount.setEnabled(false);
        this.txtNotFetchAmount.setEnabled(false);
        this.kDComboBoxCurrency.setEnabled(false);
        this.txtLocalCurExRate.setEnabled(true);
        this.prmtIntRateType.setEnabled(false);
        this.comboFloatAction.setEnabled(false);
        this.txtBasePoints.setEnabled(false);
        this.pkFirstRateAdjustDate.setEnabled(false);
        this.txtRateAdjustPeriod.setEnabled(false);
        this.comboIntRateTypeExpression.setEnabled(false);
        this.txtYearDays.setEnabled(false);
        this.txtYieldRate.setEnabled(false);
        this.comboPenAccrualType.setEnabled(false);
        this.txtPenAccrualRate.setEnabled(false);
        this.combGTInputMode.setEnabled(false);
        this.prmtMainGT.setEnabled(false);
        this.prmtPayIntMode.setEnabled(false);
        this.txtFetchSeq.setEnabled(false);
        this.pkLastCalDate.setEnabled(false);
        this.txtBalance.setEnabled(false);
        this.prmtProject.setEnabled(true);
        this.prmtBgItem.setEnabled(true);
        this.txtRemark.setEnabled(true);
        this.txtAmount.setEnabled(true);
        this.prmtReciveAccount.setEnabled(true);
        this.prmtOppositeAccountView.setEnabled(true);
        this.pkIssueDate.setEnabled(true);
        this.pkExpiredDate.setEnabled(false);
        this.txtHorizon.setEnabled(false);
        this.pkBizDate.setEnabled(true);
        isFirstEnter = this.getOprtState().equals(OprtState.ADDNEW) && this.getBOTPViewStatus() != 1;
    }

    private void setDefaultValue(LoanFetchInfo loanFetchInfo, LoanContractInfo loanContractInfo) {
        int horizon;
        loanFetchInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        loanFetchInfo.setCreator(this.userinfo);
        loanFetchInfo.setCompany(this.currentCompany);
        loanFetchInfo.setStatus(FsBillStatusEnum.SAVE);
        loanFetchInfo.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        loanFetchInfo.setHorizon(Constants.ZERO);
        loanFetchInfo.setAmount(Constants.ZERO);
        loanFetchInfo.setBalance(Constants.ZERO);
        loanFetchInfo.setAmountLocalCur(Constants.ZERO);
        loanFetchInfo.setCurrency(loanContractInfo.getCurrency());
        loanFetchInfo.setPenAccrualType(loanContractInfo.getPenAccrualType());
        loanFetchInfo.setPayIntMode(loanContractInfo.getPayIntMode());
        loanFetchInfo.setIsGenRecBill(false);
        loanFetchInfo.setIsExtension(false);
        loanFetchInfo.setFiVouchered(false);
        this.pkFirstRateAdjustDate.setEnabled(false);
        int seq = this.getExistsLoanContractCount(loanFetchInfo.getSourceBillId(), loanContractInfo.isHistoryBill());
        loanFetchInfo.setFetchSeq(seq);
        int n = horizon = loanContractInfo.getHorizon() == null ? 0 : loanContractInfo.getHorizon().intValue();
        if (seq == 1 || FMHelper.isEmpty((Object)loanContractInfo.getExpiredDate())) {
            loanFetchInfo.setExpiredDate(DateTimeUtils.truncateDate((Date)SLUtils.addManyMonthDay(new Date(), horizon)));
            this.isFirstFetchItem = true;
        } else {
            loanFetchInfo.setExpiredDate(DateTimeUtils.truncateDate((Date)loanContractInfo.getExpiredDate()));
            this.isFirstFetchItem = false;
        }
        loanFetchInfo.setIssueDate(DateTimeUtils.truncateDate((Date)new Date()));
        loanFetchInfo.setHorizon(SLUtils.getHorizon(loanFetchInfo.getIssueDate(), loanFetchInfo.getExpiredDate()));
        this.getGuaranteeEntrys(loanFetchInfo, loanContractInfo);
    }

    private void setExtendStyle(LoanFetchInfo loanFetchInfo) {
        if (FMHelper.isEmpty((CoreBaseInfo)loanFetchInfo)) {
            return;
        }
        PenAccrualTypeEnum penTtpe = loanFetchInfo.getPenAccrualType();
        if (penTtpe == null || penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.contPenAccrualRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"dailyrate"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.contPenAccrualRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"penerate"));
        }
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = loanFetchInfo.getIntRateTypeExpression();
        if (!FMHelper.isEmpty((Object)intRateTypeExpressionEnum)) {
            if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
                this.contYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"9_loanFetchEditUI"));
            } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
                this.contYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"10_loanFetchEditUI"));
            } else {
                this.contYieldRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"10_loanFetchEditUI"));
            }
        }
    }

    private int getExistsLoanContractCount(String sourceBillId, boolean isHistoryBill) {
        int size = 0;
        try {
            size = LoanFetchFactory.getRemoteInstance().existsLoancontract(sourceBillId, isHistoryBill);
            ++size;
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return size;
    }

    private LoanFetchInfo getGuaranteeEntrys(LoanFetchInfo loanFetchInfo, LoanContractInfo loanContractInfo) {
        for (GuaranteeDetailInfo element : loanContractInfo.getGuaranteeEntrys()) {
            loanFetchInfo.getGuaranteeEntrys().add(element);
        }
        return loanFetchInfo;
    }

    protected void loadEntrysFieldsStyle() {
        IRow row;
        for (int i = 0; i < this.kdGuara.getRowCount(); ++i) {
            row = this.kdGuara.getRow(i);
            row.getCell("scale").getStyleAttributes().setLocked(true);
            row.getCell("billNumber").getStyleAttributes().setLocked(true);
            row.getCell("guaranCompany").getStyleAttributes().setLocked(true);
            row.getCell("amount").getStyleAttributes().setLocked(true);
            row.getCell("assureCfgFee").getStyleAttributes().setLocked(true);
            row.getCell("currency").getStyleAttributes().setLocked(true);
        }
        for (int j = 0; j < this.kDPledge.getRowCount(); ++j) {
            row = this.kDPledge.getRow(j);
            row.getCell("scale").getStyleAttributes().setLocked(true);
            row.getCell("guaranCompany").getStyleAttributes().setLocked(true);
            row.getCell("guaranteeName").getStyleAttributes().setLocked(true);
            row.getCell("billNumber").getStyleAttributes().setLocked(true);
            row.getCell("wage").getStyleAttributes().setLocked(true);
            row.getCell("wageRate").getStyleAttributes().setLocked(true);
            row.getCell("canWage").getStyleAttributes().setLocked(true);
            row.getCell("mortgageType").getStyleAttributes().setLocked(true);
        }
        for (int k = 0; k < this.kDImpawn.getRowCount(); ++k) {
            row = this.kDImpawn.getRow(k);
            row.getCell("billNumber").getStyleAttributes().setLocked(true);
            row.getCell("guaranCompany").getStyleAttributes().setLocked(true);
            row.getCell("scale").getStyleAttributes().setLocked(true);
            row.getCell("guaranteeName").getStyleAttributes().setLocked(true);
            row.getCell("canWage").getStyleAttributes().setLocked(true);
        }
        for (int l = 0; l < this.kDCredit.getRowCount(); ++l) {
            row = this.kDCredit.getRow(l);
            row.getCell("scale").getStyleAttributes().setLocked(true);
            row.getCell("guaranCompany").getStyleAttributes().setLocked(true);
        }
        for (int m = 0; m < this.kDOther.getRowCount(); ++m) {
            row = this.kDOther.getRow(m);
            row.getCell("scale").getStyleAttributes().setLocked(true);
            row.getCell("guaranteetype").getStyleAttributes().setLocked(true);
        }
    }

    private void loadLoanBankEntrysFieldsStyle() {
        BigDecimal totalPromisePropertion = Constants.ZERO;
        BigDecimal totalPromiseAmount = Constants.ZERO;
        BigDecimal promisePropertion = Constants.ZERO;
        BigDecimal promiseAmount = Constants.ZERO;
        for (int i = 0; i < this.kdtLoanBankEntry.getRowCount(); ++i) {
            IRow row = this.kdtLoanBankEntry.getRow(i);
            row.getCell("lenderProperty").getStyleAttributes().setLocked(true);
            row.getCell("loanBank").getStyleAttributes().setLocked(true);
            row.getCell("promiseProportion").getStyleAttributes().setLocked(false);
            row.getCell("promiseLoanAmount").getStyleAttributes().setLocked(false);
            row.getCell("CreditLimit").getStyleAttributes().setLocked(true);
            row.getCell("CreditCurrency").getStyleAttributes().setLocked(true);
            if (!FMHelper.isEmpty((Object)row.getCell("promiseProportion").getValue())) {
                promisePropertion = (BigDecimal)row.getCell("promiseProportion").getValue();
            }
            if (!FMHelper.isEmpty((Object)row.getCell("promiseLoanAmount").getValue())) {
                promiseAmount = (BigDecimal)row.getCell("promiseLoanAmount").getValue();
            }
            totalPromisePropertion = totalPromisePropertion.add(promisePropertion);
            totalPromiseAmount = totalPromiseAmount.add(promiseAmount);
            if (FMHelper.isEmpty((Object)row.getCell("promiseLoanAmount").getValue())) {
                row.getCell("promiseLoanAmount").setValue((Object)Constants.ZERO);
            }
            this.addRowWithLoanBankEntry(row, false);
        }
        SLUtils.setEntryExchangeRate(this.kdtLoanBankEntry, "CreditCurrency", "CreditCurExRate", this.currencyInfo, this.isCreateFrom, this.isNeedChange, this.pkBizDate, this.currentCompany, true, "promiseLoanAmount", "CreditAmount", true);
        SLUtils.setEntryExchangeRate(this.kdGuara, "currency", "exchangeRate", this.currencyInfo, this.isCreateFrom, this.isNeedChange, this.pkBizDate, this.currentCompany, false, null, null, false);
    }

    protected void addRowWithLoanBankEntry(IRow row, boolean isTotalRow) {
        if (FMHelper.isEmpty((Object)row.getCell("promiseProportion").getValue())) {
            row.getCell("promiseProportion").setValue((Object)Constants.ZERO);
        }
        row.getCell("promiseProportion").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (FMHelper.isEmpty((Object)row.getCell("promiseLoanAmount").getValue())) {
            row.getCell("promiseLoanAmount").setValue((Object)Constants.ZERO);
        }
        row.getCell("CreditCurExRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("CreditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.initKDTPrecesion(this.currencyInfo.getPrecision());
        if (isTotalRow) {
            row.getCell("lenderProperty").getStyleAttributes().setLocked(true);
        }
    }

    protected void setExchangeRateRelAss(ICell cell, CompanyOrgUnitInfo company, CurrencyInfo destCurr) {
        try {
            FinUtils.initExchangeRateRelAss(null, (ICell)cell, (CompanyOrgUnitInfo)company, (CurrencyInfo)this.currencyInfo, (CurrencyInfo)destCurr, (Date)((Date)this.pkBizDate.getValue()));
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void initKDTPrecesion(int prec) {
        this.changePrecesion(this.kdtLoanBankEntry, new String[]{"promiseProportion", "promiseLoanAmount"}, prec);
    }

    protected void changePrecesion(KDTable kdt, String[] cols, int prec) {
        String format = FMClientHelper.getKDTNumFormat((int)prec);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = kdt.getColumn(cols[i]);
            col.getStyleAttributes().setNumberFormat(format);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal extRate;
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        if (amount == null) {
            amount = Constants.ZERO;
        }
        if (FMHelper.isEmpty((Object)(extRate = this.txtLocalCurExRate.getBigDecimalValue()))) {
            extRate = Constants.ONE;
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtAmountLocalCur, (Number)FMHelper.getLocalAmount((BigDecimal)amount, (BigDecimal)extRate));
        if (FMBillBigDecimalUtil.ge((Object)this.txtAmountLocalCur.getBigDecimalValue(), (Object)FMBillBigDecimalUtil.MAX_VALUE)) {
            this.txtAmount.setValue((Object)Constants.ZERO);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"34_NeedModifyFetchAmount");
        }
        String txt = FMBillUtil.getChineseFormat((BigDecimal)this.txtAmount.getBigDecimalValue(), (boolean)true);
        this.fetchAmountCap.setText(txt);
        for (int i = 0; i < this.kdtLoanBankEntry.getRowCount(); ++i) {
            IRow row = this.kdtLoanBankEntry.getRow(i);
            BigDecimal promisePropertion = (BigDecimal)row.getCell("promiseProportion").getValue();
            BigDecimal promiseAmount = amount.multiply(promisePropertion).divide(Constants.ONE_HUNDRED, 4);
            row.getCell("promiseLoanAmount").setValue((Object)promiseAmount);
            if (FMHelper.isEmpty((Object)row.getCell("CreditCurExRate").getValue())) continue;
            BigDecimal CreditAmount = promiseAmount.multiply((BigDecimal)row.getCell("CreditCurExRate").getValue());
            row.getCell("CreditAmount").setValue((Object)CreditAmount);
        }
        this.txtBalance.setValue((Object)amount);
        this.txtAmountLocalCur.setEnabled(false);
        this.fetchAmountCap.setEnabled(false);
        this.fetchAmountCap.setHorizontalAlignment(4);
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        Date issueDate;
        super.pkIssueDate_dataChanged(e);
        Date date = issueDate = FMHelper.isEmpty((Object)this.pkIssueDate.getValue()) ? null : (Date)this.pkIssueDate.getValue();
        if (this.isFirstFetchItem) {
            int horizon = 0;
            if (!FMHelper.isEmpty((Object)this.txtHorizon.getBigDecimalValue())) {
                horizon = this.txtHorizon.getBigDecimalValue().intValue();
            }
            if (issueDate != null) {
                this.pkExpiredDate.setValue((Object)SLUtils.addManyMonthDay(issueDate, horizon));
            }
        } else {
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtHorizon, (Number)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkExpiredDate));
        }
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExpiredDate_dataChanged(e);
    }

    protected void initBillStatus() {
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        if (isFirstEnter) {
            IKDComponent[] comps = new IKDComponent[]{this.pkBizDate, this.prmtCreator, this.prmtCompany, this.prmtType, this.kDComboBoxCurrency, this.txtAmount, this.txtBalance, this.txtLocalCurExRate, this.pkIssueDate, this.pkExpiredDate, this.txtHorizon, this.txtRemark, this.txtLocalCurExRate, this.txtAmount, this.txtAmountLocalCur, this.prmtIntRateType, this.txtLoanPromiseAmount, this.txtNotFetchAmount, this.txtFetchSeq, this.prmtReciveAccount, this.pkFirstRateAdjustDate, this.comboFloatAction, this.txtRateAdjustPeriod, this.txtBasePoints, this.comboIntRateTypeExpression, this.txtYearDays, this.txtYieldRate, this.comboPenAccrualType, this.txtPenAccrualRate, this.prmtPayIntMode, this.prmtProject, this.prmtOppositeAccountView, this.txtLoanContractNo, this.fetchAmountCap, this.prmtMainGT, this.pkLastCalDate, this.prmtBgItem};
            FMClientHelper.setCompEnable((IKDComponent[])comps, (boolean)false);
            this.kDTabbedPaneEntry.setEnabledAt(this.kDTabbedPaneEntry.indexOfComponent((Component)this.kDPanelGuara), false);
            this.kDTabbedPaneEntry.setEnabledAt(this.kDTabbedPaneEntry.indexOfComponent((Component)this.kDPanelPledge), false);
            this.kDTabbedPaneEntry.setEnabledAt(this.kDTabbedPaneEntry.indexOfComponent((Component)this.kDPanelImpawn), false);
            this.kDTabbedPaneEntry.setEnabledAt(this.kDTabbedPaneEntry.indexOfComponent((Component)this.kDPanelCredit), false);
            this.kDTabbedPaneEntry.setEnabledAt(this.kDTabbedPaneEntry.indexOfComponent((Component)this.kDPanelOther), false);
            this.kDTabbedPaneEntry.setEnabledAt(this.kDTabbedPaneEntry.indexOfComponent((Component)this.kDPanelBank), false);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.menuBiz.setVisible(false);
        }
    }

    @Override
    protected void kdtLoanBankEntry_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int selectRow = FMClientHelper.getSelectedRow((KDTable)this.kdtLoanBankEntry);
        IRow row = this.kdtLoanBankEntry.getRow(selectRow);
        if (colIndex == this.kdtLoanBankEntry.getColumn("CreditCurExRate").getColumnIndex()) {
            int creditCurExRateIndex = this.kdtLoanBankEntry.getColumn("CreditCurExRate").getColumnIndex();
            CurrencyInfo entryCurrencyInfo = (CurrencyInfo)row.getCell("CreditCurrency").getValue();
            Object creditCurExRateValue = row.getCell(creditCurExRateIndex).getValue();
            if (creditCurExRateValue instanceof BigDecimal) {
                if (((BigDecimal)creditCurExRateValue).compareTo(Constants.ZERO) < 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u6298\u6388\u4fe1\u5e01\u522b\u6c47\u7387\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
                    this.kdtLoanBankEntry.getRow(selectRow).getCell(creditCurExRateIndex).setValue(null);
                    SysUtil.abort();
                }
                BigDecimal promiseBalance = row.getCell("promiseLoanAmount").getValue() == null ? Constants.ZERO : row.getCell("promiseLoanAmount").getValue();
                BigDecimal creditCurExRate = row.getCell("CreditCurExRate").getValue() == null ? Constants.ONE : row.getCell("CreditCurExRate").getValue();
                BigDecimal creditAmount = promiseBalance.multiply(creditCurExRate);
                row.getCell("CreditAmount").setValue((Object)creditAmount);
                if (entryCurrencyInfo != null) {
                    row.getCell("CreditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)entryCurrencyInfo.getPrecision()));
                }
            }
        }
        if (colIndex == this.kdtLoanBankEntry.getColumn("CreditAmount").getColumnIndex()) {
            int creditAmountIndex = this.kdtLoanBankEntry.getColumn("CreditAmount").getColumnIndex();
            Object creditCreditAmountValue = this.kdtLoanBankEntry.getRow(FMClientHelper.getSelectedRow((KDTable)this.kdtLoanBankEntry)).getCell(creditAmountIndex).getValue();
            if (creditCreditAmountValue instanceof BigDecimal && ((BigDecimal)creditCreditAmountValue).compareTo(Constants.ZERO) < 0) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u6298\u6388\u4fe1\u5e01\u522b\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
                this.kdtLoanBankEntry.getRow(selectRow).getCell(creditAmountIndex).setValue(null);
                SysUtil.abort();
            }
        }
        if (colIndex == this.kdtLoanBankEntry.getColumn("promiseProportion").getColumnIndex()) {
            BigDecimal promisePropertion;
            BigDecimal fetchAmount = this.txtAmount.getBigDecimalValue();
            BigDecimal bigDecimal = promisePropertion = row.getCell("promiseProportion").getValue() == null ? Constants.ZERO : row.getCell("promiseProportion").getValue();
            if (fetchAmount != null) {
                BigDecimal promiseAmount = fetchAmount.multiply(promisePropertion).divide(Constants.ONE_HUNDRED, 4);
                row.getCell("promiseLoanAmount").setValue((Object)promiseAmount);
                this.totalLoanBank(selectRow, promisePropertion, promiseAmount);
            }
            BigDecimal promiseLoanAmount = SLUtils.getKdtableColumnValue(row, "promiseLoanAmount");
            BigDecimal creditCurExRate = SLUtils.getKdtableColumnValue(row, "CreditCurExRate");
            BigDecimal creditAmount = promiseLoanAmount.multiply(creditCurExRate);
            CurrencyInfo entryCurrencyInfo = (CurrencyInfo)row.getCell("CreditCurrency").getValue();
            if (entryCurrencyInfo != null) {
                row.getCell("CreditAmount").setValue((Object)creditAmount);
            }
        }
        if (colIndex == this.kdtLoanBankEntry.getColumn("promiseLoanAmount").getColumnIndex()) {
            BigDecimal promiseLoanAmount;
            BigDecimal fetchAmount = this.txtAmount.getBigDecimalValue();
            BigDecimal bigDecimal = promiseLoanAmount = row.getCell("promiseLoanAmount").getValue() == null ? Constants.ZERO : row.getCell("promiseLoanAmount").getValue();
            if (fetchAmount != null && fetchAmount.compareTo(Constants.ZERO) > 0) {
                BigDecimal promiseProportion = promiseLoanAmount.multiply(Constants.ONE_HUNDRED).divide(fetchAmount, 4);
                row.getCell("promiseProportion").setValue((Object)promiseProportion);
                this.totalLoanBank(selectRow, promiseProportion, promiseLoanAmount);
            }
            BigDecimal creditCurExRate = SLUtils.getKdtableColumnValue(row, "CreditCurExRate");
            BigDecimal creditAmount = promiseLoanAmount.multiply(creditCurExRate);
            CurrencyInfo entryCurrencyInfo = (CurrencyInfo)row.getCell("CreditCurrency").getValue();
            if (entryCurrencyInfo != null) {
                row.getCell("CreditAmount").setValue((Object)creditAmount);
            }
        }
    }

    protected void totalLoanBank(int rowIndex, BigDecimal promiseProportion, BigDecimal promiseLoanAmount) {
        int rowCount = this.kdtLoanBankEntry.getRowCount();
        BigDecimal totalPropertion = Constants.ZERO;
        BigDecimal totalPromisAmount = Constants.ZERO;
        for (int i = 0; i < rowCount - 1; ++i) {
            BigDecimal tmpTotalPromisAmount;
            IRow row = this.kdtLoanBankEntry.getRow(i);
            BigDecimal tmpTotalPropertion = row.getCell("promiseProportion").getValue() == null ? Constants.ZERO : row.getCell("promiseProportion").getValue();
            BigDecimal bigDecimal = tmpTotalPromisAmount = row.getCell("promiseLoanAmount").getValue() == null ? Constants.ZERO : row.getCell("promiseLoanAmount").getValue();
            if (i == rowIndex) {
                totalPropertion = totalPropertion.add(promiseProportion);
                totalPromisAmount = totalPromisAmount.add(promiseLoanAmount);
                continue;
            }
            totalPropertion = totalPropertion.add(tmpTotalPropertion);
            totalPromisAmount = totalPromisAmount.add(tmpTotalPromisAmount);
        }
        IRow rowTotal = this.kdtLoanBankEntry.getRow(rowCount - 1);
        rowTotal.getCell("promiseProportion").setValue((Object)totalPropertion);
        rowTotal.getCell("promiseLoanAmount").setValue((Object)totalPromisAmount);
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        java.sql.Date bizDate = this.pkBizDate.getSqlDate();
        if (!FMHelper.isEmpty((Object)bizDate)) {
            this.pkFirstRateAdjustDate.setValue((Object)SLUtils.getSpecifyDate(bizDate, 1));
        } else {
            this.pkFirstRateAdjustDate.setValue(null);
        }
        CurrencyInfo curCurrency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        try {
            CurrencyInfo baseCurrency = SLUtils.getCurrentCurrency(this.currentCompany);
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)curCurrency, (CurrencyInfo)baseCurrency, (Date)bizDate, null);
            BigDecimal amount = this.txtAmount.getBigDecimalValue();
            BigDecimal extRate = this.txtLocalCurExRate.getBigDecimalValue();
            if (FMHelper.isEmpty((Object)extRate)) {
                extRate = Constants.ONE;
            }
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtAmountLocalCur, (Number)FMHelper.getLocalAmount((BigDecimal)amount, (BigDecimal)extRate));
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        this.isNeedChange = true;
        SLUtils.setEntryExchangeRate(this.kdtLoanBankEntry, "CreditCurrency", "CreditCurExRate", this.currencyInfo, this.isCreateFrom, this.isNeedChange, this.pkBizDate, this.currentCompany, true, "promiseLoanAmount", "CreditAmount", true);
        SLUtils.setEntryExchangeRate(this.kdGuara, "currency", "exchangeRate", this.currencyInfo, this.isCreateFrom, this.isNeedChange, this.pkBizDate, this.currentCompany, false, null, null, false);
        this.isNeedChange = false;
    }

    private BigDecimal getYieldRate(CurrencyInfo currency, IntRateTypeInfo intRateType, Date date, BigDecimal bdBP, FloatActionEnum floatAction) throws BOSException, EASBizException {
        if (currency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), currency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            BigDecimal bdYieldRate = Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtBasePoints.requestFocus();
                SysUtil.abort();
            }
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    @Override
    protected void kDComboBoxCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.kDComboBoxCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        java.sql.Date date = this.pkBizDate.getSqlDate();
        if (currency != null) {
            this.setPrecesionByCurrency(currency, new KDFormattedTextField[]{this.txtLoanPromiseAmount, this.txtNotFetchAmount, this.txtAmount, this.txtBalance});
            this.initKDTPrecesion(currency.getPrecision());
            if (currency.equals((Object)SLUtils.getCurrentCurrency(this.currentCompany))) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
            SLUtils.setLocalCurExRate(this.currentCompany, currency.getId().toString(), null, date, this.txtLocalCurExRate, this.txtAmountLocalCur);
            try {
                BigDecimal amount = this.txtAmount.getBigDecimalValue();
                BigDecimal extRate = this.txtLocalCurExRate.getBigDecimalValue();
                if (FMHelper.isEmpty((Object)extRate)) {
                    extRate = Constants.ONE;
                }
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtAmountLocalCur, (Number)FMHelper.getLocalAmount((BigDecimal)amount, (BigDecimal)extRate));
            }
            catch (Exception ex) {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.currentCompany.getBaseCurrency());
                this.handUIExceptionAndAbort(ex);
            }
        }
    }

    protected void initViewStatus() {
        this.menuEdit.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionSubmit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionSubmitOption.setVisible(false);
    }

    protected void initEditStatus() {
        if (this.getDataObject() != null) {
            if (FsBillStatusEnum.SAVE.equals((Object)((LoanFetchInfo)this.getDataObject()).getStatus())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            } else if (FsBillStatusEnum.SUBMIT.equals((Object)((LoanFetchInfo)this.getDataObject()).getStatus())) {
                this.actionSave.setEnabled(false);
                this.actionSubmit.setEnabled(true);
            }
        }
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    public int getBtpCreateFromType() {
        return 0;
    }
}

