/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanFetchListUI;
import com.kingdee.eas.fm.sl.client.LoanFetchFilterParam;
import com.kingdee.eas.fm.sl.client.LoanFetchFilterUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class LoanFetchListUI
extends AbstractLoanFetchListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanFetchListUI.class);
    protected LoanFetchFilterUI filterUI = null;
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        LoanFetchInfo info = this.getSelectedInfo();
        this.checkCurrectState(FsBillStatusEnum.AUDIT, "\u4fdd\u5b58\u72b6\u6001\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u4fee\u6539", true, info);
        if (SLUtils.existsDestBillSet(info.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u4fdd\u5b58\u72b6\u6001\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u4fee\u6539");
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int maxSeq;
        LoanFetchInfo info = this.getSelectedInfo();
        this.checkCurrectState(FsBillStatusEnum.AUDIT, "\u4fdd\u5b58\u72b6\u6001\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u5220\u9664", true, info);
        if (info.isIsExtension()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"11_Extension_Not_Delete"));
            SysUtil.abort();
        }
        if (info != null && info.getSourceBillId() != null && (maxSeq = LoanFetchFactory.getRemoteInstance().existsLoancontract(info.getSourceBillId(), true)) != 0 && info.getFetchSeq() != maxSeq) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u540c\u4e00\u501f\u6b3e\u5408\u540c\u4e0b\u7684\u63d0\u6b3e\u5355\u5220\u9664\u5fc5\u987b\u6309\u63d0\u6b3e\u5e8f\u53f7\u4ece\u540e\u5f80\u524d\u987a\u5e8f\u5220\u9664");
            SysUtil.abort();
        }
        if (SLUtils.existsDestBillSet(info.getId().toString())) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"21_exsitsDownStream_CanNot_Delete");
        }
        super.actionRemove_actionPerformed(e);
    }

    private void checkCurrectState(FsBillStatusEnum state, String msg, boolean flag, LoanFetchInfo info) throws Exception {
        if (info != null && state.equals((Object)info.getStatus()) == flag) {
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    private LoanFetchInfo getSelectedInfo() throws Exception {
        this.checkSelected();
        return LoanFetchFactory.getRemoteInstance().getLoanFetchInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanFetchFilterUI();
        }
        return this.filterUI;
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && this.getBOTPViewStatus() == 1) {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("isGenRecBill", (Object)Boolean.FALSE));
        }
        return filter;
    }

    private void setRightAttribute(IRow curRow, String[] needSetArr) {
        if (needSetArr != null) {
            for (int i = 0; i < needSetArr.length; ++i) {
                curRow.getCell(needSetArr[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        if (e == null) {
            return;
        }
        IRow row = null;
        for (int j = 0; j < tblMain.getRowCount(); ++j) {
            row = tblMain.getRow(j);
            String[] needSetArribute = new String[]{"LocalCurExRate", "loanPromiseAmount", "notFetchAmount", "Horizon", "BasePoints", "rateAdjustPeriod", "penAccrualRateAddPercent", "penAccrualRateAddaccrual", "yearDays", "YieldRate", "AmountLocalCur", "fetchSeq"};
            this.setRightAttribute(row, needSetArribute);
        }
        String currencyId = null;
        IRow row2 = null;
        for (int j = 0; j < tblMain.getRowCount(); ++j) {
            String rateExpression;
            row2 = tblMain.getRow(j);
            row2.getCell("BasePoints").getFormattedStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
            row2.getCell("BasePoints").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (row2.getCell("intRateTypeExpression").getValue() == null || (rateExpression = row2.getCell("intRateTypeExpression").getValue().toString()) == null) continue;
            if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                row2.getCell("YieldRate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!%");
                continue;
            }
            row2.getCell("YieldRate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!\u2030");
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            if (row.getCell("Horizon").getValue() != null) {
                row.getCell("Horizon").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)1));
            }
            if (row.getCell("AmountLocalCur").getValue() != null) {
                row.getCell("AmountLocalCur").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.getBaseCurrencyPrecision()));
            }
            if (row.getCell("penAccrualRateAddPercent").getValue() != null) {
                row.getCell("penAccrualRateAddPercent").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)10));
            }
            if (row.getCell("penAccrualRateAddaccrual").getValue() != null) {
                row.getCell("penAccrualRateAddaccrual").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)10));
            }
            if (row.getCell("LocalCurExRate").getValue() != null) {
                row.getCell("LocalCurExRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)6));
            }
            if ((currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue()) == null) continue;
            String[] formatCol = this.getPrecColName();
            for (int j = 0; j < formatCol.length; ++j) {
                FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
            }
        }
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"loanPromiseAmount", "notFetchAmount", "Amount", "Balance"};
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fm.sl.client.LoanFetchEditUI";
    }

    public void onLoad() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.onLoad();
        this.displayButton();
        this.setBtnDisplayInBizUnit();
    }

    protected void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        if (extFilter != null && extFilter.getFilterItems().size() > 0) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.onshows();
    }

    private void onshows() {
        boolean isFpItem = FMClientHelper.getIsFpOrBg();
        FMClientHelper.initFpOrBgF7Item((boolean)isFpItem, (IColumn)this.tblMain.getColumn("fpItem"), (IColumn)this.tblMain.getColumn("bgItem"));
        this.formatFootRow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanFetchFactory.getRemoteInstance();
    }

    private void setBtnDisplayInBizUnit() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        this.actionAudit.setVisible(!isBizUnit);
        this.actionUnAudit.setVisible(!isBizUnit);
        this.actionVoucher.setVisible(!isBizUnit);
        this.actionDelVoucher.setVisible(!isBizUnit);
        this.btnCreateTo.setVisible(!isBizUnit);
        this.menuItemCreate.setVisible(!isBizUnit);
    }

    protected boolean isVoucherVisible() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        return !isBizUnit;
    }

    protected void displayButton() {
        this.actionVoucher.setVisible(true);
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setVisible(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionGenRecBill.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isMutiRemove() {
        return false;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LoanFetchFilterParam param = (LoanFetchFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new String[]{"loanPromiseAmount", "AmountLocalCur", "notFetchAmount", "Amount"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionCreateTo.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_releasebymodule"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectStringPK pk = new ObjectStringPK(this.getSelectedKeyValue());
        LoanFetchInfo info = (LoanFetchInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info != null && (info.getStatus() == FsBillStatusEnum.AUDIT || info.getStatus() == FsBillStatusEnum.SAVE)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"15_SubmitStatus_can_audit"));
            SysUtil.abort();
        }
        LoanFetchFactory.getRemoteInstance().audit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectStringPK pk = new ObjectStringPK(this.getSelectedKeyValue());
        LoanFetchInfo info = (LoanFetchInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getStatus() != FsBillStatusEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"16_Audit_not_relation_can_unAudit"));
            SysUtil.abort();
        }
        if (SLUtils.existsDestBillSet(info.getId().toString())) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"16_Audit_not_relation_can_unAudit");
        }
        LoanFetchFactory.getRemoteInstance().unAudit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSelectOneItem((CoreUI)this, this.tblMain);
        ObjectStringPK pk = new ObjectStringPK(this.getSelectedKeyValue());
        LoanFetchInfo info = (LoanFetchInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getStatus() != FsBillStatusEnum.AUDIT || info.isIsGenRecBill()) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"17_Audit_can_create_genRecBill");
        }
        super.actionCreateTo_actionPerformed(e);
        this.refreshList();
    }

    public void checkSelectOneItem(CoreUI ui, KDTable table) {
        int size = KDTableUtil.getSelectedRowCount((KDTable)this.tblMain);
        if (size > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5355\u7b14\u8bb0\u5f55\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355");
            SysUtil.abort();
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectStringPK pk = new ObjectStringPK(this.getSelectedKeyValue());
        LoanFetchInfo info = (LoanFetchInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getStatus() == FsBillStatusEnum.SAVE) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"19_Submit_And_Audit_CanCreateVorchor"));
            SysUtil.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        ObjectStringPK pk = new ObjectStringPK(this.getSelectedKeyValue());
        LoanFetchInfo info = (LoanFetchInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.isFiVouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            LoanFetchListUI.this.setListUITable(LoanFetchListUI.this.tblMain, e);
        }
    }
}

