/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.stock.IInitStockFacade;
import com.kingdee.eas.fm.stock.InitStockFacadeFactory;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockHelper;
import com.kingdee.eas.fm.stock.client.AbstractDailySettleUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class DailySettleUI
extends AbstractDailySettleUI {
    private static final Logger logger = CoreUIObject.getLogger(DailySettleUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private String curCompId = this.currentCompany.getId().toString();
    private static final String resPath = "com.kingdee.eas.fm.stock.client.DailySettleResource";
    private Date settleDate = new Date();

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        if (!StockHelper.isInited(null, this.curCompId)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"1_DailySettleUI"));
            SysUtil.abort();
        }
        super.onLoad();
        this.settleDate = this.getDailySettledDate(this.curCompId);
        this.kDbeginDate.setValue((Object)this.settleDate);
        Date endDate = new Date();
        if (this.getUIContext().containsKey("endDate") && this.getUIContext().get("endDate") != null) {
            endDate = (Date)this.getUIContext().get("endDate");
        }
        this.kDendDate.setValue((Object)endDate);
        this.kDbeginDate.setEnabled(false);
        this.kDendDate.setEnabled(true);
        this.initUI();
    }

    private void initUI() throws Exception {
        this.setImage();
        this.setDescText(true);
    }

    private void setImage() {
        Icon guide = EASResource.getIcon((String)"imgGuide_pic260");
        KDLabel backlabel = new KDLabel(guide);
        backlabel.setBounds(0, 0, guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.add((Component)backlabel, (Object)"Center");
        this.pnlPicture.setSize(guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.setBackground(Color.blue);
    }

    private void setDescText(boolean isSettle) throws BOSException {
        if (this.kDendDate.getValue() == null) {
            return;
        }
        DateFormat df = DateFormat.getDateInstance(1);
        Date preSettleDate = DateUtil.getBeforeDay((Date)this.settleDate);
        String settleText = MessageFormat.format(this.getResString("CurrentSettleDate"), df.format(preSettleDate));
        StringBuffer sb = new StringBuffer();
        sb.append(settleText);
        sb.append("\n");
        if (this.getWithBill(DateUtil.getAfterDay((Date)((Date)this.kDbeginDate.getValue())), (Date)this.kDendDate.getValue())) {
            String nextSettleText = MessageFormat.format(this.getResString("DURINGDATE"), df.format((Date)this.kDbeginDate.getValue()), df.format((Date)this.kDendDate.getValue()));
            sb.append(nextSettleText).append(MessageFormat.format(this.getResString("WITHBILL"), null));
        } else {
            String nextSettleText = MessageFormat.format(this.getResString("DURINGDATE"), df.format((Date)this.kDbeginDate.getValue()), df.format((Date)this.kDendDate.getValue()));
            sb.append(nextSettleText).append(MessageFormat.format(this.getResString("WITHOUTBILL"), null));
        }
        this.txtDesc.setText(sb.toString());
    }

    private String getResString(String resName) {
        return EASResource.getString((String)resPath, (String)resName);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        String info = null;
        IInitStockFacade manager = InitStockFacadeFactory.getRemoteInstance();
        if (this.radioDailySettle.isSelected()) {
            manager.dailySettle(this.currentCompany, (Date)this.kDbeginDate.getValue(), (Date)this.kDendDate.getValue());
            info = this.getResString("Success");
        } else if (this.radioAntiDailySettle.isSelected()) {
            manager.antiDailySettle(this.curCompId, (Date)this.kDbeginDate.getValue(), (Date)this.kDendDate.getValue());
            info = this.getResString("AntiSettleSuccess");
        }
        this.settleDate = this.getDailySettledDate(this.curCompId);
        DateFormat df = DateFormat.getDateInstance(1);
        info = info + "\n" + MessageFormat.format(this.getResString("CurrentSettleDate"), df.format(DateUtil.getBeforeDay((Date)this.settleDate)));
        this.txtDesc.setText(info);
        this.radioDailySettle.setEnabled(false);
        this.radioAntiDailySettle.setEnabled(false);
        this.btnOK.setVisible(false);
        this.btnCancel.setText(this.getResString("Close"));
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void radioDailySettle_actionPerformed(ActionEvent e) throws Exception {
        this.kDbeginDate.setValue((Object)this.settleDate);
        Date endDate = new Date();
        if (this.getUIContext().containsKey("endDate") && this.getUIContext().get("endDate") != null) {
            endDate = (Date)this.getUIContext().get("endDate");
        }
        this.kDendDate.setValue((Object)endDate);
        this.setDescText(true);
    }

    @Override
    protected void radioAntiDailySettle_actionPerformed(ActionEvent e) throws Exception {
        this.kDbeginDate.setValue((Object)DateUtil.getBeforeDay((Date)this.settleDate));
        this.kDendDate.setValue(this.kDbeginDate.getValue());
        this.setDescText(false);
    }

    @Override
    protected void kDendDate_dataChanged(DataChangeEvent e) throws Exception {
        this.setDescText(true);
    }

    public Date getDailySettledDate(String companyId) throws BOSException, SQLException, StockException {
        Date initday = new Date();
        String sql = " select FsettleDate  from T_SK_SettleDate where  FCurCompanyID='" + companyId + "' and FIsinit=0 ";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (!rs.next()) {
            throw new StockException(StockException.INIT_EXC1);
        }
        initday = rs.getDate("FsettleDate");
        return initday;
    }

    public Date getOpenDate(String companyId) throws BOSException, EASBizException {
        Date initday = new Date();
        String sql = " select FsettleDate  from T_SK_SettleDate where  FCurCompanyID='" + companyId + "' and FIsinit=1 ";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            if (rs.next()) {
                initday = rs.getDate("FsettleDate");
                return initday;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        throw new StockException(StockException.INIT_EXC1);
    }

    public boolean getWithBill(Date dateFrom, Date dateTo) throws BOSException {
        boolean withbill = false;
        String sql = " select *  from T_SK_StockInvestBill where  FCompanyID='" + this.curCompId + "'  and FExchangeDate>={" + Constants.FORMAT_TIME.format(dateFrom) + "} and FExchangeDate<={" + Constants.FORMAT_TIME.format(dateTo) + "}";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            withbill = rs.next();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return withbill;
    }

    public void verify() throws EASBizException, BOSException {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kDbeginDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kDendDate);
        Date beginDate = (Date)this.kDbeginDate.getValue();
        Date endDate = (Date)this.kDendDate.getValue();
        if (this.radioDailySettle.isSelected()) {
            if (endDate.before(beginDate)) {
                MsgBox.showInfo((String)this.getResString("EndGreaterEqualStart"));
                SysUtil.abort();
            }
        } else if (this.radioAntiDailySettle.isSelected()) {
            Date openDate;
            if (endDate.after(beginDate)) {
                MsgBox.showInfo((String)this.getResString("EndLessEqualStart"));
                SysUtil.abort();
            }
            if (endDate.before(openDate = StockHelper.getOpenDate(null, this.curCompId))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"2_DailySettleUI"));
                SysUtil.abort();
            }
        }
    }
}

