/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.stock.FundSettleBillCollection;
import com.kingdee.eas.fm.stock.IInitStockFacade;
import com.kingdee.eas.fm.stock.InitStockFacadeFactory;
import com.kingdee.eas.fm.stock.InitTypeEnum;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockHelper;
import com.kingdee.eas.fm.stock.StockSettleBillCollection;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.fm.stock.client.AbstractInitSettleEditUI;
import com.kingdee.eas.fm.stock.client.InitSettleHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InitSettleEditUI
extends AbstractInitSettleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InitSettleEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private String curCompId = this.currentCompany.getId().toString();
    private boolean isEdit = false;
    private boolean isSave = false;
    private InitSettleHelper helper = InitSettleHelper.getInstance();
    private boolean beEdited = false;

    private String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.stock.client.StockResource", (String)key);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionFinished.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_initialize"));
        this.actionUnFinished.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
        this.initGuaraTable();
        if (StockHelper.isInited(null, this.curCompId)) {
            this.setActionEnable(false);
        } else {
            this.setActionEnable(true);
        }
        this.actionSetBizDate.setVisible(false);
        this.kDInitDate.setValue((Object)this.getInitDate());
        this.loadFields();
    }

    private Date getInitDate() throws EASBizException, BOSException {
        Date initDate = StockHelper.getOpenDate(null, this.curCompId);
        return DateUtil.getFirstDayOfMonth((Date)initDate);
    }

    private void setActionEnable(boolean isUsed) {
        this.actionSave.setEnabled(isUsed);
        this.actionAddLine.setEnabled(isUsed);
        this.actionInsertLine.setEnabled(isUsed);
        this.actionRemoveLine.setEnabled(isUsed);
        this.actionFinished.setEnabled(isUsed);
        this.actionUnFinished.setEnabled(!isUsed);
        this.kDInitDate.setEnabled(isUsed);
        this.isEdit = isUsed;
    }

    protected void initGuaraTable() throws Exception {
        this.initFundTable();
        this.initStockTable();
        if (!StockHelper.isInited(null, this.curCompId)) {
            if (!StockHelper.FundisSaved(null, this.curCompId)) {
                this.addLine(-1, this.FundTable);
            }
            if (!StockHelper.StockisSaved(null, this.curCompId)) {
                // empty if block
            }
        }
    }

    protected void initFundTable() throws Exception {
        this.FundTable.checkParsed();
        KDFormattedTextField txtFund = new KDFormattedTextField();
        txtFund.setDataType(1);
        txtFund.setPrecision(2);
        txtFund.setHorizontalAlignment(4);
        this.FundTable.getColumn("initFund").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFund));
        this.FundTable.getColumn("initFund").getStyleAttributes().setNumberFormat("###,##0.00");
        this.FundTable.getColumn("initFund").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDBizPromptBox prmtAccountBank = new KDBizPromptBox();
        ExtendParser parserAccountBank = new ExtendParser(prmtAccountBank);
        prmtAccountBank.setCommitParser((IParser)parserAccountBank);
        prmtAccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtAccountBank.setVisible(true);
        prmtAccountBank.setEditable(false);
        prmtAccountBank.setDisplayFormat("$name$ $number$");
        prmtAccountBank.setEditFormat("$number$");
        prmtAccountBank.setCommitFormat("$number$");
        EntityViewInfo eviAccountBank = new EntityViewInfo();
        eviAccountBank.setFilter(this.getAccountBankFilter());
        prmtAccountBank.setEntityViewInfo(eviAccountBank);
        ObjectValueRender avrAccountBank = new ObjectValueRender();
        avrAccountBank.setFormat((IDataFormat)new BizDataFormat("$number$ $name$"));
        this.FundTable.getColumn("bankAccount").setRenderer((IBasicRender)avrAccountBank);
        prmtAccountBank.setRequired(true);
        this.FundTable.getColumn("bankAccount").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccountBank));
        KDComboBox cboCurrency = new KDComboBox();
        CashHelper.initCombCurrency((KDComboBox)cboCurrency, (boolean)false);
        this.FundTable.getColumn("currency").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cboCurrency));
    }

    protected void initStockTable() {
        this.StockTable.checkParsed();
        KDFormattedTextField txtStorageNum = new KDFormattedTextField();
        txtStorageNum.setDataType(1);
        txtStorageNum.setPrecision(2);
        txtStorageNum.setHorizontalAlignment(4);
        this.StockTable.getColumn("initStorageNum").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtStorageNum));
        this.StockTable.getColumn("initStorageNum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.StockTable.getColumn("initStorageNum").getStyleAttributes().setNumberFormat("###,##0.00");
        KDFormattedTextField txtCostPrice = new KDFormattedTextField();
        txtCostPrice.setDataType(1);
        txtCostPrice.setPrecision(3);
        txtCostPrice.setHorizontalAlignment(4);
        this.StockTable.getColumn("initCostPrice").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCostPrice));
        this.StockTable.getColumn("initCostPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.StockTable.getColumn("initCostPrice").getStyleAttributes().setNumberFormat("###,##0.000");
        KDFormattedTextField txtAmount = new KDFormattedTextField();
        txtAmount.setDataType(1);
        txtAmount.setPrecision(3);
        txtAmount.setHorizontalAlignment(4);
        this.StockTable.getColumn("initAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmount));
        this.StockTable.getColumn("initAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.StockTable.getColumn("initAmount").getStyleAttributes().setNumberFormat("###,##0.00");
        KDBizPromptBox prmtStockholder = new KDBizPromptBox();
        ExtendParser parserStockholder = new ExtendParser(prmtStockholder);
        prmtStockholder.setCommitParser((IParser)parserStockholder);
        prmtStockholder.setQueryInfo("com.kingdee.eas.fm.stock.app.StockholderQuery");
        prmtStockholder.setVisible(true);
        prmtStockholder.setEditable(false);
        prmtStockholder.setDisplayFormat("$number$ $name$");
        prmtStockholder.setEditFormat("$number$");
        prmtStockholder.setCommitFormat("$number$");
        EntityViewInfo eviStockholder = new EntityViewInfo();
        eviStockholder.setFilter(this.getStockHolderFilter());
        prmtStockholder.setEntityViewInfo(eviStockholder);
        ObjectValueRender avrStockholder = new ObjectValueRender();
        avrStockholder.setFormat((IDataFormat)new BizDataFormat("$number$ $name$"));
        this.StockTable.getColumn("stockholder").setRenderer((IBasicRender)avrStockholder);
        prmtStockholder.setRequired(true);
        prmtStockholder.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                InitSettleEditUI.this.fillCellAfterBillSelectedStockholder(eventObj);
            }
        });
        this.StockTable.getColumn("stockholder").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtStockholder));
        KDBizPromptBox prmtStock = new KDBizPromptBox();
        ExtendParser parserStock = new ExtendParser(prmtStock);
        prmtStock.setCommitParser((IParser)parserStock);
        prmtStock.setQueryInfo("com.kingdee.eas.fm.stock.app.StockQuery");
        prmtStock.setVisible(true);
        prmtStock.setEditable(true);
        prmtStock.setDisplayFormat("$number$ $simpleName$");
        prmtStock.setEditFormat("$number$");
        prmtStock.setCommitFormat("$number$");
        prmtStock.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtStock));
        ObjectValueRender avrStock = new ObjectValueRender();
        avrStock.setFormat((IDataFormat)new BizDataFormat("$number$ $simpleName$"));
        this.StockTable.getColumn("stock").setRenderer((IBasicRender)avrStock);
        prmtStock.setRequired(true);
        EntityViewInfo eviStock = new EntityViewInfo();
        eviStock.setFilter(this.getStockFilter());
        prmtStock.setEntityViewInfo(eviStock);
        this.StockTable.getColumn("stock").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtStock));
        this.StockTable.getColumn("currency").getStyleAttributes().setLocked(true);
        this.StockTable.getColumn("currency").getStyleAttributes().setBackground(new Color(0xE8E8E3));
        this.StockTable.getColumn("bankAccount").getStyleAttributes().setLocked(true);
        this.StockTable.getColumn("bankAccount").getStyleAttributes().setBackground(new Color(0xE8E8E3));
    }

    @Override
    public void loadFields() {
        try {
            this.helper.loadField(this.FundTable, this.curCompId);
            this.helper.loadField(this.StockTable, this.curCompId);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (!this.isEdit) {
            this.FundTable.setEditable(false);
            this.StockTable.setEditable(false);
        }
    }

    @Override
    protected void CBoxType_itemStateChanged(ItemEvent e) throws Exception {
        super.CBoxType_itemStateChanged(e);
        if (this.CBoxType.getSelectedItem().equals((Object)InitTypeEnum.Fund)) {
            this.StockTable.setVisible(false);
            this.FundTable.setVisible(true);
        } else {
            this.FundTable.setVisible(false);
            this.StockTable.setVisible(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kDInitDate);
        Date initDate = DateTimeUtils.truncateDate((Date)((Date)this.kDInitDate.getValue()));
        Date firstDate = DateUtil.getFirstDayOfMonth((Date)initDate);
        if (initDate.compareTo(firstDate) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"3_InitSettleEditUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        FundSettleBillCollection fundcl = null;
        StockSettleBillCollection stockcl = null;
        if (this.CBoxType.getSelectedItem().equals((Object)InitTypeEnum.Fund) && this.FundTable.getRowCount() > 0) {
            fundcl = this.helper.storeFieldofFund(this.FundTable, this.currentCompany);
        }
        if (this.CBoxType.getSelectedItem().equals((Object)InitTypeEnum.Stock) && this.StockTable.getRowCount() > 0) {
            stockcl = this.helper.storeFieldofStock(this.StockTable, this.currentCompany);
        }
        IInitStockFacade manager = InitStockFacadeFactory.getRemoteInstance();
        manager.submit(fundcl, stockcl, this.curCompId, (Date)this.kDInitDate.getValue());
        this.isSave = true;
        this.beEdited = false;
        this.showStatusMessage(InitSettleHelper.SAVESUCCEED);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (this.CBoxType.getSelectedItem().equals((Object)InitTypeEnum.Fund)) {
            this.addLine(-1, this.FundTable);
        } else {
            this.addLine(-1, this.StockTable);
        }
        this.beEdited = true;
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        if (this.CBoxType.getSelectedItem().equals((Object)InitTypeEnum.Fund)) {
            int index = this.FundTable.getSelectManager().getActiveRowIndex();
            this.addLine(index, this.FundTable);
        } else {
            int index = this.StockTable.getSelectManager().getActiveRowIndex();
            this.addLine(index, this.StockTable);
        }
        this.beEdited = true;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.CBoxType.getSelectedItem().equals((Object)InitTypeEnum.Fund)) {
            this.removeLine(this.FundTable);
        } else {
            this.removeLine(this.StockTable);
        }
        this.beEdited = true;
    }

    @Override
    public void actionFinished_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.checkeDate((Date)this.kDInitDate.getValue())) {
            throw new StockException(StockException.EXCHANGE_EXC2);
        }
        this.actionSave_actionPerformed(e);
        IInitStockFacade manager = InitStockFacadeFactory.getRemoteInstance();
        manager.Init(this.curCompId, (Date)this.kDInitDate.getValue());
        this.setActionEnable(false);
        this.FundTable.setEditable(false);
        this.StockTable.setEditable(false);
    }

    @Override
    public void actionUnFinished_actionPerformed(ActionEvent e) throws Exception {
        IInitStockFacade manager = InitStockFacadeFactory.getRemoteInstance();
        manager.antiInit(this.curCompId);
        this.setActionEnable(true);
        this.FundTable.setEditable(true);
        this.StockTable.setEditable(true);
    }

    @Override
    protected void StockTable_editStopped(KDTEditEvent e) throws Exception {
        super.StockTable_editStopped(e);
        IRow row = this.StockTable.getRow(e.getRowIndex());
        if (row.getCell("initCostPrice").getValue() != null && row.getCell("initStorageNum").getValue() != null) {
            row.getCell("initAmount").setValue((Object)((BigDecimal)row.getCell("initCostPrice").getValue()).multiply((BigDecimal)row.getCell("initStorageNum").getValue()));
        }
        this.beEdited = true;
    }

    @Override
    protected void FundTable_editStopped(KDTEditEvent e) throws Exception {
        super.FundTable_editStopped(e);
        this.beEdited = true;
    }

    private void addLine(int index, KDTable kdtEntrys) throws EASBizException, BOSException {
        IRow row = null;
        row = index != -1 ? kdtEntrys.addRow(index) : kdtEntrys.addRow();
        row.getCell("currency").setValue((Object)this.getCurrency(this.currentCompany.getBaseCurrency().getId().toString()));
    }

    private void removeLine(KDTable kdtEntrys) {
        int index = kdtEntrys.getSelectManager().getActiveRowIndex();
        if (index < 0 || index >= kdtEntrys.getRowCount()) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("noneRow_Selected"));
            return;
        }
        kdtEntrys.removeRow(index);
    }

    protected void fillCellAfterBillSelectedStockholder(DataChangeEvent eventObj) {
        int rowIndex = this.StockTable.getSelectManager().getActiveRowIndex();
        IRow curRow = this.StockTable.getRow(rowIndex);
        FinHelper.clearCells((KDTable)this.StockTable, (int)rowIndex, (String[])new String[]{"bankAccount", "currency", "stock"});
        if (eventObj.getNewValue() instanceof StockholderInfo) {
            StockholderInfo info = (StockholderInfo)eventObj.getNewValue();
            curRow.getCell("bankAccount").setValue((Object)this.getAccountBankInfo(info.getBankAccount().getId().toString()));
            curRow.getCell("currency").setValue((Object)this.getCurrencyInfo(info.getCurrency().getId().toString()));
            KDBizPromptBox prmtStock = new KDBizPromptBox();
            ExtendParser parserStock = new ExtendParser(prmtStock);
            prmtStock.setCommitParser((IParser)parserStock);
            prmtStock.setQueryInfo("com.kingdee.eas.fm.stock.app.StockQuery");
            prmtStock.setVisible(true);
            prmtStock.setEditable(true);
            prmtStock.setDisplayFormat("$number$ $simpleName$");
            prmtStock.setEditFormat("$number$");
            prmtStock.setCommitFormat("$number$");
            prmtStock.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtStock));
            ObjectValueRender avrStock = new ObjectValueRender();
            avrStock.setFormat((IDataFormat)new BizDataFormat("$number$ $simpleName$"));
            this.StockTable.getColumn("stock").setRenderer((IBasicRender)avrStock);
            prmtStock.setRequired(true);
            EntityViewInfo eviStock = new EntityViewInfo();
            eviStock.setFilter(this.getStockFilter(info));
            prmtStock.setEntityViewInfo(eviStock);
            curRow.getCell("stock").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtStock));
        }
    }

    private CurrencyInfo getCurrencyInfo(String id) {
        try {
            return CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    private AccountBankInfo getAccountBankInfo(String id) {
        try {
            return AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    protected FilterInfo getStockHolderFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.curCompId));
        return filter;
    }

    protected FilterInfo getStockFilter() {
        IRow curRow;
        FilterInfo filter = new FilterInfo();
        int rowIndex = this.StockTable.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (curRow = this.StockTable.getRow(rowIndex)).getCell("stockholder").getValue() instanceof StockholderInfo) {
            StockholderInfo info = (StockholderInfo)curRow.getCell("stockholder").getValue();
            filter.getFilterItems().add(new FilterItemInfo("exchagePlace", (Object)info.getExchagePlaceEnu().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("stockType", (Object)info.getStockTypeEnum().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        }
        return filter;
    }

    protected FilterInfo getStockFilter(StockholderInfo info) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchagePlace", (Object)info.getExchagePlaceEnu().getValue()));
        filter.getFilterItems().add(new FilterItemInfo("stockType", (Object)info.getStockTypeEnum().getValue()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        return filter;
    }

    protected FilterInfo getAccountBankFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.curCompId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        return filter;
    }

    private Date getFirstDateOfMonth() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(5, 1);
        return c.getTime();
    }

    private void showStatusMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    public CurrencyInfo getCurrency(String pk) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(pk));
        return currency;
    }

    private boolean checkeDate(Date exchangeDate) throws BOSException, SQLException {
        String sql = " select *  from T_SK_StockInvestBill where   FCompanyID='" + this.currentCompany.getId().toString() + "' and FExchangeDate<{" + Constants.FORMAT_TIME.format(exchangeDate) + "}";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        return rs.next();
    }

    protected boolean checkBeforeWindowClosing() {
        int result;
        if (this.beEdited && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"4_InitSettleEditUI"))) == 0) {
            SysUtil.abort();
        }
        return super.checkBeforeWindowClosing();
    }
}

