/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.stock.FundSettleBillCollection;
import com.kingdee.eas.fm.stock.FundSettleBillInfo;
import com.kingdee.eas.fm.stock.IInitStockFacade;
import com.kingdee.eas.fm.stock.InitStockFacadeFactory;
import com.kingdee.eas.fm.stock.StockInfo;
import com.kingdee.eas.fm.stock.StockSettleBillCollection;
import com.kingdee.eas.fm.stock.StockSettleBillInfo;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.HashMap;

public class InitSettleHelper {
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    public static final String resPath = "com.kingdee.eas.fm.fs.FSClientResource";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String SAVESUCCEED = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSClientResource", (String)"saveSucceed");
    private FundSettleBillCollection FundSettleBillCollection;
    private StockSettleBillCollection StockSettleBillCollection;
    private static InitSettleHelper instance;

    private InitSettleHelper() {
    }

    public static InitSettleHelper getInstance() {
        if (instance == null) {
            instance = new InitSettleHelper();
        }
        return instance;
    }

    public void loadField(KDTable table, String companyId) throws Exception {
        IInitStockFacade manager = InitStockFacadeFactory.getRemoteInstance();
        if (table.getName().equals("FundTable")) {
            FundSettleBillCollection Fundcoll;
            this.FundSettleBillCollection = Fundcoll = manager.getInitFundCollection(companyId);
            this.loadCollectionToTable(Fundcoll, table);
        } else {
            StockSettleBillCollection Stockcoll;
            this.StockSettleBillCollection = Stockcoll = manager.getInitStockCollection(companyId);
            this.loadCollectionToTable(Stockcoll, table);
        }
    }

    public void loadCollectionToTable(FundSettleBillCollection coll, KDTable table) throws Exception {
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                FundSettleBillInfo InitInfo = coll.get(i);
                IRow row = table.addRow();
                row.setUserObject((Object)InitInfo);
                this.loadLineFields(row, InitInfo);
            }
        }
    }

    public void loadCollectionToTable(StockSettleBillCollection coll, KDTable table) throws Exception {
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                StockSettleBillInfo InitInfo = coll.get(i);
                IRow row = table.addRow();
                row.setUserObject((Object)InitInfo);
                this.loadLineFields(row, InitInfo);
            }
        }
    }

    public void loadLineFields(IRow row, FundSettleBillInfo obj) {
        row.getCell("currency").setValue((Object)obj.getCurrency());
        row.getCell("bankAccount").setValue((Object)obj.getBankAccount());
        row.getCell("initFund").setValue((Object)this.getBigDecimalByScale(obj.getInitFund()));
    }

    public void loadLineFields(IRow row, StockSettleBillInfo obj) {
        StockSettleBillInfo intinfo = obj;
        row.getCell("currency").setValue((Object)obj.getCurrency());
        row.getCell("bankAccount").setValue((Object)obj.getBankAccount());
        row.getCell("stockholder").setValue((Object)obj.getStockholder());
        row.getCell("stock").setValue((Object)obj.getStock());
        row.getCell("initStorageNum").setValue((Object)this.getBigDecimalByScale(obj.getInitStorageNum()));
        row.getCell("initCostPrice").setValue((Object)this.getBigDecimalByScale(obj.getInitCostPrice()));
        row.getCell("initAmount").setValue((Object)this.getBigDecimalByScale(obj.getInitAmount()));
    }

    public FundSettleBillCollection storeFieldofFund(KDTable table, CompanyOrgUnitInfo company) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        FundSettleBillCollection FundSettleCol = null;
        HashMap<String, String> infoMap = new HashMap<String, String>();
        if (rowCount > 0) {
            FundSettleCol = new FundSettleBillCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                if (row.getCell("bankAccount").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"5_InitSettleHelper"));
                    SysUtil.abort();
                } else if (infoMap.containsKey(row.getCell("bankAccount").getValue().toString() + row.getCell("currency").getValue().toString())) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"6_InitSettleHelper"));
                    SysUtil.abort();
                }
                if (this.isRowNotValidaboutFund(row)) continue;
                FundSettleBillInfo FundSettleInfo = new FundSettleBillInfo();
                FundSettleInfo.setCompany(company);
                FundSettleInfo.setCurrency((CurrencyInfo)row.getCell("currency").getValue());
                FundSettleInfo.setBankAccount((AccountBankInfo)row.getCell("bankAccount").getValue());
                FundSettleInfo.setInitFund(FMHelper.getBigDecimal((Object)row.getCell("initFund").getValue()));
                FundSettleInfo.setBeginFundBalance(FMHelper.getBigDecimal((Object)row.getCell("initFund").getValue()));
                FundSettleInfo.setFundBalance(FMHelper.getBigDecimal((Object)row.getCell("initFund").getValue()));
                FundSettleInfo.setStockJobber(((AccountBankInfo)row.getCell("bankAccount").getValue()).getBank());
                FundSettleInfo.setIsInit(true);
                FundSettleCol.add(FundSettleInfo);
                infoMap.put(row.getCell("bankAccount").getValue().toString() + row.getCell("currency").getValue().toString(), row.getCell("bankAccount").getValue().toString() + row.getCell("currency").getValue().toString());
            }
        }
        return FundSettleCol;
    }

    public StockSettleBillCollection storeFieldofStock(KDTable table, CompanyOrgUnitInfo company) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        StockSettleBillCollection SettleCol = null;
        HashMap<String, String> infoMap = new HashMap<String, String>();
        if (rowCount > 0) {
            SettleCol = new StockSettleBillCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                if (row.getCell("stockholder").getValue() == null) {
                    MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"7_InitSettleHelper") + (row.getRowIndex() + 1) + EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"8_InitSettleHelper")));
                    SysUtil.abort();
                }
                if (row.getCell("stock").getValue() == null) {
                    MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"7_InitSettleHelper") + (row.getRowIndex() + 1) + EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"9_InitSettleHelper")));
                    SysUtil.abort();
                }
                if (infoMap.containsKey(row.getCell("stockholder").getValue().toString() + row.getCell("stock").getValue().toString())) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"10_InitSettleHelper"));
                    SysUtil.abort();
                }
                if (this.isRowNotValidaboutStock(row)) continue;
                StockSettleBillInfo SettleInfo = new StockSettleBillInfo();
                SettleInfo.setCompany(company);
                SettleInfo.setCurrency((CurrencyInfo)row.getCell("currency").getValue());
                SettleInfo.setBankAccount((AccountBankInfo)row.getCell("bankAccount").getValue());
                SettleInfo.setInitAmount(FMHelper.getBigDecimal((Object)row.getCell("initAmount").getValue()));
                SettleInfo.setBeginSumAmount(FMHelper.getBigDecimal((Object)row.getCell("initAmount").getValue()));
                SettleInfo.setSumamount(FMHelper.getBigDecimal((Object)row.getCell("initAmount").getValue()));
                SettleInfo.setInitStorageNum(FMHelper.getBigDecimal((Object)row.getCell("initStorageNum").getValue()));
                SettleInfo.setBeginSumNum(FMHelper.getBigDecimal((Object)row.getCell("initStorageNum").getValue()));
                SettleInfo.setSumnum(FMHelper.getBigDecimal((Object)row.getCell("initStorageNum").getValue()));
                SettleInfo.setInitCostPrice(FMHelper.getBigDecimal((Object)row.getCell("initCostPrice").getValue()));
                SettleInfo.setCostprice(FMHelper.getBigDecimal((Object)row.getCell("initCostPrice").getValue()));
                SettleInfo.setIsInit(true);
                SettleInfo.setStock((StockInfo)row.getCell("stock").getValue());
                SettleInfo.setStockholder((StockholderInfo)row.getCell("stockholder").getValue());
                SettleInfo.setStockjobber(((StockholderInfo)row.getCell("stockholder").getValue()).getStockJobber());
                SettleCol.add(SettleInfo);
                infoMap.put(row.getCell("stockholder").getValue().toString() + row.getCell("stock").getValue().toString(), row.getCell("stockholder").getValue().toString() + row.getCell("stock").getValue().toString());
            }
        }
        return SettleCol;
    }

    private boolean isRowNotValidaboutFund(IRow row) {
        Object initFund = row.getCell("initFund").getValue();
        boolean isNotValid = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)initFund));
        return isNotValid;
    }

    private boolean isRowNotValidaboutStock(IRow row) {
        Object initStorageNum = row.getCell("initStorageNum").getValue();
        Object initCostPrice = row.getCell("initCostPrice").getValue();
        Object initAmount = row.getCell("initAmount").getValue();
        boolean isNotValid = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)initStorageNum));
        boolean isNotValidCPrice = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)initCostPrice));
        boolean isNotValidAmount = FMHelper.isZERO((BigDecimal)FMHelper.getBigDecimal((Object)initAmount));
        return isNotValid && isNotValidCPrice && isNotValidAmount;
    }

    public BigDecimal getBigDecimalByScale(BigDecimal big) {
        BigDecimal newBig = this.getBigDecimal(big);
        newBig = newBig.setScale(2, 4);
        return newBig;
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }
}

