/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.stock.MarketCapFactory;
import com.kingdee.eas.fm.stock.MarketCapInfo;
import com.kingdee.eas.fm.stock.client.AbstractMarketCapEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class MarketCapEditUI
extends AbstractMarketCapEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MarketCapEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getStock() != null) {
            this.editData.setNumber(this.editData.getStock().getNumber() + "-" + DateTimeUtils.format((Date)this.editData.getCurDate(), (String)"yyyyMMdd"));
        }
    }

    public void onLoad() throws Exception {
        this.txtOpenPrice.setPrecision(2);
        this.txtClosePrice.setPrecision(2);
        this.txtHighestPrice.setPrecision(2);
        this.txtLowestPrice.setPrecision(2);
        this.txtXdxrPrice.setPrecision(2);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtHighestPrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLowestPrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtOpenPrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtClosePrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtXdxrPrice);
        super.onLoad();
        this.prmtStock.setSelector(null);
        if (this.getOprtState().equals(OprtState.ADDNEW) || !this.editData.isIsXDXR()) {
            this.txtXdxrPrice.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.chkIsXDXR.setEnabled(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionPrint, this.actionEdit, this.actionSave, this.actionCancel, this.actionCancelCancel, this.actionCopy, this.actionRemove, this.actionFirst, this.actionPre, this.actionNext, this.actionLast, this.actionPrintPreview};
        this.setActionVisible(false, actions);
    }

    private void setActionVisible(boolean visible, ItemAction[] actions) {
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(visible);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MarketCapFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        MarketCapInfo objectValue = new MarketCapInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCurDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setHighestPrice(Constants.ZERO);
        objectValue.setLowestPrice(Constants.ZERO);
        objectValue.setOpenPrice(Constants.ZERO);
        objectValue.setClosePrice(Constants.ZERO);
        objectValue.setXdxrPrice(Constants.ZERO);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyAGreaterThanEqualsB((CoreUIObject)this, (KDFormattedTextField)this.txtHighestPrice, (KDFormattedTextField)this.txtOpenPrice);
        FMClientVerifyHelper.verifyALesserThanEqualsB((CoreUIObject)this, (KDFormattedTextField)this.txtLowestPrice, (KDFormattedTextField)this.txtOpenPrice);
        FMClientVerifyHelper.verifyAGreaterThanEqualsB((CoreUIObject)this, (KDFormattedTextField)this.txtClosePrice, (KDFormattedTextField)this.txtLowestPrice);
        FMClientVerifyHelper.verifyALesserThanEqualsB((CoreUIObject)this, (KDFormattedTextField)this.txtClosePrice, (KDFormattedTextField)this.txtHighestPrice);
        FMClientVerifyHelper.verifyAGreaterThanEqualsB((CoreUIObject)this, (KDFormattedTextField)this.txtHighestPrice, (KDFormattedTextField)this.txtLowestPrice);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtOpenPrice, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtHighestPrice, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtLowestPrice, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtClosePrice, (BigDecimal)Constants.ZERO);
        if (this.editData.isIsXDXR()) {
            FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtXdxrPrice);
        }
    }

    @Override
    protected void chkIsXDXR_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsXDXR_stateChanged(e);
        if (this.chkIsXDXR.isSelected()) {
            this.txtXdxrPrice.setEnabled(true);
            this.txtXdxrPrice.setRequired(true);
        } else {
            this.txtXdxrPrice.setValue((Object)Constants.ZERO);
            this.txtXdxrPrice.setEnabled(false);
            this.txtXdxrPrice.setRequired(false);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkCurDate);
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }
}

