/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.stock.client.RptStockGeneralFilterParam;
import com.kingdee.eas.fm.stock.client.RptStockGeneralHandlerAdapter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;

public class RptStockGeneralHandler
extends RptStockGeneralHandlerAdapter {
    public RptStockGeneralHandler(RptStockGeneralFilterParam param, KDTable kdt) {
        super(param, kdt);
    }

    @Override
    protected void insertHeadRow() {
        IColumn colstockjobber = this.kdt.addColumn();
        colstockjobber.setKey("stockjobber_name");
        colstockjobber.setMergeable(true);
        colstockjobber.setGroup(true);
        IColumn colcurrency_name = this.kdt.addColumn();
        colcurrency_name.setKey("currency_name");
        colcurrency_name.setGroup(true);
        IColumn colstock_name = this.kdt.addColumn();
        colstock_name.setKey("stock_name");
        colstock_name.setGroup(true);
        IColumn colOfferingDate = this.kdt.addColumn();
        colOfferingDate.setKey("STOCK_OFFERINGDATE");
        colOfferingDate.setGroup(true);
        IColumn colExchangeDate = this.kdt.addColumn();
        colExchangeDate.setKey("EXCHANGEDATE");
        colExchangeDate.setGroup(true);
        IColumn colFreefloat = this.kdt.addColumn();
        colFreefloat.setKey("STOCK_FREEFLOAT");
        colFreefloat.setGroup(true);
        this.formatCol(colFreefloat, 1);
        IColumn colFIssuPrice = this.kdt.addColumn();
        colFIssuPrice.setKey("STOCK_ISSUPRICE");
        colFIssuPrice.setGroup(true);
        this.formatCol(colFIssuPrice, 1);
        IColumn colissueamount = this.kdt.addColumn();
        colissueamount.setKey("STOCK_ISSUEAMOUNT");
        colissueamount.setGroup(true);
        this.formatCol(colissueamount, 1);
        IColumn colrepwinrate = this.kdt.addColumn();
        colrepwinrate.setKey("REPWINRATE");
        colrepwinrate.setGroup(true);
        this.formatCol(colrepwinrate, 4);
        IColumn colactwinrate = this.kdt.addColumn();
        colactwinrate.setKey("ACTWINRATE");
        colactwinrate.setGroup(true);
        this.formatCol(colactwinrate, 4);
        IColumn colindustry = this.kdt.addColumn();
        colindustry.setKey("INDUSTRY_NAME");
        colindustry.setGroup(true);
        IColumn colperatio = this.kdt.addColumn();
        colperatio.setKey("STOCK_PERATIO");
        colperatio.setGroup(true);
        this.formatCol(colperatio, 1);
        IColumn colfirstupper = this.kdt.addColumn();
        colfirstupper.setKey("STOCK_FIRSTUPPER");
        colfirstupper.setGroup(true);
        this.formatCol(colfirstupper, 1);
        IColumn colapplyAmount = this.kdt.addColumn();
        colapplyAmount.setKey("APPLYAMOUNT");
        colapplyAmount.setGroup(true);
        this.formatCol(colapplyAmount, 1);
        IColumn colexchagenum = this.kdt.addColumn();
        colexchagenum.setKey("EXCHANGENUM");
        colexchagenum.setGroup(true);
        this.formatCol(colexchagenum, 2);
        IColumn colFExchangeAmount = this.kdt.addColumn();
        colFExchangeAmount.setKey("EXCHANGEAMOUNT");
        colFExchangeAmount.setGroup(true);
        this.formatCol(colFExchangeAmount, 1);
        IColumn coltheroyvaluerate = this.kdt.addColumn();
        coltheroyvaluerate.setKey("THEROYVALUERATE");
        coltheroyvaluerate.setGroup(true);
        this.formatCol(coltheroyvaluerate, 4);
        IColumn colactvaluerate = this.kdt.addColumn();
        colactvaluerate.setKey("ACTVALUERATE");
        colactvaluerate.setGroup(true);
        this.formatCol(colactvaluerate, 4);
        IColumn colearing = this.kdt.addColumn();
        colearing.setKey("EARNING");
        colearing.setGroup(true);
        this.formatCol(colearing, 1);
        IColumn colbankaccount_name = this.kdt.addColumn();
        colbankaccount_name.setKey("bankaccount_name");
        colbankaccount_name.setGroup(true);
    }

    @Override
    public void setTableStateRow() {
        this.kdt.getColumn("currency_name").setStat(true);
        IRow subtotalcurRow = this.kdt.getGroupManager().getStatRowTemplate(1);
        subtotalcurRow.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"11_RptStockGeneralHandler"));
        subtotalcurRow.getCell(1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalcurRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        this.formatSumRow(subtotalcurRow, "APPLYAMOUNT");
        this.formatSumRow(subtotalcurRow, "EXCHANGEAMOUNT");
        this.formatSumRow(subtotalcurRow, "EARNING");
    }

    private void formatSumRow(IRow row, String name) {
        row.getCell(name).setExpressions("SUM");
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell(name).getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell(name).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        row.getCell(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void formatCol(IColumn col, int type) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (type == 1) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        } else if (type == 2) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0}f");
        } else if (type == 4) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0.0000}f");
        }
    }

    protected void formatCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }
}

