/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.stock.client.RptStockGeneralFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public abstract class RptStockGeneralHandlerAdapter
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.stock.client.RptStockGeneralResource";
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    private CompanyOrgUnitInfo currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private RptStockGeneralFilterParam param;
    Set companyIdSet;
    Set bankIdSet;
    Date dateFrom;
    Date dateTo;
    CurrencyInfo currency;
    Set AccountBankIdSet;

    public RptStockGeneralHandlerAdapter(FilterInfo filterInfo, KDTable kdt) {
        super(filterInfo, kdt);
    }

    public RptStockGeneralHandlerAdapter(RptStockGeneralFilterParam param, KDTable kdt) {
        super(param.getFilter(), kdt);
        this.param = param;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
    }

    private String getDetailSQL() {
        StringBuffer sbDetailSQL = new StringBuffer();
        sbDetailSQL.append("SELECT STOCKINVESTBILL.Fid AS ID, STOCKJOBBER.FName_l2 AS STOCKJOBBER_NAME, STOCK.FSimpleName AS STOCK_NAME, CURRENCY.FName_l2 AS CURRENCY_NAME,STOCKINVESTBILL.FCurrencyID AS CURRENCY_ID, STOCKINVESTBILL.FOfferingDate AS STOCK_OFFERINGDATE, STOCKINVESTBILL.FExchangeDate AS EXCHANGEDATE, STOCK.FFreeFloat AS STOCK_FREEFLOAT, STOCKINVESTBILL.FExchangePrice AS STOCK_ISSUPRICE, STOCK.FIssueAmount AS STOCK_ISSUEAMOUNT, STOCKINVESTBILL.FRepwinRate AS REPWINRATE, STOCKINVESTBILL.FActwinRate AS ACTWINRATE, INDUSTRY.FName_l2 AS INDUSTRY_NAME, STOCK.FPERatio AS STOCK_PERATIO, STOCK.FFirstUpPer AS STOCK_FIRSTUPPER, STOCKINVESTBILL.FApplyAmount AS APPLYAMOUNT, STOCKINVESTBILL.FExchangeNum AS EXCHANGENUM, STOCKINVESTBILL.FExchangeAmount AS EXCHANGEAMOUNT, ((STOCKINVESTBILL.FRepwinRate * STOCK.FFirstUpPer) / 100) AS THEROYVALUERATE, ((STOCKINVESTBILL.FEarning / STOCKINVESTBILL.FApplyAmount) * 100) AS ACTVALUERATE, STOCKINVESTBILL.FEarning AS EARNING, BANKACCOUNT.FName_l2 AS BANKACCOUNT_NAME,  STOCKINVESTBILL.FInvestType AS INVESTTYPE FROM T_SK_StockInvestBill AS STOCKINVESTBILL LEFT OUTER JOIN T_ORG_Company AS COMPANY ON STOCKINVESTBILL.FCompanyID = COMPANY.FID LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON STOCKINVESTBILL.FCurrencyID = CURRENCY.FID LEFT OUTER JOIN T_SK_Stockholder AS STOCKHOLDER ON STOCKINVESTBILL.FStockHolderID = STOCKHOLDER.FID LEFT OUTER JOIN T_SK_Stock AS STOCK ON STOCKINVESTBILL.FStockID = STOCK.FID LEFT OUTER JOIN T_BD_AccountBanks AS BANKACCOUNT ON STOCKHOLDER.FBankAccountID = BANKACCOUNT.FID LEFT OUTER JOIN T_BD_Bank AS STOCKJOBBER ON STOCKHOLDER.FStockJobberID = STOCKJOBBER.FID LEFT OUTER JOIN T_BD_Industry AS INDUSTRY ON STOCK.FIndustryID = INDUSTRY.FID WHERE STOCKINVESTBILL.FInvestType = '1' ");
        sbDetailSQL.append(this.getCommonFilterToChLoan());
        sbDetailSQL.append(" order by STOCKJOBBER_NAME,CURRENCY_NAME");
        return sbDetailSQL.toString();
    }

    private String getSumSQL() {
        StringBuffer sbSumSQL = new StringBuffer();
        sbSumSQL.append("select CURRENCY.FName_l2 AS CURRENCY_NAME,sum(isnull(STOCKINVESTBILL.FApplyAmount,0)) AS APPLYAMOUNT, sum(isnull(STOCKINVESTBILL.FExchangeAmount,0)) AS EXCHANGEAMOUNT, sum(isnull(STOCKINVESTBILL.FEarning,0)) AS EARNING FROM T_SK_StockInvestBill AS STOCKINVESTBILL LEFT OUTER JOIN T_ORG_Company AS COMPANY ON STOCKINVESTBILL.FCompanyID = COMPANY.FID LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON STOCKINVESTBILL.FCurrencyID = CURRENCY.FID LEFT OUTER JOIN T_SK_Stockholder AS STOCKHOLDER ON STOCKINVESTBILL.FStockHolderID = STOCKHOLDER.FID LEFT OUTER JOIN T_SK_Stock AS STOCK ON STOCKINVESTBILL.FStockID = STOCK.FID LEFT OUTER JOIN T_BD_AccountBanks AS BANKACCOUNT ON STOCKHOLDER.FBankAccountID = BANKACCOUNT.FID LEFT OUTER JOIN T_BD_Bank AS STOCKJOBBER ON STOCKHOLDER.FStockJobberID = STOCKJOBBER.FID LEFT OUTER JOIN T_BD_Industry AS INDUSTRY ON STOCK.FIndustryID = INDUSTRY.FID WHERE STOCKINVESTBILL.FInvestType = '1' ");
        sbSumSQL.append(this.getCommonFilterToChLoan());
        sbSumSQL.append(" group by CURRENCY.FName_l2");
        return sbSumSQL.toString();
    }

    public void endDataFill() {
        super.endDataFill();
        try {
            this.setMergeTotalValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        String preID = "";
        while (rs.next()) {
            String tmpID = rs.getString("id");
            IRow row = this.kdt.addRow();
            row.getCell("stockjobber_name").setValue((Object)rs.getString("stockjobber_name"));
            row.getCell("stock_name").setValue((Object)rs.getString("stock_name"));
            row.getCell("currency_name").setValue((Object)rs.getString("currency_name"));
            row.getCell("STOCK_OFFERINGDATE").setValue((Object)rs.getDate("STOCK_OFFERINGDATE"));
            row.getCell("EXCHANGEDATE").setValue((Object)rs.getDate("EXCHANGEDATE"));
            row.getCell("STOCK_FREEFLOAT").setValue((Object)rs.getString("STOCK_FREEFLOAT"));
            row.getCell("STOCK_ISSUPRICE").setValue((Object)rs.getString("STOCK_ISSUPRICE"));
            row.getCell("STOCK_ISSUEAMOUNT").setValue((Object)rs.getString("STOCK_ISSUEAMOUNT"));
            row.getCell("REPWINRATE").setValue((Object)rs.getString("REPWINRATE"));
            row.getCell("ACTWINRATE").setValue((Object)rs.getString("ACTWINRATE"));
            row.getCell("INDUSTRY_NAME").setValue((Object)rs.getString("INDUSTRY_NAME"));
            row.getCell("STOCK_PERATIO").setValue((Object)rs.getString("STOCK_PERATIO"));
            row.getCell("STOCK_FIRSTUPPER").setValue((Object)rs.getString("STOCK_FIRSTUPPER"));
            row.getCell("APPLYAMOUNT").setValue((Object)rs.getString("APPLYAMOUNT"));
            row.getCell("EXCHANGENUM").setValue((Object)rs.getString("EXCHANGENUM"));
            row.getCell("EXCHANGEAMOUNT").setValue((Object)rs.getString("EXCHANGEAMOUNT"));
            row.getCell("THEROYVALUERATE").setValue((Object)rs.getString("THEROYVALUERATE"));
            row.getCell("ACTVALUERATE").setValue((Object)rs.getString("ACTVALUERATE"));
            row.getCell("EARNING").setValue((Object)rs.getString("EARNING"));
            row.getCell("bankaccount_name").setValue((Object)rs.getString("bankaccount_name"));
        }
    }

    protected void setMergeTotalValue() throws Exception {
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)this.getSumSQL()).executeSQL();
            while (rs.next()) {
                IRow row = this.kdt.addRow();
                row.getCell("currency_name").setValue((Object)rs.getString("currency_name"));
                row.getCell("APPLYAMOUNT").setValue((Object)rs.getString("APPLYAMOUNT"));
                row.getCell("EXCHANGEAMOUNT").setValue((Object)rs.getString("EXCHANGEAMOUNT"));
                row.getCell("EARNING").setValue((Object)rs.getString("EARNING"));
                row.getCell("stockjobber_name").setValue((Object)FMRptClientUtils.getTotalResString());
                row.setMergeable(true);
            }
            KDTMergeManager mm = this.kdt.getMergeManager();
            mm.mergeBlock(this.kdt.getRowCount() - rs.size(), 0, this.kdt.getRowCount() - 1, 0, 3);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected abstract void insertHeadRow();

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("stockjobber_name").setValue((Object)this.getResString("stockJobber"));
        headRow.getCell("stock_name").setValue((Object)this.getResString("stock"));
        headRow.getCell("currency_name").setValue((Object)this.getResString("currency"));
        headRow.getCell("STOCK_OFFERINGDATE").setValue((Object)this.getResString("offeringdate"));
        headRow.getCell("EXCHANGEDATE").setValue((Object)this.getResString("exchangeDate"));
        headRow.getCell("STOCK_FREEFLOAT").setValue((Object)this.getResString("freeFloat"));
        headRow.getCell("STOCK_ISSUPRICE").setValue((Object)this.getResString("issuPrice"));
        headRow.getCell("STOCK_ISSUEAMOUNT").setValue((Object)this.getResString("issueAmount"));
        headRow.getCell("REPWINRATE").setValue((Object)this.getResString("repwinRate"));
        headRow.getCell("ACTWINRATE").setValue((Object)this.getResString("actwinRate"));
        headRow.getCell("INDUSTRY_NAME").setValue((Object)this.getResString("industry"));
        headRow.getCell("STOCK_PERATIO").setValue((Object)this.getResString("pERatio"));
        headRow.getCell("STOCK_FIRSTUPPER").setValue((Object)this.getResString("firstUpPer"));
        headRow.getCell("APPLYAMOUNT").setValue((Object)this.getResString("applyAmount"));
        headRow.getCell("EXCHANGENUM").setValue((Object)this.getResString("exchangeNum"));
        headRow.getCell("EXCHANGEAMOUNT").setValue((Object)this.getResString("exchangeAmount"));
        headRow.getCell("THEROYVALUERATE").setValue((Object)this.getResString("theoryReturnRate"));
        headRow.getCell("ACTVALUERATE").setValue((Object)this.getResString("actReturnRate"));
        headRow.getCell("EARNING").setValue((Object)this.getResString("actReturn"));
        headRow.getCell("bankaccount_name").setValue((Object)this.getResString("bankAccount"));
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        this.companyIdSet = this.param.getCompanyIdSet();
        this.bankIdSet = this.param.getBankIdSet();
        this.dateFrom = this.param.getDateFrom();
        this.dateTo = this.param.getDateTo();
        this.currency = this.param.getCurrency();
        this.AccountBankIdSet = this.param.getAccountBankIdSet();
        sb.append(" and STOCKINVESTBILL.FCompanyID ='").append(this.currencyCompany.getId().toString()).append("'");
        if (this.AccountBankIdSet != null && this.AccountBankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" STOCKHOLDER.FBankAccountID ", (Object[])this.AccountBankIdSet.toArray()));
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" STOCKHOLDER.FStockJobberID ", (Object[])this.bankIdSet.toArray()));
        }
        if (this.dateTo != null) {
            sb.append(" and STOCKINVESTBILL.FExchangeDate<= { ").append(Constants.FORMAT_TIME.format(this.dateTo)).append("}");
        }
        if (this.dateFrom != null) {
            sb.append(" and STOCKINVESTBILL.FExchangeDate>={ ").append(Constants.FORMAT_TIME.format(this.dateFrom)).append("}");
        }
        if (this.currency != null) {
            sb.append(" and STOCKINVESTBILL.fcurrencyid ='").append(this.currency.getId().toString()).append("'");
        }
        return sb.toString();
    }
}

