/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.client.RptStockInvestDetailFilterParam;
import com.kingdee.eas.fm.stock.client.RptStockInvestDetailHandlerBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

public class RptStockInvestDetailHandler
extends RptStockInvestDetailHandlerBase {
    private static final String resourcePath = "com.kingdee.eas.fm.stock.client.RptStockInvestResource";
    private BigDecimal lastRemain;

    public RptStockInvestDetailHandler(RptStockInvestDetailFilterParam param, KDTable kdt) {
        super(param, kdt);
    }

    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(false);
        this.kdt.getGroupManager().setOrientation(1);
        IColumn coExchangeDate = this.kdt.addColumn();
        coExchangeDate.setKey("exchangeDate");
        coExchangeDate.setGroup(true);
        coExchangeDate.setWidth(80);
        IColumn colStockNumber = this.kdt.addColumn();
        colStockNumber.setKey("stockNumber");
        colStockNumber.setGroup(true);
        colStockNumber.setWidth(80);
        IColumn colStockName = this.kdt.addColumn();
        colStockName.setKey("stockName");
        colStockName.setGroup(true);
        colStockName.setWidth(80);
        IColumn colInvestType = this.kdt.addColumn();
        colInvestType.setKey("investType");
        colInvestType.setGroup(true);
        colInvestType.setWidth(80);
        IColumn colExchangeNum = this.kdt.addColumn();
        colExchangeNum.setKey("exchangeNum");
        colExchangeNum.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colExchangeNum.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colExchangeNum.setWidth(80);
        IColumn colExchangePrice = this.kdt.addColumn();
        colExchangePrice.setKey("exchangePrice");
        colExchangePrice.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colExchangePrice.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colExchangePrice.setWidth(80);
        IColumn colExchangeAmount = this.kdt.addColumn();
        colExchangeAmount.setKey("exchangeAmount");
        colExchangeAmount.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colExchangeAmount.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colExchangeAmount.setWidth(80);
        IColumn colRemainAmount = this.kdt.addColumn();
        colRemainAmount.setKey("remainAmount");
        colRemainAmount.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colRemainAmount.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colRemainAmount.setWidth(80);
        IColumn colBrokeage = this.kdt.addColumn();
        colBrokeage.setKey("brokeage");
        colBrokeage.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colBrokeage.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colBrokeage.setWidth(60);
        IColumn colStampTax = this.kdt.addColumn();
        colStampTax.setKey("stampTax");
        colStampTax.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colStampTax.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colStampTax.setWidth(80);
        IColumn colStAssignPay = this.kdt.addColumn();
        colStAssignPay.setKey("stAssignPay");
        colStAssignPay.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colStAssignPay.getStyleAttributes().setNumberFormat("%r{#,###.00}f");
        colStAssignPay.setWidth(80);
        IColumn colContactNo = this.kdt.addColumn();
        colContactNo.setKey("contractNo");
        colContactNo.setGroup(true);
        colContactNo.setWidth(60);
        IColumn colStockHolder = this.kdt.addColumn();
        colStockHolder.setKey("stockHolder");
        colStockHolder.setGroup(true);
        colStockHolder.setWidth(80);
        this.initHeaderRow();
    }

    private void initHeaderRow() {
        IRow row = this.kdt.addHeadRow();
        row.getCell("exchangeDate").setValue((Object)this.getResString("exchangeDate"));
        row.getCell("stockNumber").setValue((Object)this.getResString("stockNumber"));
        row.getCell("stockName").setValue((Object)this.getResString("stockName"));
        row.getCell("investType").setValue((Object)this.getResString("investType"));
        row.getCell("exchangeNum").setValue((Object)this.getResString("exchangeNum"));
        row.getCell("exchangePrice").setValue((Object)this.getResString("exchangePrice"));
        row.getCell("exchangeAmount").setValue((Object)this.getResString("exchangeAmount"));
        row.getCell("remainAmount").setValue((Object)this.getResString("remainAmount"));
        row.getCell("brokeage").setValue((Object)this.getResString("brokeage"));
        row.getCell("stampTax").setValue((Object)this.getResString("stampTax"));
        row.getCell("stAssignPay").setValue((Object)this.getResString("stAssignPay"));
        row.getCell("contractNo").setValue((Object)this.getResString("contractNo"));
        row.getCell("stockHolder").setValue((Object)this.getResString("stockHolder"));
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.setRefresh(false);
        this.insertLastDateRemainRow();
        this.lastRemain = this.lastDateRemain;
        Date lastDate = null;
        BigDecimal dateNum = Constants.ZERO;
        BigDecimal dateAmount = Constants.ZERO;
        BigDecimal dateRemain = Constants.ZERO;
        BigDecimal monthAmount = Constants.ZERO;
        BigDecimal monthRemain = Constants.ZERO;
        BigDecimal yearAmount = Constants.ZERO;
        if (rs.next()) {
            ParameterInfo v1 = this.readData(rs);
            ParameterInfo v2 = null;
            this.writeData(v1);
            lastDate = v1.getExchangeDate();
            dateNum = v1.getExchangeNum();
            dateAmount = v1.getExchangeAmount();
            dateRemain = v1.getRemainAmount();
            monthAmount = v1.getExchangeAmount();
            monthRemain = v1.getRemainAmount();
            yearAmount = v1.getExchangeAmount();
            while (rs.next()) {
                v2 = this.readData(rs);
                yearAmount = yearAmount.add(v2.getExchangeAmount());
                Date currentDate = v2.getExchangeDate();
                if (currentDate.compareTo(lastDate) != 0) {
                    this.insertDateRow(lastDate, dateNum, dateAmount, dateRemain);
                    if (DateTimeUtils.getMonth((Date)currentDate) - DateTimeUtils.getMonth((Date)lastDate) != 0) {
                        this.insertMonthRow(lastDate, monthAmount, monthRemain);
                        monthAmount = v2.getExchangeAmount();
                    } else {
                        monthAmount = monthAmount.add(v2.getExchangeAmount());
                    }
                    lastDate = currentDate;
                    dateNum = v2.getExchangeNum();
                    dateAmount = v2.getExchangeAmount();
                } else {
                    dateNum = dateNum.add(v2.getExchangeNum());
                    dateAmount = dateAmount.add(v2.getExchangeAmount());
                    monthAmount = monthAmount.add(v2.getExchangeAmount());
                }
                dateRemain = v2.getRemainAmount();
                monthRemain = v2.getRemainAmount();
                this.writeData(v2);
            }
            if (v2 != null) {
                this.insertDateRow(lastDate, dateNum, dateAmount, dateRemain);
                this.insertMonthRow(lastDate, monthAmount, monthRemain);
            }
        }
        if (lastDate != null) {
            this.insertYearRow(lastDate, yearAmount, monthRemain);
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
    }

    public void endDataFill() {
        super.endDataFill();
    }

    public void setTableStateRow() {
    }

    private ParameterInfo readData(IRowSet rs) throws SQLException {
        ParameterInfo v = new ParameterInfo();
        v.setExchangeDate(rs.getDate(2));
        v.setStockNumber(rs.getString(3));
        v.setStockName(rs.getString(4));
        String type = rs.getString(5);
        InvestTypeEnum typeEnum = InvestTypeEnum.getEnum(type);
        v.setInvestType(typeEnum.getAlias());
        v.setExchangeNum(rs.getBigDecimal(6));
        v.setExchangePrice(rs.getBigDecimal(7));
        if (typeEnum == InvestTypeEnum.Sale || typeEnum == InvestTypeEnum.BanktoBond) {
            v.setExchangeAmount(rs.getBigDecimal(8));
        } else {
            v.setExchangeAmount(rs.getBigDecimal(8).negate());
        }
        this.lastRemain = this.lastRemain.add(v.getExchangeAmount());
        v.setRemainAmount(this.lastRemain);
        v.setBrokeage(rs.getBigDecimal(9));
        v.setStatmpTax(rs.getBigDecimal(10));
        v.setStAssignPay(rs.getBigDecimal(11));
        v.setContractNo(rs.getString(12));
        v.setStockHolder(rs.getString(13));
        v.setId(rs.getString(1));
        return v;
    }

    private void writeData(ParameterInfo v) {
        IRow row = this.kdt.addRow();
        row.getCell("exchangeDate").setValue((Object)v.getExchangeDate());
        row.getCell("stockNumber").setValue((Object)v.getStockNumber());
        row.getCell("stockName").setValue((Object)v.getStockName());
        row.getCell("investType").setValue((Object)v.getInvestType());
        row.getCell("exchangeNum").setValue((Object)v.getExchangeNum());
        row.getCell("exchangePrice").setValue((Object)v.getExchangePrice());
        row.getCell("exchangeAmount").setValue((Object)v.getExchangeAmount());
        row.getCell("remainAmount").setValue((Object)v.getRemainAmount());
        row.getCell("brokeage").setValue((Object)v.getBrokeage());
        row.getCell("stampTax").setValue((Object)v.getStatmpTax());
        row.getCell("stAssignPay").setValue((Object)v.getStAssignPay());
        row.getCell("contractNo").setValue((Object)v.getContractNo());
        row.getCell("stockHolder").setValue((Object)v.getStockHolder());
        row.setUserObject((Object)v.getId());
    }

    private String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    private void insertLastDateRemainRow() {
        IRow totalRow = this.kdt.addRow();
        totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        totalRow.getCell("exchangeDate").setValue((Object)this.param.getDateFrom());
        totalRow.getCell("stockNumber").setValue((Object)this.getResString("LastDateRemain"));
        totalRow.getCell("remainAmount").setValue((Object)this.lastDateRemain);
    }

    private void insertDateRow(Date lastDate, BigDecimal num, BigDecimal amount, BigDecimal remain) {
        IRow totalRow = this.kdt.addRow();
        totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        totalRow.getCell("exchangeDate").setValue((Object)lastDate);
        totalRow.getCell("stockNumber").setValue((Object)this.getResString("TodaySum"));
        totalRow.getCell("exchangeNum").setValue((Object)num);
        totalRow.getCell("exchangeAmount").setValue((Object)amount);
        totalRow.getCell("remainAmount").setValue((Object)remain);
    }

    private void insertMonthRow(Date lastDate, BigDecimal amount, BigDecimal remain) {
        IRow totalRow = this.kdt.addRow();
        totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        totalRow.getCell("exchangeDate").setValue((Object)lastDate);
        totalRow.getCell("stockNumber").setValue((Object)this.getResString("MonthSum"));
        totalRow.getCell("exchangeAmount").setValue((Object)amount);
        totalRow.getCell("remainAmount").setValue((Object)remain);
    }

    private void insertYearRow(Date lastDate, BigDecimal amount, BigDecimal remain) {
        IRow totalRow = this.kdt.addRow();
        totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        totalRow.getCell("exchangeDate").setValue((Object)lastDate);
        totalRow.getCell("stockNumber").setValue((Object)this.getResString("YearSum"));
        totalRow.getCell("exchangeAmount").setValue((Object)amount);
        totalRow.getCell("remainAmount").setValue((Object)remain);
    }

    class ParameterInfo {
        String id;
        Date exchangeDate;
        String stockNumber;
        String stockName;
        String investType;
        BigDecimal exchangeNum;
        BigDecimal exchangePrice;
        BigDecimal exchangeAmount;
        BigDecimal remainAmount;
        BigDecimal brokeage;
        BigDecimal statmpTax;
        BigDecimal stAssignPay;
        String contractNo;
        String stockHolder;

        public Date getExchangeDate() {
            return this.exchangeDate;
        }

        public void setExchangeDate(Date exchangeDate) {
            this.exchangeDate = exchangeDate;
        }

        public String getStockNumber() {
            return this.stockNumber;
        }

        public void setStockNumber(String stockNumber) {
            this.stockNumber = stockNumber;
        }

        public String getStockName() {
            return this.stockName;
        }

        public void setStockName(String stockName) {
            this.stockName = stockName;
        }

        public String getInvestType() {
            return this.investType;
        }

        public void setInvestType(String investType) {
            this.investType = investType;
        }

        public BigDecimal getExchangeNum() {
            return this.exchangeNum;
        }

        public void setExchangeNum(BigDecimal exchangeNum) {
            this.exchangeNum = exchangeNum;
        }

        public BigDecimal getExchangePrice() {
            return this.exchangePrice;
        }

        public void setExchangePrice(BigDecimal exchangePrice) {
            this.exchangePrice = exchangePrice;
        }

        public BigDecimal getExchangeAmount() {
            return this.exchangeAmount;
        }

        public void setExchangeAmount(BigDecimal exchangeAmount) {
            this.exchangeAmount = exchangeAmount;
        }

        public BigDecimal getRemainAmount() {
            return this.remainAmount;
        }

        public void setRemainAmount(BigDecimal remainAmount) {
            this.remainAmount = remainAmount;
        }

        public BigDecimal getBrokeage() {
            return this.brokeage;
        }

        public void setBrokeage(BigDecimal brokeage) {
            this.brokeage = brokeage;
        }

        public BigDecimal getStatmpTax() {
            return this.statmpTax;
        }

        public void setStatmpTax(BigDecimal statmpTax) {
            this.statmpTax = statmpTax;
        }

        public BigDecimal getStAssignPay() {
            return this.stAssignPay;
        }

        public void setStAssignPay(BigDecimal stAssignPay) {
            this.stAssignPay = stAssignPay;
        }

        public String getContractNo() {
            return this.contractNo;
        }

        public void setContractNo(String contractNo) {
            this.contractNo = contractNo;
        }

        public String getStockHolder() {
            return this.stockHolder;
        }

        public void setStockHolder(String stockHolder) {
            this.stockHolder = stockHolder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

