/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.stock.client.RptStockInvestDetailFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Set;

public abstract class RptStockInvestDetailHandlerBase
extends FMDetailRptBaseHandler {
    protected RptStockInvestDetailFilterParam param;
    protected BigDecimal lastDateRemain;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String locale = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
    private final CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public RptStockInvestDetailHandlerBase(RptStockInvestDetailFilterParam param, KDTable kdt) {
        super(param.getFilter(), kdt);
        this.param = param;
    }

    protected String getQueryPath() {
        return null;
    }

    private void initRemainData() throws BOSException {
        StringBuffer sqlLastDate = new StringBuffer();
        sqlLastDate.append("select sum(FInAmount) - sum(FOutAmount) as FRemainAmount from ( \n");
        sqlLastDate.append("select F.FInitFund as FInAmount, 0 as FOutAmount from T_SK_FundSettleBill as F \n");
        sqlLastDate.append("where F.FIsInit = 1 \n");
        sqlLastDate.append("and F.FCompanyID = '" + this.currentCompany.getId() + "'\n");
        sqlLastDate.append("and F.FExchagedate < {ts'" + this.sdf.format(this.param.getDateFrom()) + "'}");
        if (this.param.getCurrency() != null) {
            sqlLastDate.append("and F.FCurrencyID = '" + this.param.getCurrency().getId() + "' \n");
        }
        if (this.param.getStockJobberIdSet() != null && this.param.getStockJobberIdSet().size() > 0) {
            sqlLastDate.append("and F.FStockJobberID in " + FMHelper.setTran2String((Set)this.param.getStockJobberIdSet()));
        }
        if (this.param.getAccountBankIdSet() != null && this.param.getAccountBankIdSet().size() > 0) {
            sqlLastDate.append(" and F.FBankAccountID in " + FMHelper.setTran2String((Set)this.param.getAccountBankIdSet()));
        }
        sqlLastDate.append("\n union all \n");
        sqlLastDate.append("select I.FExchangeAmount as FInAmount, 0 as FOutAmount from T_SK_StockInvestBill as I \n");
        sqlLastDate.append("left outer join T_SK_StockHolder as H \n");
        sqlLastDate.append("on I.FStockHolderID = H.FID \n");
        sqlLastDate.append("where I.FInvestType in ('3','4')");
        sqlLastDate.append("and I.FExchangeDate < {ts'" + this.sdf.format(this.param.getDateFrom()) + "'}");
        sqlLastDate.append("and I.FCompanyID = '" + this.currentCompany.getId() + "'\n");
        if (this.param.getCurrency() != null) {
            sqlLastDate.append("and I.FCurrencyID = '" + this.param.getCurrency().getId() + "' \n");
        }
        if (this.param.getStockJobberIdSet() != null && this.param.getStockJobberIdSet().size() > 0) {
            sqlLastDate.append("and H.FStockJobberID in " + FMHelper.setTran2String((Set)this.param.getStockJobberIdSet()));
        }
        if (this.param.getAccountBankIdSet() != null && this.param.getAccountBankIdSet().size() > 0) {
            sqlLastDate.append(" and H.FBankAccountID in " + FMHelper.setTran2String((Set)this.param.getAccountBankIdSet()));
        }
        sqlLastDate.append("\n union all \n");
        sqlLastDate.append("select 0 as FInAmount,I.FExchangeAmount as FOutAmount from T_SK_StockInvestBill as I \n");
        sqlLastDate.append("left outer join T_SK_StockHolder as H \n");
        sqlLastDate.append("on I.FStockHolderID = H.FID \n");
        sqlLastDate.append("where I.FInvestType in ('1','2','5')");
        sqlLastDate.append("and I.FExchangeDate < {ts'" + this.sdf.format(this.param.getDateFrom()) + "'}");
        sqlLastDate.append("and I.FCompanyID = '" + this.currentCompany.getId() + "'\n");
        if (this.param.getCurrency() != null) {
            sqlLastDate.append("and I.FCurrencyID = '" + this.param.getCurrency().getId() + "' \n");
        }
        if (this.param.getStockJobberIdSet() != null && this.param.getStockJobberIdSet().size() > 0) {
            sqlLastDate.append("and H.FStockJobberID in " + FMHelper.setTran2String((Set)this.param.getStockJobberIdSet()));
        }
        if (this.param.getAccountBankIdSet() != null && this.param.getAccountBankIdSet().size() > 0) {
            sqlLastDate.append(" and H.FBankAccountID in " + FMHelper.setTran2String((Set)this.param.getAccountBankIdSet()));
        }
        sqlLastDate.append(") as A \n");
        try {
            IRowSet set = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sqlLastDate.toString(), null);
            this.lastDateRemain = set.next() && set.getBigDecimal(1) != null ? set.getBigDecimal(1) : Constants.ZERO;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    public IRowSet getRowSet() throws BOSException {
        this.initRemainData();
        StringBuffer sql = new StringBuffer();
        sql.append("select I.FID as FID,\n");
        sql.append("I.FExchangeDate as FExchangeDate,\n");
        sql.append("S.FNumber as FStockNumber,\n");
        sql.append("S.FName_" + this.locale + " as FStockName,\n");
        sql.append("I.FInvestType as FInvestType,\n");
        sql.append("I.FExchangeNum as FExchangeNum,\n");
        sql.append("I.FExchangePrice as FExchangePrice,\n");
        sql.append("I.FExchangeAmount as FExchangeAmount,\n");
        sql.append("I.FBrokeage as FBrokeage,\n");
        sql.append("I.FStampTax as FStampTax,\n");
        sql.append("I.FStAssignPay as FStAssignPay,\n");
        sql.append("I.FContractNo as FContractNo,\n");
        sql.append("H.FHolderNumber as FStockHolder \n");
        sql.append("from T_SK_StockInvestBill as I \n");
        sql.append("left outer join T_SK_StockHolder as H \n");
        sql.append("on I.FStockHolderID = H.FID \n");
        sql.append("left outer join T_SK_Stock as S \n");
        sql.append("on I.FStockID = S.FID \n");
        sql.append("where \n");
        sql.append("I.FCompanyID = '" + this.currentCompany.getId() + "'\n");
        sql.append("and I.FExchangeDate >= {ts'" + this.sdf.format(this.param.getDateFrom()) + "'} \n");
        sql.append("and I.FExchangeDate <= {ts'" + this.sdf.format(this.param.getDateTo()) + "'} \n");
        if (this.param.getCurrency() != null) {
            sql.append("and I.FCurrencyID = '" + this.param.getCurrency().getId() + "' \n");
        }
        if (this.param.getStockJobberIdSet() != null && this.param.getStockJobberIdSet().size() > 0) {
            sql.append("and H.FStockJobberID in " + FMHelper.setTran2String((Set)this.param.getStockJobberIdSet()));
        }
        if (this.param.getAccountBankIdSet() != null && this.param.getAccountBankIdSet().size() > 0) {
            sql.append(" and H.FBankAccountID in " + FMHelper.setTran2String((Set)this.param.getAccountBankIdSet()));
        }
        sql.append(" order by FExchangeDate \n");
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), null);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }
}

