/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.stock.client.AbstractRptStockInvestDetailMainUI;
import com.kingdee.eas.fm.stock.client.RptStockInvestDetailFilterParam;
import com.kingdee.eas.fm.stock.client.RptStockInvestDetailFilterUI;
import com.kingdee.eas.fm.stock.client.RptStockInvestDetailHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;

public class RptStockInvestDetailMainUI
extends AbstractRptStockInvestDetailMainUI {
    private RptStockInvestDetailFilterUI filterUI;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public RptStockInvestDetailMainUI() throws Exception {
        if (!this.companyInfo.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionJoinQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_linkviewbill"));
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        RptStockInvestDetailFilterParam filterParam = (RptStockInvestDetailFilterParam)this.getFilterParam();
        if (filterParam == null) {
            return;
        }
        this.tblMain.checkParsed();
        RptStockInvestDetailHandler handler = new RptStockInvestDetailHandler(filterParam, this.tblMain);
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.kDDateFrom.setText(this.sdf.format(filterParam.getDateFrom()));
        this.kDDateTo.setText(this.sdf.format(filterParam.getDateTo()));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptStockInvestDetailFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionJoinQuery_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            IRow row = this.tblMain.getRow(selectBlock.getTop());
            Object id = row.getUserObject();
            String stockInvestBillID = null;
            if (id != null) {
                stockInvestBillID = id.toString();
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String[])new String[]{stockInvestBillID}, (CompanyOrgUnitInfo)this.companyInfo);
            }
        }
    }
}

