/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.client.TimeDepositHelper;
import com.kingdee.eas.fm.stock.client.AbstractRptStockLuckNumberFilterUI;
import com.kingdee.eas.fm.stock.client.RptStockLuckNumberFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptStockLuckNumberFilterUI
extends AbstractRptStockLuckNumberFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptStockLuckNumberFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7Filter();
    }

    protected void init() throws Exception {
        super.init();
        CashHelper.initCombCurrency((KDComboBox)this.CombCurrency, (boolean)false);
        this.CombCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.CombCurrency.setSelectedIndex(this.CombCurrency.getItemCount() - 1);
        this.DateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtstockJobber, null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    @Override
    protected void prmtstockJobber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstockJobber_dataChanged(e);
        if (this.prmtstockJobber.getData() != null) {
            this.prmtbankAccount.setValue(null);
        }
    }

    @Override
    protected void prmtbankAccount_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        if (this.getIdSetFromF7(this.prmtstockJobber).size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.getIdSetFromF7(this.prmtstockJobber), CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtbankAccount.setEntityViewInfo(evi);
        this.prmtbankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public Object getParam() {
        Object obj;
        RptStockLuckNumberFilterParam param = new RptStockLuckNumberFilterParam();
        param.setBankIdSet(this.getIdSetFromF7(this.prmtstockJobber));
        param.setDateFrom(this.DateFrom.getSqlDate());
        param.setDateTo(this.DateTo.getSqlDate());
        try {
            param.setAccountBankIdSet(this.getIdSetFromF7(this.prmtbankAccount));
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ACCOUNT_ERROR"));
            SysUtil.abort();
        }
        if (null != this.CombCurrency.getSelectedItem() && (obj = this.CombCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            param.setCurrency((CurrencyInfo)this.CombCurrency.getSelectedItem());
        }
        return param;
    }

    public void setParam(Object param) {
        RptStockLuckNumberFilterParam Param = (RptStockLuckNumberFilterParam)param;
        this.setCompanyIdSet(Param.getCompanyIdSet());
        try {
            this.prmtstockJobber.setData((Object)this.getBaseInfoFromIdSet(Param.getBankIdSet()));
            this.prmtbankAccount.setData((Object)this.getBaseInfoFromIdSet(Param.getAccountBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.DateFrom.setValue((Object)Param.getDateFrom());
        this.DateTo.setValue((Object)Param.getDateTo());
        if (Param.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.CombCurrency, (Object)Param.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.CombCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
    }

    public boolean verify() {
        if (this.DateFrom.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"StartDateIsNull"));
            SysUtil.abort();
        }
        if (this.DateTo.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"EndDateIsNull"));
            SysUtil.abort();
        }
        if (((Date)this.DateTo.getValue()).compareTo((Date)this.DateFrom.getValue()) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)TimeDepositHelper.getInstance().getResourcePath(), (String)TimeDepositHelper.getInstance().getDateMsg()));
            this.DateFrom.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.prmtstockJobber.setValue(null);
        this.prmtbankAccount.setValue(null);
        CashHelper.initCombCurrency((KDComboBox)this.CombCurrency, (boolean)false);
        this.CombCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.CombCurrency.setSelectedIndex(this.CombCurrency.getItemCount() - 1);
        this.DateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.DateTo.setValue((Object)new Date());
        this.DateTo.setSupportedEmpty(false);
    }

    protected Class getParamClass() {
        return RptStockLuckNumberFilterParam.class;
    }
}

