/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.stock.client.RptStockLuckNumberFilterParam;
import com.kingdee.eas.fm.stock.client.RptStockLuckNumberHandlerAdapter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;

public class RptStockLuckNumberHandler
extends RptStockLuckNumberHandlerAdapter {
    public RptStockLuckNumberHandler(RptStockLuckNumberFilterParam param, KDTable kdt) {
        super(param, kdt);
    }

    @Override
    protected void insertHeadRow() {
        IColumn colstockjobber = this.kdt.addColumn();
        colstockjobber.setKey("stockjobber_name");
        colstockjobber.setMergeable(true);
        colstockjobber.setGroup(true);
        IColumn colcurrency_name = this.kdt.addColumn();
        colcurrency_name.setKey("currency_name");
        colcurrency_name.setGroup(true);
        IColumn colExchangeDate = this.kdt.addColumn();
        colExchangeDate.setKey("FExchangeDate");
        IColumn colstock_name = this.kdt.addColumn();
        colstock_name.setKey("stock_name");
        IColumn colFIssuPrice = this.kdt.addColumn();
        colFIssuPrice.setKey("FIssuPrice");
        this.formatCol(colFIssuPrice, 1);
        IColumn colFExchangeNum = this.kdt.addColumn();
        colFExchangeNum.setKey("FExchangeNum");
        this.formatCol(colFExchangeNum, 2);
        IColumn colFExchangeAmount = this.kdt.addColumn();
        colFExchangeAmount.setKey("FExchangeAmount");
        this.formatCol(colFExchangeAmount, 1);
        IColumn colbankaccount_name = this.kdt.addColumn();
        colbankaccount_name.setKey("bankaccount_name");
    }

    @Override
    public void setTableStateRow() {
        this.kdt.getColumn("currency_name").setStat(true);
        IRow subtotalRow = this.kdt.getGroupManager().getStatRowTemplate(1);
        subtotalRow.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"11_RptStockGeneralHandler"));
        subtotalRow.getCell(1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        this.formatSumRow(subtotalRow, "FExchangeNum");
        subtotalRow.getCell("FExchangeNum").getStyleAttributes().setNumberFormat("%r{#,##0}f");
        this.formatSumRow(subtotalRow, "FExchangeAmount");
    }

    private void formatSumRow(IRow row, String name) {
        row.getCell(name).setExpressions("SUM");
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell(name).getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell(name).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        row.getCell(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void formatCol(IColumn col, int type) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (type == 1) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        } else if (type == 2) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0}f");
        }
    }

    protected void formatCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }
}

