/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.stock.client.RptStockLuckNumberFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public abstract class RptStockLuckNumberHandlerAdapter
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.stock.client.RptStockLuckNumberResource";
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    private RptStockLuckNumberFilterParam param;
    private CompanyOrgUnitInfo currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    Set companyIdSet;
    Set bankIdSet;
    Date dateFrom;
    Date dateTo;
    Set AccountBankIdSet;
    CurrencyInfo currency;

    public RptStockLuckNumberHandlerAdapter(RptStockLuckNumberFilterParam param, KDTable kdt) {
        super(param.getFilter(), kdt);
        this.param = param;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
    }

    private String getDetailSQL() {
        StringBuffer sbDetailSQL = new StringBuffer();
        sbDetailSQL.append("SELECT a.fid as id,j.FName_l2 as stockjobber_name, a.FExchangeDate ,s.FSimpleName as stock_name, c.FName_l2 as currency_name,s.FIssuPrice,a.FExchangeNum,a.FExchangeAmount,sc.FName_l2 as bankaccount_name FROM T_SK_StockInvestBill AS a,T_BD_Currency AS c, T_SK_Stockholder AS h, T_SK_Stock AS s,T_BD_AccountBanks AS sc, T_BD_Bank AS j where a.FInvestType = '1' and a.FCurrencyID = c.FID and a.FStockHolderID = h.FID and a.FStockID = s.FID and h.FBankAccountID = sc.FID and h.FStockJobberID = j.FID");
        sbDetailSQL.append(this.getCommonFilterToChLoan());
        sbDetailSQL.append(" order by stockjobber_name,currency_name");
        return sbDetailSQL.toString();
    }

    private String getSumSQL() {
        StringBuffer sbSumSQL = new StringBuffer();
        sbSumSQL.append("SELECT  c.FName_l2 as currency_name,sum(isnull(a.FExchangeNum,0)) AS FExchangeNum,sum(isnull(a.FExchangeAmount,0)) AS FExchangeAmount FROM T_SK_StockInvestBill AS a,T_BD_Currency AS c, T_SK_Stockholder AS h, T_SK_Stock AS s,T_BD_AccountBanks AS sc, T_BD_Bank AS j where a.FInvestType = '1' and a.FCurrencyID = c.FID and a.FStockHolderID = h.FID and a.FStockID = s.FID and h.FBankAccountID = sc.FID and h.FStockJobberID = j.FID");
        sbSumSQL.append(this.getCommonFilterToChLoan());
        sbSumSQL.append(" group by c.FName_l2");
        return sbSumSQL.toString();
    }

    public void endDataFill() {
        super.endDataFill();
        try {
            this.setMergeTotalValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        String preID = "";
        while (rs.next()) {
            String tmpID = rs.getString("id");
            IRow row = this.kdt.addRow();
            row.getCell("bankaccount_name").setValue((Object)rs.getString("bankaccount_name"));
            row.getCell("FExchangeNum").setValue((Object)rs.getString("FExchangeNum"));
            row.getCell("FExchangeAmount").setValue((Object)rs.getString("FExchangeAmount"));
            row.getCell("stockjobber_name").setValue((Object)rs.getString("stockjobber_name"));
            row.getCell("FExchangeDate").setValue((Object)rs.getDate("FExchangeDate"));
            row.getCell("stock_name").setValue((Object)rs.getString("stock_name"));
            row.getCell("currency_name").setValue((Object)rs.getString("currency_name"));
            row.getCell("FIssuPrice").setValue((Object)rs.getString("FIssuPrice"));
        }
    }

    protected void setMergeTotalValue() throws Exception {
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)this.getSumSQL()).executeSQL();
            while (rs.next()) {
                IRow row = this.kdt.addRow();
                row.getCell("currency_name").setValue((Object)rs.getString("currency_name"));
                row.getCell("FExchangeNum").setValue((Object)rs.getString("FExchangeNum"));
                row.getCell("FExchangeAmount").setValue((Object)rs.getString("FExchangeAmount"));
                row.getCell("stockjobber_name").setValue((Object)FMRptClientUtils.getTotalResString());
                row.setMergeable(true);
            }
            KDTMergeManager mm = this.kdt.getMergeManager();
            mm.mergeBlock(this.kdt.getRowCount() - rs.size(), 0, this.kdt.getRowCount() - 1, 0, 3);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected abstract void insertHeadRow();

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("stockjobber_name").setValue((Object)this.getResString("stockJobber"));
        headRow.getCell("FExchangeDate").setValue((Object)this.getResString("date"));
        headRow.getCell("stock_name").setValue((Object)this.getResString("stock"));
        headRow.getCell("currency_name").setValue((Object)this.getResString("currency"));
        headRow.getCell("FIssuPrice").setValue((Object)this.getResString("issuPrice"));
        headRow.getCell("FExchangeNum").setValue((Object)this.getResString("winNubmer"));
        headRow.getCell("FExchangeAmount").setValue((Object)this.getResString("winAmount"));
        headRow.getCell("bankaccount_name").setValue((Object)this.getResString("bankAccount"));
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        this.companyIdSet = this.param.getCompanyIdSet();
        this.bankIdSet = this.param.getBankIdSet();
        this.dateFrom = this.param.getDateFrom();
        this.dateTo = this.param.getDateTo();
        this.currency = this.param.getCurrency();
        this.AccountBankIdSet = this.param.getAccountBankIdSet();
        sb.append(" and a.FCompanyID ='").append(this.currencyCompany.getId().toString()).append("'");
        if (this.AccountBankIdSet != null && this.AccountBankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" h.FBankAccountID ", (Object[])this.AccountBankIdSet.toArray()));
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" h.FStockJobberID ", (Object[])this.bankIdSet.toArray()));
        }
        if (this.dateTo != null) {
            sb.append(" and a.FExchangeDate<= { ").append(Constants.FORMAT_TIME.format(this.dateTo)).append("}");
        }
        if (this.dateFrom != null) {
            sb.append(" and a.FExchangeDate>={ ").append(Constants.FORMAT_TIME.format(this.dateFrom)).append("}");
        }
        if (this.currency != null) {
            sb.append(" and a.fcurrencyid ='").append(this.currency.getId().toString()).append("'");
        }
        return sb.toString();
    }
}

