/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.stock.client.RptStockRealizeFilterParam;
import com.kingdee.eas.fm.stock.client.RptStockRealizeHandlerAdapter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;

public class RptStockRealizeHandler
extends RptStockRealizeHandlerAdapter {
    public RptStockRealizeHandler(RptStockRealizeFilterParam param, KDTable kdt) {
        super(param, kdt);
    }

    @Override
    protected void insertHeadRow() {
        IColumn colstockjobber = this.kdt.addColumn();
        colstockjobber.setKey("stockjobber_name");
        colstockjobber.setMergeable(true);
        colstockjobber.setGroup(true);
        IColumn colcurrency_name = this.kdt.addColumn();
        colcurrency_name.setKey("currency_name");
        colcurrency_name.setMergeable(true);
        colcurrency_name.setGroup(true);
        IColumn colExchangeDate = this.kdt.addColumn();
        colExchangeDate.setKey("EXCHANGEDATE");
        IColumn colstock_name = this.kdt.addColumn();
        colstock_name.setKey("stock_name");
        IColumn colsaleNubmer = this.kdt.addColumn();
        colsaleNubmer.setKey("saleNubmer");
        this.formatCol(colsaleNubmer, 2);
        IColumn colsaleAmount = this.kdt.addColumn();
        colsaleAmount.setKey("saleAmount");
        this.formatCol(colsaleAmount, 1);
        IColumn colcost = this.kdt.addColumn();
        colcost.setKey("cost");
        this.formatCol(colcost, 1);
        IColumn colrecvalue = this.kdt.addColumn();
        colrecvalue.setKey("recvalue");
        this.formatCol(colrecvalue, 1);
        IColumn colbankaccount_name = this.kdt.addColumn();
        colbankaccount_name.setKey("bankaccount_name");
    }

    @Override
    public void setTableStateRow() {
        this.kdt.getColumn("currency_name").setStat(true);
        IRow subtotalcurRow = this.kdt.getGroupManager().getStatRowTemplate(1);
        subtotalcurRow.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"11_RptStockGeneralHandler"));
        subtotalcurRow.getCell(1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalcurRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        this.formatSumRow(subtotalcurRow, "saleNubmer");
        subtotalcurRow.getCell("saleNubmer").getStyleAttributes().setNumberFormat("%r{#,##0}f");
        this.formatSumRow(subtotalcurRow, "saleAmount");
        this.formatSumRow(subtotalcurRow, "cost");
        this.formatSumRow(subtotalcurRow, "recvalue");
    }

    private void formatSumRow(IRow row, String name) {
        row.getCell(name).setExpressions("SUM");
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell(name).getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell(name).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        row.getCell(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void formatCol(IColumn col, int type) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (type == 1) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        } else if (type == 2) {
            col.getStyleAttributes().setNumberFormat("%r{#,##0}f");
        }
    }

    protected void formatCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }
}

