/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.stock.client.RptStockRealizeFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public abstract class RptStockRealizeHandlerAdapter
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.stock.client.RptStockRealizeResource";
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    private CompanyOrgUnitInfo currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private RptStockRealizeFilterParam param;
    Set companyIdSet;
    Set bankIdSet;
    Date dateFrom;
    Date dateTo;
    CurrencyInfo currency;
    Set AccountBankIdSet;

    public RptStockRealizeHandlerAdapter(RptStockRealizeFilterParam param, KDTable kdt) {
        super(param.getFilter(), kdt);
        this.param = param;
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
    }

    private String getDetailSQL() {
        StringBuffer sbDetailSQL = new StringBuffer();
        sbDetailSQL.append("SELECT STOCKJOBBER.fid as id,STOCKJOBBER.FName_l2 AS STOCKJOBBER_NAME, STOCKINVESTBILL.FExchangeDate AS EXCHANGEDATE, STOCKINVESTBILL.FInvestType AS INVESTTYPE, CURRENCY.FName_l2 AS CURRENCY_NAME, STOCKINVESTBILL.FExchangeNum AS saleNubmer, STOCKINVESTBILL.FExchangeAmount AS saleAmount, (STOCKINVESTBILL.FRefCostPrice * STOCKINVESTBILL.FExchangeNum) AS COST, (STOCKINVESTBILL.FExchangeAmount - (STOCKINVESTBILL.FExchangeNum * STOCKINVESTBILL.FRefCostPrice)) AS RECVALUE, STOCK.FSimpleName as STOCK_NAME,BANKACCOUNT.FName_l2 AS BANKACCOUNT_NAME FROM T_SK_StockInvestBill AS STOCKINVESTBILL, T_BD_Currency AS CURRENCY ,T_SK_Stockholder AS STOCKHOLDER ,T_SK_Stock AS STOCK ,T_BD_Bank AS STOCKJOBBER ,T_BD_AccountBanks AS BANKACCOUNT WHERE STOCKINVESTBILL.FInvestType = '3' and STOCKINVESTBILL.FCurrencyID = CURRENCY.FID and STOCKINVESTBILL.FStockHolderID = STOCKHOLDER.FID and STOCKINVESTBILL.FStockID = STOCK.FID and  STOCKHOLDER.FStockJobberID = STOCKJOBBER.FID  and  STOCKHOLDER.FBankAccountID = BANKACCOUNT.FID ");
        sbDetailSQL.append(this.getCommonFilterToChLoan());
        sbDetailSQL.append(" order by STOCKJOBBER_NAME,CURRENCY_NAME");
        return sbDetailSQL.toString();
    }

    private String getSumSQL() {
        StringBuffer sbSumSQL = new StringBuffer();
        sbSumSQL.append("SELECT  CURRENCY.FName_l2 AS CURRENCY_NAME, sum(isnull(STOCKINVESTBILL.FExchangeNum,0)) AS saleNubmer, sum(isnull(STOCKINVESTBILL.FExchangeAmount,0)) AS saleAmount, sum(isnull((STOCKINVESTBILL.FRefCostPrice * STOCKINVESTBILL.FExchangeNum),0)) AS COST, sum(isnull((STOCKINVESTBILL.FExchangeAmount - (STOCKINVESTBILL.FExchangeNum * STOCKINVESTBILL.FRefCostPrice)),0)) AS RECVALUE FROM T_SK_StockInvestBill AS STOCKINVESTBILL, T_BD_Currency AS CURRENCY ,T_SK_Stockholder AS STOCKHOLDER ,T_SK_Stock AS STOCK ,T_BD_Bank AS STOCKJOBBER ,T_BD_AccountBanks AS BANKACCOUNT WHERE STOCKINVESTBILL.FInvestType = '3' and STOCKINVESTBILL.FCurrencyID = CURRENCY.FID and STOCKINVESTBILL.FStockHolderID = STOCKHOLDER.FID and STOCKINVESTBILL.FStockID = STOCK.FID and  STOCKHOLDER.FStockJobberID = STOCKJOBBER.FID  and  STOCKHOLDER.FBankAccountID = BANKACCOUNT.FID ");
        sbSumSQL.append(this.getCommonFilterToChLoan());
        sbSumSQL.append(" group by CURRENCY.FName_l2");
        return sbSumSQL.toString();
    }

    public void endDataFill() {
        super.endDataFill();
        try {
            this.setMergeTotalValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        String preID = "";
        while (rs.next()) {
            String tmpID = rs.getString("id");
            IRow row = this.kdt.addRow();
            row.getCell("stockjobber_name").setValue((Object)rs.getString("stockjobber_name"));
            row.getCell("EXCHANGEDATE").setValue((Object)rs.getDate("EXCHANGEDATE"));
            row.getCell("stock_name").setValue((Object)rs.getString("stock_name"));
            row.getCell("currency_name").setValue((Object)rs.getString("currency_name"));
            row.getCell("saleNubmer").setValue((Object)rs.getString("saleNubmer"));
            row.getCell("saleAmount").setValue((Object)rs.getString("saleAmount"));
            row.getCell("cost").setValue((Object)rs.getString("COST"));
            row.getCell("recvalue").setValue((Object)rs.getString("RECVALUE"));
            row.getCell("bankaccount_name").setValue((Object)rs.getString("bankaccount_name"));
        }
    }

    protected void setMergeTotalValue() throws Exception {
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)this.getSumSQL()).executeSQL();
            while (rs.next()) {
                IRow row = this.kdt.addRow();
                row.getCell("currency_name").setValue((Object)rs.getString("currency_name"));
                row.getCell("saleNubmer").setValue((Object)rs.getString("saleNubmer"));
                row.getCell("saleAmount").setValue((Object)rs.getString("saleAmount"));
                row.getCell("cost").setValue((Object)rs.getString("COST"));
                row.getCell("recvalue").setValue((Object)rs.getString("RECVALUE"));
                row.getCell("stockjobber_name").setValue((Object)FMRptClientUtils.getTotalResString());
                row.setMergeable(true);
            }
            KDTMergeManager mm = this.kdt.getMergeManager();
            mm.mergeBlock(this.kdt.getRowCount() - rs.size(), 0, this.kdt.getRowCount() - 1, 0, 3);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected abstract void insertHeadRow();

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("stockjobber_name").setValue((Object)this.getResString("stockJobber"));
        headRow.getCell("EXCHANGEDATE").setValue((Object)this.getResString("date"));
        headRow.getCell("stock_name").setValue((Object)this.getResString("stock"));
        headRow.getCell("currency_name").setValue((Object)this.getResString("currency"));
        headRow.getCell("saleNubmer").setValue((Object)this.getResString("saleNubmer"));
        headRow.getCell("saleAmount").setValue((Object)this.getResString("saleAmount"));
        headRow.getCell("cost").setValue((Object)this.getResString("cost"));
        headRow.getCell("recvalue").setValue((Object)this.getResString("recvalue"));
        headRow.getCell("bankaccount_name").setValue((Object)this.getResString("bankAccount"));
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        this.companyIdSet = this.param.getCompanyIdSet();
        this.bankIdSet = this.param.getBankIdSet();
        this.dateFrom = this.param.getDateFrom();
        this.dateTo = this.param.getDateTo();
        this.currency = this.param.getCurrency();
        this.AccountBankIdSet = this.param.getAccountBankIdSet();
        sb.append(" and STOCKINVESTBILL.FCompanyID ='").append(this.currencyCompany.getId().toString()).append("'");
        if (this.AccountBankIdSet != null && this.AccountBankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" STOCKHOLDER.FBankAccountID ", (Object[])this.AccountBankIdSet.toArray()));
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" STOCKHOLDER.FStockJobberID ", (Object[])this.bankIdSet.toArray()));
        }
        if (this.dateTo != null) {
            sb.append(" and STOCKINVESTBILL.FExchangeDate<= { ").append(Constants.FORMAT_TIME.format(this.dateTo)).append("}");
        }
        if (this.dateFrom != null) {
            sb.append(" and STOCKINVESTBILL.FExchangeDate>={ ").append(Constants.FORMAT_TIME.format(this.dateFrom)).append("}");
        }
        if (this.currency != null) {
            sb.append(" and STOCKINVESTBILL.fcurrencyid ='").append(this.currency.getId().toString()).append("'");
        }
        return sb.toString();
    }
}

