/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.stock.client.AbstractRptStockRealizeMainUI;
import com.kingdee.eas.fm.stock.client.RptStockRealizeFilterParam;
import com.kingdee.eas.fm.stock.client.RptStockRealizeFilterUI;
import com.kingdee.eas.fm.stock.client.RptStockRealizeHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class RptStockRealizeMainUI
extends AbstractRptStockRealizeMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptStockRealizeMainUI.class);
    private FMFilterBaseUI filterUI = null;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        RptStockRealizeFilterParam param = (RptStockRealizeFilterParam)this.getFilterParam();
        RptStockRealizeHandler handler = null;
        this.tblMain.checkParsed();
        this.tblMain.getMergeManager().setDataMode(0);
        handler = new RptStockRealizeHandler(param, this.getMainTable());
        Date date = param.getDateFrom();
        if (date != null) {
            this.kDDateFrom.setText(this.getFormatDate(date));
        } else {
            this.kDDateFrom.setText(this.getFormatDate(param.getDateTo()));
        }
        this.kDDateTo.setText(this.getFormatDate(param.getDateTo()));
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        handler.endDataFill();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptStockRealizeFilterUI();
        }
        return this.filterUI;
    }

    protected String getFormatDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(ds);
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
    }
}

