/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.stock.ExchagePlanceEnum;
import com.kingdee.eas.fm.stock.StockFactory;
import com.kingdee.eas.fm.stock.StockInfo;
import com.kingdee.eas.fm.stock.StockTypeEnum;
import com.kingdee.eas.fm.stock.client.AbstractStockEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class StockEditUI
extends AbstractStockEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StockEditUI.class);

    public StockEditUI() throws Exception {
        this.setFocusCycleRoot(false);
    }

    @Override
    public void loadFields() {
        try {
            this.doCheck();
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        super.loadFields();
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.combCurrency, (boolean)true);
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        FMClientHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)this.editData.getCurrency());
        if (this.editData.getStockType() != null) {
            this.stockType.removeAllItems();
            if (this.editData.getStockType().equals((Object)StockTypeEnum.A) || this.editData.getStockType().equals((Object)StockTypeEnum.B)) {
                this.stockType.addItem((Object)StockTypeEnum.A);
                this.stockType.addItem((Object)StockTypeEnum.B);
            } else if (this.editData.getStockType().equals((Object)StockTypeEnum.H)) {
                this.stockType.addItem((Object)StockTypeEnum.H);
            } else if (this.editData.getStockType().equals((Object)StockTypeEnum.N)) {
                this.stockType.addItem((Object)StockTypeEnum.N);
            } else if (this.editData.getStockType().equals((Object)StockTypeEnum.S)) {
                this.stockType.addItem((Object)StockTypeEnum.S);
            }
            FMClientHelper.setSelectObject((KDComboBox)this.stockType, (Object)((Object)this.editData.getStockType()));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionPrint, this.actionEdit, this.actionSave, this.actionCancel, this.actionCancelCancel, this.actionCopy, this.actionRemove, this.actionFirst, this.actionPre, this.actionNext, this.actionLast, this.actionPrintPreview};
        this.setActionVisible(false, actions);
    }

    private void setActionVisible(boolean visible, ItemAction[] actions) {
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(visible);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StockInfo objectValue = new StockInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStockType(StockTypeEnum.A);
        objectValue.setExchagePlace(ExchagePlanceEnum.SHANGHAI);
        try {
            objectValue.setCurrency(ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(ContextHelperFactory.getRemoteInstance().getCurrentCompany()));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        objectValue.setOfferingDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setPublicDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setFreeFloat(Constants.ZERO);
        objectValue.setFirstClose(Constants.ZERO);
        objectValue.setIssuPrice(Constants.ZERO);
        objectValue.setIssueAmount(Constants.ZERO);
        objectValue.setPERatio(Constants.ZERO);
        objectValue.setFirstUpPer(Constants.ZERO);
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.txtissuPrice.setPrecision(2);
        this.txtfirstClose.setPrecision(2);
        this.txtfreeFloat.setPrecision(2);
        this.txtissueAmount.setPrecision(2);
        this.txtfirstUpPer.setPrecision(2);
        this.txtpERatio.setPrecision(2);
        this.txtDescription.setMaxLength(120);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtissuPrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtfirstClose);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtfreeFloat);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtissueAmount);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtfirstUpPer);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtpERatio);
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setOprtState(OprtState.VIEW);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtissuPrice, (BigDecimal)Constants.ZERO);
        if (this.editData.getNumber().length() > 70) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.client.StockResource.StockNumTooLong"));
            SysUtil.abort();
        }
    }

    private void doCheck() throws BOSException {
        if (this.getOprtState().equals(OprtState.EDIT)) {
            IRefChecker checker = RefCheckerFactory.getRemoteInstance();
            try {
                if (checker.isReferenced(this.editData.getId())) {
                    this.combCurrency.setEnabled(false);
                    this.stockType.setEnabled(false);
                    this.exchagePlace.setEnabled(false);
                } else {
                    this.combCurrency.setEnabled(true);
                    this.stockType.setEnabled(true);
                    this.exchagePlace.setEnabled(true);
                }
            }
            catch (BizReferenceException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException ex) {
                this.handUIExceptionAndAbort((Exception)((Object)ex));
            }
        }
    }

    @Override
    protected void exchagePlace_itemStateChanged(ItemEvent e) throws Exception {
        super.exchagePlace_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        this.stockType.removeAllItems();
        if (this.exchagePlace.getSelectedItem().equals((Object)ExchagePlanceEnum.SHANGHAI) || this.exchagePlace.getSelectedItem().equals((Object)ExchagePlanceEnum.SHENZHEN)) {
            this.stockType.addItem((Object)StockTypeEnum.A);
            this.stockType.addItem((Object)StockTypeEnum.B);
        } else if (this.exchagePlace.getSelectedItem().equals((Object)ExchagePlanceEnum.HONGKONG)) {
            this.stockType.addItem((Object)StockTypeEnum.H);
        } else if (this.exchagePlace.getSelectedItem().equals((Object)ExchagePlanceEnum.NEWYORK)) {
            this.stockType.addItem((Object)StockTypeEnum.N);
        } else if (this.exchagePlace.getSelectedItem().equals((Object)ExchagePlanceEnum.SINGAPORE)) {
            this.stockType.addItem((Object)StockTypeEnum.S);
        }
    }

    @Override
    protected void txtfirstClose_dataChanged(DataChangeEvent e) throws Exception {
        super.txtfirstClose_dataChanged(e);
        BigDecimal issuePrice = this.txtissuPrice.getBigDecimalValue();
        BigDecimal firstClose = this.txtfirstClose.getBigDecimalValue();
        if (issuePrice != null && firstClose != null && issuePrice.compareTo(Constants.ZERO) > 0 && firstClose.compareTo(Constants.ZERO) > 0) {
            BigDecimal firstUp = firstClose.subtract(issuePrice).divide(issuePrice, 4).multiply(new BigDecimal("100"));
            this.txtfirstUpPer.setValue((Object)firstUp);
        }
    }

    @Override
    protected void txtissuPrice_dataChanged(DataChangeEvent e) throws Exception {
        super.txtissuPrice_dataChanged(e);
        BigDecimal issuePrice = this.txtissuPrice.getBigDecimalValue();
        BigDecimal firstClose = this.txtfirstClose.getBigDecimalValue();
        if (issuePrice != null && firstClose != null && issuePrice.compareTo(Constants.ZERO) > 0 && firstClose.compareTo(Constants.ZERO) > 0) {
            BigDecimal firstUp = firstClose.subtract(issuePrice).divide(issuePrice, 4).multiply(new BigDecimal("100"));
            this.txtfirstUpPer.setValue((Object)firstUp);
        }
    }
}

