/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.StockInvestBillFactory;
import com.kingdee.eas.fm.stock.StockInvestBillInfo;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.fm.stock.client.AbstractStockInvestBilBondBankUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class StockInvestBilBondBankUI
extends AbstractStockInvestBilBondBankUI {
    private static final Logger logger = CoreUIObject.getLogger(StockInvestBilBondBankUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo currentCurrency = this.currentCompany.getBaseCurrency();
    private Date curDate = DateUtil.getDayBegin();

    public void onLoad() throws Exception {
        this.initInvestType();
        super.onLoad();
        this.txtexchangeAmount.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtexchangeAmount);
        this.txtexchangeAmount.setPrecision(2);
        this.txtDescription.setMaxLength(78);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.txtNumber.setEnabled(false);
            if (this.editData.isFivouchered()) {
                this.prmtstockHolder.setEnabled(false);
                this.pkexchangeDate.setEnabled(false);
                this.txtexchangeAmount.setEnabled(false);
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initInvestType() {
        this.investType.removeAllItems();
        this.investType.addItem((Object)InvestTypeEnum.BondtoBank);
        this.investType.addItem((Object)InvestTypeEnum.BanktoBond);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtstockHolder);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtexchangeAmount);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getStockHolder() != null) {
            this.editData.setCurrency(this.editData.getStockHolder().getCurrency());
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockInvestBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StockInvestBillInfo objectValue = new StockInvestBillInfo();
        objectValue.setInvestType(InvestTypeEnum.BondtoBank);
        objectValue.setCompany(this.currentCompany);
        objectValue.setOfferingDate(this.curDate);
        objectValue.setExchangeDate(this.curDate);
        objectValue.setBizDate(this.curDate);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        objectValue.setApplyNum(Constants.ZERO);
        objectValue.setApplyAmount(Constants.ZERO);
        objectValue.setActwinRate(Constants.ZERO);
        objectValue.setRepwinRate(Constants.ZERO);
        objectValue.setEarning(Constants.ZERO);
        objectValue.setExchangeAmount(Constants.ZERO);
        objectValue.setExchangeNum(Constants.ZERO);
        objectValue.setExchangePrice(Constants.ZERO);
        objectValue.setAmount(Constants.ZERO);
        objectValue.setStampTax(Constants.ZERO);
        objectValue.setBrokeage(Constants.ZERO);
        objectValue.setStAssignPay(Constants.ZERO);
        objectValue.setRefCostPrice(Constants.ZERO);
        return objectValue;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected void prmtstockHolder_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.currentCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtstockHolder.setEntityViewInfo(evi);
        this.prmtstockHolder.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockHolder_willCommit(CommitEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.currentCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtstockHolder.setEntityViewInfo(evi);
        this.prmtstockHolder.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockHolder_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstockHolder_dataChanged(e);
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stockholderInfo = (StockholderInfo)this.prmtstockHolder.getData();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.disposeUIWindow();
    }
}

