/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.StockInfo;
import com.kingdee.eas.fm.stock.StockInvestBillFactory;
import com.kingdee.eas.fm.stock.StockInvestBillInfo;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.fm.stock.client.AbstractStockInvestBillApplyUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class StockInvestBillApplyUI
extends AbstractStockInvestBillApplyUI {
    private static final Logger logger = CoreUIObject.getLogger(StockInvestBillApplyUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo currentCurrency = this.currentCompany.getBaseCurrency();
    private Date curDate = DateUtil.getDayBegin();

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtapplyNum.setHorizontalAlignment(4);
        this.txtexchangePrice.setHorizontalAlignment(4);
        this.txtapplyAmount.setHorizontalAlignment(4);
        this.txtexchangeNum.setHorizontalAlignment(4);
        this.txtexchangeAmount.setHorizontalAlignment(4);
        this.txtactwinRate.setHorizontalAlignment(4);
        this.txtrepwinRate.setHorizontalAlignment(4);
        this.txtearning.setHorizontalAlignment(4);
        this.txtactwinRate.setPrecision(4);
        this.txtrepwinRate.setPrecision(4);
        this.txtDescription.setMaxLength(78);
        this.initPre(2);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initPre(int precision) {
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtapplyAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtexchangeAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtexchangePrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtearning);
        this.txtapplyAmount.setPrecision(precision);
        this.txtexchangeAmount.setPrecision(precision);
        this.txtexchangePrice.setPrecision(precision);
        this.txtearning.setPrecision(precision);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.txtNumber.setEnabled(false);
            if (this.editData.isFivouchered()) {
                this.prmtstockHolder.setEnabled(false);
                this.prmtstock.setEnabled(false);
                this.pkofferingDate.setEnabled(false);
                this.txtapplyNum.setEnabled(false);
                this.txtexchangePrice.setEnabled(false);
                this.txtapplyAmount.setEnabled(false);
                this.pkexchangeDate.setEnabled(false);
                this.txtexchangeNum.setEnabled(false);
                this.txtexchangeAmount.setEnabled(false);
                this.txtactwinRate.setEnabled(false);
                this.txtrepwinRate.setEnabled(false);
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    protected IObjectValue createNewData() {
        StockInvestBillInfo objectValue = new StockInvestBillInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setCompany(this.currentCompany);
        objectValue.setOfferingDate(this.curDate);
        objectValue.setExchangeDate(StockInvestBillApplyUI.getAfThreeDay(this.curDate));
        objectValue.setBizDate(this.curDate);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        objectValue.setInvestType(InvestTypeEnum.Apply);
        objectValue.setApplyNum(Constants.ZERO);
        objectValue.setApplyAmount(Constants.ZERO);
        objectValue.setActwinRate(Constants.ZERO);
        objectValue.setRepwinRate(Constants.ZERO);
        objectValue.setEarning(Constants.ZERO);
        objectValue.setExchangeAmount(Constants.ZERO);
        objectValue.setExchangeNum(Constants.ZERO);
        objectValue.setExchangePrice(Constants.ZERO);
        objectValue.setIsbankbond(false);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtapplyNum);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtexchangePrice);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getStockHolder() != null) {
            this.editData.setCurrency(this.editData.getStockHolder().getCurrency());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockInvestBillFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected void prmtstockHolder_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.currentCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtstockHolder.setEntityViewInfo(evi);
        this.prmtstockHolder.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockHolder_willCommit(CommitEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.currentCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtstockHolder.setEntityViewInfo(evi);
        this.prmtstockHolder.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockHolder_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstockHolder_dataChanged(e);
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            this.prmtstock.setValue(null);
        }
    }

    @Override
    protected void prmtstock_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstock_dataChanged(e);
        if (this.prmtstock.getData() != null) {
            StockInfo stock = (StockInfo)this.prmtstock.getData();
            this.txtexchangePrice.setValue((Object)stock.getIssuPrice());
        }
    }

    @Override
    protected void prmtstock_willCommit(CommitEvent e) throws Exception {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("exchagePlace", (Object)stholder.getExchagePlaceEnu().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("stockType", (Object)stholder.getStockTypeEnum().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)stholder.getCurrency().getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtstock.setEntityViewInfo(evi);
            this.prmtstock.getQueryAgent().resetRuntimeEntityView();
        } else {
            super.prmtstock_willCommit(e);
        }
    }

    @Override
    protected void prmtstock_willShow(SelectorEvent e) throws Exception {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("exchagePlace", (Object)stholder.getExchagePlaceEnu().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("stockType", (Object)stholder.getStockTypeEnum().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)stholder.getCurrency().getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtstock.setEntityViewInfo(evi);
            this.prmtstock.getQueryAgent().resetRuntimeEntityView();
        } else {
            super.prmtstock_willShow(e);
        }
    }

    @Override
    protected void txtapplyNum_dataChanged(DataChangeEvent e) throws Exception {
        this.calcapplyAmount();
    }

    @Override
    protected void txtexchangePrice_dataChanged(DataChangeEvent e) throws Exception {
        this.calcapplyAmount();
        this.calcexchangeAmount();
    }

    @Override
    protected void txtapplyAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcactwinRate();
    }

    @Override
    protected void txtexchangeNum_dataChanged(DataChangeEvent e) throws Exception {
        this.calcexchangeAmount();
    }

    @Override
    protected void txtexchangeAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcactwinRate();
    }

    private void calcapplyAmount() {
        if (this.txtapplyNum.getBigDecimalValue() != null && this.txtexchangePrice.getBigDecimalValue() != null) {
            this.txtapplyAmount.setValue((Object)this.txtapplyNum.getBigDecimalValue().multiply(this.txtexchangePrice.getBigDecimalValue()));
        }
    }

    private void calcexchangeAmount() {
        if (this.txtexchangeNum.getBigDecimalValue() != null && this.txtexchangePrice.getBigDecimalValue() != null) {
            this.txtexchangeAmount.setValue((Object)this.txtexchangeNum.getBigDecimalValue().multiply(this.txtexchangePrice.getBigDecimalValue()));
        }
    }

    private void calcactwinRate() {
        if (this.txtexchangeAmount.getBigDecimalValue() != null && this.txtapplyAmount.getBigDecimalValue() != null && this.txtapplyAmount.getBigDecimalValue().compareTo(Constants.ZERO) == 1) {
            this.txtactwinRate.setValue((Object)this.txtexchangeAmount.getBigDecimalValue().multiply(Constants.ONE_HUNDRED).divide(this.txtapplyAmount.getBigDecimalValue(), 4, 4));
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void pkofferingDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkofferingDate_dataChanged(e);
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.pkexchangeDate.setValue((Object)StockInvestBillApplyUI.getAfThreeDay((Date)this.pkofferingDate.getValue()));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Fivouchered"));
        return sic;
    }

    public static Date getAfThreeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, 3);
        return cal.getTime();
    }
}

