/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockInvestBillFactory;
import com.kingdee.eas.fm.stock.StockInvestBillInfo;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.fm.stock.client.AbstractStockInvestBillBuyUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class StockInvestBillBuyUI
extends AbstractStockInvestBillBuyUI {
    private static final Logger logger = CoreUIObject.getLogger(StockInvestBillBuyUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private Date curDate = DateUtil.getDayBegin();
    private CurrencyInfo currentCurrency = this.currentCompany.getBaseCurrency();

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getStockHolder() != null) {
            this.editData.setCurrency(this.editData.getStockHolder().getCurrency());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtexchangeNum.setPrecision(0);
        this.txtexchangeNum.setHorizontalAlignment(4);
        this.txtexchangePrice.setHorizontalAlignment(4);
        this.txtexchangeAmount.setHorizontalAlignment(4);
        this.txtbrokeage.setHorizontalAlignment(4);
        this.txtstampTax.setHorizontalAlignment(4);
        this.txtstAssignPay.setHorizontalAlignment(4);
        this.txtamount.setHorizontalAlignment(4);
        this.initPre(2);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtDescription.setMaxLength(78);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.txtNumber.setEnabled(false);
            if (this.editData.isFivouchered()) {
                this.prmtstockHolder.setEnabled(false);
                this.prmtstock.setEnabled(false);
                this.txtexchangePrice.setEnabled(false);
                this.pkexchangeDate.setEnabled(false);
                this.txtexchangeNum.setEnabled(false);
                this.txtexchangeAmount.setEnabled(false);
                this.txtamount.setEnabled(false);
                this.txtbrokeage.setEnabled(false);
                this.txtstampTax.setEnabled(false);
                this.txtstAssignPay.setEnabled(false);
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initPre(int precision) {
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtexchangeAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtexchangePrice);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtbrokeage);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtstAssignPay);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtstampTax);
        this.txtamount.setPrecision(precision);
        this.txtexchangeAmount.setPrecision(precision);
        this.txtexchangePrice.setPrecision(precision);
        this.txtbrokeage.setPrecision(precision);
        this.txtstAssignPay.setPrecision(precision);
        this.txtstampTax.setPrecision(precision);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.txtexchangeNum.getBigDecimalValue().compareTo(Constants.ZERO) == 0 && this.txtexchangeAmount.getBigDecimalValue().compareTo(Constants.ZERO) == 0) {
            throw new StockException(StockException.EXCHANGE_EXC1);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockInvestBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StockInvestBillInfo objectValue = new StockInvestBillInfo();
        objectValue.setInvestType(InvestTypeEnum.Buy);
        objectValue.setCompany(this.currentCompany);
        objectValue.setOfferingDate(this.curDate);
        objectValue.setExchangeDate(this.curDate);
        objectValue.setBizDate(this.curDate);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        objectValue.setApplyNum(Constants.ZERO);
        objectValue.setApplyAmount(Constants.ZERO);
        objectValue.setActwinRate(Constants.ZERO);
        objectValue.setRepwinRate(Constants.ZERO);
        objectValue.setEarning(Constants.ZERO);
        objectValue.setExchangeAmount(Constants.ZERO);
        objectValue.setExchangeNum(Constants.ZERO);
        objectValue.setExchangePrice(Constants.ZERO);
        objectValue.setAmount(Constants.ZERO);
        objectValue.setStampTax(Constants.ZERO);
        objectValue.setBrokeage(Constants.ZERO);
        objectValue.setStAssignPay(Constants.ZERO);
        objectValue.setIsbankbond(false);
        return objectValue;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected void prmtstockHolder_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.currentCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtstockHolder.setEntityViewInfo(evi);
        this.prmtstockHolder.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockHolder_willCommit(CommitEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCompany.id", (Object)this.currentCompany.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtstockHolder.setEntityViewInfo(evi);
        this.prmtstockHolder.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockHolder_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstockHolder_dataChanged(e);
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            this.prmtstock.setValue(null);
            this.calcapplyAmount();
        }
    }

    @Override
    protected void prmtstock_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstock_dataChanged(e);
    }

    @Override
    protected void prmtstock_willCommit(CommitEvent e) throws Exception {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("exchagePlace", (Object)stholder.getExchagePlaceEnu().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("stockType", (Object)stholder.getStockTypeEnum().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)stholder.getCurrency().getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtstock.setEntityViewInfo(evi);
            this.prmtstock.getQueryAgent().resetRuntimeEntityView();
        } else {
            super.prmtstock_willCommit(e);
        }
    }

    @Override
    protected void prmtstock_willShow(SelectorEvent e) throws Exception {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("exchagePlace", (Object)stholder.getExchagePlaceEnu().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("stockType", (Object)stholder.getStockTypeEnum().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)stholder.getCurrency().getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtstock.setEntityViewInfo(evi);
            this.prmtstock.getQueryAgent().resetRuntimeEntityView();
        } else {
            super.prmtstock_willShow(e);
        }
    }

    @Override
    protected void txtexchangeNum_dataChanged(DataChangeEvent e) throws Exception {
        this.calcapplyAmount();
    }

    @Override
    protected void txtexchangePrice_dataChanged(DataChangeEvent e) throws Exception {
        this.calcapplyAmount();
    }

    private void calcapplyAmount() {
        if (this.txtexchangeNum.getBigDecimalValue() != null && this.txtexchangePrice.getBigDecimalValue() != null) {
            this.txtamount.setValue((Object)this.txtexchangeNum.getBigDecimalValue().multiply(this.txtexchangePrice.getBigDecimalValue()));
            this.calcAssignPay();
        }
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        this.calcbrokeage();
        this.calcstampTax();
        this.calcAssignPay();
    }

    @Override
    protected void txtbrokeage_dataChanged(DataChangeEvent e) throws Exception {
        this.calcexchangeAmount();
    }

    @Override
    protected void txtstampTax_dataChanged(DataChangeEvent e) throws Exception {
        this.calcexchangeAmount();
    }

    @Override
    protected void txtstAssignPay_dataChanged(DataChangeEvent e) throws Exception {
        this.calcexchangeAmount();
    }

    private void calcbrokeage() {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            this.txtbrokeage.setValue((Object)this.BigValue(this.txtamount.getBigDecimalValue().multiply(stholder.getPRate()).divide(Constants.ONE_HUNDRED, 4, 4), stholder.getLowestPrate()));
        }
    }

    private void calcstampTax() {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            this.txtstampTax.setValue((Object)this.txtamount.getBigDecimalValue().multiply(stholder.getStampTaxRate()).divide(Constants.ONE_HUNDRED, 4, 4));
        }
    }

    private void calcAssignPay() {
        if (this.prmtstockHolder.getData() != null) {
            StockholderInfo stholder = (StockholderInfo)this.prmtstockHolder.getData();
            this.txtstAssignPay.setValue((Object)this.BigValue(this.txtexchangeNum.getBigDecimalValue().multiply(stholder.getAssignPayRate()).divide(Constants.ONE_HUNDRED, 4, 4), stholder.getLowestAssignPay()));
        }
    }

    private void calcexchangeAmount() {
        if (this.txtamount.getBigDecimalValue() != null && this.txtbrokeage.getBigDecimalValue() != null && this.txtstampTax.getBigDecimalValue() != null && this.txtstAssignPay.getBigDecimalValue() != null) {
            this.txtexchangeAmount.setValue((Object)this.txtamount.getBigDecimalValue().add(this.txtbrokeage.getBigDecimalValue()).add(this.txtstampTax.getBigDecimalValue()).add(this.txtstAssignPay.getBigDecimalValue()));
        }
    }

    private BigDecimal BigValue(BigDecimal A, BigDecimal B) {
        if (A.compareTo(B) == 1) {
            return A;
        }
        return B;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Fivouchered"));
        return sic;
    }
}

