/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FilterParam;
import java.util.Date;
import java.util.Set;

public class StockInvestBillFilterParam
implements FilterParam {
    private static final long serialVersionUID = -7351894673772205328L;
    private String currencyId;
    private Date dateFrom;
    private Date dateTo;
    private Set companys;

    public Set getCompanys() {
        return this.companys;
    }

    public void setCompanys(Set companys) {
        this.companys = companys;
    }

    public CurrencyInfo getCurrency() {
        if (this.currencyId != null) {
            CurrencyInfo info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)this.currencyId));
            return info;
        }
        return null;
    }

    public void setCurrency(CurrencyInfo currencyInfo) {
        this.currencyId = currencyInfo == null ? null : currencyInfo.getId().toString();
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public FilterInfo getFilter() {
        FilterInfo fi = new FilterInfo();
        this.addStockInvestBillFilterItems(fi);
        return fi;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    private void addStockInvestBillFilterItems(FilterInfo fi) {
        CompanyOrgUnitInfo currencyCompany;
        if (null != this.getDateFrom()) {
            fi.getFilterItems().add(new FilterItemInfo("exchangeDate", (Object)this.getDateFrom(), CompareType.GREATER_EQUALS));
        }
        if (null != this.getDateTo()) {
            fi.getFilterItems().add(new FilterItemInfo("exchangeDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
        }
        if (null != this.getCurrency()) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrency().getId()));
        }
        if ((currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany()).isIsUnion()) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanys(), CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)currencyCompany.getId().toString(), CompareType.INCLUDE));
        }
    }
}

