/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.client.TimeDepositHelper;
import com.kingdee.eas.fm.stock.client.AbstractStockInvestBillFilterUI;
import com.kingdee.eas.fm.stock.client.StockInvestBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class StockInvestBillFilterUI
extends AbstractStockInvestBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StockInvestBillFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    protected void init() throws Exception {
        super.init();
        this.initCurrency();
        this.initDate();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboCurrency.setSelectedIndex(this.cboCurrency.getItemCount() - 1);
    }

    public void initDate() {
        Date now = new Date();
        this.exDayBegin.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.exDayEnd.setValue((Object)now);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        Object obj;
        StockInvestBillFilterParam param = new StockInvestBillFilterParam();
        if (null != this.exDayBegin.getValue()) {
            param.setDateFrom(DateTimeUtils.truncateDate((Date)((Date)this.exDayBegin.getValue())));
        }
        if (null != this.exDayEnd.getValue()) {
            param.setDateTo(DateTimeUtils.truncateDate((Date)((Date)this.exDayEnd.getValue())));
        }
        if (null != this.cboCurrency.getSelectedItem() && (obj = this.cboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            param.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        }
        return param;
    }

    public void setParam(Object param) {
        if (null == param || !(param instanceof StockInvestBillFilterParam)) {
            return;
        }
        StockInvestBillFilterParam filterparam = (StockInvestBillFilterParam)param;
        this.exDayBegin.setValue((Object)filterparam.getDateFrom());
        this.exDayEnd.setValue((Object)filterparam.getDateTo());
        if (filterparam.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterparam.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.setCompanyIdSet(filterparam.getCompanys());
    }

    public boolean verify() {
        if (this.exDayBegin.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"StartDateIsNull"));
            SysUtil.abort();
        }
        if (this.exDayEnd.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"EndDateIsNull"));
            SysUtil.abort();
        }
        if (((Date)this.exDayEnd.getValue()).compareTo((Date)this.exDayBegin.getValue()) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)TimeDepositHelper.getInstance().getResourcePath(), (String)TimeDepositHelper.getInstance().getDateMsg()));
            this.exDayBegin.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.initCurrency();
        this.initDate();
    }

    protected Class getParamClass() {
        return StockInvestBillFilterParam.class;
    }
}

