/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockInvestBillFactory;
import com.kingdee.eas.fm.stock.StockInvestBillInfo;
import com.kingdee.eas.fm.stock.client.AbstractStockInvestBillListUI;
import com.kingdee.eas.fm.stock.client.StockInvestBilBondBankUI;
import com.kingdee.eas.fm.stock.client.StockInvestBillApplyUI;
import com.kingdee.eas.fm.stock.client.StockInvestBillBuyUI;
import com.kingdee.eas.fm.stock.client.StockInvestBillFilterUI;
import com.kingdee.eas.fm.stock.client.StockInvestBillSaleUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockInvestBillListUI
extends AbstractStockInvestBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(StockInvestBillListUI.class);
    private StockInvestBillFilterUI filterUI = null;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
        this.menuBiz.setEnabled(true);
        this.menuBiz.setVisible(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionApply.setEnabled(true);
        this.actionBuy.setEnabled(true);
        this.actionBondBank.setEnabled(true);
        this.actionSale.setEnabled(true);
        this.actionApply.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_purchase"));
        this.actionBuy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionBondBank.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_turnaccount"));
        this.actionSale.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_payment"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        Boolean isBankBond = (Boolean)row.getCell("isBankBond").getValue();
        if (isBankBond.booleanValue()) {
            throw new StockException(StockException.EDIT_EXC1);
        }
        Date exchangeDate = (Date)row.getCell("exchangeDate").getValue();
        if (this.checkeDate(exchangeDate)) {
            throw new StockException(StockException.EDIT_DATEEXC1);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
        this.refresh(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockInvestBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        StockInvestBillInfo objectValue = new StockInvestBillInfo();
        return objectValue;
    }

    @Override
    public void actionApply_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(StockInvestBillApplyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionBondBank_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(StockInvestBilBondBankUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionBuy_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(StockInvestBillBuyUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionSale_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(StockInvestBillSaleUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        Boolean isVouched = (Boolean)row.getCell("Fivouchered").getValue();
        if (isVouched.booleanValue()) {
            throw new StockException(StockException.DELETE_EXC2);
        }
        Date exchangeDate = (Date)row.getCell("exchangeDate").getValue();
        if (this.checkeDate(exchangeDate)) {
            throw new StockException(StockException.EDIT_DATEEXC1);
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected String getEditUIName() {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        if (row == null) {
            return null;
        }
        String investType = row.getCell("investType").getValue().toString();
        if (investType.equals(InvestTypeEnum.Buy.toString())) {
            return StockInvestBillBuyUI.class.getName().toString();
        }
        if (investType.equals(InvestTypeEnum.Apply.toString())) {
            return StockInvestBillApplyUI.class.getName().toString();
        }
        if (investType.equals(InvestTypeEnum.Sale.toString())) {
            return StockInvestBillSaleUI.class.getName().toString();
        }
        return StockInvestBilBondBankUI.class.getName().toString();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new StockInvestBillFilterUI();
        }
        return this.filterUI;
    }

    private boolean checkeDate(Date exchangeDate) throws BOSException, SQLException {
        String sql = " select *  from T_SK_SettleDate where   FCurCompanyID='" + this.currentCompany.getId().toString() + "' and FSettleDate>{" + exchangeDate + "}";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        return rs.next();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(StockInvestBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                String currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"exchangePrice", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"brokeage", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"stAssignPay", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"exchangeAmount", (String)currencyId);
                }
                row.getCell("stampTax").getStyleAttributes().setNumberFormat("%r-[]0.2n");
                row.getCell("stampTax").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("exchangeNum").getFormattedStyleAttributes().setNumberFormat("###,##0");
                row.getCell("exchangeNum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

