/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.stock.client.AbstractStockVCFilterUI;
import com.kingdee.eas.fm.stock.client.StockVCFilterParam;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class StockVCFilterUI
extends AbstractStockVCFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StockVCFilterUI.class);
    private CompanyOrgUnitInfo company;
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() throws Exception {
        this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CashHelper.initCombCurrency((KDComboBox)this.CombCurrency, (boolean)false);
        this.DateTo.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.initF7Filter();
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtstockJobber, null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    protected void prmtstockJobber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstockJobber_dataChanged(e);
        if (this.prmtstockJobber.getData() != null) {
            this.prmtbankAccount.setValue(null);
        }
    }

    @Override
    protected void prmtbankAccount_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        if (this.getIdSetFromF7(this.prmtstockJobber).size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.getIdSetFromF7(this.prmtstockJobber), CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtbankAccount.setEntityViewInfo(evi);
        this.prmtbankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public Object getParam() {
        Object obj;
        StockVCFilterParam param = new StockVCFilterParam();
        param.setBankIdSet(this.getIdSetFromF7(this.prmtstockJobber));
        param.setDateTo(this.DateTo.getSqlDate());
        try {
            param.setAccountBankIdSet(this.getIdSetFromF7(this.prmtbankAccount));
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ACCOUNT_ERROR"));
            SysUtil.abort();
        }
        if (null != this.CombCurrency.getSelectedItem() && (obj = this.CombCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            param.setCurrency((CurrencyInfo)this.CombCurrency.getSelectedItem());
        }
        return param;
    }

    public void setParam(Object param) {
        StockVCFilterParam Param = (StockVCFilterParam)((Object)param);
        try {
            this.prmtstockJobber.setData((Object)this.getBaseInfoFromIdSet(Param.getBankIdSet()));
            this.prmtbankAccount.setData((Object)this.getBaseInfoFromIdSet(Param.getAccountBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.DateTo.setValue((Object)Param.getDateTo());
        FMClientHelper.setSelectObject((KDComboBox)this.CombCurrency, (Object)Param.getCurrency());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    protected Set getIdSetFromF7(KDBizPromptBox bizBox) {
        return AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)bizBox));
    }

    protected CoreBaseInfo[] getBaseInfoFromIdSet(Set idSet) throws BOSException {
        if (idSet == null || idSet.size() <= 0) {
            return null;
        }
        ICoreBase bizCtrl = EJBAccessFactory.createRemoteInstance().getEntityBizInterface(idSet.toArray()[0].toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        CoreBaseCollection collection = bizCtrl.getCollection(evi);
        CoreBaseInfo[] ovs = new CoreBaseInfo[collection.size()];
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            ovs[i] = collection.get(i);
        }
        return ovs;
    }

    public boolean verify() {
        if (this.DateTo.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"14_StockVCFilterUI"));
            this.DateTo.setValue((Object)new Date());
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        try {
            this.init();
            this.prmtstockJobber.setData(null);
            this.prmtbankAccount.setData(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected Class getParamClass() {
        return StockVCFilterParam.class;
    }
}

