/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.stock.MarketCapFactory;
import com.kingdee.eas.fm.stock.MarketCapInfo;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockHelper;
import com.kingdee.eas.fm.stock.client.AbstractStockVcCheckUI;
import com.kingdee.eas.fm.stock.client.DailySettleUI;
import com.kingdee.eas.fm.stock.client.StockVCFilterParam;
import com.kingdee.eas.fm.stock.client.StockVCFilterUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StockVcCheckUI
extends AbstractStockVcCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(StockVcCheckUI.class);
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private StockVCFilterUI filterUI;
    private StockVCFilterParam param;
    Set bankIdSet;
    Date dateTo;
    CurrencyInfo currency;
    Set accountBankIdSet;
    String sqlHolderStatement = "";
    String sqlBankStatement = "";

    public StockVcCheckUI() throws Exception {
        if (!this.companyInfo.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        StringBuffer sbBankStatement = new StringBuffer();
        sbBankStatement.append("SELECT BANKACCOUNT.FName_l2 AS ACCOUNTNAME, BANKACCOUNT.FNumber AS BANKACCOUNTNUMBER, \n");
        sbBankStatement.append("FUNDSETTLEBILL.FBankAccountID AS BANKACCOUNTID, ISNULL(FUNDSETTLEBILL.FFundBalance, 0) AS FUNDBALANCE, \n");
        sbBankStatement.append("FUNDSETTLEBILL.FCurrencyID AS CURRENCYID, FUNDSETTLEBILL.FCompanyID AS COMPANYID, \n");
        sbBankStatement.append("FUNDSETTLEBILL.FStockJobberID AS STOCKJOBBERID, ISNULL(SUMVCHOLDERQUERY.SUMAMOUNT, 0) AS DepStockAmt, \n");
        sbBankStatement.append("ISNULL(SUMVCHOLDERQUERY.NEWMARTKET, 0) AS NEWMARTKET, ISNULL(SUMVCHOLDERQUERY.FLOATAMOUNT, 0) AS FLOATAMOUNT, \n");
        sbBankStatement.append("(ISNULL(SUMVCHOLDERQUERY.SUMAMOUNT, 0) + ISNULL(FUNDSETTLEBILL.FFundBalance, 0)) AS FUNDAMOUNT, \n");
        sbBankStatement.append("(ISNULL(FUNDSETTLEBILL.FFundBalance, 0) + ISNULL(SUMVCHOLDERQUERY.NEWMARTKET, 0)) AS FUNDMARKET \n");
        sbBankStatement.append("FROM T_SK_FundSettleBill FUNDSETTLEBILL \n");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_AccountBanks BANKACCOUNT ON FUNDSETTLEBILL.FBankAccountID = BANKACCOUNT.FID \n");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_Bank STOCKJOBBER ON FUNDSETTLEBILL.FStockJobberID = STOCKJOBBER.FID \n");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_Currency CURRENCY ON FUNDSETTLEBILL.FCurrencyID = CURRENCY.FID \n");
        sbBankStatement.append("LEFT OUTER JOIN T_ORG_Company COMPANY ON FUNDSETTLEBILL.FCompanyID = COMPANY.FID \n");
        sbBankStatement.append("LEFT OUTER JOIN  (SELECT sum(STOCKSETTLEBILL.FSumamount) AS SUMAMOUNT, \n");
        sbBankStatement.append("sum(STOCKSETTLEBILL.FSumnum * ISNULL(CUREPRICE.LASTPRICE, 0)) AS NEWMARTKET, \n");
        sbBankStatement.append("sum(STOCKSETTLEBILL.FSumnum * (ISNULL(CUREPRICE.LASTPRICE, 0) - STOCKSETTLEBILL.FCostprice)) AS FLOATAMOUNT, \n");
        sbBankStatement.append("STOCKSETTLEBILL.FExchangedate AS EXCHANGEDATE, STOCKSETTLEBILL.FCurrencyID AS CURRENCYID, \n");
        sbBankStatement.append("CURRENCY.FName_l2 AS CURRENCYNAME, STOCKSETTLEBILL.FBankAccountID AS BANKACCOUNTID \n");
        sbBankStatement.append("FROM T_SK_StockSettleBill STOCKSETTLEBILL \n");
        sbBankStatement.append("\tLEFT OUTER JOIN T_SK_Stock STOCK ON STOCKSETTLEBILL.FStockID = STOCK.FID \n");
        sbBankStatement.append("\tLEFT OUTER JOIN T_BD_Currency CURRENCY ON STOCKSETTLEBILL.FCurrencyID = CURRENCY.FID \n");
        sbBankStatement.append("\tLEFT OUTER JOIN T_SK_Stockholder STOCKHOLDER ON STOCKSETTLEBILL.FStockholderID = STOCKHOLDER.FID \n");
        sbBankStatement.append("\tLEFT OUTER JOIN T_BD_AccountBanks BANKACCOUNT ON STOCKSETTLEBILL.FBankAccountID = BANKACCOUNT.FID \n");
        sbBankStatement.append("\tLEFT OUTER JOIN T_BD_Bank STOCKJOBBER ON STOCKSETTLEBILL.FStockjobberID = STOCKJOBBER.FID \n");
        sbBankStatement.append("\tLEFT OUTER JOIN T_ORG_Company COMPANY ON STOCKSETTLEBILL.FCompanyID = COMPANY.FID \n");
        sbBankStatement.append("\tLEFT OUTER JOIN (SELECT MARKETCAP.FClosePrice AS LASTPRICE, DATEQUERY.ID AS STOCKID \n");
        sbBankStatement.append("\tFROM T_SK_MarketCap MARKETCAP \n");
        sbBankStatement.append("\t\tINNER JOIN \n");
        sbBankStatement.append("\t\t\t(SELECT max(MARKETCAP.FCurDate) AS MARKETCAP_CURDATE, STOCK.FID AS ID \n");
        sbBankStatement.append("\t\t\t\tFROM T_SK_Stock STOCK \n");
        sbBankStatement.append("\t\t\t\t\tINNER JOIN T_SK_MarketCap AS MARKETCAP ON STOCK.FID = MARKETCAP.FStockID \n");
        sbBankStatement.append("\t\t\t\tGROUP BY STOCK.FID) DATEQUERY \n");
        sbBankStatement.append("ON (MARKETCAP.FCurDate = DATEQUERY.MARKETCAP_CURDATE AND MARKETCAP.FStockID = DATEQUERY.ID)) CUREPRICE ");
        sbBankStatement.append("ON STOCKSETTLEBILL.FStockID = CUREPRICE.STOCKID GROUP BY STOCKSETTLEBILL.FExchangedate,STOCKSETTLEBILL.FCurrencyID , \n");
        sbBankStatement.append("CURRENCY.FName_l2 , STOCKSETTLEBILL.FBankAccountID) SUMVCHOLDERQUERY ON ((FUNDSETTLEBILL.FBankAccountID = SUMVCHOLDERQUERY.BANKACCOUNTID \n");
        sbBankStatement.append("AND FUNDSETTLEBILL.FCurrencyID = SUMVCHOLDERQUERY.CURRENCYID) AND FUNDSETTLEBILL.FExchagedate = SUMVCHOLDERQUERY.EXCHANGEDATE) WHERE 1=1 \n");
        this.sqlBankStatement = sbBankStatement.toString();
        StringBuffer sbHolderStatement = new StringBuffer();
        sbHolderStatement.append("SELECT STOCKHOLDER.FHolderNumber AS HOLDERNUMBER, STOCK.FSimpleName AS STOCKSIMPLENAME, \n");
        sbHolderStatement.append("STOCK.FNumber AS STOCKNUMBER, STOCK.FName_l2 AS STOCKNAME, STOCKSETTLEBILL.FSumnum AS SUMNUM, \n");
        sbHolderStatement.append("STOCKSETTLEBILL.FCostprice AS COSTPRICE, STOCKSETTLEBILL.FSumamount AS SUMAMOUNT, \n");
        sbHolderStatement.append("ISNULL(CUREPRICE.LASTPRICE, 0) AS CUREPRICE, (STOCKSETTLEBILL.FSumnum * ISNULL(CUREPRICE.LASTPRICE, 0)) AS NEWMARTKET, \n");
        sbHolderStatement.append("(STOCKSETTLEBILL.FSumnum * (ISNULL(CUREPRICE.LASTPRICE, 0) - STOCKSETTLEBILL.FCostprice)) AS FLOATAMOUNT, \n");
        sbHolderStatement.append("STOCKSETTLEBILL.FExchangedate AS EXCHANGEDATE, STOCKSETTLEBILL.FCurrencyID AS CURRENCYID, \n");
        sbHolderStatement.append("CURRENCY.FName_l2 AS CURRENCYNAME, STOCKSETTLEBILL.FCompanyID AS COMPANYID, \n");
        sbHolderStatement.append("STOCKSETTLEBILL.FBankAccountID AS BANKACCOUNTID FROM T_SK_StockSettleBill AS STOCKSETTLEBILL \n");
        sbHolderStatement.append("LEFT OUTER JOIN T_SK_Stock STOCK ON STOCKSETTLEBILL.FStockID = STOCK.FID \n");
        sbHolderStatement.append("LEFT OUTER JOIN T_BD_Currency  CURRENCY ON STOCKSETTLEBILL.FCurrencyID = CURRENCY.FID \n");
        sbHolderStatement.append("LEFT OUTER JOIN T_SK_Stockholder  STOCKHOLDER ON STOCKSETTLEBILL.FStockholderID = STOCKHOLDER.FID \n");
        sbHolderStatement.append("LEFT OUTER JOIN T_BD_AccountBanks  BANKACCOUNT ON STOCKSETTLEBILL.FBankAccountID = BANKACCOUNT.FID \n");
        sbHolderStatement.append("LEFT OUTER JOIN T_BD_Bank STOCKJOBBER ON STOCKSETTLEBILL.FStockjobberID = STOCKJOBBER.FID \n");
        sbHolderStatement.append("LEFT OUTER JOIN T_ORG_Company COMPANY ON STOCKSETTLEBILL.FCompanyID = COMPANY.FID \n");
        sbHolderStatement.append("LEFT OUTER JOIN (SELECT MARKETCAP.FClosePrice AS LASTPRICE, DATEQUERY.ID AS STOCKID FROM T_SK_MarketCap MARKETCAP \n");
        sbHolderStatement.append("INNER JOIN (SELECT max(MARKETCAP.FCurDate) AS MARKETCAPCURDATE, STOCK.FID AS ID FROM T_SK_Stock STOCK \n");
        sbHolderStatement.append("INNER JOIN T_SK_MarketCap MARKETCAP ON STOCK.FID = MARKETCAP.FStockID GROUP BY STOCK.FID)  DATEQUERY \n");
        sbHolderStatement.append("ON (MARKETCAP.FCurDate = DATEQUERY.MARKETCAPCURDATE AND MARKETCAP.FStockID = DATEQUERY.ID))  CUREPRICE \n");
        sbHolderStatement.append("ON STOCKSETTLEBILL.FStockID = CUREPRICE.STOCKID WHERE 1=1 \n");
        this.sqlHolderStatement = sbHolderStatement.toString();
    }

    public void onLoad() throws Exception {
        this.tblFund.checkParsed();
        this.tblStockHolder.checkParsed();
        super.onLoad();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.tblFund.requestFocus();
        this.tblFund.setColumnMoveable(true);
        this.tblFund.getSelectManager().setSelectMode(2);
        this.tblFund.getStyleAttributes().setLocked(true);
        this.tblStockHolder.setColumnMoveable(true);
        this.tblStockHolder.getSelectManager().setSelectMode(2);
        this.tblStockHolder.getStyleAttributes().setLocked(true);
        FMClientHelper.setTableAutoSorter((KDTable)this.tblStockHolder);
        FMClientHelper.setTableAutoSorter((KDTable)this.tblFund);
        this.splitVC.setOrientation(0);
        this.splitVC.setDividerLocation((this.getHeight() - 60) / 3);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    private IRowSet getRowsetBySQL(StringBuffer sb, boolean isBank) {
        IRowSet rs = null;
        String sql = isBank ? sb.toString() + this.getFilterToAccount() : sb.toString() + this.getFilterToHolder();
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            rs = sqlExe.executeSQL();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        return rs;
    }

    private StringBuffer getFundSettleSql() {
        Date endDate = this.param.getDateTo();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT BANKACCOUNT.FName_l2 AS ACCOUNTNAME, BANKACCOUNT.FNumber AS BANKACCOUNTNUMBER, \n");
        sb.append("FUNDSETTLEBILL.FBankAccountID AS BANKACCOUNTID, ISNULL(FUNDSETTLEBILL.FFundBalance, 0) AS FUNDBALANCE, \n");
        sb.append("FUNDSETTLEBILL.FCurrencyID AS CURRENCYID, FUNDSETTLEBILL.FCompanyID AS COMPANYID, \n");
        sb.append("FUNDSETTLEBILL.FStockJobberID AS STOCKJOBBERID, ISNULL(SUMVCHOLDERQUERY.SUMAMOUNT, 0) AS DepStockAmt, \n");
        sb.append("ISNULL(SUMVCHOLDERQUERY.NEWMARTKET, 0) AS NEWMARTKET, ISNULL(SUMVCHOLDERQUERY.FLOATAMOUNT, 0) AS FLOATAMOUNT, \n");
        sb.append("(ISNULL(SUMVCHOLDERQUERY.SUMAMOUNT, 0) + ISNULL(FUNDSETTLEBILL.FFundBalance, 0)) AS FUNDAMOUNT, \n");
        sb.append("(ISNULL(FUNDSETTLEBILL.FFundBalance, 0) + ISNULL(SUMVCHOLDERQUERY.NEWMARTKET, 0)) AS FUNDMARKET \n");
        sb.append("FROM T_SK_FundSettleBill FUNDSETTLEBILL \n");
        sb.append("LEFT OUTER JOIN T_BD_AccountBanks BANKACCOUNT ON FUNDSETTLEBILL.FBankAccountID = BANKACCOUNT.FID \n");
        sb.append("LEFT OUTER JOIN T_BD_Bank STOCKJOBBER ON FUNDSETTLEBILL.FStockJobberID = STOCKJOBBER.FID \n");
        sb.append("LEFT OUTER JOIN T_BD_Currency CURRENCY ON FUNDSETTLEBILL.FCurrencyID = CURRENCY.FID \n");
        sb.append("LEFT OUTER JOIN T_ORG_Company COMPANY ON FUNDSETTLEBILL.FCompanyID = COMPANY.FID \n");
        sb.append("LEFT OUTER JOIN  (SELECT sum(ISNULL(STOCKSETTLEBILL.FCostprice, 0)*ISNULL(STOCKSETTLEBILL.FSumnum, 0)) AS SUMAMOUNT, \n");
        sb.append("sum(STOCKSETTLEBILL.FSumnum * ISNULL(CUREPRICE.LASTPRICE, 0)) AS NEWMARTKET, \n");
        sb.append("sum(STOCKSETTLEBILL.FSumnum * (ISNULL(CUREPRICE.LASTPRICE, 0) - STOCKSETTLEBILL.FCostprice)) AS FLOATAMOUNT, \n");
        sb.append("STOCKSETTLEBILL.FExchangedate AS EXCHANGEDATE, STOCKSETTLEBILL.FCurrencyID AS CURRENCYID, \n");
        sb.append("CURRENCY.FName_l2 AS CURRENCYNAME, STOCKSETTLEBILL.FBankAccountID AS BANKACCOUNTID \n");
        sb.append("FROM T_SK_StockSettleBill STOCKSETTLEBILL \n");
        sb.append("\tLEFT OUTER JOIN T_SK_Stock STOCK ON STOCKSETTLEBILL.FStockID = STOCK.FID \n");
        sb.append("\tLEFT OUTER JOIN T_BD_Currency CURRENCY ON STOCKSETTLEBILL.FCurrencyID = CURRENCY.FID \n");
        sb.append("\tLEFT OUTER JOIN T_SK_Stockholder STOCKHOLDER ON STOCKSETTLEBILL.FStockholderID = STOCKHOLDER.FID \n");
        sb.append("\tLEFT OUTER JOIN T_BD_AccountBanks BANKACCOUNT ON STOCKSETTLEBILL.FBankAccountID = BANKACCOUNT.FID \n");
        sb.append("\tLEFT OUTER JOIN T_BD_Bank STOCKJOBBER ON STOCKSETTLEBILL.FStockjobberID = STOCKJOBBER.FID \n");
        sb.append("\tLEFT OUTER JOIN T_ORG_Company COMPANY ON STOCKSETTLEBILL.FCompanyID = COMPANY.FID \n");
        sb.append("\tLEFT OUTER JOIN (");
        sb.append(this.getLastPriceSql(endDate));
        sb.append("\t) CUREPRICE ");
        sb.append("ON STOCKSETTLEBILL.FStockID = CUREPRICE.STOCKID GROUP BY STOCKSETTLEBILL.FExchangedate,STOCKSETTLEBILL.FCurrencyID , \n");
        sb.append("CURRENCY.FName_l2 , STOCKSETTLEBILL.FBankAccountID) SUMVCHOLDERQUERY ON ((FUNDSETTLEBILL.FBankAccountID = SUMVCHOLDERQUERY.BANKACCOUNTID \n");
        sb.append("AND FUNDSETTLEBILL.FCurrencyID = SUMVCHOLDERQUERY.CURRENCYID) AND FUNDSETTLEBILL.FExchagedate = SUMVCHOLDERQUERY.EXCHANGEDATE) WHERE 1=1 \n");
        return sb;
    }

    private StringBuffer getLastPriceSql(Date endDate) {
        StringBuffer lastDateSb = new StringBuffer();
        lastDateSb.append("SELECT  MAX (MARKETCAP.fcurdate) AS marketcap_curdate, \n").append("         stock.FID AS ID \n").append("     FROM T_SK_Stock stock INNER JOIN T_SK_MarketCap marketCap \n").append("         ON stock.fid = MARKETCAP.fstockid \n").append("\tWHERE MARKETCAP.fcurdate <= {").append(Constants.FORMAT_TIME.format(endDate)).append("        } GROUP BY stock.fid \n");
        StringBuffer lastPriceSb = new StringBuffer();
        lastPriceSb.append("SELECT marketCap.FClosePrice AS lastPrice, datequery.ID AS stockId \n").append("  FROM T_SK_MarketCap marketCap \n").append("       INNER JOIN \n").append("       (").append(lastDateSb).append("\t\t) dateQuery \n").append("       ON (marketCap.fcurdate = dateQuery.marketcap_curdate \n").append("           AND MarketCap.fstockid = dateQuery.ID \n").append("          ) \n");
        return lastPriceSb;
    }

    private StringBuffer getStockSettleSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT STOCKHOLDER.FHolderNumber AS HOLDERNUMBER, STOCK.FSimpleName AS STOCKSIMPLENAME, \n");
        sb.append("STOCK.FNumber AS STOCKNUMBER,STOCK.FIssuPrice AS STOCKISSUPRICE, STOCK.FName_l2 AS STOCKNAME, STOCKSETTLEBILL.FSumnum AS SUMNUM, \n");
        sb.append("STOCKSETTLEBILL.FCostprice AS COSTPRICE, ISNULL(STOCKSETTLEBILL.FCostprice, 0)*ISNULL(STOCKSETTLEBILL.FSumnum, 0) AS SUMAMOUNT, \n");
        sb.append("ISNULL(CUREPRICE.LASTPRICE, 0) AS CUREPRICE, (STOCKSETTLEBILL.FSumnum * ISNULL(CUREPRICE.LASTPRICE, 0)) AS NEWMARTKET, \n");
        sb.append("(STOCKSETTLEBILL.FSumnum * (ISNULL(CUREPRICE.LASTPRICE, 0) - STOCKSETTLEBILL.FCostprice)) AS FLOATAMOUNT, \n");
        sb.append("STOCKSETTLEBILL.FExchangedate AS EXCHANGEDATE, STOCKSETTLEBILL.FCurrencyID AS CURRENCYID, \n");
        sb.append("CURRENCY.FName_l2 AS CURRENCYNAME, STOCKSETTLEBILL.FCompanyID AS COMPANYID, \n");
        sb.append("STOCKSETTLEBILL.FBankAccountID AS BANKACCOUNTID FROM T_SK_StockSettleBill AS STOCKSETTLEBILL \n");
        sb.append("LEFT OUTER JOIN T_SK_Stock STOCK ON STOCKSETTLEBILL.FStockID = STOCK.FID \n");
        sb.append("LEFT OUTER JOIN T_BD_Currency  CURRENCY ON STOCKSETTLEBILL.FCurrencyID = CURRENCY.FID \n");
        sb.append("LEFT OUTER JOIN T_SK_Stockholder  STOCKHOLDER ON STOCKSETTLEBILL.FStockholderID = STOCKHOLDER.FID \n");
        sb.append("LEFT OUTER JOIN T_BD_AccountBanks  BANKACCOUNT ON STOCKSETTLEBILL.FBankAccountID = BANKACCOUNT.FID \n");
        sb.append("LEFT OUTER JOIN T_BD_Bank STOCKJOBBER ON STOCKSETTLEBILL.FStockjobberID = STOCKJOBBER.FID \n");
        sb.append("LEFT OUTER JOIN T_ORG_Company COMPANY ON STOCKSETTLEBILL.FCompanyID = COMPANY.FID \n");
        sb.append("LEFT OUTER JOIN (");
        sb.append(this.getLastPriceSql(this.dateTo));
        sb.append(")  CUREPRICE \n");
        sb.append("ON STOCKSETTLEBILL.FStockID = CUREPRICE.STOCKID WHERE 1=1 \n");
        return sb;
    }

    private String getFilterToHolder() {
        StringBuffer sb = new StringBuffer();
        sb.append(" and STOCKSETTLEBILL.FCompanyID ='").append(this.companyInfo.getId().toString()).append("'");
        if (this.accountBankIdSet != null && this.accountBankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" STOCKSETTLEBILL.FBankAccountID ", (Object[])this.accountBankIdSet.toArray()));
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" STOCKSETTLEBILL.FStockjobberID ", (Object[])this.bankIdSet.toArray()));
        }
        if (this.dateTo != null) {
            sb.append(" and STOCKSETTLEBILL.FExchangedate= (SELECT max(FExchangeDate) FROM T_SK_StockSettleBill WHERE FExchangedate<={ ").append(Constants.FORMAT_TIME.format(this.dateTo)).append("})");
        }
        if (this.currency != null) {
            sb.append(" and STOCKSETTLEBILL.FCurrencyID ='").append(this.currency.getId().toString()).append("'");
        }
        sb.append(" and STOCKSETTLEBILL.FSumnum<>0");
        return sb.toString();
    }

    private String getFilterToAccount() {
        StringBuffer sb = new StringBuffer();
        sb.append(" and FUNDSETTLEBILL.FCompanyID ='").append(this.companyInfo.getId().toString()).append("'");
        if (this.accountBankIdSet != null && this.accountBankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" FUNDSETTLEBILL.FBankAccountID ", (Object[])this.accountBankIdSet.toArray()));
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sb.append(" and ").append(FMHelper.buildIn((String)" FUNDSETTLEBILL.FStockJobberID ", (Object[])this.bankIdSet.toArray()));
        }
        if (this.dateTo != null) {
            sb.append(" and FUNDSETTLEBILL.FExchagedate= (SELECT max(FExchagedate) FROM T_SK_FundSettleBill WHERE FExchagedate<={ ").append(Constants.FORMAT_TIME.format(this.dateTo)).append("})");
        }
        if (this.currency != null) {
            sb.append(" and FUNDSETTLEBILL.FCurrencyID ='").append(this.currency.getId().toString()).append("'");
        }
        return sb.toString();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contFund.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 408, 200));
        this.contFund.getContentPane().add((Component)this.tblFund, new KDLayout.Constraints(0, 0, 408, 200, 31));
        this.contStockHolder.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 405, 600));
        this.contStockHolder.getContentPane().add((Component)this.tblStockHolder, new KDLayout.Constraints(0, 0, 405, 600, 31));
    }

    public void fillFundTable(IRowSet rs) throws SQLException {
        this.tblFund.removeRows();
        while (rs.next()) {
            IRow row = this.tblFund.addRow();
            row.getCell("Account").setValue((Object)rs.getString("ACCOUNTNAME"));
            row.getCell("Balance").setValue((Object)rs.getBigDecimal("FUNDBALANCE"));
            row.getCell("DepStockAmt").setValue((Object)rs.getBigDecimal("DepStockAmt"));
            row.getCell("Amount").setValue((Object)rs.getBigDecimal("FUNDAMOUNT"));
            row.getCell("DepMarketAmt").setValue((Object)rs.getBigDecimal("NEWMARTKET"));
            row.getCell("MarketAmt").setValue((Object)rs.getBigDecimal("FUNDMARKET"));
            row.getCell("Float").setValue((Object)rs.getBigDecimal("FLOATAMOUNT"));
        }
        String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)this.param.getCurrency().getId());
        String[] stockColumns = new String[]{"Balance", "DepStockAmt", "Amount", "MarketAmt", "Float", "DepMarketAmt"};
        int len = stockColumns.length;
        for (int i = 0; i < len; ++i) {
            this.tblFund.getColumn(stockColumns[i]).getStyleAttributes().setNumberFormat(numberFmt);
        }
    }

    public void fillHolderTable(IRowSet rs) throws SQLException {
        this.tblStockHolder.removeRows();
        while (rs.next()) {
            IRow row = this.tblStockHolder.addRow();
            row.getCell("HolderNumber").setValue((Object)rs.getString("HOLDERNUMBER"));
            row.getCell("StockNumber").setValue((Object)rs.getString("STOCKNUMBER"));
            row.getCell("StockName").setValue((Object)rs.getString("STOCKNAME"));
            row.getCell("StockNum").setValue((Object)rs.getBigDecimal("SUMNUM"));
            row.getCell("CostPrice").setValue((Object)rs.getBigDecimal("COSTPRICE"));
            row.getCell("Amount").setValue((Object)rs.getBigDecimal("SUMAMOUNT"));
            row.getCell("Float").setValue((Object)rs.getBigDecimal("FLOATAMOUNT"));
            this.setCurPriceAndMarketAmt(row, rs);
            BigDecimal isSuprice = rs.getBigDecimal("STOCKISSUPRICE");
            if (isSuprice == null || isSuprice.compareTo(SysConstant.BIGZERO) == 0) {
                row.getCell("UpExtent").setValue((Object)"--%");
                continue;
            }
            row.getCell("UpExtent").setValue((Object)rs.getBigDecimal("CUREPRICE").subtract(isSuprice).divide(isSuprice, 10, 4));
        }
        this.tblStockHolder.getColumn("UpExtent").getStyleAttributes().setNumberFormat("0.00%");
        String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)this.param.getCurrency().getId());
        String[] fundColumns = new String[]{"Amount", "CurPrice", "MarketAmt", "Float", "StockNum"};
        int len = fundColumns.length;
        for (int i = 0; i < len; ++i) {
            this.tblStockHolder.getColumn(fundColumns[i]).getStyleAttributes().setNumberFormat(numberFmt);
        }
        this.tblStockHolder.getColumn("CostPrice").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)3));
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? SysConstant.BIGZERO : big;
    }

    private void setCurPriceAndMarketAmt(IRow row, IRowSet rs) throws SQLException {
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("stock.number", (Object)rs.getString("STOCKNUMBER"), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("curDate", (Object)this.param.getDateTo(), CompareType.LESS_EQUALS));
            ev.setFilter(filter);
            ev.getSorter().clear();
            SorterItemInfo curDate = new SorterItemInfo("curDate");
            curDate.setSortType(SortType.DESCEND);
            ev.getSorter().add(curDate);
            CoreBaseCollection coreBaseCollection = MarketCapFactory.getRemoteInstance().getCollection(ev);
            if (coreBaseCollection == null || coreBaseCollection.size() <= 0) {
                row.getCell("CurPrice").setValue((Object)rs.getBigDecimal("CUREPRICE"));
                row.getCell("MarketAmt").setValue((Object)rs.getBigDecimal("NEWMARTKET"));
                return;
            }
            MarketCapInfo marketCapInfo = (MarketCapInfo)coreBaseCollection.get(0);
            row.getCell("CurPrice").setValue((Object)marketCapInfo.getClosePrice());
            row.getCell("MarketAmt").setValue((Object)rs.getBigDecimal("SUMNUM").multiply(marketCapInfo.getClosePrice()));
        }
        catch (BOSException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected void execQuery() throws BOSException {
        this.param = (StockVCFilterParam)this.getFilterParam();
        this.bankIdSet = this.param.getBankIdSet();
        this.dateTo = this.param.getDateTo();
        this.currency = this.param.getCurrency();
        this.accountBankIdSet = this.param.getAccountBankIdSet();
        this.txtPeriod.setText(Constants.FORMAT_DAY.format(this.dateTo));
        this.cboCurrency.setText(this.currency.getName());
        try {
            this.checkHasSettle(this.param.getDateTo());
        }
        catch (StockException e1) {
            this.handUIException((Throwable)((Object)e1));
        }
        try {
            IRowSet fundRs = this.getRowsetBySQL(this.getFundSettleSql(), true);
            IRowSet stockHolderRs = this.getRowsetBySQL(this.getStockSettleSql(), false);
            fundRs.beforeFirst();
            stockHolderRs.beforeFirst();
            this.fillFundTable(fundRs);
            this.fillHolderTable(stockHolderRs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void checkHasSettle(Date endDate) throws BOSException, StockException {
        Date settleDate = StockHelper.getSettleDate(null, this.companyInfo.getId().toString());
        if (!settleDate.after(endDate)) {
            DateFormat df = DateFormat.getDateInstance(1);
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"12_StockVcCheckUI") + df.format(endDate) + EASResource.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"13_StockVcCheckUI");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)msg);
            if (result == 0) {
                String uiName = DailySettleUI.class.getName();
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"endDate", (Object)endDate);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiCtx, null, OprtState.VIEW);
                uiWindow.show();
            } else if (result == 2) {
                SysUtil.abort();
            } else if (result == 1) {
                try {
                    this.dateTo = DateUtil.getBeforeDay((Date)this.getDailySettledDate(this.companyInfo.getId().toString()));
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new StockVCFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblFund;
    }

    public Date getDailySettledDate(String companyId) throws BOSException, SQLException, StockException {
        Date initday = new Date();
        String sql = " select FsettleDate  from T_SK_SettleDate where  FCurCompanyID='" + companyId + "' and FIsinit=0 ";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (!rs.next()) {
            throw new StockException(StockException.INIT_EXC1);
        }
        initday = rs.getDate("FsettleDate");
        return initday;
    }
}

