/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.stock.ExchagePlanceEnum;
import com.kingdee.eas.fm.stock.StockTypeEnum;
import com.kingdee.eas.fm.stock.StockholderFactory;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.fm.stock.client.AbstractStockholderEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.UuidException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class StockholderEditUI
extends AbstractStockholderEditUI {
    private static final Logger logger = CoreUIObject.getLogger(StockholderEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.CombCurrency);
        super.onLoad();
        this.txtpRate.setHorizontalAlignment(4);
        this.txtlowestPrate.setHorizontalAlignment(4);
        this.txtlowestPrate.setPrecision(2);
        this.txtstampTaxRate.setPrecision(2);
        this.txtstampTaxRate.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtlowestAssignPay);
        this.txtlowestAssignPay.setPrecision(2);
        this.txtassignPayRate.setHorizontalAlignment(4);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.initF7Filter();
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtstockJobber, null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    protected void CombCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.CombCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.CombCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
    }

    @Override
    protected void exchagePlaceEnu_itemStateChanged(ItemEvent e) throws Exception {
        super.exchagePlaceEnu_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        this.stockTypeEnum.removeAllItems();
        if (this.exchagePlaceEnu.getSelectedItem().equals((Object)ExchagePlanceEnum.SHANGHAI) || this.exchagePlaceEnu.getSelectedItem().equals((Object)ExchagePlanceEnum.SHENZHEN)) {
            this.stockTypeEnum.addItem((Object)StockTypeEnum.A);
            this.stockTypeEnum.addItem((Object)StockTypeEnum.B);
        } else if (this.exchagePlaceEnu.getSelectedItem().equals((Object)ExchagePlanceEnum.HONGKONG)) {
            this.stockTypeEnum.addItem((Object)StockTypeEnum.H);
        } else if (this.exchagePlaceEnu.getSelectedItem().equals((Object)ExchagePlanceEnum.NEWYORK)) {
            this.stockTypeEnum.addItem((Object)StockTypeEnum.N);
        } else if (this.exchagePlaceEnu.getSelectedItem().equals((Object)ExchagePlanceEnum.SINGAPORE)) {
            this.stockTypeEnum.addItem((Object)StockTypeEnum.S);
        }
    }

    @Override
    protected void prmtstockJobber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstockJobber_dataChanged(e);
        if (this.prmtstockJobber.getData() != null) {
            this.prmtbankAccount.setValue(null);
        }
    }

    @Override
    protected void prmtbankAccount_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        if (this.prmtstockJobber.getData() != null) {
            BankInfo bank = (BankInfo)this.prmtstockJobber.getData();
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bank.getId().toString()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtbankAccount.setEntityViewInfo(evi);
        this.prmtbankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtsettleAccount_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtsettleAccount.setEntityViewInfo(evi);
        this.prmtsettleAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtstockAccount_willShow(SelectorEvent e) throws Exception {
        if (this.CombCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.CombCurrency.getSelectedItem();
        this.setOppAcctEvi(info);
    }

    @Override
    protected void prmtstockAccount_willCommit(CommitEvent e) throws Exception {
        if (this.CombCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.CombCurrency.getSelectedItem();
        this.setOppAcctEvi(info);
    }

    private void setOppAcctEvi(CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        this.prmtstockAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        this.prmtstockAccount.setSelector((KDPromptSelector)opseelect);
        this.prmtstockAccount.setEntityViewInfo(evi);
    }

    @Override
    protected void prmtstockJobber_willShow(SelectorEvent e) throws Exception {
        super.prmtstockJobber_willShow(e);
    }

    @Override
    protected void exchagePlaceEnu_actionPerformed(ActionEvent e) throws Exception {
        super.exchagePlaceEnu_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.CombCurrency, (Object)this.editData.getCurrency());
        this.loadStockType();
        try {
            this.doCheck();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void loadStockType() {
        if (this.editData.getStockTypeEnum() != null) {
            this.stockTypeEnum.removeAllItems();
            if (this.editData.getStockTypeEnum().equals((Object)StockTypeEnum.A) || this.editData.getStockTypeEnum().equals((Object)StockTypeEnum.B)) {
                this.stockTypeEnum.addItem((Object)StockTypeEnum.A);
                this.stockTypeEnum.addItem((Object)StockTypeEnum.B);
            } else if (this.editData.getStockTypeEnum().equals((Object)StockTypeEnum.H)) {
                this.stockTypeEnum.addItem((Object)StockTypeEnum.H);
            } else if (this.editData.getStockTypeEnum().equals((Object)StockTypeEnum.N)) {
                this.stockTypeEnum.addItem((Object)StockTypeEnum.N);
            } else if (this.editData.getStockTypeEnum().equals((Object)StockTypeEnum.S)) {
                this.stockTypeEnum.addItem((Object)StockTypeEnum.S);
            }
            FMClientHelper.setSelectObject((KDComboBox)this.stockTypeEnum, (Object)((Object)this.editData.getStockTypeEnum()));
        }
    }

    public void doCheck() throws BOSException {
        IRefChecker checker = RefCheckerFactory.getRemoteInstance();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            try {
                if (checker.isReferenced(this.editData.getId())) {
                    this.txtNumber.setEnabled(false);
                    this.exchagePlaceEnu.setEnabled(false);
                    this.stockTypeEnum.setEnabled(false);
                    this.CombCurrency.setEnabled(false);
                    this.prmtstockJobber.setEnabled(false);
                    this.prmtbankAccount.setEnabled(false);
                }
            }
            catch (BizReferenceException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (UuidException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtpRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtlowestPrate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtstampTaxRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtassignPayRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.txtlowestAssignPay, (BigDecimal)Constants.ZERO);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        StockholderInfo objectValue = new StockholderInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCurrency(this.currentCompany == null ? null : this.currentCompany.getBaseCurrency());
        objectValue.setCurCompany(this.currentCompany);
        objectValue.setExchagePlaceEnu(ExchagePlanceEnum.SHANGHAI);
        objectValue.setStockTypeEnum(StockTypeEnum.A);
        objectValue.setPRate(Constants.ZERO);
        objectValue.setLowestPrate(new BigDecimal("5"));
        objectValue.setStampTaxRate(Constants.ZERO);
        objectValue.setAssignPayRate(Constants.ZERO);
        objectValue.setLowestAssignPay(new BigDecimal("1"));
        return objectValue;
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockholderFactory.getRemoteInstance();
    }
}

