/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.stock.StockTypeEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Set;

public class StockholderFilterParam
implements FilterParam {
    private static final long serialVersionUID = 7634970503271297643L;
    private String sStockType;
    private String currencyId;
    private Set companys;
    private String bankId;

    public Set getCompanys() {
        return this.companys;
    }

    public void setCompanys(Set companys) {
        this.companys = companys;
    }

    public BankInfo getBank() {
        if (this.bankId != null) {
            BankInfo info = null;
            try {
                info = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(this.bankId));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return info;
        }
        return null;
    }

    public void setBank(BankInfo bank) {
        this.bankId = bank == null ? null : bank.getId().toString();
    }

    public StockTypeEnum getStockType() {
        return StockTypeEnum.getEnum(this.sStockType);
    }

    public void setStockType(StockTypeEnum StockType) {
        this.sStockType = StockType == null ? null : StockType.getValue();
    }

    public CurrencyInfo getCurrency() {
        CurrencyInfo currencyInfo = null;
        if (this.currencyId == null || this.currencyId.length() == 0) {
            return null;
        }
        try {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currencyId));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        return currencyInfo;
    }

    public void setCurrency(CurrencyInfo currencyInfo) {
        this.currencyId = currencyInfo == null ? "" : currencyInfo.getId().toString();
    }

    public FilterInfo getFilter() {
        FilterInfo fi = new FilterInfo();
        this.addStockholderFilterItems(fi);
        return fi;
    }

    private void addStockholderFilterItems(FilterInfo fi) {
        CompanyOrgUnitInfo currencyCompany;
        if (null != this.getCurrency()) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrency().getId()));
        }
        if (null != this.getBank()) {
            fi.getFilterItems().add(new FilterItemInfo("stockjobber.id", (Object)this.getBank().getId()));
        }
        if (null != this.getStockType()) {
            fi.getFilterItems().add(new FilterItemInfo("stockTypeEnum", (Object)this.getStockType().getValue()));
        }
        if ((currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany()).isIsUnion()) {
            fi.getFilterItems().add(new FilterItemInfo("curcompany.id", (Object)this.getCompanys(), CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("curcompany.id", (Object)currencyCompany.getId().toString(), CompareType.INCLUDE));
        }
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection selectcollection = new SorterItemCollection();
        return selectcollection;
    }
}

