/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.stock.StockTypeEnum;
import com.kingdee.eas.fm.stock.client.AbstractStockholderFilterUI;
import com.kingdee.eas.fm.stock.client.StockholderFilterParam;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class StockholderFilterUI
extends AbstractStockholderFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(StockholderFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.initCurrency();
        this.initStockType();
        this.initF7Filter();
    }

    private void initF7Filter() throws BOSException {
        try {
            FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.f7StockJobber, null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboCurrency.setSelectedIndex(this.cboCurrency.getItemCount() - 1);
    }

    private void initStockType() {
        this.cboStockType.addItems(StockTypeEnum.getEnumList().toArray());
        this.cboStockType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboStockType.setSelectedItem((Object)StockTypeEnum.A);
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        Object obj;
        StockholderFilterParam param = new StockholderFilterParam();
        if (null != this.cboCurrency.getSelectedItem() && (obj = this.cboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            param.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        }
        if (null != this.cboStockType.getSelectedItem() && (obj = this.cboStockType.getSelectedItem()) instanceof StockTypeEnum) {
            param.setStockType((StockTypeEnum)((Object)this.cboStockType.getSelectedItem()));
        }
        if (null != this.f7StockJobber.getValue()) {
            param.setBank((BankInfo)this.f7StockJobber.getValue());
        }
        return param;
    }

    public void setParam(Object param) {
        if (null == param || !(param instanceof StockholderFilterParam)) {
            return;
        }
        StockholderFilterParam filterparam = (StockholderFilterParam)param;
        if (filterparam.getStockType() != null) {
            this.cboStockType.setSelectedItem((Object)filterparam.getStockType());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboStockType, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        if (filterparam.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterparam.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.f7StockJobber.setValue((Object)filterparam.getBank());
        this.setCompanyIdSet(filterparam.getCompanys());
    }

    public void clear() {
        super.clear();
        try {
            this.init();
            this.f7StockJobber.setValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected Class getParamClass() {
        return StockholderFilterParam.class;
    }
}

