/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositConstants;
import com.kingdee.eas.fm.td.client.AbstractIntReceiveDateChooseUI;
import com.kingdee.eas.fm.td.client.IntReceivedBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IntReceiveDateChooseUI
extends AbstractIntReceiveDateChooseUI {
    private static final Logger logger = CoreUIObject.getLogger(IntReceiveDateChooseUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private Set createdIntReceivedID;

    public void onLoad() throws Exception {
        this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get(TimeDepositConstants.CURRENT_COMPANY);
        super.onLoad();
        this.dtpDate.setSupportedEmpty(false);
        this.customed_init();
    }

    private void customed_init() {
        this.initPrmtDeposit(this.prmtDeposit);
        this.initCurrency(this.cboCurrency);
        this.initData(this.dtpDate);
    }

    private void initData(KDDatePicker dtpDate) {
        dtpDate.setValue((Object)new Date());
    }

    private void initPrmtDeposit(KDBizPromptBox prmtDeposit) {
        prmtDeposit.setEnabledMultiSelection(true);
    }

    private void initCurrency(KDComboBox cboCurrency) {
        CashHelper.initCombCurrency((KDComboBox)cboCurrency, (boolean)false);
        cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    public void prmtDeposit_willShow(SelectorEvent e) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtDeposit.setEntityViewInfo(evi);
        this.prmtDeposit.getQueryAgent().resetRuntimeEntityView();
    }

    private void setFilterItems(FilterInfo filter) {
        boolean cludeCurrency = false;
        filter.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dtpDate.getValue())), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("lastRecvIntDay", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dtpDate.getValue())), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("lastRecvIntDay", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2), CompareType.EQUALS));
        Object obj = this.cboCurrency.getSelectedItem();
        if (obj instanceof CurrencyInfo) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)obj).getId().toString(), CompareType.EQUALS));
            cludeCurrency = true;
        }
        if (!cludeCurrency) {
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5");
        } else {
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6");
        }
        logger.info((Object)"");
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Set ids = null;
        ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtDeposit));
        if (ids == null || ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"14_IntReceiveDateChooseUI"));
            SysUtil.abort();
        }
        this.createdIntReceivedID = IntReceivedBillFactory.getRemoteInstance().addBatch(ids, (Date)this.dtpDate.getValue());
        if (this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"noIntReceiveBillCreated"));
        }
        this.disposeUIWindow();
    }

    private Set convertIDSet(TimeDepositBillCollection col) {
        HashSet<String> idSets = new HashSet<String>();
        TimeDepositBillInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            idSets.add(info.getId().toString());
        }
        return idSets;
    }

    private EntityViewInfo getEntityView() {
        EntityViewInfo env = this.prmtDeposit.getEntityViewInfo();
        if (env == null) {
            env = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        env.setFilter(filter);
        return env;
    }

    @Override
    protected void prmtDeposit_focusLost(FocusEvent e) throws Exception {
        if (this.prmtDeposit.getData() == null) {
            this.prmtDeposit.setText(TimeDepositConstants.ALL_TIME_DEPOSIT);
        }
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
    }

    public Set getReturnValue() {
        return this.createdIntReceivedID;
    }

    public static Set showIntReceiveScopeChooseUI(IntReceivedBillListUI ui, CompanyOrgUnitInfo currentCompany) {
        Set returnValue = null;
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put(TimeDepositConstants.CURRENT_COMPANY, (Object)currentCompany);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntReceiveDateChooseUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((IntReceiveDateChooseUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }
}

