/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.client.AbstractRptTimeDepositDetailFilterUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptTimeDepositDetailFilterUI
extends AbstractRptTimeDepositDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositBalanceFilterUI.class);
    private CurrencyInfo baseCurrency;

    public RptTimeDepositDetailFilterUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    }

    protected void init() throws Exception {
        super.init();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
    }

    public void clear() {
        super.clear();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
        this.prmtBank.setValue(null);
    }

    private void customInit() {
        this.initCurrency();
        this.initDate();
        this.initBillType();
        this.initStatisticalUnit();
        this.intQueryType();
    }

    public boolean verify() {
        if (this.comboUnit.getSelectedItem() == null) {
            this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
        }
        this.checkAmtValid();
        return super.verify();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }

    private void checkAmtValid() {
        if (this.dpStartDate.getSqlDate().compareTo(this.dpEndDate.getSqlDate()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"24_RptTimeDepositDetailFilterUI"));
            SysUtil.abort();
        }
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboCurrency.setSelectedItem((Object)this.baseCurrency);
    }

    private void initDate() {
        Date now = DateUtil.getDayBegin();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private void initBillType() {
        this.cboType.removeAllItems();
        this.cboType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    private void initStatisticalUnit() {
        this.comboUnit.removeAllItems();
        this.comboUnit.addItems(StatisticalUnitEnum.getEnumList().toArray());
        this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
    }

    private void intQueryType() {
        this.rdByBank.setSelected(true);
    }

    public Object getParam() {
        RptTimeDepositDetailFilterParam filterParam = new RptTimeDepositDetailFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setStartDate(this.dpStartDate.getSqlDate());
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCurrencyIDs(this.getCurrencyParam());
        Object obj = this.cboType.getSelectedItem();
        if (obj instanceof TimeDepositTypeEnum) {
            filterParam.setTimeDepositType((TimeDepositTypeEnum)obj);
        } else {
            filterParam.setTimeDepositType(null);
        }
        filterParam.setBankIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBank));
        filterParam.setStatisticalUnit((StatisticalUnitEnum)((Object)this.comboUnit.getSelectedItem()));
        if (this.rdByBank.isSelected()) {
            filterParam.setQueryType("By_Bank");
        } else if (this.rdByCompany.isSelected()) {
            filterParam.setQueryType("By_Company");
        } else if (this.rdByCurrency.isSelected()) {
            filterParam.setQueryType("By_Currency");
        }
        return filterParam;
    }

    private String[] getCurrencyParam() {
        String[] currencyIds = null;
        Object currencySelected = this.comboCurrency.getSelectedItem();
        if (currencySelected instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            currencyIds = new String[]{info.getId().toString()};
        } else {
            currencyIds = null;
        }
        return currencyIds;
    }

    protected Class getParamClass() {
        return RptTimeDepositDetailFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        RptTimeDepositDetailFilterParam filterParam = (RptTimeDepositDetailFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        try {
            if (filterParam.getCurrencyIDs() != null && filterParam.getCurrencyIDs().length > 0) {
                String selectedId = filterParam.getCurrencyIDs()[0];
                this.comboCurrency.setSelectedItem((Object)this.getSelectCurrency(selectedId));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
            this.prmtBank.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getBankIDs())));
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        if (filterParam.getTimeDepositType() != null) {
            this.cboType.setSelectedItem((Object)filterParam.getTimeDepositType());
        } else {
            this.cboType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboUnit.setSelectedItem((Object)filterParam.getStatisticalUnit());
        if ("By_Bank".equals(filterParam.getQueryType())) {
            this.rdByBank.setSelected(true);
        } else if ("By_Company".equals(filterParam.getQueryType())) {
            this.rdByCompany.setSelected(true);
        } else if ("By_Currency".equals(filterParam.getQueryType())) {
            this.rdByCurrency.setSelected(true);
        }
    }

    private CurrencyInfo getSelectCurrency(String currencyId) {
        if (currencyId == null || currencyId.length() == 0) {
            return null;
        }
        CurrencyInfo selectedInfo = null;
        try {
            selectedInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        return selectedInfo;
    }
}

