/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.td.RptTimeDepositConstants;
import com.kingdee.eas.fm.td.client.AbstractRptTimeDepositDetailMainUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailByBankHandler;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailByComoanyHandler;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailByCurrencyHandler;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailFilterUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositHandlerAdapter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.text.DateFormat;
import org.apache.log4j.Logger;

public class RptTimeDepositDetailMainUI
extends AbstractRptTimeDepositDetailMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositDetailMainUI.class);
    private FMFilterBaseUI filterUI;

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtScope.setEnabled(false);
        this.txtUnit.setEnabled(false);
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptTimeDepositDetailFilterUI();
        }
        return this.filterUI;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.setColumnMoveable(false);
        RptTimeDepositDetailFilterParam filterParam = (RptTimeDepositDetailFilterParam)this.getFilterParam();
        this.showHead(filterParam);
        int groupType = filterParam.getType();
        IFMDetailRptHandler handler = this.getBizHander(filterParam, groupType);
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
    }

    private IFMDetailRptHandler getBizHander(RptTimeDepositDetailFilterParam filterParam, int groupType) {
        RptTimeDepositHandlerAdapter handler = null;
        switch (groupType) {
            case 0: {
                handler = new RptTimeDepositDetailByBankHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 1: {
                handler = new RptTimeDepositDetailByComoanyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 2: {
                handler = new RptTimeDepositDetailByCurrencyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            default: {
                handler = new RptTimeDepositDetailByBankHandler(this.tblMain, filterParam.getFilter(), filterParam);
            }
        }
        return handler;
    }

    private void showHead(RptTimeDepositDetailFilterParam filterParam) {
        this.txtScope.setText(this.getScopeText(filterParam.getStartDate(), filterParam.getEndDate()));
        this.txtUnit.setText(filterParam.getStatisticalUnit().getAlias());
    }

    private String getScopeText(Date startDate, Date endDate) {
        StringBuffer sb = new StringBuffer();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (startDate != null && endDate != null) {
            java.util.Date date = new java.util.Date(startDate.getTime());
            sb.append(dtformat.format(date));
            sb.append(RptTimeDepositConstants.TO_TEXT);
            date = new java.util.Date(endDate.getTime());
            sb.append(dtformat.format(date));
        }
        return sb.toString();
    }
}

