/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositFilterParamAdapter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RptTimeDepositHandlerAdapter
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static final String TDSOURCE_PATH = "com.kingdee.eas.fm.td.TimeDeposittResource";
    private static final String RptTimeDepositBalanceFilterParam = null;
    private RptTimeDepositFilterParamAdapter params;
    private CompanyOrgUnitInfo currentCompany;
    private int queryType;
    private String orderByColumn = "fbankid";
    private Date endDate;
    private StatisticalUnitEnum amountUnit;
    private String[] currencyIDs;
    private String[] bankIDS;
    private String unit;
    private int precisionLocalCurrency = 2;
    private CurrencyInfo rateCurrencyInfo;
    private boolean isRateCurrency = false;
    private Map rateMap;
    private CompanyOrgUnitInfo company;

    public RptTimeDepositHandlerAdapter(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        super(filterInfo, sorter, kdt);
    }

    public RptTimeDepositHandlerAdapter(KDTable tblMain, FilterInfo filterInfo) {
        super(filterInfo, tblMain);
    }

    protected void prepare() {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
            this.precisionLocalCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId())).getPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.queryType = this.params.getType();
        if (this.queryType == 0) {
            this.orderByColumn = " bankName";
        } else if (this.queryType == 1) {
            this.orderByColumn = " companyName";
        } else if (this.queryType == 2) {
            this.orderByColumn = " fcurrencyName";
        }
        this.endDate = this.params.getEndDate();
        this.amountUnit = this.params.getStatisticalUnit();
        this.currencyIDs = this.params.getCurrencyIDs();
        this.bankIDS = this.params.getBankIDs();
        if (this.params instanceof RptTimeDepositBalanceFilterParam) {
            this.rateCurrencyInfo = ((RptTimeDepositBalanceFilterParam)this.params).getRateCurrencyInfo();
            if (this.rateCurrencyInfo != null) {
                this.isRateCurrency = true;
                this.rateMap = new HashMap();
                this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            }
        }
        this.unit = "1";
        if (this.amountUnit.equals((Object)StatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    private String getCommonFilterToChLoan() {
        StringBuffer sb = new StringBuffer();
        sb.append("( td.FEffectedStatus = 2  ");
        Set companys = this.params.getCompanyIdSet();
        if (companys != null && companys.size() > 0) {
            sb.append(" and td.fdepositcompanyid in (");
            Iterator it = companys.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        if (this.currencyIDs != null && this.currencyIDs.length > 0) {
            sb.append(" and td.fcurrencyid in ").append(this.getValues(this.currencyIDs));
        }
        if (this.bankIDS != null && this.bankIDS.length > 0) {
            sb.append(" and td.fdepositbankid in ").append(this.getValues(this.bankIDS));
        }
        if (this.params instanceof RptTimeDepositDetailFilterParam) {
            Date startDate = ((RptTimeDepositDetailFilterParam)this.params).getStartDate();
            Date endDate = ((RptTimeDepositDetailFilterParam)this.params).getEndDate();
            sb.append(" and td.feffectivedate <= { ").append(Constants.FORMAT_TIME.format(endDate)).append("}");
            sb.append(" and td.feffectivedate >= { ").append(Constants.FORMAT_TIME.format(startDate)).append("}");
        } else if (this.params instanceof RptTimeDepositBalanceFilterParam) {
            if (this.endDate != null) {
                sb.append(" and td.feffectivedate <={ ").append(Constants.FORMAT_TIME.format(this.endDate)).append("}   ");
            }
            if (this.params.getAmtFrom() != null && this.params.getAmtFrom().compareTo(Constants.ZERO) > 0) {
                sb.append(" and td.fdepositamt >= ").append(this.params.getAmtFrom());
            }
            if (this.params.getAmtTo() != null && this.params.getAmtTo().compareTo(Constants.ZERO) > 0) {
                sb.append(" and td.fdepositamt <= ").append(this.params.getAmtTo());
            }
        }
        if (this.params.getTimeDepositType() != null) {
            sb.append(" and td.ftimedeposittype = '").append(this.params.getTimeDepositType().getValue()).append("' ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getValues(String[] IDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < IDs.length; ++i) {
            sb.append("'").append(IDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    public void setChloanDetailFilterParam(RptTimeDepositFilterParamAdapter rptChloanDetailFilterParam) {
        this.params = rptChloanDetailFilterParam;
    }

    public void initHeader() {
        super.initHeader();
    }

    protected String getQueryPath() {
        return "";
    }

    public IRowSet getRowSet() throws BOSException {
        return SQLExecutorFactory.getRemoteInstance((String)this.getDetailSQL()).executeSQL();
    }

    private String getDetailSQL() {
        StringBuffer sbDetailSQL = new StringBuffer();
        sbDetailSQL.append("select fcurrencyid,fcompanyid,fintratetableid,fbankid,                                                          \n");
        sbDetailSQL.append("       fcurrencyName,companyName,rateTypeName,bankName,                                                         \n");
        sbDetailSQL.append("       ftimedeposittype,   fcurrencyPrecision,                                                                                     \n");
        sbDetailSQL.append("       fnumber,fid,                                                                                             \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       finitbalanceofhistorybill/" + this.unit + " as fdepositamt,                                                                                             \n");
        sbDetailSQL.append("       finitbalanceofhistorybill*fexchangerate/" + this.unit + " as fdepositamtLocal,                                                                                        \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       undepositamt/" + this.unit + " as undepositamt,                                                                                            \n");
        sbDetailSQL.append("       undepositamtLoacl/" + this.unit + " as undepositamtLoacl,                                                                                       \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       (fdepositamt - undepositamt)/" + this.unit + " as balance,                                                                 \n");
        sbDetailSQL.append("       (fdepositamtLocal - undepositamtLoacl)/" + this.unit + " as balanceLocal,                                                  \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       fintratetypeexpressiondis,                                                                                  \n");
        sbDetailSQL.append("       FFYearDays0,                                                                                             \n");
        sbDetailSQL.append("       rate,                                                                                                    \n");
        sbDetailSQL.append("       currate,                                                                                      \n");
        sbDetailSQL.append("       feffectivedate,                                                                                          \n");
        sbDetailSQL.append("       fmaturityday,                                                                                            \n");
        sbDetailSQL.append("       fdescription,                                                                                            \n");
        sbDetailSQL.append("       fcertificateno,                                                                                           \n");
        sbDetailSQL.append("       finttermname,                                                                                           \n");
        sbDetailSQL.append("       fdeptype                                                                                           \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("       from                                                                                                     \n");
        sbDetailSQL.append("       (                                                                                                        \n");
        sbDetailSQL.append("        select                                                                                                  \n");
        sbDetailSQL.append("        term.fname_l2 as finttermname,                                                                          \n");
        sbDetailSQL.append("        td.fdeptype as fdeptype,                                                                          \n");
        sbDetailSQL.append("        td.fcurrencyid as fcurrencyid,                                                                          \n");
        sbDetailSQL.append("        td.fdepositcompanyid as fcompanyid,                                                                            \n");
        sbDetailSQL.append("        td.fintratetableid as fintratetableid,                                                                  \n");
        sbDetailSQL.append("        td.fdepositbankid as fbankid,                                                                           \n");
        sbDetailSQL.append("        cur.fname_l2 as fcurrencyName,   cur.fprecision as fcurrencyPrecision,                                                                        \n");
        sbDetailSQL.append("        com.fname_l2 as companyName,                                                                            \n");
        sbDetailSQL.append("        rateType.Fname_L2 as rateTypeName,                                                                      \n");
        sbDetailSQL.append("        bank.fname_l2 as bankName,                                                                              \n");
        sbDetailSQL.append(" td.finitbalanceofhistorybill as finitbalanceofhistorybill,td.fexchangerate as fexchangerate, \n");
        sbDetailSQL.append(" (                                                 ");
        sbDetailSQL.append("          case td.ftimedeposittype                 ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"437_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(" ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"438_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(" ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"497_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(" ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"498_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append("           else ''                                 ");
        sbDetailSQL.append("           end                                     ");
        sbDetailSQL.append(" )as ftimedeposittype,                             ");
        sbDetailSQL.append("        td.fnumber as fnumber, td.fid as fid,                                                                   \n");
        sbDetailSQL.append("        td.finitbalanceofhistorybill as fdepositamt,                                                                          \n");
        sbDetailSQL.append("        td.finitbalanceofhistorybill*td.fexchangerate as fdepositamtLocal,                                                    \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("        (select isnull(sum(fundepositamt),0) from t_td_untimedepositbill                                           \n");
        sbDetailSQL.append("         where fbizdate <= {" + Constants.FORMAT_TIME.format(this.endDate) + "} and  ftimedepositbillid = td.fid                  \n");
        sbDetailSQL.append("         ) +                                                                                                    \n");
        sbDetailSQL.append("         ( case td.fisredeposited                                                                               \n");
        sbDetailSQL.append("          when 1 then ( " + this.getDeducted() + ")                                             \n");
        sbDetailSQL.append("          else 0                                                                                                \n");
        sbDetailSQL.append("          end                                                                                                   \n");
        sbDetailSQL.append("          ) as undepositamt,                                                                                    \n");
        sbDetailSQL.append("                                                                                                                \n");
        sbDetailSQL.append("        (select isnull(sum(fundepositamt*t_td_untimedepositbill.fexchangerate),0) from t_td_untimedepositbill      \n");
        sbDetailSQL.append("         where fbizdate <= {" + Constants.FORMAT_TIME.format(this.endDate) + "} and  ftimedepositbillid = td.fid                  \n");
        sbDetailSQL.append("        )  +                                                                                                   \n");
        sbDetailSQL.append("        (case td.fisredeposited                                                                                 \n");
        sbDetailSQL.append("          when 1 then ( " + this.getDedcutedLocal() + ")         \n");
        sbDetailSQL.append("          else 0                                                                                                \n");
        sbDetailSQL.append("          end                                                                                                   \n");
        sbDetailSQL.append("        ) as undepositamtLoacl,                                                                                 \n");
        sbDetailSQL.append(" td.fintratetypeexpression, \n");
        sbDetailSQL.append(" (                                        ");
        sbDetailSQL.append("         case td.fintratetypeexpression   ");
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"27_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"28_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"29_RptTimeDepositHandlerAdapter"));
        sbDetailSQL.append("          else ''                         ");
        sbDetailSQL.append("          end                             ");
        sbDetailSQL.append(" ) as  fintratetypeexpressiondis,            ");
        sbDetailSQL.append("        td.FFYearDays0,                                                                                         \n");
        sbDetailSQL.append("        ( case td.fintratetypeexpression                                                                        \n");
        sbDetailSQL.append("          when 'year' then to_char(td.fyearrate)||'%'                                                                    \n");
        sbDetailSQL.append("          else to_char(td.fyearrate)||'\u2030'                                                                              \n");
        sbDetailSQL.append("          end                                                                                                   \n");
        sbDetailSQL.append("         ) as rate,                                                                                             \n");
        sbDetailSQL.append("        ( case td.fintratetypeexpression                                                                        \n");
        sbDetailSQL.append("          when 'year' then to_char(td.fcuryearrate)||'%'                                                                 \n");
        sbDetailSQL.append("          else to_char(td.fcuryearrate)||'\u2030'                                                                          \n");
        sbDetailSQL.append("          end                                                                                                   \n");
        sbDetailSQL.append("          ) as currate,                                                                                         \n");
        sbDetailSQL.append("        td.feffectivedate as feffectivedate,                                                                    \n");
        sbDetailSQL.append("        td.fmaturityday as fmaturityday,                                                                        \n");
        sbDetailSQL.append("        td.fdescription as fdescription,                                                                        \n");
        sbDetailSQL.append("        td.fcertificateno as fcertificateno                                                                     \n");
        sbDetailSQL.append("        from t_td_timedepositbill td                                                                            \n");
        sbDetailSQL.append("        left outer join  t_int_intterm term on term.fid = td.finttermid                                            \n");
        sbDetailSQL.append("        left outer join  t_org_company com on com.fid = td.fdepositcompanyid                                           \n");
        sbDetailSQL.append("        left outer join  t_bd_bank bank on bank.fid = td.fdepositbankid                                         \n");
        sbDetailSQL.append("        left outer join  t_bd_currency cur on cur.fid = td.fcurrencyid                                          \n");
        sbDetailSQL.append("        left outer join  T_INT_IntRateType rateType on rateType.fid = td.fintratetableid                        \n");
        sbDetailSQL.append("        where                                                                             ").append(this.getCommonFilterToChLoan());
        sbDetailSQL.append(") aa  \n");
        if (this.params instanceof RptTimeDepositBalanceFilterParam) {
            sbDetailSQL.append(" where (fdepositamt - undepositamt) >0 ");
        }
        sbDetailSQL.append(" order by ").append(this.orderByColumn);
        return sbDetailSQL.toString();
    }

    private String getDeducted() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select isnull(sum((timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt)),0) ");
        sql.append(" from t_td_timedepositbill timinner");
        Date endDate = this.params.getEndDate();
        sql.append(" where timinner.feffectivedate <= {" + Constants.FORMAT_TIME.format(endDate) + "} and timinner.fsourcebillid = td.fid");
        return sql.toString();
    }

    private String getDedcutedLocal() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select isnull(sum((timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt)*timinner.fexchangerate),0) ");
        sql.append(" from t_td_timedepositbill timinner");
        Date endDate = this.params.getEndDate();
        sql.append(" where timinner.feffectivedate <= {" + Constants.FORMAT_TIME.format(endDate) + "} and timinner.fsourcebillid = td.fid");
        return sql.toString();
    }

    protected void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
        this.initCommonColumn();
        IRow row = this.formatCommonHeadRow();
        this.formatCustomerHeadRow(row);
        IRow rowH = this.kdt.addHeadRow();
        this.kdt.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.kdt.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.kdt.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.kdt.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.kdt.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.kdt.getHeadMergeManager().mergeBlock(0, 5, 0, 6);
        rowH.getCell("depositAmt").setValue((Object)this.getResString("rpt_common_amt"));
        rowH.getCell("depositAmtLocal").setValue((Object)this.getResString("rpt_common_amtLocal"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 7, 0, 8);
        rowH.getCell("undepositAmt").setValue((Object)this.getResString("rpt_common_amt"));
        rowH.getCell("undepositAmtLocal").setValue((Object)this.getResString("rpt_common_amtLocal"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 9, 0, 10);
        rowH.getCell("balance").setValue((Object)this.getResString("rpt_common_amt"));
        rowH.getCell("balanceLocal").setValue((Object)this.getResString("rpt_common_amtLocal"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 11, 1, 11);
        this.kdt.getHeadMergeManager().mergeBlock(0, 12, 1, 12);
        this.kdt.getHeadMergeManager().mergeBlock(0, 13, 1, 13);
        this.kdt.getHeadMergeManager().mergeBlock(0, 14, 1, 14);
        this.kdt.getHeadMergeManager().mergeBlock(0, 15, 1, 15);
        this.kdt.getHeadMergeManager().mergeBlock(0, 16, 1, 16);
        this.kdt.getHeadMergeManager().mergeBlock(0, 17, 1, 17);
        this.kdt.getHeadMergeManager().mergeBlock(0, 18, 1, 18);
        this.kdt.getHeadMergeManager().mergeBlock(0, 19, 1, 19);
        this.kdt.getHeadMergeManager().mergeBlock(0, 20, 1, 20);
    }

    protected void initCommonColumn() {
        IColumn cNumber = this.kdt.addColumn();
        cNumber.setKey("number");
        IColumn cAmt = this.kdt.addColumn();
        cAmt.setKey("depositAmt");
        IColumn cAmtLoacl = this.kdt.addColumn();
        cAmtLoacl.setKey("depositAmtLocal");
        IColumn cUndepositAmt = this.kdt.addColumn();
        cUndepositAmt.setKey("undepositAmt");
        IColumn cUndepositAmtLocal = this.kdt.addColumn();
        cUndepositAmtLocal.setKey("undepositAmtLocal");
        IColumn cBalance = this.kdt.addColumn();
        cBalance.setKey("balance");
        IColumn cBalanceLocal = this.kdt.addColumn();
        cBalanceLocal.setKey("balanceLocal");
        IColumn cIntExpression = this.kdt.addColumn();
        cIntExpression.setKey("intExpression");
        IColumn cYearDays = this.kdt.addColumn();
        cYearDays.setKey("yearDays");
        IColumn rRate = this.kdt.addColumn();
        rRate.setKey("rate");
        IColumn cCurRate = this.kdt.addColumn();
        cCurRate.setKey("curRate");
        IColumn cEffectivedate = this.kdt.addColumn();
        cEffectivedate.setKey("effectiveDate");
        IColumn cMaturityday = this.kdt.addColumn();
        cMaturityday.setKey("maturityday");
        IColumn cIntTerm = this.kdt.addColumn();
        cIntTerm.setKey("intTerm");
        IColumn cDescription = this.kdt.addColumn();
        cDescription.setKey("description");
        IColumn cCertificateno = this.kdt.addColumn();
        cCertificateno.setKey("certificateno");
        IColumn cID = this.kdt.addColumn();
        cID.setKey("id");
        cID.getStyleAttributes().setHided(true);
        IColumn cCurrencyPrecision = this.kdt.addColumn();
        cCurrencyPrecision.setKey("currency.precision");
        cCurrencyPrecision.getStyleAttributes().setHided(true);
    }

    protected IRow formatCommonHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("number").setValue((Object)this.getResString("rpt_balance_number"));
        headRow.getCell("depositAmt").setValue((Object)this.getResString("rpt_common_principal"));
        headRow.getCell("depositAmtLocal").setValue((Object)this.getResString("rpt_common_principal"));
        headRow.getCell("undepositAmt").setValue((Object)this.getResString("rpt_common_unDepositAmt"));
        headRow.getCell("undepositAmtLocal").setValue((Object)this.getResString("rpt_common_unDepositAmt"));
        headRow.getCell("balance").setValue((Object)this.getResString("rpt_common_balance"));
        headRow.getCell("balanceLocal").setValue((Object)this.getResString("rpt_common_balance"));
        headRow.getCell("intExpression").setValue((Object)this.getResString("rpt_balance_rateExpression"));
        headRow.getCell("yearDays").setValue((Object)this.getResString("rpt_balance_yearDays"));
        headRow.getCell("rate").setValue((Object)this.getResString("rpt_balance_rate"));
        headRow.getCell("curRate").setValue((Object)this.getResString("rpt_balance_curRate"));
        headRow.getCell("effectiveDate").setValue((Object)this.getResString("rpt_balance_effectiveDate"));
        headRow.getCell("maturityday").setValue((Object)this.getResString("rpt_balance_maturityDate"));
        headRow.getCell("intTerm").setValue((Object)this.getResString("rpt_balance_intTerm"));
        headRow.getCell("description").setValue((Object)this.getResString("rpt_balance_diggest"));
        headRow.getCell("certificateno").setValue((Object)this.getResString("rpt_balance_certiNo"));
        headRow.getCell("id").setValue((Object)this.getResString(""));
        headRow.getCell("currency.precision").setValue((Object)this.getResString(""));
        return headRow;
    }

    private void initDecimalCol(ICell cell, String format) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(format);
    }

    protected void formatCol(IColumn col, int precision) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    protected String getResString(String key) {
        return EASResource.getString((String)TDSOURCE_PATH, (String)key);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
    }

    protected void initCustomHeader() {
    }

    protected void formatCustomerHeadRow(IRow row) {
    }

    protected void setContentToCommonColumn(IRow row, IRowSet rs) throws SQLException, EASBizException, BOSException {
        BigDecimal balanceValue;
        BigDecimal undepositamtLoacl;
        BigDecimal depositamtLocal;
        String currencyId = rs.getString("fcurrencyid");
        BigDecimal rate = Constants.ONE;
        if (this.isRateCurrency) {
            if (this.rateMap.containsKey(currencyId)) {
                rate = (BigDecimal)this.rateMap.get(currencyId);
            } else {
                if (currencyId.equals(this.rateCurrencyInfo.getId().toString())) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((CurrencyInfo)currency, (CurrencyInfo)this.rateCurrencyInfo, (CompanyOrgUnitInfo)this.company, (java.util.Date)this.endDate);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currency.getName(), this.rateCurrencyInfo.getName()});
                    }
                    rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                }
                this.rateMap.put(currencyId, rate);
            }
        }
        row.getCell("currency.precision").setValue(rs.getObject("fcurrencyPrecision"));
        int precision = Integer.parseInt(row.getCell("currency.precision").getValue().toString());
        row.getCell("number").setValue(rs.getObject("fnumber"));
        row.getCell("depositAmt").setValue(rs.getObject("fdepositamt"));
        this.initDecimalCol(row.getCell("depositAmt"), precision);
        BigDecimal bigDecimal = depositamtLocal = this.isRateCurrency ? rs.getBigDecimal("fdepositamt") : rs.getBigDecimal("fdepositamtLocal");
        if (this.isRateCurrency) {
            row.getCell("depositAmtLocal").setValue((Object)depositamtLocal.multiply(rate));
        } else {
            row.getCell("depositAmtLocal").setValue((Object)depositamtLocal);
        }
        this.initDecimalCol(row.getCell("depositAmtLocal"), this.precisionLocalCurrency);
        row.getCell("undepositAmt").setValue(rs.getObject("undepositamt"));
        this.initDecimalCol(row.getCell("undepositAmt"), precision);
        BigDecimal bigDecimal2 = undepositamtLoacl = this.isRateCurrency ? rs.getBigDecimal("undepositamt") : rs.getBigDecimal("undepositamtLoacl");
        if (this.isRateCurrency) {
            row.getCell("undepositAmtLocal").setValue((Object)undepositamtLoacl.multiply(rate));
        } else {
            row.getCell("undepositAmtLocal").setValue((Object)undepositamtLoacl);
        }
        this.initDecimalCol(row.getCell("undepositAmtLocal"), this.precisionLocalCurrency);
        row.getCell("balance").setValue(rs.getObject("balance"));
        this.initDecimalCol(row.getCell("balance"), precision);
        if (this.isRateCurrency) {
            balanceValue = (BigDecimal)row.getCell("balance").getValue();
            if (balanceValue.compareTo(Constants.ZERO) == 0) {
                row.getCell("balanceLocal").setValue((Object)Constants.ZERO);
            } else {
                BigDecimal balanceLocal = rs.getBigDecimal("balance");
                row.getCell("balanceLocal").setValue((Object)balanceLocal.multiply(rate));
            }
        } else {
            balanceValue = (BigDecimal)row.getCell("balance").getValue();
            if (balanceValue.compareTo(Constants.ZERO) == 0) {
                row.getCell("balanceLocal").setValue((Object)Constants.ZERO);
            } else {
                row.getCell("balanceLocal").setValue(rs.getObject("balanceLocal"));
            }
        }
        this.initDecimalCol(row.getCell("balanceLocal"), this.precisionLocalCurrency);
        row.getCell("intExpression").setValue(rs.getObject("fintratetypeexpressiondis"));
        row.getCell("yearDays").setValue(rs.getObject("FFYearDays0"));
        this.initDecimalCell(row.getCell("yearDays"));
        String rateTmp = (String)rs.getObject("rate");
        if (rateTmp != null && rateTmp.startsWith(".")) {
            rateTmp = "0" + rateTmp;
        }
        rateTmp = ChLoanHelper.getInstance().trimZero(rateTmp, rateTmp.substring(rateTmp.length() - 1, rateTmp.length()));
        rateTmp = this.formatValue(rateTmp);
        row.getCell("rate").setValue((Object)rateTmp);
        this.initDecimalCell(row.getCell("rate"));
        rateTmp = (String)rs.getObject("currate");
        if (rateTmp != null && rateTmp.startsWith(".")) {
            rateTmp = "0" + rateTmp;
        }
        rateTmp = ChLoanHelper.getInstance().trimZero(rateTmp, rateTmp.substring(rateTmp.length() - 1, rateTmp.length()));
        rateTmp = this.formatValue(rateTmp);
        row.getCell("curRate").setValue((Object)rateTmp);
        this.initDecimalCell(row.getCell("curRate"));
        row.getCell("effectiveDate").setValue((Object)rs.getDate("feffectivedate"));
        row.getCell("maturityday").setValue((Object)rs.getDate("fmaturityday"));
        row.getCell("intTerm").setValue(rs.getObject("finttermname"));
        row.getCell("description").setValue(rs.getObject("fdescription"));
        row.getCell("certificateno").setValue(rs.getObject("fcertificateno"));
        row.getCell("id").setValue(rs.getObject("fid"));
    }

    private String formatValue(String rateTmp) {
        String tmp = rateTmp.substring(rateTmp.indexOf(".") + 1, rateTmp.length() - 1);
        if (tmp.length() == 5) {
            return rateTmp;
        }
        int size = 5 - tmp.length();
        for (int i = 0; i < size; ++i) {
            tmp = tmp + "0";
        }
        return rateTmp.substring(0, rateTmp.indexOf(".") + 1) + tmp + rateTmp.substring(rateTmp.length() - 1);
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    public void endDataFill() {
        super.endDataFill();
        this.kdt.getSelectManager().setSelectMode(2);
    }

    public void setTableStateRow() {
        this.queryType = this.params.getType();
        if (this.queryType == 0) {
            this.kdt.getColumn("bank").setStat(true);
        } else if (this.queryType == 1) {
            this.kdt.getColumn("company").setStat(true);
        } else if (this.queryType == 2) {
            this.kdt.getColumn("currency").setStat(true);
        }
        IRow subtotalRow = this.kdt.getGroupManager().getStatRowTemplate(0);
        subtotalRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"30_RptTimeDepositHandlerAdapter"));
        subtotalRow.getCell(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subtotalRow.getCell("depositAmtLocal").setExpressions("SUM");
        subtotalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell("depositAmtLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCol(subtotalRow.getCell("depositAmtLocal"), this.precisionLocalCurrency);
        subtotalRow.getCell("undepositAmtLocal").setExpressions("SUM");
        subtotalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell("undepositAmtLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCol(subtotalRow.getCell("undepositAmtLocal"), this.precisionLocalCurrency);
        subtotalRow.getCell("balanceLocal").setExpressions("SUM");
        subtotalRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        subtotalRow.getCell("balanceLocal").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.initDecimalCol(subtotalRow.getCell("balanceLocal"), this.precisionLocalCurrency);
        IRow summationRow = this.kdt.getGroupManager().getStatRowTemplate(-1);
        summationRow.getCell("depositAmtLocal").setExpressions("SUM");
        this.initDecimalCol(summationRow.getCell("depositAmtLocal"), this.precisionLocalCurrency);
        summationRow.getCell("undepositAmtLocal").setExpressions("SUM");
        this.initDecimalCol(summationRow.getCell("undepositAmtLocal"), this.precisionLocalCurrency);
        summationRow.getCell("balanceLocal").setExpressions("SUM");
        this.initDecimalCol(summationRow.getCell("balanceLocal"), this.precisionLocalCurrency);
        summationRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"31_RptTimeDepositHandlerAdapter"));
        summationRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
    }

    private void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

