/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.td.RptTimeDepositConstants;
import com.kingdee.eas.fm.td.RptTimeDepositSumFacadeFactory;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.fm.td.client.AbstractRptTimeDepositSumMainUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositDetailMainUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositFilterParamAdapter;
import com.kingdee.eas.fm.td.client.RptTimeDepositSumFilterUI;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptTimeDepositSumMainUI
extends AbstractRptTimeDepositSumMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositSumMainUI.class);
    private CurrencyInfo currencyInfo;
    private Date startDate;
    private Date endDate;
    private StatisticalUnitEnum amountUnit;
    RptTimeDepositSumFilterUI filterUI;

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        this.filterUI = new RptTimeDepositSumFilterUI();
        return this.filterUI;
    }

    protected IBireportBaseFacade getRemoteInstance() throws BOSException {
        return RptTimeDepositSumFacadeFactory.getRemoteInstance();
    }

    protected void onBeforeQuery() throws Exception {
        try {
            this.currencyInfo = (CurrencyInfo)this.params.getObject("currency");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.startDate = (Date)this.params.getObject("startDate");
        this.endDate = (Date)this.params.getObject("endDate");
        this.amountUnit = (StatisticalUnitEnum)((Object)this.params.getObject("amountUnit"));
        Object currencyObj = this.params.getObject("currency");
        this.currencyInfo = currencyObj instanceof CurrencyInfo ? (CurrencyInfo)currencyObj : null;
        this.initLableText();
    }

    private void initLableText() {
        this.txtScope.setText(this.getLableText(1));
        this.txtCurrency.setText(this.getLableText(2));
        this.txtUnit.setText(this.getLableText(3));
    }

    private String getLableText(int i) {
        StringBuffer sb = new StringBuffer();
        if (1 == i) {
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            if (this.startDate != null && this.endDate != null) {
                java.util.Date date = new java.util.Date(this.startDate.getTime());
                sb.append(dtformat.format(date));
                sb.append(RptTimeDepositConstants.TO_TEXT);
                date = new java.util.Date(this.endDate.getTime());
                sb.append(dtformat.format(date));
            } else if (this.startDate == null) {
                java.util.Date date = new java.util.Date(this.endDate.getTime());
                sb.append(RptTimeDepositConstants.END_TEXT);
                sb.append(dtformat.format(date));
                sb.append(RptTimeDepositConstants.END1_TEXT);
            } else if (this.endDate == null) {
                java.util.Date date = new java.util.Date(this.startDate.getTime());
                sb.append(RptTimeDepositConstants.FROM_TEXT);
                sb.append(dtformat.format(date));
                sb.append(RptTimeDepositConstants.START_TEXT);
            }
        } else if (2 == i) {
            sb.append(this.currencyInfo != null ? this.currencyInfo.getName() : RptTimeDepositConstants.ALL);
        } else if (3 == i) {
            sb.append(this.amountUnit.getAlias());
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void onAfterQuery() throws Exception {
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.contScope.getBoundLabelText()).append("&[Scope]&|").append(this.contCurrency.getBoundLabelText()).append("&[Currency]&| ").append(this.conUnit.getBoundLabelText()).append("&[Unit]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Scope", this.txtScope.getText());
        map.put("Currency", this.txtCurrency.getText());
        map.put("Unit", this.txtUnit.getText());
        return map;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.actionJoinQueryBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionJoinQueryDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    protected RptParams getParamsForRequest() {
        RptParams pp = RptParams.parseFrom((Map)this.params.toMap());
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit())) {
            try {
                pp.setObject("companyTree", (Object)this.getCompanyTree());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            OrgStructureInfo os = new OrgStructureInfo();
            os.setUnit((OrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            pp.setObject("companyTree", (Object)new SimpleTreeNode((Object)os, 0));
        }
        return pp;
    }

    @Override
    public void actionJoinQueryBalance_actionPerformed(ActionEvent e) throws Exception {
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms == null) {
            String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        RptTimeDepositBalanceFilterParam rptBalanceFilterParam = new RptTimeDepositBalanceFilterParam();
        this.setFilterParam(rptBalanceFilterParam);
        HashSet companySet = new HashSet();
        HashSet currencySet = new HashSet();
        HashSet<Object> bankSet = new HashSet<Object>();
        if (ms != null) {
            for (Member m : ms) {
                HashSet<Object> set;
                if (!m.isLeaf()) continue;
                String dimName = m.getDimension().getName();
                if ("Bank".equals(dimName)) {
                    set = bankSet;
                } else if ("Currency".equals(dimName)) {
                    set = currencySet;
                } else {
                    if (!"Company".equals(dimName)) continue;
                    set = companySet;
                }
                if (m.getKey() == null) continue;
                set.add(m.getKey());
            }
        }
        if (companySet.size() > 0) {
            rptBalanceFilterParam.setCompanyIdSet(companySet);
        } else {
            rptBalanceFilterParam.setCompanyIdSet((Set)this.params.getObject("companyIdSet"));
        }
        if (currencySet.size() > 0) {
            rptBalanceFilterParam.setCurrencyIDs(currencySet.toArray(new String[currencySet.size()]));
        }
        if (bankSet != null && bankSet.size() > 0) {
            String[] bankids = bankSet.toArray(new String[bankSet.size()]);
            rptBalanceFilterParam.setBankIDs(bankids);
        }
        if (companySet != null && companySet.size() > 0) {
            rptBalanceFilterParam.setQueryType("By_Company");
        } else if (currencySet != null && currencySet.size() > 0) {
            rptBalanceFilterParam.setQueryType("By_Currency");
        } else if (bankSet != null && bankSet.size() > 0) {
            rptBalanceFilterParam.setQueryType("By_Bank");
        }
        if (rptBalanceFilterParam.getType() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"choose_detail_node"));
            SysUtil.abort();
        }
        uiContext.put((Object)"filterParam", (Object)rptBalanceFilterParam);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = null;
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)uiContext);
        IUIObject uiObject = mainUI.getUiManager().findUIObject(RptTimeDepositBalanceUI.class.getName(), (Map)uiContext, this.dataObjects, OprtState.VIEW);
        if (uiObject != null) {
            uiWindow = uiObject.getUIWindow();
            uiWindow.close();
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptTimeDepositBalanceUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void setFilterParam(RptTimeDepositFilterParamAdapter rcpfp) {
        this.endDate = (Date)this.params.getObject("endDate");
        this.amountUnit = (StatisticalUnitEnum)((Object)this.params.getObject("amountUnit"));
        String[] currenycIDs = null;
        try {
            this.currencyInfo = (CurrencyInfo)this.params.getObject("currency");
            currenycIDs = new String[]{this.currencyInfo.getId().toString()};
        }
        catch (ClassCastException e) {
            currenycIDs = new String[]{};
            this.currencyInfo = null;
        }
        String[] bankIDarr = (String[])this.params.getObject("bankIDS");
        try {
            TimeDepositTypeEnum type = (TimeDepositTypeEnum)((Object)this.params.getObject("depositType"));
            if (type == TimeDepositTypeEnum.TIMEDEPOSIT_INNER) {
                rcpfp.setTimeDepositType(com.kingdee.eas.fm.common.TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
            } else if (type == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
                rcpfp.setTimeDepositType(com.kingdee.eas.fm.common.TimeDepositTypeEnum.TIMEDEPOSIT_OUTER);
            } else if (type == TimeDepositTypeEnum.CALLDEPOSIT_INNER) {
                rcpfp.setTimeDepositType(com.kingdee.eas.fm.common.TimeDepositTypeEnum.CALLDEPOSIT_INNER);
            } else if (type == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
                rcpfp.setTimeDepositType(com.kingdee.eas.fm.common.TimeDepositTypeEnum.CALLDEPOSIT_OUTER);
            }
        }
        catch (ClassCastException cce) {
            rcpfp.setTimeDepositType(null);
        }
        rcpfp.setEndDate(this.endDate);
        rcpfp.setStatisticalUnit(this.amountUnit);
        rcpfp.setBankIDs(bankIDarr);
        rcpfp.setCurrencyIDs(currenycIDs);
        rcpfp.setQueryType((String)this.params.getObject("queryType"));
        if (rcpfp instanceof RptTimeDepositDetailFilterParam) {
            this.startDate = (Date)this.params.getObject("startDate");
            ((RptTimeDepositDetailFilterParam)rcpfp).setStartDate(this.startDate);
        } else {
            rcpfp.setAmtFrom(Constants.ZERO);
            rcpfp.setAmtTo(Constants.ZERO);
        }
    }

    @Override
    public void actionJoinQueryDetail_actionPerformed(ActionEvent e) throws Exception {
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms == null) {
            String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        RptTimeDepositDetailFilterParam rptBalanceFilterParam = new RptTimeDepositDetailFilterParam();
        this.setFilterParam(rptBalanceFilterParam);
        HashSet companySet = new HashSet();
        HashSet currencySet = new HashSet();
        HashSet<Object> bankSet = new HashSet<Object>();
        if (ms != null) {
            for (Member m : ms) {
                HashSet<Object> set;
                if (!m.isLeaf()) continue;
                String dimName = m.getDimension().getName();
                if ("Bank".equals(dimName)) {
                    set = bankSet;
                } else if ("Currency".equals(dimName)) {
                    set = currencySet;
                } else {
                    if (!"Company".equals(dimName)) continue;
                    set = companySet;
                }
                if (m.getKey() == null) continue;
                set.add(m.getKey());
            }
        }
        if (companySet.size() > 0) {
            rptBalanceFilterParam.setCompanyIdSet(companySet);
        } else {
            rptBalanceFilterParam.setCompanyIdSet((Set)this.params.getObject("companyIdSet"));
        }
        if (currencySet.size() > 0) {
            rptBalanceFilterParam.setCurrencyIDs(currencySet.toArray(new String[currencySet.size()]));
        }
        if (bankSet != null && bankSet.size() > 0) {
            String[] bankids = bankSet.toArray(new String[bankSet.size()]);
            rptBalanceFilterParam.setBankIDs(bankids);
        }
        if (companySet != null && companySet.size() > 0) {
            rptBalanceFilterParam.setQueryType("By_Company");
        } else if (currencySet != null && currencySet.size() > 0) {
            rptBalanceFilterParam.setQueryType("By_Currency");
        } else if (bankSet != null && bankSet.size() > 0) {
            rptBalanceFilterParam.setQueryType("By_Bank");
        }
        if (rptBalanceFilterParam.getType() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"choose_detail_node"));
            SysUtil.abort();
        }
        uiContext.put((Object)"filterParam", (Object)rptBalanceFilterParam);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = null;
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)uiContext);
        IUIObject uiObject = mainUI.getUiManager().findUIObject(RptTimeDepositDetailMainUI.class.getName(), (Map)uiContext, this.dataObjects, OprtState.VIEW);
        if (uiObject != null) {
            uiWindow = uiObject.getUIWindow();
            uiWindow.close();
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptTimeDepositDetailMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

