/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.DepTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.BillPropertysConfineUtil;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.ApplyTimeDepositTypeEnum;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.fm.td.TimeDepositFetchParamFacadeFactory;
import com.kingdee.eas.fm.td.client.AbstractTimeDepositApplyEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class TimeDepositApplyEditUI
extends AbstractTimeDepositApplyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TimeDepositApplyEditUI.class);
    private Map paramsMap;
    private CompanyOrgUnitInfo company;
    private CurrencyInfo currencyInfo;
    private UserInfo userInfo;

    private void batchFetchParam() throws Exception {
        this.paramsMap = new HashMap();
        this.paramsMap.put("company", null);
        this.paramsMap.put("currencyCollection", null);
        this.paramsMap.put("baseCurrency", null);
        this.paramsMap.put("user", null);
        this.paramsMap.put("hasNumber", Boolean.FALSE);
        this.paramsMap.put("currentCtrlUnit", null);
        Map map = TimeDepositFetchParamFacadeFactory.getRemoteInstance().fetchParam(this.paramsMap);
        this.paramsMap.putAll(map);
    }

    public void onLoad() throws Exception {
        this.batchFetchParam();
        this.company = (CompanyOrgUnitInfo)this.paramsMap.get("company");
        this.currencyInfo = (CurrencyInfo)this.paramsMap.get("baseCurrency");
        this.userInfo = (UserInfo)this.paramsMap.get("user");
        FMClientHelper.initSpComponents((KDComboBox)this.comboCurreny, (KDFormattedTextField)this.kdApplyAmount, null, null, (CurrencyInfo)this.currencyInfo, (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.company);
        this.kdApplyAmount.setHorizontalAlignment(4);
        this.kdApplyAmount.setRemoveingZeroInDispaly(false);
        this.kdRate.setPrecision(5);
        this.kdRate.setHorizontalAlignment(4);
        this.kdRate.setRemoveingZeroInDispaly(false);
        super.onLoad();
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtSaveingOrg, (boolean)true);
        F7SelectorFactory.initAccountBank((KDBizPromptBox)this.prmtPayerAccount, (BankInfo)((BankInfo)this.prmtSaveingOrg.getValue()), (AccountBankPropertyEnum)AccountBankPropertyEnum.Current);
        F7SelectorFactory.initAccountBank((KDBizPromptBox)this.prmtPayeeAccount, (BankInfo)((BankInfo)this.prmtSaveingOrg.getValue()), (AccountBankPropertyEnum)AccountBankPropertyEnum.Fixed);
        BillPropertysConfineUtil.billPropertysOutsideRepair((EditUI)this);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.kdBaseRate.setPrecision(5);
        this.kdBaseRate.setHorizontalAlignment(4);
        this.kdBaseRate.setRemoveingZeroInDispaly(false);
        if (this.currentCompany == null || !this.currentCompany.isIsBizUnit()) {
            this.menuItemTraceUp.setEnabled(false);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEditable()) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBeginDate);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtSaveingOrg);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.kdApplyAmount);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboApplyType);
        ApplyTimeDepositTypeEnum applyType = this.editData.getApplyType();
        if (ApplyTimeDepositTypeEnum.TIMEDEPOSIT_INNER.equals((Object)applyType)) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtintTerm);
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayerAccount);
        } else if (ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER.equals((Object)applyType)) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtintTerm);
        } else if (ApplyTimeDepositTypeEnum.CALLDEPOSIT_INNER.equals((Object)applyType)) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayerAccount);
        } else if (ApplyTimeDepositTypeEnum.CALLDEPOSIT_OUTER.equals((Object)applyType)) {
            // empty if block
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayeeAccount);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.kdApplyAmount, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThanEqual((CoreUIObject)this, (KDFormattedTextField)this.kdRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyLessThanEqual((CoreUIObject)this, (KDFormattedTextField)this.kdRate, (BigDecimal)Constants.ONE_HUNDRED);
    }

    @Override
    public void loadFields() {
        Map allListeners = null;
        try {
            allListeners = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        boolean result = FMClientHelper.isAddView((CoreBaseInfo)new TimeDepositApplyInfo(), (String)this.currentCompany.getId().toString());
        if (OprtState.ADDNEW.equals(this.getOprtState()) && !result) {
            this.txtNumber.setText(null);
            this.editData.setNumber(this.txtNumber.getText());
        }
        EventListener[] listeners = this.prmtPayeeAccount.getListeners(DataChangeListener.class);
        DataChangeListener payeeDcl = null;
        if (listeners != null && listeners.length > 0) {
            payeeDcl = (DataChangeListener)listeners[0];
            this.prmtPayeeAccount.removeDataChangeListener(payeeDcl);
        }
        listeners = this.prmtPayerAccount.getListeners(DataChangeListener.class);
        DataChangeListener payerDcl = null;
        if (listeners != null && listeners.length > 0) {
            payerDcl = (DataChangeListener)listeners[0];
            this.prmtPayerAccount.removeDataChangeListener(payerDcl);
        }
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurreny, (Object)this.editData.getCurrency(), (boolean)false);
        this.showByApplyType(this.editData.getApplyType());
        ApplyBillStatusEnum billState = this.editData.getBillState();
        if (ApplyBillStatusEnum.SUBMIT == billState) {
            this.actionSave.setVisible(false);
        } else if (ApplyBillStatusEnum.SAVE == billState) {
            this.actionSave.setVisible(true);
        }
        this.actionAttachment.setVisible(false);
        this.prmtPayeeAccount.addDataChangeListener(payeeDcl);
        this.prmtPayerAccount.addDataChangeListener(payerDcl);
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)allListeners);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.setRateLabelText();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtDesc.setEditable(true);
        this.txtNumber.setEditable(true);
        this.contCurreny.setEnabled(true);
        Boolean hasNumber = (Boolean)this.paramsMap.get("hasNumber");
        Boolean isModifiable = (Boolean)this.paramsMap.get("isModifiable");
        if (hasNumber.booleanValue() && !isModifiable.booleanValue()) {
            this.txtNumber.setEditable(false);
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.hideAction();
        this.comboCurreny.addItems(((CurrencyCollection)this.paramsMap.get("currencyCollection")).toArray());
        this.prmtAuthor.setDisplayFormat("$name$");
    }

    private void hideAction() {
        this.actionRemove.setVisible(false);
        this.actionTraceDown.setVisible(false);
    }

    @Override
    protected void prmtIntRateTable_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ=", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"QYYAAAAKQTYkfZJ0", CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtIntRateTable.setEntityViewInfo(evi);
        this.prmtIntRateTable.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void comboCurreny_itemStateChanged(ItemEvent e) throws Exception {
        BigDecimal bdBaseRate = this.calcBaseRate();
        this.kdBaseRate.setValue((Object)bdBaseRate);
        this.kdRate.setValue((Object)bdBaseRate);
    }

    @Override
    protected void comboApplyType_itemStateChanged(ItemEvent e) throws Exception {
        KDComboBox kdComboBox = (KDComboBox)e.getSource();
        ApplyTimeDepositTypeEnum applyEnum = (ApplyTimeDepositTypeEnum)((Object)kdComboBox.getSelectedItem());
        this.showByApplyType(applyEnum);
        this.prmtintTerm.setData(null);
        this.comboDepType.setSelectedItem((Object)DepTypeEnum.SevenDay);
    }

    private void showByApplyType(ApplyTimeDepositTypeEnum applyEnum) {
        if (ApplyTimeDepositTypeEnum.TIMEDEPOSIT_INNER == applyEnum) {
            this.contintTerm.setVisible(true);
            this.contDepType.setVisible(false);
            this.prmtPayerAccount.setRequired(true);
        } else if (ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER == applyEnum) {
            this.contintTerm.setVisible(true);
            this.contDepType.setVisible(false);
            this.prmtPayerAccount.setRequired(false);
        } else if (ApplyTimeDepositTypeEnum.CALLDEPOSIT_INNER == applyEnum) {
            this.contintTerm.setVisible(false);
            this.contDepType.setVisible(true);
            this.prmtPayerAccount.setRequired(true);
        } else if (ApplyTimeDepositTypeEnum.CALLDEPOSIT_OUTER == applyEnum) {
            this.contintTerm.setVisible(false);
            this.contDepType.setVisible(true);
            this.prmtPayerAccount.setRequired(false);
        } else {
            this.contintTerm.setVisible(false);
            this.contDepType.setVisible(false);
        }
        this.prmtPayeeAccount.setRequired(true);
    }

    private void setControl(JComponent jComponent) {
        JComponent[] jComponents = new JComponent[]{this.contintTerm, this.contDepType};
        for (int i = 0; i < jComponents.length; ++i) {
            if (jComponent.equals(jComponents[i])) {
                jComponents[i].setVisible(true);
                continue;
            }
            jComponents[i].setVisible(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TimeDepositApplyFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (ApplyBillStatusEnum.SAVE.equals((Object)this.editData.getBillState())) {
            this.actionSave.setVisible(true);
            this.actionSubmit.setVisible(true);
        } else if (ApplyBillStatusEnum.SUBMIT.equals((Object)this.editData.getBillState())) {
            this.actionSave.setVisible(false);
            this.actionSubmit.setVisible(true);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"timeDepositApplyEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.actionAttachment.setVisible(false);
    }

    @Override
    protected void prmtPayeeAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeAccount_dataChanged(e);
        AccountBankInfo acctBankInfo = (AccountBankInfo)e.getNewValue();
        if (acctBankInfo != null && acctBankInfo.getBank() != null) {
            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getBank().getId().toString()));
            this.prmtPayeeBank.setData((Object)bankInfo);
        } else {
            this.prmtPayeeBank.setData(null);
        }
    }

    @Override
    protected void prmtPayerAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayerAccount_dataChanged(e);
        AccountBankInfo acctBankInfo = (AccountBankInfo)e.getNewValue();
        if (acctBankInfo != null) {
            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getBank().getId().toString()));
            this.prmtPayerBank.setData((Object)bankInfo);
        } else {
            this.prmtPayerBank.setData(null);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("currency.*"));
        return sic;
    }

    protected IObjectValue createNewData() {
        TimeDepositApplyInfo info = new TimeDepositApplyInfo();
        info.setApplyAmount(Constants.ZERO);
        info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setBeginDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setApplyType(ApplyTimeDepositTypeEnum.TIMEDEPOSIT_INNER);
        info.setIsCreatePayment(false);
        info.setRate(Constants.ZERO);
        info.setCreator(this.userInfo);
        info.setCompany(this.company);
        info.setIsTimeDepBank(0);
        info.setIsBalanceBill(0);
        info.setCurrency(this.currencyInfo);
        FMClientHelper.initNumber((CoreBaseInfo)new TimeDepositApplyInfo(), (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        info.setNumber(this.txtNumber.getText().toString());
        info.setBaseRate(Constants.ZERO);
        return info;
    }

    @Override
    protected void prmtSaveingOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSaveingOrg_dataChanged(e);
        this.prmtPayerAccount.setValue(null);
        this.prmtPayeeAccount.setValue(null);
        F7SelectorFactory.initAccountBank((KDBizPromptBox)this.prmtPayerAccount, (BankInfo)((BankInfo)this.prmtSaveingOrg.getValue()), (AccountBankPropertyEnum)AccountBankPropertyEnum.Current);
        F7SelectorFactory.initAccountBank((KDBizPromptBox)this.prmtPayeeAccount, (BankInfo)((BankInfo)this.prmtSaveingOrg.getValue()), (AccountBankPropertyEnum)AccountBankPropertyEnum.Fixed);
    }

    private BigDecimal calcBaseRate() throws EASBizException, BOSException {
        IntRateBaseInfo intRateBase;
        CurrencyInfo currency = (CurrencyInfo)this.comboCurreny.getSelectedItem();
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateTable.getData();
        Date date = DateTimeUtils.truncateDate((Date)this.pkBeginDate.getSqlDate());
        BigDecimal bdBaseRate = new BigDecimal("0.00000");
        if (currency != null && intRateType != null && date != null && (bdBaseRate = (intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), currency.getId().toString(), date)) != null ? intRateBase.getYearRate() : Constants.ZERO).compareTo(Constants.ZERO) < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
            this.kdRate.requestFocus();
            SysUtil.abort();
        }
        return bdBaseRate;
    }

    private void setRateLabelText() {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateTable.getData();
        if (null == intRateType) {
            return;
        }
        if (!intRateType.getRateExpression().getName().equals(IntRateTypeExpressionEnum.YEAR.getName())) {
            this.contBaseRate.setBoundLabelText(this.contBaseRate.getBoundLabelText().replaceAll("%", "\u2030"));
            this.contRate.setBoundLabelText(this.contRate.getBoundLabelText().replaceAll("%", "\u2030"));
        } else {
            this.contBaseRate.setBoundLabelText(this.contBaseRate.getBoundLabelText().replaceAll("\u2030", "%"));
            this.contRate.setBoundLabelText(this.contRate.getBoundLabelText().replaceAll("\u2030", "%"));
        }
    }

    @Override
    protected void prmtIntRateTable_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtIntRateTable_dataChanged(e);
        this.setBaseRateAndRate();
    }

    @Override
    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkBeginDate_dataChanged(e);
        this.setBaseRateAndRate();
    }

    private void setBaseRateAndRate() throws EASBizException, BOSException {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurreny.getSelectedItem();
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateTable.getData();
        Date date = DateTimeUtils.truncateDate((Date)this.pkBeginDate.getSqlDate());
        if (currency != null && intRateType != null && date != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), currency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            if (bdBaseRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.kdRate.requestFocus();
                SysUtil.abort();
            }
            this.kdRate.setValue((Object)bdBaseRate);
            this.kdBaseRate.setValue((Object)bdBaseRate);
            this.setRateLabelText();
        }
    }
}

