/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Date;
import java.util.Set;

public class UnDepositBillFilterParam
implements FilterParam {
    private static final long serialVersionUID = -8927613881776686839L;
    private Date dateFrom;
    private Date dateTo;
    private String sBillType;
    private String currencyId;
    private String bankId;
    private Set companys;

    public Set getCompanys() {
        return this.companys;
    }

    public void setCompanys(Set companys) {
        this.companys = companys;
    }

    public FilterInfo getFilter() {
        FilterInfo fi = new FilterInfo();
        this.addUnDepositFilterItems(fi);
        return fi;
    }

    private void addUnDepositFilterItems(FilterInfo fi) {
        CompanyOrgUnitInfo currencyCompany;
        if (null != this.getDateFrom()) {
            fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)this.getDateFrom(), CompareType.GREATER_EQUALS));
        }
        if (null != this.getDateTo()) {
            fi.getFilterItems().add(new FilterItemInfo("bizDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
        }
        if (null != this.getBillType()) {
            fi.getFilterItems().add(new FilterItemInfo("timeDepositBill.timeDepositType", (Object)this.getBillType().getValue()));
        }
        if (null != this.getCurrency()) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrency().getId()));
        }
        if (null != this.getBank()) {
            fi.getFilterItems().add(new FilterItemInfo("bank.id", (Object)this.getBank().getId()));
        }
        if ((currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany()).isIsUnion()) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanys(), CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)currencyCompany.getId().toString(), CompareType.INCLUDE));
        }
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public BankInfo getBank() {
        if (this.bankId != null) {
            BankInfo info = new BankInfo();
            try {
                info = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(this.bankId));
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return info;
        }
        return null;
    }

    public void setBank(BankInfo bank) {
        this.bankId = bank == null ? null : bank.getId().toString();
    }

    public TimeDepositTypeEnum getBillType() {
        return TimeDepositTypeEnum.getEnum(this.sBillType);
    }

    public void setBillType(TimeDepositTypeEnum billType) {
        this.sBillType = billType == null ? null : billType.getValue();
    }

    public CurrencyInfo getCurrency() {
        if (this.currencyId != null) {
            CurrencyInfo info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)this.currencyId));
            return info;
        }
        return null;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currencyId = currency == null ? null : currency.getId().toString();
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }
}

