/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.fm.td.client.AbstractUnTimeDepositApplyBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UnTimeDepositApplyBillEditUI
extends AbstractUnTimeDepositApplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(UnTimeDepositApplyBillEditUI.class);
    private boolean loadingFields = false;
    private boolean settingStatus = false;
    private Date btunDepositDate = null;

    @Override
    public void loadFields() {
        this.loadingFields = true;
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.currency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.unDepositType, (Object)this.editData.getUnDepositType());
        ApplyBillStatusEnum billState = this.editData.getBillState();
        if (ApplyBillStatusEnum.SUBMIT == billState) {
            this.actionSave.setVisible(false);
        } else if (ApplyBillStatusEnum.SAVE == billState) {
            this.actionSave.setVisible(true);
        }
        this.loadingFields = false;
    }

    public void setCompState(UnTimeDepositApplyBillInfo info) {
        this.unDepositType.removeAllItems();
        if (TimeDepositTypeEnum.TIMEDEPOSIT_INNER == info.getDepositType()) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
            this.contpayeeAccount.setVisible(false);
            this.prmtpayeeAccount.setRequired(false);
        } else if (TimeDepositTypeEnum.TIMEDEPOSIT_OUTER == info.getDepositType()) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
            this.contpayeeAccount.setVisible(true);
            this.prmtpayeeAccount.setRequired(true);
        } else if (TimeDepositTypeEnum.CALLDEPOSIT_INNER == info.getDepositType()) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
            this.contpayeeAccount.setVisible(false);
            this.prmtpayeeAccount.setRequired(false);
        } else if (TimeDepositTypeEnum.CALLDEPOSIT_OUTER == info.getDepositType()) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
            this.contpayeeAccount.setVisible(true);
            this.prmtpayeeAccount.setRequired(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        this.checkUndepositDate();
        BigDecimal applyAmount = (BigDecimal)this.txtapplyAmount.getValue();
        BigDecimal balance = null;
        String sourceBillID = this.editData.getSourceBillId();
        try {
            if (CompDepositAccountBillFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(sourceBillID))) {
                CompDepositAccountBillInfo compDepAccInfo = CompDepositAccountBillFactory.getRemoteInstance().getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID));
                balance = compDepAccInfo.getBalance();
            }
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        if (balance != null && applyAmount.compareTo(balance) > 0) {
            throw new TDException(TDException.APPLYAMOUNT_BIG_BALANCE);
        }
    }

    private void checkUndepositDate() throws TDException {
        Date unDepositDate;
        Date applyDate = (Date)this.pkBizDate.getValue();
        if (applyDate.compareTo(unDepositDate = (Date)this.pkunDepositDate.getValue()) > 0) {
            throw new TDException(TDException.APPLY_BIG_UNDEPOSIT);
        }
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FMClientHelper.initComboCurrency((KDComboBox)this.currency, (boolean)true);
        F7SelectorFactory.initPayerAccount((IUIObject)this, (KDBizPromptBox)this.prmtpayeeAccount, (CompanyOrgUnitInfo)this.currentCompany);
        this.txtapplyAmount.setHorizontalAlignment(4);
        FMClientHelper.initSpComponents((KDComboBox)this.currency, (KDFormattedTextField)this.txtapplyAmount, null, null, (CurrencyInfo)FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany), (KDDatePicker)this.pkBizDate, (CompanyOrgUnitInfo)this.currentCompany);
        this.txtapplyAmount.setRemoveingZeroInDispaly(false);
        this.txtNumber.setRequired(false);
        super.onLoad();
        if (this.currentCompany == null || !this.currentCompany.isIsBizUnit()) {
            this.menuItemTraceUp.setEnabled(false);
            this.menuItemTraceDown.setEnabled(false);
        }
        if (this.editData.getUnDepositDate() != null && this.btunDepositDate == null) {
            this.btunDepositDate = this.editData.getUnDepositDate();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setCurrency((CurrencyInfo)this.currency.getSelectedItem());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (ApplyBillStatusEnum.SAVE.equals((Object)this.editData.getBillState())) {
            this.actionSave.setVisible(true);
            this.actionSubmit.setVisible(true);
        } else if (ApplyBillStatusEnum.SUBMIT.equals((Object)this.editData.getBillState())) {
            this.actionSave.setVisible(false);
            this.actionSubmit.setVisible(true);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"unTimeDepositApplyBillEditOrDel"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getSourceBillId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"mustCreateFromCompUnTmDepBill"));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getSourceBillId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.client.TdResource", (String)"mustCreateFromCompUnTmDepBill"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return UnTimeDepositApplyBillFactory.getRemoteInstance();
    }

    protected void initDataStatus() {
        this.settingStatus = true;
        super.initDataStatus();
        UnTimeDepositApplyBillInfo info = (UnTimeDepositApplyBillInfo)this.getDataObject();
        this.setCompState(info);
        this.unDepositType.setSelectedItem((Object)info.getUnDepositType());
        String srcBillID = info.getSourceBillId();
        if (!FMHelper.isEmpty((String)srcBillID) && FMHelper.isInstanceof((String)srcBillID, TimeDepositBillInfo.class)) {
            this.depositType.setEnabled(false);
        } else {
            this.depositType.setEnabled(true);
        }
        this.settingStatus = false;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1 && OprtState.ADDNEW.equals(this.getOprtState())) {
            UnTimeDepositApplyBillInfo info = (UnTimeDepositApplyBillInfo)dataObject;
            if (TimeDepositTypeEnum.TIMEDEPOSIT_INNER == info.getDepositType() || TimeDepositTypeEnum.TIMEDEPOSIT_OUTER == info.getDepositType()) {
                info.setUnDepositType(UnDepositTypeEnum.MATURE_UNDEPOSIT);
            } else if (TimeDepositTypeEnum.CALLDEPOSIT_INNER == info.getDepositType() || TimeDepositTypeEnum.CALLDEPOSIT_OUTER == info.getDepositType()) {
                info.setUnDepositType(UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            }
            info.setCompany(this.currentCompany);
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        UnTimeDepositApplyBillInfo info = new UnTimeDepositApplyBillInfo();
        info.setCompany(this.currentCompany);
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setIsCreCmpUnTmDep(false);
        try {
            info.setCurrency(FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        info.setDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
        info.setUnDepositType(UnDepositTypeEnum.MATURE_UNDEPOSIT);
        info.setIsGenUnTDBill(false);
        return info;
    }

    @Override
    protected void unDepositType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.loadingFields && !this.settingStatus) {
            super.unDepositType_itemStateChanged(e);
            KDComboBox kdComboBox = (KDComboBox)e.getSource();
            UnDepositTypeEnum unDepositType = (UnDepositTypeEnum)kdComboBox.getSelectedItem();
            if (UnDepositTypeEnum.MATURE_UNDEPOSIT == unDepositType || UnDepositTypeEnum.CONSULT_UNDEPOSIT == unDepositType) {
                this.txtapplyAmount.setEnabled(false);
            } else if (UnDepositTypeEnum.AHEAD_UNDEPOSIT == unDepositType || UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT == unDepositType) {
                this.txtapplyAmount.setEnabled(true);
            }
            if (UnDepositTypeEnum.AHEAD_UNDEPOSIT == unDepositType) {
                this.pkunDepositDate.setValue(this.pkBizDate.getValue());
            }
            if (UnDepositTypeEnum.MATURE_UNDEPOSIT == unDepositType && this.btunDepositDate != null) {
                this.pkunDepositDate.setValue((Object)this.btunDepositDate);
            }
        }
    }

    @Override
    protected void depositType_itemStateChanged(ItemEvent e) throws Exception {
        TimeDepositTypeEnum depositType = (TimeDepositTypeEnum)e.getItem();
        this.unDepositType.removeAllItems();
        if (TimeDepositTypeEnum.TIMEDEPOSIT_INNER == depositType) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
            this.contpayeeAccount.setVisible(false);
            this.prmtpayeeAccount.setRequired(false);
            this.prmtpayeeAccount.setData(null);
        } else if (TimeDepositTypeEnum.TIMEDEPOSIT_OUTER == depositType) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
            this.contpayeeAccount.setVisible(true);
            this.prmtpayeeAccount.setRequired(true);
            this.prmtpayeeAccount.setData(null);
        } else if (TimeDepositTypeEnum.CALLDEPOSIT_INNER == depositType) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
            this.contpayeeAccount.setVisible(false);
            this.prmtpayeeAccount.setRequired(false);
            this.prmtpayeeAccount.setData(null);
        } else if (TimeDepositTypeEnum.CALLDEPOSIT_OUTER == depositType) {
            this.unDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            this.unDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
            this.contpayeeAccount.setVisible(true);
            this.prmtpayeeAccount.setRequired(true);
            this.prmtpayeeAccount.setData(null);
        }
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("isCreCmpUnTmDep"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        return sic;
    }

    protected boolean isPerTitleAuto() {
        return false;
    }

    @Override
    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.btunDepositDate = null;
        HashMap<String, String> ctx = new HashMap<String, String>();
        this.getBOTPCreateFromListUIClassName(this.getEntityBOSType());
        ctx.put("FROME", "UnTimeDepositApplyBill");
        ctx.put("COMPANYID", ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        this.getBillEdit().createFrom(null, ctx);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    @Override
    protected String getTDFileName() {
        return "/fm/invest/td/undepositapply";
    }
}

