/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.td.IUnTimeDepositBill;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.client.AbstractUnTimeDepositBillListUI;
import com.kingdee.eas.fm.td.client.ChooseCompUnDepositUI;
import com.kingdee.eas.fm.td.client.UnDepositBillFilterParam;
import com.kingdee.eas.fm.td.client.UnDepositDataProvider;
import com.kingdee.eas.fm.td.client.UnTimeDepositBillEditUI;
import com.kingdee.eas.fm.td.client.UnTimeDepositBillFilterUI;
import com.kingdee.eas.fm.td.client.UnTimeDepositQueryProcessor;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UnTimeDepositBillListUI
extends AbstractUnTimeDepositBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(UnTimeDepositBillListUI.class);
    private UnTimeDepositBillFilterUI filterUI;
    private CompanyOrgUnitInfo companyInfo;
    FillListener fillListener = new FillListener();
    private static final String UNTIMEDEPOSITBILL_FILENAME = "/FM/INVEST/TD/UNDEPOSIT";

    public UnTimeDepositBillListUI() throws Exception {
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    @Override
    protected String getEditUIName() {
        return UnTimeDepositBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return UnTimeDepositBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new UnTimeDepositBillFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new UnTimeDepositQueryProcessor();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.companyInfo);
        super.onLoad();
        this.tblMain.getColumn("unDepositDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    @Override
    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 1;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionReceiveCompUnDeposit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    private void initControls() {
        this.actionAddHistoryUnDeposit.setEnabled(false);
        this.actionAddHistoryUnDeposit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeDeleted();
        super.actionRemove_actionPerformed(e);
    }

    private void checkCanBeDeleted() throws Exception {
        UnTimeDepositBillInfo info = this.getSelectObject();
        this.condition1(info);
        this.condition2(info);
        this.condition3(info);
    }

    private void condition3(UnTimeDepositBillInfo info) throws TDException {
        if (info.getTimeDepositBill().isIsReDeposited()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC4);
        }
    }

    private void condition1(UnTimeDepositBillInfo info) throws Exception {
        if (info.getTimeDepositBill().isIsReDeposited()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC1);
        }
    }

    private void condition2(UnTimeDepositBillInfo info) throws TDException {
        if (info.isFivouchered()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC2);
        }
        int maxSeqNo = this.getMaxSeqNo(info.getTimeDepositBill().getId().toString());
        int deletedSeqNo = info.getUnTimeDepositSeqNo();
        if (deletedSeqNo != maxSeqNo) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC3);
        }
    }

    @Override
    public void actionAddHistoryUnDeposit_actionPerformed(ActionEvent e) throws Exception {
        TimeDepositHelper.getInstance().showUnDeopsitHisWindow(this, this.getSelectedKeyValue(), 1);
    }

    private int getMaxSeqNo(String id) {
        int maxSeqNo = 0;
        try {
            Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(id));
            Integer maxSeqInteger = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
            maxSeqNo = maxSeqInteger;
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return maxSeqNo;
    }

    protected void execQuery() {
        if (this.getUIContext().get("NewUnTimeDepositID") != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK((String)this.getUIContext().get("NewUnTimeDepositID")), CompareType.EQUALS));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private UnTimeDepositBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        UnTimeDepositBillInfo info = ((IUnTimeDepositBill)this.getBizInterface()).getUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getSelectors());
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timeDepositBill.isReDeposited"));
        return sic;
    }

    @Override
    public void actionReceiveCompUnDeposit_actionPerformed(ActionEvent e) throws Exception {
        Map hm = ChooseCompUnDepositUI.showChooseUnCompDepositUI((CoreUI)this);
        if (hm == null) {
            SysUtil.abort();
        } else {
            Set setIDs = (Set)hm.get("receivedBillId");
            if (setIDs != null) {
                String includeValue = TimeDepositHelper.getInstance().parseValue(setIDs);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
                this.mainQuery.setFilter(filter);
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        UnDepositDataProvider data = new UnDepositDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(UNTIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        UnDepositDataProvider data = new UnDepositDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(UNTIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            UnDepositBillFilterParam param = (UnDepositBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrency());
            String[] columns = new SumFiledsInfo(SumBillEnum.UnTimeDep).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove"};
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionVoucher_actionPerformed(e);
        }
        catch (Exception ex) {
            if (ex instanceof BOTPException && "802".equals(((BOTPException)ex).getSubCode())) {
                throw new TDException(TDException.UNTIMEBILLNOMAPPING);
            }
            throw ex;
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(UnTimeDepositBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                String currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"undepositAmt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"undepositAmtTotal", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"deIntamt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"curIntAmt", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"intSum", (String)currencyId);
                }
                this.setAmtCellNumberFormat(row);
            }
        }

        private void setNumberFormat(IRow row, String columnKey, int precision) {
            String formatString = "%r-[ ]0." + precision + "n";
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            styleAttributes.setNumberFormat(formatString);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row) {
            this.setNumberFormat(row, "exchange", 5);
            this.setNumberFormat(row, "yearRate", 5);
        }
    }
}

