/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.client.HRBaseClientUtils;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import java.util.Map;

public class AffairXinDianHandler {
    private KDTable kdtEntrys;
    private String adminKey;
    private String positionKey = null;
    private String xinDianKey = null;
    private boolean isHide = true;
    private Map positionHrMap = new HashMap();
    protected PlugInUIParam ctx = null;

    public AffairXinDianHandler(KDTable kdtEntrys, String xinDian) {
        this.kdtEntrys = kdtEntrys;
        this.xinDianKey = xinDian;
    }

    private String getPositionHrIDByAdminID(String adminId) {
        if (this.positionHrMap.containsKey(adminId)) {
            return (String)this.positionHrMap.get(adminId);
        }
        String hrID = null;
        HROrgUnitInfo hrOrgUnitInfo = null;
        try {
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)adminId));
            hrOrgUnitInfo = HRUtilExtend.getAdminOrgOfHRO(null, (AdminOrgUnitInfo)orgInfo);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (hrOrgUnitInfo != null) {
            hrID = hrOrgUnitInfo.getId().toString();
            this.positionHrMap.put(adminId, hrID);
        }
        return hrID;
    }

    public void setXinDianEditor() {
        IRow row = null;
        if (this.kdtEntrys.getColumn(this.xinDianKey) == null || this.kdtEntrys.getColumn(this.adminKey) == null) {
            return;
        }
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            if (this.kdtEntrys.getColumn(this.xinDianKey).getStyleAttributes().isHided() || row.getCell(this.adminKey).getValue() == null) continue;
            this.setXinDianEditor(i, (AdminOrgUnitInfo)row.getCell("adminOrg").getValue());
        }
    }

    public void setXinDianEditor(IRow row, AdminOrgUnitInfo admin) {
        if (this.kdtEntrys.getColumn(this.xinDianKey) == null) {
            return;
        }
        if (admin == null) {
            this.setXinDianEditorAndCellStyle(row, null, null);
            return;
        }
        String hrOrgID = this.getPositionHrIDByAdminID(admin.getId().toString());
        if (hrOrgID != null) {
            this.setXinDianEditorAndCellStyle(row, this.getSalaryPointEditor(hrOrgID), hrOrgID);
        } else {
            this.setXinDianEditorAndCellStyle(row, null, null);
        }
    }

    public void setXinDianEditor(int rowIndex, AdminOrgUnitInfo admin) {
        IRow row = this.kdtEntrys.getRow(rowIndex);
        this.setXinDianEditor(row, admin);
    }

    private void setXinDianEditorAndCellStyle(IRow row, KDTDefaultCellEditor editor, String hrId) {
        if (editor != null) {
            Object obj = row.getCell(this.xinDianKey).getValue();
            if (obj != null && obj instanceof SalariatHiberPropsInfo) {
                String shid = ((SalariatHiberPropsInfo)obj).getId().toString();
                try {
                    SalariatHiberPropsInfo info = SalariatHiberPropsFactory.getRemoteInstance().getSalariatHiberPropsInfo("select scheme.hrOrgUnit.id where id='" + shid + "'");
                    if (!info.getScheme().getHrOrgUnit().getId().toString().equals(hrId)) {
                        row.getCell(this.xinDianKey).setValue(null);
                    }
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            row.getCell(this.xinDianKey).setEditor((ICellEditor)editor);
            row.getCell(this.xinDianKey).getStyleAttributes().setLocked(false);
        } else {
            row.getCell(this.xinDianKey).setValue(null);
            row.getCell(this.xinDianKey).setEditor(null);
            row.getCell(this.xinDianKey).getStyleAttributes().setLocked(true);
        }
    }

    public KDTDefaultCellEditor getSalaryPointEditor(String hrID) {
        return HRBaseClientUtils.getSalaryPointEditor((String)hrID, (HROrgUnitInfo)((HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO)));
    }

    public void hideXinDian() {
    }

    public void hideXinDianByParam(String hroId) {
        if (this.kdtEntrys.getColumn(this.xinDianKey) == null) {
            return;
        }
        boolean paramValue = false;
        try {
            paramValue = HRParamUtil.getParamOfHR(null, (String)"hr_cmp_013", (String)hroId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (paramValue) {
            this.kdtEntrys.getColumn(this.xinDianKey).getStyleAttributes().setHided(false);
        } else {
            this.kdtEntrys.getColumn(this.xinDianKey).getStyleAttributes().setHided(true);
        }
    }

    public boolean isCanCopyXinDian(boolean isSingleSelect) {
        if (this.kdtEntrys.getColumn(this.xinDianKey) == null || this.kdtEntrys.getColumn(this.adminKey) == null) {
            return true;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntrys.getSelectManager().size();
        if (size <= 0) {
            return false;
        }
        sb = this.kdtEntrys.getSelectManager().get(0);
        int rowBegin = sb.getTop();
        int column = sb.getLeft();
        int adminOrgIndex = this.kdtEntrys.getColumnIndex(this.adminKey);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        if (column != this.kdtEntrys.getColumnIndex(this.xinDianKey)) {
            return true;
        }
        AdminOrgUnitInfo beginAdminOrg = (AdminOrgUnitInfo)this.kdtEntrys.getCell(rowBegin, adminOrgIndex).getValue();
        if (beginAdminOrg == null) {
            return false;
        }
        AdminOrgUnitInfo ctInfo = null;
        if (!isSingleSelect) {
            int rowCount = this.kdtEntrys.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ctInfo = (AdminOrgUnitInfo)this.kdtEntrys.getCell(i, adminOrgIndex).getValue();
                if (ctInfo != null && this.getPositionHrIDByAdminID(ctInfo.getId().toString()).equals(this.getPositionHrIDByAdminID(beginAdminOrg.getId().toString()))) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"94_copy_error"));
                return false;
            }
        } else {
            for (int i = 0; i < rows.length; ++i) {
                ctInfo = (AdminOrgUnitInfo)this.kdtEntrys.getCell(rows[i], adminOrgIndex).getValue();
                if (ctInfo != null && this.getPositionHrIDByAdminID(ctInfo.getId().toString()).equals(this.getPositionHrIDByAdminID(beginAdminOrg.getId().toString()))) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"94_copy_error"));
                return false;
            }
        }
        return true;
    }

    public String getAdminKey() {
        return this.adminKey;
    }

    public void setAdminKey(String adminKey) {
        this.adminKey = adminKey;
    }

    public String getPositionKey() {
        return this.positionKey;
    }

    public void setPositionKey(String positionKey) {
        this.positionKey = positionKey;
    }

    public void setCtx(PlugInUIParam ctx) {
        this.ctx = ctx;
    }
}

