/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.client.EmpEnrollBizBillEditUI;
import com.kingdee.eas.hr.affair.client.EmployeeInfoUI;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.affair.client.HRAffairBizBillEditUI;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.DimissionReasonInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.client.CodingRuleManager;
import com.kingdee.eas.hr.base.client.HRBaseClientUtils;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.apache.log4j.Logger;

public class EmpEnrollBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    private IDetailPanelListener addListener = null;
    private final String IDCARDNUMBER = "IDCardNo";
    private final String PASSPORTNUMBER = "passportNo";
    private boolean isNeedCheckReEnroll = false;
    private boolean isPersonNumberEditable = true;
    private boolean isIDCardVerify = true;
    Logger logger = Logger.getLogger(EmpEnrollBizBillEditUIBiz.class);
    private int isParPersonColumnIndex = -1;
    private int xinDianColumnIndex = -1;

    @Override
    public void beforeOnLoad() throws Exception {
        this.isIDCardVerify = this.initIDcardVerify();
        super.beforeOnLoad();
    }

    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        ICellEditor txtEditor = EditorCreator.getTextCellEditor((int)80);
        this.kdtEntrys.getColumn("empNumber").setEditor(txtEditor);
        this.kdtEntrys.getColumn("empName").setEditor(txtEditor);
        KDTextField textField = new KDTextField();
        ((AbstractDocument)textField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet attr) throws BadLocationException {
                fb.insertString(offset, str.toUpperCase(), attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                fb.replace(offset, length, text.toUpperCase(), attrs);
            }
        });
        this.kdtEntrys.getColumn("IDCardNo").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kdtEntrys.getColumn("passportNo").setEditor(txtEditor);
        this.kdtEntrys.getColumn("birthday").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("birthday").getStyleAttributes().setNumberFormat("yyyy-mm-dd");
        this.kdtEntrys.getColumn("enrollDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("enrollDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd");
        this.kdtEntrys.getColumn("probation").setEditor(EditorCreator.getNumberCellEditor((int)3, (int)0, (int)1));
        this.kdtEntrys.getColumn("probation").getStyleAttributes().setNumberFormat(EditorCreator.getIntFormatStr());
        this.kdtEntrys.getColumn("probation").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public IDetailPanelListener getAddLineListener() {
        if (this.addListener == null) {
            this.addListener = new IDetailPanelListener(){

                public void beforeEvent(DetailPanelEvent event) throws Exception {
                    EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)event.getObjectValue();
                    if (entryInfo.getId() == null) {
                        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    }
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                    ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstance();
                    CodingRuleManager personRule = new CodingRuleManager(EmpEnrollBizBillEditUIBiz.this.kdtEntrys.getColumn("empNumber"), (IObjectValue)personInfo, icrmFacade);
                    ((HRAffairBizBillEditUI)((Object)EmpEnrollBizBillEditUIBiz.this.ctx.get("CoreUIObject"))).setDefaultBizDefine(entryInfo);
                    entryInfo.setEmpNumber(personRule.apply());
                }

                public void afterEvent(DetailPanelEvent event) throws Exception {
                    if (!EmpEnrollBizBillEditUIBiz.this.kdtEntrys.getColumn("isParPerson").getStyleAttributes().isHided()) {
                        int j = EmpEnrollBizBillEditUIBiz.this.kdtEntrys.getRowCount();
                        for (int i = 0; i < j; ++i) {
                            EmpEnrollBizBillEditUIBiz.this.kdtEntrys.getRow(i).getCell("isParPerson").setValue((Object)Boolean.TRUE);
                        }
                    }
                }
            };
        }
        return this.addListener;
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
        this.isNeedCheckReEnroll = true;
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected List getProcessedPersons(List persons, String billID) throws Exception {
        return persons;
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    @Override
    public void initDataStatus() throws Exception {
        super.initDataStatus();
        this.kdtEntrys.getColumn("empNumber").getStyleAttributes().setLocked(!this.isPersonNumberEditable);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrgInfo == null) {
            throw new AffairBizException(AffairBizException.CURRENT_NO_HRINFO);
        }
        IPermission per = PermissionFactory.getRemoteInstance();
        FieldPermission fields = per.getFieldPermission(BOSObjectType.create((String)"B41CAA3F"), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(hrOrgInfo.getId()));
        IColumn col = this.kdtEntrys.getColumn(this.getJobLevelCol());
        FieldAccessInfo accessInfo = fields.getFieldAccessInfo("entrys.jobLevel");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
        col = this.kdtEntrys.getColumn(this.getJobGradeCol());
        accessInfo = fields.getFieldAccessInfo("entrys.jobGrade");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) throws Exception {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            IRow row;
            PersonInfo personInfo = new PersonInfo();
            personInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstance();
            PersonInfo person = new PersonInfo();
            if (OprtState.ADDNEW.equals(this.ctx.getOprtState())) {
                row = null;
                CodingRuleManager personRule = null;
                int size = this.kdtEntrys.getRowCount();
                for (int i = 0; i < size; ++i) {
                    row = this.kdtEntrys.getRow(i);
                    personRule = new CodingRuleManager(row.getCell("empNumber"), (IObjectValue)person, icrmFacade);
                    personRule.apply();
                    this.isPersonNumberEditable = personRule.isModifable();
                }
                EmpEnrollBizBillInfo info = (EmpEnrollBizBillInfo)this.ctx.getEditData();
                info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                if (!StringUtils.isEmpty((String)info.getEnrollFromOthers()) && size <= 0) {
                    this.isPersonNumberEditable = icrmFacade.isModifiable((IObjectValue)person, null);
                    this.kdtEntrys.getColumn("empNumber").getStyleAttributes().setLocked(!this.isPersonNumberEditable);
                    if (!this.isPersonNumberEditable) {
                        this.kdtEntrys.getColumn("empNumber").getStyleAttributes().setBackground(CodingRuleManager.DISABLE_FIELD_COLOR);
                    }
                }
            } else if (OprtState.EDIT.equals(this.ctx.getOprtState()) || OprtState.VIEW.equals(this.ctx.getOprtState())) {
                this.isPersonNumberEditable = icrmFacade.isModifiable((IObjectValue)person, null);
                this.kdtEntrys.getColumn("empNumber").getStyleAttributes().setLocked(!this.isPersonNumberEditable);
            }
            row = null;
            int count = this.kdtEntrys.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.kdtEntrys.getRow(i);
                row.getCell("position").setValue(null);
            }
        }
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"empNumber", "empName", "gender", "position", "enrollDate", "bizDate", "empType", "hrBizDefine", "actionReason"};
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"empNumber", "IDCardNo", "passportNo"};
    }

    @Override
    public void beforeStoreField(ActionEvent e) throws Exception {
        super.beforeStoreField(e);
        IRow row = null;
        String idCard = null;
        String passport = null;
        String empName = null;
        String personNum = null;
        boolean enrollAgain = false;
        String enrollAgainPersonID = null;
        int colIndex = 0;
        HashMap<String, String> idCardNoMap = new HashMap<String, String>();
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntrys.getRow(i);
            idCard = (String)row.getCell("IDCardNo").getValue();
            passport = (String)row.getCell("passportNo").getValue();
            empName = (String)row.getCell("empName").getValue();
            personNum = (String)row.getCell("empNumber").getValue();
            enrollAgain = row.getCell("enrollAgain").getValue() != null ? (Boolean)row.getCell("enrollAgain").getValue() : false;
            String string = enrollAgainPersonID = row.getCell("existPersonID").getValue() != null ? row.getCell("existPersonID").getValue().toString() : null;
            if (StringUtils.isEmpty((String)empName)) {
                empName = "ROW" + i;
            }
            if (StringUtils.isEmpty((String)idCard) && StringUtils.isEmpty((String)passport)) {
                colIndex = row.getCell("IDCardNo").getColumnIndex();
                this.kdtEntrys.getSelectManager().select(i, colIndex);
                throw new EmployeeException(EmployeeException.BOTH_NO_NOT_ALL_NULL, new Object[]{empName});
            }
            if (!StringUtils.isEmpty((String)idCard)) {
                new IDCardCommonUtil(idCard, this.isIDCardVerify);
                String HROrgUnitID = this.getPositionHrIDByAdminID(((PositionInfo)row.getCell("adminOrg").getValue()).getId().toString());
                boolean isCheckIDCard18To15 = HRParamUtil.getParamOfHR(null, (String)"IsCheckIDCardNO18To15", (String)HROrgUnitID);
                if (isCheckIDCard18To15 && idCard.length() == 15) {
                    try {
                        idCard = IDCardCommonUtil.IDCardNO15To18((String)idCard);
                    }
                    catch (Exception e1) {
                        this.logger.error((Object)e);
                    }
                }
                if (idCardNoMap.containsKey(idCard)) {
                    throw new AffairBizException(AffairBizException.IDCARD_DUP, new Object[]{empName, idCardNoMap.get(idCard)});
                }
                idCardNoMap.put(idCard, empName);
            }
            ((EmpEnrollBizBillEditUI)this.ctx.getUI()).checkEmpNumber(personNum, enrollAgain, enrollAgainPersonID);
        }
    }

    public void beforeLoadData() {
        this.isNeedCheckReEnroll = false;
    }

    protected boolean IDCardNoOrPassportNoEdit(IRow row, String type, String value) throws Exception {
        HROrgUnitInfo hrOrg;
        if (!this.isNeedCheckReEnroll) {
            return true;
        }
        String pType = null;
        if (type.equals("passportNo")) {
            if (value != null && value.length() > 80) {
                throw new BaseException(BaseException.PASSPORT_INVALID);
            }
            pType = "passportNumber";
        }
        IDCardCommonUtil iDCardCommonUtil = null;
        if (type.equals("IDCardNo")) {
            if (value != null) {
                if (value.trim().length() == 0) {
                    row.getCell("IDCardNo").setValue(null);
                } else {
                    iDCardCommonUtil = new IDCardCommonUtil(value, this.isIDCardVerify);
                }
            }
            pType = "idCardNumber";
        }
        if ((hrOrg = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO)) != null) {
            PersonInfo pInfo = PersonFactory.getRemoteInstance().getPersonByStr(value, pType, hrOrg.getId().toString());
            boolean isError = this.enrollAgain(row, type, value, pInfo);
            if (!isError && iDCardCommonUtil != null && iDCardCommonUtil.checkIdCard(row.getCell("IDCardNo").getValue().toString())) {
                try {
                    row.getCell("birthday").setValue((Object)DateTimeUtils.parseDate((String)iDCardCommonUtil.getBirthday(), (String)"yyyy-MM-dd"));
                    row.getCell("gender").setValue((Object)iDCardCommonUtil.getGenders());
                }
                catch (Exception e) {
                    throw new BaseException(BaseException.IDCARD_INVALID);
                }
            }
            return isError;
        }
        return true;
    }

    protected boolean enrollAgain(IRow row, String type, String value, PersonInfo pInfo) throws Exception {
        boolean isError = false;
        if (row == null || StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)value)) {
            return isError;
        }
        String msg = null;
        if (pInfo != null) {
            EmployeeTypeInfo pTypeInfo = pInfo.getEmployeeType();
            int inService = pTypeInfo.getInService().getValue();
            if (inService == 2) {
                DimissionReasonInfo drInfo = (DimissionReasonInfo)pInfo.get("DimissionReasonInfo");
                if (drInfo == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.CAN_ENROLL_AGAIN");
                    if (0 != MsgBox.showConfirm2((Component)this.ctx.getUI(), (String)msg)) {
                        isError = true;
                    }
                } else if (drInfo.isIsPermission()) {
                    msg = type.equals("IDCardNo") ? EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.IDCardNumber_ReasonType") : EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.PassportNumber_ReasonType");
                    MsgBox.showWarning((Component)this.ctx.getUI(), (String)msg);
                    isError = true;
                }
                if (!isError) {
                    IUIWindow empUI = this.createEmpInfoUI(pInfo.getId().toString());
                    empUI.show();
                    boolean isReEnroll = ((EmployeeInfoUI)empUI.getUIObject()).isReEnroll;
                    Object isReEnrollOld = row.getCell("enrollAgain").getValue();
                    row.getCell("enrollAgain").setValue((Object)isReEnroll);
                    row.getCell("existPersonID").setValue((Object)pInfo.getId());
                    if (isReEnroll) {
                        boolean isUseOldNumber = this.showConfirm(EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.Confirm_User_Old_Number"));
                        if (isUseOldNumber) {
                            pInfo.setCU((CtrlUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.ctx.getMainOrgContext(), (OrgType)OrgType.ControlUnit));
                            row.getCell("empNumber").setValue((Object)pInfo.getNumber());
                        }
                        PersonPositionInfo ppInfo = null;
                        if (pInfo.get("PersonPosition") != null) {
                            ppInfo = (PersonPositionInfo)pInfo.get("PersonPosition");
                        }
                        this.fillReEnrollPersonInfo(row, pInfo, ppInfo);
                        row.getCell("isUseOldNumber").setValue((Object)isUseOldNumber);
                        HRBizDefineInfo bizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAApC9TmaL7Z");
                        row.getCell("hrBizDefine").setValue((Object)bizDefineInfo);
                    } else {
                        Object isUserOldNumber;
                        row.getCell(type).setValue(null);
                        if (isReEnrollOld != null && ((Boolean)isReEnrollOld).booleanValue() && (isUserOldNumber = row.getCell("isUseOldNumber").getValue()) != null && ((Boolean)isUserOldNumber).booleanValue()) {
                            PersonInfo person = new PersonInfo();
                            person.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                            ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstance();
                            CodingRuleManager personRule = new CodingRuleManager(row.getCell("empNumber"), (IObjectValue)person, icrmFacade);
                            personRule.apply();
                        }
                        isError = true;
                    }
                }
            } else {
                msg = type.equals("IDCardNo") ? EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.IDCardNumber_EmployeeType") : EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.PassportNumber_EmployeeType");
                MsgBox.showWarning((Component)this.ctx.getUI(), (String)msg);
                isError = true;
            }
        }
        return isError;
    }

    @Override
    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        super.fillRow(row, value, dataRow, copyCol);
    }

    protected void fillReEnrollPersonInfo(IRow row, PersonInfo pInfo, PersonPositionInfo ppInfo) {
        if (row == null || pInfo == null) {
            return;
        }
        row.getCell("empName").setValue((Object)pInfo.getName());
        row.getCell("gender").setValue((Object)pInfo.getGender());
        row.getCell("birthday").setValue((Object)pInfo.getBirthday());
        row.getCell("oldAdminOrg").setValue((Object)ppInfo.getPersonDep());
        row.getCell("oldEmpType").setValue((Object)pInfo.getEmployeeType());
    }

    private IUIWindow createEmpInfoUI(String id) throws Exception {
        UIContext uiCtx = new UIContext((Object)this.ctx.getUIContext());
        uiCtx.put((Object)"ID", (Object)id);
        RealModeIDList idList = new RealModeIDList();
        idList.add(id);
        uiCtx.put((Object)"IDList", (Object)idList);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmployeeInfoUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        return uiWindow;
    }

    private boolean showConfirm(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)this.ctx.getUI(), (String)msg));
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo info) {
        return new EmpEnrollBizBillEntryInfo();
    }

    private boolean initIDcardVerify() throws Exception {
        String paramNum = "IS_IDCARD_VERIFY";
        String hrOrgId = null;
        if (this.ctx.getMainOrgContext() == null) {
            return true;
        }
        HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        if (hrOrg != null) {
            hrOrgId = hrOrg.getId().toString();
        }
        this.isIDCardVerify = HRParamUtil.getParamOfHR(null, (String)paramNum, (String)hrOrgId);
        return this.isIDCardVerify;
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.EmpEnrollBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.EmpEnrollApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/EmpEnroll";
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.EmpEnrollBizBillEditUIFunction";
    }

    @Override
    protected boolean isGetJobGradeByPositionChange() {
        return true;
    }

    @Override
    protected void positionChanged(IRow row, PositionInfo pInfo) throws Exception {
        super.positionChanged(row, pInfo);
    }

    @Override
    protected void hideXinDianByParam(String hroId) throws Exception {
        int j = this.kdtEntrys.getRowCount();
        this.kdtEntrys.getColumn("isParPerson").getStyleAttributes().setHided(false);
        this.kdtEntrys.getColumn("xinDian").getStyleAttributes().setHided(false);
        this.kdtEntrys.getColumn("xinDian").getStyleAttributes().setLocked(false);
        if (this.isParPersonColumnIndex > -1) {
            this.kdtEntrys.moveColumn(this.kdtEntrys.getColumn("isParPerson").getColumnIndex(), this.isParPersonColumnIndex);
        }
        if (this.xinDianColumnIndex > -1) {
            this.kdtEntrys.moveColumn(this.kdtEntrys.getColumn("xinDian").getColumnIndex(), this.xinDianColumnIndex);
        }
        for (int i = 0; i < j; ++i) {
            this.kdtEntrys.getRow(i).getCell("isParPerson").setValue((Object)Boolean.TRUE);
            if (!this.ctx.getOprtState().equals(OprtState.ADDNEW)) continue;
            this.kdtEntrys.getRow(i).getCell("xinDian").setValue(null);
        }
        HROrgUnitInfo hrOrgInfo = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        String hrOrgId = null;
        if (hrOrgInfo != null) {
            hrOrgId = hrOrgInfo.getId().toString();
        }
        this.kdtEntrys.getColumn("xinDian").setEditor((ICellEditor)HRBaseClientUtils.getSalaryPointEditor((String)hrOrgId, (HROrgUnitInfo)hrOrgInfo));
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "false";
    }

    @Override
    public boolean isAddPersonByF7() {
        return false;
    }
}

