/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.affair.client.AbstractHRAffairFilterUI;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class HRAffairFilterUI
extends AbstractHRAffairFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(HRAffairFilterUI.class);
    private String affairName;
    private String classResource = "com.kingdee.eas.hr.affair.ClassResource.";

    public HRAffairFilterUI(String affairName) throws Exception {
        this.affairName = affairName;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    public void clear() {
        super.clear();
        this.prmtOrg.setValue(null);
        this.prmtEmp.setValue(null);
        this.prmtPosition.setValue(null);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkShowSealUp.setSelected(false);
        this.chkIsSearch.setSelected(false);
        this.chkIsSearch.setEnabled(false);
        this.txFiledPerson.setEnabled(false);
        this.txFiledPerson.setVisible(false);
        this.kdradioOrg.setSelected(true);
        this.chkIsIncludeOrg.setEnabled(true);
        this.setSelect("org");
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtOrg);
        AdminByOrgRangePromptBox admin = (AdminByOrgRangePromptBox)this.prmtOrg.getSelector();
        admin.setIncludeSealUp("true");
        admin.showChkSealUp(true);
        register.registerPositionPromptBox2(this.prmtPosition, true);
        PositionPromptBox2 position = (PositionPromptBox2)this.prmtPosition.getSelector();
        position.showChkSealUp(true);
        position.setSealUp("true");
        register.registerEmployeeMultiF7PromptBox(this.prmtEmp, true);
    }

    private void initAllEditor() {
        this.chkIsSearch.setEnabled(false);
        this.txFiledPerson.setEditable(false);
        this.clear();
        this.kdradioOrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRAffairFilterUI.this.setSelect("org");
            }
        });
        this.kdRadioEmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRAffairFilterUI.this.setSelect("emp");
            }
        });
        this.kdRadioPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRAffairFilterUI.this.setSelect("position");
            }
        });
        this.chkIsSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRAffairFilterUI.this.setSearchType();
            }
        });
    }

    private void setSelect(String selectType) {
        if ("org".equals(selectType) && this.kdradioOrg.isSelected()) {
            this.prmtOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.chkShowSealUp.setEnabled(true);
            this.prmtEmp.setData(null);
            this.prmtEmp.setEnabled(false);
            this.prmtEmp.setVisible(true);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
        if ("emp".equals(selectType) && this.kdRadioEmp.isSelected()) {
            this.prmtEmp.setEnabled(true);
            this.prmtEmp.setVisible(true);
            this.prmtOrg.setData(null);
            this.prmtOrg.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.chkShowSealUp.setSelected(false);
            this.chkShowSealUp.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
        if ("position".equals(selectType) && this.kdRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtOrg.setData(null);
            this.prmtOrg.setEnabled(false);
            this.prmtEmp.setData(null);
            this.prmtEmp.setEnabled(false);
            this.prmtEmp.setVisible(true);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.chkShowSealUp.setSelected(false);
            this.chkShowSealUp.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
    }

    private void setSearchType() {
        if (this.chkIsSearch.isSelected()) {
            this.prmtEmp.setValue(null);
            this.prmtEmp.setEnabled(false);
            this.prmtEmp.setVisible(false);
            this.txFiledPerson.setEnabled(true);
            this.txFiledPerson.setEditable(true);
            this.txFiledPerson.setVisible(true);
        } else {
            this.prmtEmp.setEnabled(true);
            this.prmtEmp.setVisible(true);
            this.txFiledPerson.setEditable(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
    }

    public CustomerParams getCustomerParams() {
        PositionInfo position;
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        cp.putBoolean(this.kdradioOrg.getName(), this.kdradioOrg.isSelected());
        cp.putBoolean(this.kdRadioEmp.getName(), this.kdRadioEmp.isSelected());
        cp.putBoolean(this.kdRadioPosition.getName(), this.kdRadioPosition.isSelected());
        cp.putBoolean(this.chkIsIncludeOrg.getName(), this.chkIsIncludeOrg.isSelected());
        cp.putBoolean(this.chkShowSealUp.getName(), this.chkShowSealUp.isSelected());
        cp.putBoolean(this.chkIsSearch.getName(), this.chkIsSearch.isSelected());
        AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)this.prmtOrg.getData();
        if (adminOrg != null) {
            cp.addCustomerParam(this.prmtOrg.getName(), adminOrg.getId().toString());
        }
        if ((position = (PositionInfo)this.prmtPosition.getData()) != null) {
            cp.addCustomerParam(this.prmtPosition.getName(), position.getId().toString());
        }
        if (this.chkIsSearch.isSelected()) {
            cp.addCustomerParam(this.prmtEmp.getName(), this.txFiledPerson.getText());
        } else {
            PersonInfo person = (PersonInfo)this.prmtEmp.getData();
            if (person != null) {
                cp.addCustomerParam(this.prmtEmp.getName(), person.getId().toString());
            }
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        String positionId;
        String orgId;
        if (cp == null) {
            return;
        }
        super.setCustomerParams(cp);
        this.kdradioOrg.setSelected(cp.getBoolean(this.kdradioOrg.getName()));
        this.kdRadioEmp.setSelected(cp.getBoolean(this.kdRadioEmp.getName()));
        this.kdRadioPosition.setSelected(cp.getBoolean(this.kdRadioPosition.getName()));
        this.chkIsIncludeOrg.setSelected(cp.getBoolean(this.chkIsIncludeOrg.getName()));
        this.chkShowSealUp.setSelected(cp.getBoolean(this.chkShowSealUp.getName()));
        this.chkIsSearch.setSelected(cp.getBoolean(this.chkIsSearch.getName()));
        if (this.kdradioOrg.isSelected()) {
            this.setSelect("org");
        }
        if (this.kdRadioEmp.isSelected()) {
            this.setSelect("emp");
        }
        if (this.kdRadioPosition.isSelected()) {
            this.setSelect("position");
        }
        if ((orgId = cp.getCustomerParam(this.prmtOrg.getName())) != null) {
            try {
                AdminOrgUnitInfo adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                this.prmtOrg.setData((Object)adminOrg);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        }
        if ((positionId = cp.getCustomerParam(this.prmtPosition.getName())) != null) {
            try {
                PositionInfo position = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
                this.prmtPosition.setData((Object)position);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        }
        if (cp.getBoolean(this.chkIsSearch.getName())) {
            String personNumberOrName = cp.getCustomerParam(this.prmtEmp.getName());
            this.txFiledPerson.setText(personNumberOrName);
        } else {
            String personId = cp.getCustomerParam(this.prmtEmp.getName());
            if (personId != null) {
                try {
                    PersonInfo person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                    this.prmtEmp.setData((Object)person);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
            }
        }
    }

    public FilterInfo getFilterInfo() {
        PositionInfo positionInfo;
        FilterInfo filter = new FilterInfo();
        if (this.kdRadioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null && this.affairName != null) {
            if (this.affairName.equals(EASResource.getString((String)(this.classResource + "EnrollBillListUI")))) {
                filter.getFilterItems().add(new FilterItemInfo("entries.position.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
            }
            if (this.affairName.equals(EASResource.getString((String)(this.classResource + "HireBillListUI")))) {
                filter.getFilterItems().add(new FilterItemInfo("entries.eposition.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
            }
            if (this.affairName.equals(EASResource.getString((String)(this.classResource + "FluctuationBillListUI")))) {
                filter.getFilterItems().add(new FilterItemInfo("entries.oldPosition.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
            }
            if (this.affairName.equals(EASResource.getString((String)(this.classResource + "ResignBillListUI")))) {
                filter.getFilterItems().add(new FilterItemInfo("entries.eposition.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
            }
            if (this.affairName.equals(EASResource.getString((String)(this.classResource + "RetireBillListUI")))) {
                filter.getFilterItems().add(new FilterItemInfo("entries.eposition.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
            }
            if (this.affairName.equals(EASResource.getString((String)(this.classResource + "FireBillListUI")))) {
                filter.getFilterItems().add(new FilterItemInfo("entries.eposition.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
            }
        }
        if (this.kdRadioEmp.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String personNumberOrName = this.txFiledPerson.getText();
                if (personNumberOrName != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entries.person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("entries.person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                    filter.setMaskString("#0 or #1");
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtEmp.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entries.person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kdradioOrg.isSelected()) {
            AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.prmtOrg.getData();
            if (orgUnit != null) {
                if (this.chkIsIncludeOrg.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                }
            }
            if (!this.chkShowSealUp.isSelected()) {
                FilterInfo sealUpFi = new FilterInfo();
                sealUpFi.getFilterItems().add(new FilterItemInfo("adminOrg.isSealUp", (Object)Boolean.FALSE));
                try {
                    filter.mergeFilter(sealUpFi, "and");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        return filter;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }
}

