/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.client.AbstractHRAffairQueryFilterUI;
import com.kingdee.eas.hr.base.FluctuationTypeCollection;
import com.kingdee.eas.hr.base.FluctuationTypeFactory;
import com.kingdee.eas.hr.base.FluctuationTypeInfo;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class HRAffairQueryFilterUI
extends AbstractHRAffairQueryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(HRAffairQueryFilterUI.class);
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String BTNORG_CP = "btnOrg";
    public static final String CHKISINCLUDEORG_CP = "chkIsIncludeOrg";
    public static final String PRMTORG_CP = "prmtOrg";
    public static final String BTNPOS_CP = "btnPos";
    public static final String PRMTPOSITION_CP = "prmtPosition";
    public static final String BTNEMP_CP = "btnEmp";
    public static final String PRMTEMP_CP = "prmtEmp";
    public static final String COMBAFFAIRTYPE_CP = "combAffairType";
    public static final String TXTNUMBER_CP = "txtNumber";
    public static final String PRMTPROPOSER_CP = "prmtProposer";
    public static final String PICKERAPPLYDATESTART_CP = "pickerApplyDateStart";
    public static final String PICKERAPPLYDATEEND_CP = "pickerApplyDateEnd";
    public static final String PICKEREFFECTDATESTART_CP = "pickerEffectDateStart";
    public static final String PICKEREFFECTDATEEND_CP = "pickerEffectDateEnd";
    public static final String COMBAPPROVESTATE_CP = "combApproveState";
    public static final String COMBFLUCTUATIONTYPE_CP = "combFluctuationType";
    public static final String DISPATCHNUM_CP = "dispatchNum";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(CtrlFormatUtilities.getDateFormatString());

    public HRAffairQueryFilterUI() throws Exception {
        this.initControl();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private String getCurrentHROID() {
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OUResource", (String)"NO_HRO_EXISTS"));
            throw new AbortException();
        }
        return SysContext.getSysContext().getCurrentHRUnit().getId().toString();
    }

    private void initControl() {
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(this.getCurrentHROID());
        AdminByOrgRangePromptBox aSel = new AdminByOrgRangePromptBox("false");
        aSel.showChkSealUp(true);
        this.prmtOrg.setSelector((KDPromptSelector)aSel);
        this.prmtOrg.setEditable(false);
        AdminByOrgRangePromptBox aSelMult = new AdminByOrgRangePromptBox("false");
        aSelMult.showChkSealUp(true);
        aSelMult.setIsSingleSelect(false);
        this.prmtOrgMult.setSelector((KDPromptSelector)aSelMult);
        this.prmtOrgMult.setEditable(false);
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)this);
        pmtNew.showChkSealUp(true);
        this.prmtPosition.setSelector((KDPromptSelector)pmtNew);
        this.prmtPosition.setEditable(false);
        EmployeeMultiF7PromptBox employeeMutilF7 = new EmployeeMultiF7PromptBox();
        employeeMutilF7.showNoPositionPerson(true);
        employeeMutilF7.setUserOrgRangeFilter(true);
        this.prmtEmp.setSelector((KDPromptSelector)employeeMutilF7);
        this.prmtEmp.setEditable(false);
        this.prmtProposer.setQueryInfo("com.kingdee.eas.base.permission.app.UserListQuery");
        this.prmtProposer.setEditFormat("$name$");
        this.prmtProposer.setCommitFormat("$number$");
        this.prmtProposer.setDisplayFormat("$name$");
        this.combApproveState.addItem((Object)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"69_HRAffairQueryFilterUI"));
        this.combAffairType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRAffairQueryFilterUI.this.setControlStateReRetain();
                HRAffairQueryFilterUI.this.setFluctionTypeVisiable();
            }
        });
        this.initCombFluctionType();
        this.clear();
    }

    @Override
    protected void btnEmp_actionPerformed(ActionEvent e) throws Exception {
        this.setF7State("emp");
    }

    @Override
    protected void btnOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setF7State("org");
    }

    @Override
    protected void btnPos_actionPerformed(ActionEvent e) throws Exception {
        this.setF7State("pos");
    }

    @Override
    protected void rdOrgMult_actionPerformed(ActionEvent e) throws Exception {
        this.setF7State("orgMult");
    }

    private void initCombFluctionType() {
        try {
            FluctuationTypeCollection fluctuationTypeColl = FluctuationTypeFactory.getRemoteInstance().getFluctuationTypeCollection();
            int j = fluctuationTypeColl.size();
            for (int i = 0; i < j; ++i) {
                this.combFluctuationType.addItem((Object)fluctuationTypeColl.get(i));
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.combFluctuationType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"69_HRAffairQueryFilterUI"));
    }

    private void setFluctionTypeVisiable() {
        AffairTypeEnum affairTypeEnum = (AffairTypeEnum)((Object)this.combAffairType.getSelectedItem());
        if (affairTypeEnum.getValue() == 2) {
            this.lblFluctuationType.setEnabled(true);
            this.lblDispatchNum.setEnabled(true);
        } else {
            this.lblFluctuationType.setEnabled(false);
            this.lblDispatchNum.setEnabled(false);
            this.setFluctuatTypeControlDisableState();
        }
    }

    private void setControlStateReRetain() {
        AffairTypeEnum affairType = (AffairTypeEnum)((Object)this.combAffairType.getSelectedItem());
        if (affairType.getValue() == 6) {
            this.txtNumber.setText("");
            this.prmtProposer.setData(null);
            this.pickerApplyDateStart.setValue(null);
            this.pickerApplyDateEnd.setValue(null);
            this.setControlState(false);
        } else {
            this.setControlState(true);
        }
    }

    private void setControlState(boolean state) {
        this.txtNumber.setEnabled(state);
        this.prmtProposer.setEnabled(state);
        this.pickerApplyDateStart.setEnabled(state);
        this.pickerApplyDateEnd.setEnabled(state);
        this.combApproveState.setEnabled(state);
    }

    private void setF7State(String type) {
        this.prmtOrg.setEnabled(false);
        this.prmtEmp.setEnabled(false);
        this.prmtPosition.setEnabled(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkShowSealUp.setEnabled(false);
        this.prmtOrgMult.setEnabled(false);
        if ("org".equals(type)) {
            this.prmtOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.chkShowSealUp.setEnabled(true);
        }
        if ("emp".equals(type)) {
            this.prmtEmp.setEnabled(true);
        }
        if ("pos".equals(type)) {
            this.prmtPosition.setEnabled(true);
        }
        if ("orgMult".equals(type)) {
            this.prmtOrgMult.setEnabled(true);
        }
        this.clearQueryWeiDu(type);
    }

    private void clearQueryWeiDu(String type) {
        if ("org".equals(type)) {
            this.prmtPosition.setValue(null);
            this.prmtEmp.setValue(null);
            this.prmtOrgMult.setValue(null);
        }
        if ("orgMult".equals(type)) {
            this.prmtPosition.setValue(null);
            this.prmtEmp.setValue(null);
            this.prmtOrg.setValue(null);
        }
        if ("emp".equals(type)) {
            this.prmtOrg.setValue(null);
            this.prmtOrgMult.setValue(null);
            this.prmtPosition.setValue(null);
        }
        if ("pos".equals(type)) {
            this.prmtEmp.setValue(null);
            this.prmtOrg.setValue(null);
            this.prmtOrgMult.setValue(null);
        }
        if ("all".equals(type)) {
            this.prmtPosition.setValue(null);
            this.prmtEmp.setValue(null);
            this.prmtOrg.setValue(null);
            this.prmtOrgMult.setValue(null);
        }
    }

    public FilterInfo getFilterInfo() {
        AffairTypeEnum affairType;
        FilterInfo filter = new FilterInfo();
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        Object filterOrg = null;
        if (this.btnOrg.isSelected() && this.prmtOrg.getData() != null) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtOrg.getData();
        }
        if (this.btnPos.isSelected() && this.prmtPosition.getData() != null) {
            PositionInfo position = (PositionInfo)this.prmtPosition.getData();
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)position.getId().toString()));
        }
        if (this.btnEmp.isSelected() && this.prmtEmp.getData() != null) {
            PersonInfo person = (PersonInfo)this.prmtEmp.getData();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString()));
        }
        if ((affairType = (AffairTypeEnum)((Object)this.combAffairType.getSelectedItem())).getValue() != 6) {
            this.setAppNumberFilter(filter);
            this.setProperFilter(filter);
            this.setApplyDateFilter(filter);
            this.setApproveStateFilter(filter);
            if (affairType.getValue() == 2) {
                this.setFluctationTyepFilter(filter);
            }
        }
        this.setEffectDateFilter(filter);
        if (this.btnOrg.isSelected() && !this.chkShowSealUp.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.isSealUp", (Object)Boolean.FALSE));
        }
        if (this.rdOrgMult.isSelected()) {
            Object[] orgs = (Object[])this.prmtOrgMult.getData();
            try {
                FilterInfo orgMultFilter = new FilterInfo("adminOrgUnit.id in (" + OrgStringUtil.getOrgIdsSql((Object[])orgs) + ")");
                filter.mergeFilter(orgMultFilter, "and");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.setIncoludeOrgFilter(this.btnOrg.isSelected(), this.chkIsIncludeOrg.isSelected(), adminOrgUnitInfo, filter);
        }
        return filter;
    }

    private void setIncoludeOrgFilter(boolean isSecOrg, boolean isInc, AdminOrgUnitInfo adminOrgUnitInfo, FilterInfo filter) {
        if (!isSecOrg || adminOrgUnitInfo == null || filter == null) {
            return;
        }
        if (isInc) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo filterOrg = new FilterInfo();
                filterOrg.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filterOrg.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString()));
                filterOrg.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(filterOrg, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString()));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString()));
        }
    }

    private void setFluctationTyepFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Object ob = this.combFluctuationType.getSelectedItem();
        if (!(ob instanceof String)) {
            FluctuationTypeInfo fluctuationTypeInfo = (FluctuationTypeInfo)ob;
            filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)fluctuationTypeInfo.getId().toString()));
        }
        if (!"".equals(this.txtDispatchNum.getText())) {
            filter.getFilterItems().add(new FilterItemInfo("entries.dispatchNum", (Object)("%" + this.txtDispatchNum.getText() + "%"), CompareType.LIKE));
        }
    }

    private void setProperFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        UserInfo user = (UserInfo)this.prmtProposer.getValue();
        if (user != null) {
            String userId = user.getId().toString();
            try {
                UserInfo userQ = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                PersonInfo perInfo = userQ.getPerson();
                if (userQ.getPerson() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)perInfo.getId().toString()));
                }
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        }
    }

    private void setAppNumberFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        if (!"".equals(this.txtNumber.getText())) {
            filter.getFilterItems().add(new FilterItemInfo("appNumber", (Object)this.txtNumber.getText(), CompareType.LIKE));
        }
    }

    private void setApplyDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date applyDateStart = (Date)this.pickerApplyDateStart.getValue();
        Date applyDateEnd = (Date)this.pickerApplyDateEnd.getValue();
        if (applyDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyDate", (Object)this.simpleDateFormat.format(applyDateStart), CompareType.GREATER_EQUALS));
        }
        if (applyDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyDate", (Object)this.simpleDateFormat.format(applyDateEnd), CompareType.LESS_EQUALS));
        }
    }

    private void setEffectDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date effectDateStart = (Date)this.pickerEffectDateStart.getValue();
        Date effectDateEnd = (Date)this.pickerEffectDateEnd.getValue();
        if (effectDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("effectDate", (Object)this.simpleDateFormat.format(effectDateStart), CompareType.GREATER_EQUALS));
        }
        if (effectDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("effectDate", (Object)this.simpleDateFormat.format(effectDateEnd), CompareType.LESS_EQUALS));
        }
    }

    private void setApproveStateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Object obAffairState = this.combApproveState.getSelectedItem();
        if (!(obAffairState instanceof String)) {
            HRAffairState hrAffairState = (HRAffairState)((Object)obAffairState);
            int approveSate = hrAffairState.getValue();
            filter.getFilterItems().add(new FilterItemInfo("bizState", (Object)approveSate));
        }
    }

    public void clear() {
        this.clearQueryWeiDu("all");
        this.combAffairType.setSelectedIndex(0);
        this.setFluctuatTypeControlDisableState();
        this.setFluctionTypeVisiable();
        this.txtNumber.setText("");
        this.prmtProposer.setValue(null);
        this.pickerApplyDateStart.setValue(null);
        this.pickerApplyDateEnd.setValue(null);
        this.pickerEffectDateStart.setValue(null);
        this.pickerEffectDateEnd.setValue(null);
        this.combApproveState.setSelectedIndex(this.combApproveState.getItemCount() - 1);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkShowSealUp.setSelected(false);
        this.btnOrg.setSelected(true);
        this.setF7State("org");
    }

    private void setFluctuatTypeControlDisableState() {
        this.combFluctuationType.setSelectedIndex(this.combFluctuationType.getItemCount() - 1);
        this.txtDispatchNum.setText("");
    }

    public boolean verify() {
        if (!(this.btnOrg.isSelected() || this.btnPos.isSelected() || this.btnEmp.isSelected() || this.rdOrgMult.isSelected())) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "HRAffairQueryFilter_QueryNotNull")));
            return false;
        }
        if (this.rdOrgMult.isSelected() && this.prmtOrgMult.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"48_AffairSynFilterUI"));
            return false;
        }
        Date applyDateStart = (Date)this.pickerApplyDateStart.getValue();
        Date applyDateEnd = (Date)this.pickerApplyDateEnd.getValue();
        if (applyDateStart != null && applyDateEnd != null && applyDateStart.getTime() > applyDateEnd.getTime()) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "HRAffairQueryFilter_ApplyDate_Error")));
            return false;
        }
        Date effectDateStart = (Date)this.pickerEffectDateStart.getValue();
        Date effectDateEnd = (Date)this.pickerEffectDateEnd.getValue();
        if (effectDateStart != null && effectDateEnd != null && effectDateStart.getTime() > effectDateEnd.getTime()) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "HRAffairQueryFilter_EffectDate_Error")));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean(BTNORG_CP, this.btnOrg.isSelected());
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)this.prmtOrg.getData();
        if (adminOrgUnit != null) {
            cp.addCustomerParam(PRMTORG_CP, adminOrgUnit.getId().toString());
        }
        cp.putBoolean(this.rdOrgMult.getName(), this.rdOrgMult.isSelected());
        Object[] orgs = (Object[])this.prmtOrgMult.getData();
        if (orgs != null) {
            cp.addCustomerParam(this.prmtOrgMult.getName(), OrgStringUtil.orgInfoArr2String((Object[])orgs));
        }
        cp.putBoolean(CHKISINCLUDEORG_CP, this.chkIsIncludeOrg.isSelected());
        cp.putBoolean(this.chkShowSealUp.getName(), this.chkShowSealUp.isSelected());
        cp.putBoolean(BTNPOS_CP, this.btnPos.isSelected());
        PositionInfo position = (PositionInfo)this.prmtPosition.getData();
        if (position != null) {
            cp.addCustomerParam(PRMTPOSITION_CP, position.getId().toString());
        }
        cp.putBoolean(BTNEMP_CP, this.btnEmp.isSelected());
        PersonInfo person = (PersonInfo)this.prmtEmp.getData();
        if (person != null) {
            cp.addCustomerParam(PRMTEMP_CP, person.getId().toString());
        }
        cp.putInt(COMBAFFAIRTYPE_CP, this.combAffairType.getSelectedIndex());
        cp.addCustomerParam(TXTNUMBER_CP, this.txtNumber.getText());
        UserInfo user = (UserInfo)this.prmtProposer.getValue();
        if (user != null) {
            cp.addCustomerParam(PRMTPROPOSER_CP, user.getId().toString());
        }
        Date applyDateStart = (Date)this.pickerApplyDateStart.getValue();
        Date applyDateEnd = (Date)this.pickerApplyDateEnd.getValue();
        if (applyDateStart != null) {
            cp.addCustomerParam(PICKERAPPLYDATESTART_CP, this.simpleDateFormat.format(applyDateStart));
        } else {
            cp.addCustomerParam(PICKERAPPLYDATESTART_CP, "");
        }
        if (applyDateEnd != null) {
            cp.addCustomerParam(PICKERAPPLYDATEEND_CP, this.simpleDateFormat.format(applyDateEnd));
        } else {
            cp.addCustomerParam(PICKERAPPLYDATEEND_CP, "");
        }
        Date effectDateStart = (Date)this.pickerEffectDateStart.getValue();
        Date effectDateEnd = (Date)this.pickerEffectDateEnd.getValue();
        if (effectDateStart != null) {
            cp.addCustomerParam(PICKEREFFECTDATESTART_CP, this.simpleDateFormat.format(effectDateStart));
        } else {
            cp.addCustomerParam(PICKEREFFECTDATESTART_CP, "");
        }
        if (effectDateEnd != null) {
            cp.addCustomerParam(PICKEREFFECTDATEEND_CP, this.simpleDateFormat.format(effectDateEnd));
        } else {
            cp.addCustomerParam(PICKEREFFECTDATEEND_CP, "");
        }
        cp.putInt(COMBAPPROVESTATE_CP, this.combApproveState.getSelectedIndex());
        cp.putInt(COMBFLUCTUATIONTYPE_CP, this.combFluctuationType.getSelectedIndex());
        cp.addCustomerParam(DISPATCHNUM_CP, this.txtDispatchNum.getText());
        return cp;
    }

    public void setCustomerParams(CustomerParams param) {
        String empId;
        String orgs;
        String posId;
        String orgId;
        if (param == null) {
            return;
        }
        this.btnOrg.setSelected(param.getBoolean(BTNORG_CP));
        this.chkIsIncludeOrg.setSelected(param.getBoolean(CHKISINCLUDEORG_CP));
        this.chkShowSealUp.setSelected(param.getBoolean(this.chkShowSealUp.getName()));
        if (this.btnOrg.isSelected()) {
            this.setF7State("org");
        }
        if ((orgId = param.getCustomerParam(PRMTORG_CP)) != null) {
            try {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                this.prmtOrg.setValue((Object)adminOrgUnitInfo);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        } else {
            this.prmtOrg.setValue(null);
        }
        this.btnPos.setSelected(param.getBoolean(BTNPOS_CP));
        if (this.btnPos.isSelected()) {
            this.setF7State("pos");
        }
        if ((posId = param.getCustomerParam(PRMTPOSITION_CP)) != null) {
            try {
                PositionInfo position = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(posId));
                this.prmtPosition.setValue((Object)position);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        } else {
            this.prmtPosition.setValue(null);
        }
        this.btnEmp.setSelected(param.getBoolean(BTNEMP_CP));
        if (this.btnEmp.isSelected()) {
            this.setF7State("emp");
        }
        this.rdOrgMult.setSelected(param.getBoolean(this.rdOrgMult.getName()));
        if (this.rdOrgMult.isSelected()) {
            this.setF7State("orgMult");
        }
        if ((orgs = param.getCustomerParam(this.prmtOrgMult.getName())) != null) {
            this.prmtOrgMult.setData((Object)OrgStringUtil.string2OrgInfoArr((String)orgs));
        }
        if ((empId = param.getCustomerParam(PRMTEMP_CP)) != null) {
            try {
                PersonInfo person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(empId));
                this.prmtEmp.setValue((Object)person);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        } else {
            this.prmtEmp.setValue(null);
        }
        this.combAffairType.setSelectedIndex(param.getInt(COMBAFFAIRTYPE_CP));
        this.txtNumber.setText(param.getCustomerParam(TXTNUMBER_CP));
        String userId = param.getCustomerParam(PRMTPROPOSER_CP);
        if (userId != null) {
            try {
                UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                this.prmtProposer.setValue((Object)user);
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        } else {
            this.prmtProposer.setValue(null);
        }
        this.pickerApplyDateStart.setValue((Object)this.getDateByPram(param, PICKERAPPLYDATESTART_CP));
        this.pickerApplyDateEnd.setValue((Object)this.getDateByPram(param, PICKERAPPLYDATEEND_CP));
        this.pickerEffectDateStart.setValue((Object)this.getDateByPram(param, PICKEREFFECTDATESTART_CP));
        this.pickerEffectDateEnd.setValue((Object)this.getDateByPram(param, PICKEREFFECTDATEEND_CP));
        this.combApproveState.setSelectedIndex(param.getInt(COMBAPPROVESTATE_CP));
        this.combFluctuationType.setSelectedIndex(param.getInt(COMBFLUCTUATIONTYPE_CP));
        this.txtDispatchNum.setText(param.getCustomerParam(DISPATCHNUM_CP));
    }

    private Date getDateByPram(CustomerParams param, String paramName) {
        Date date = null;
        if (param.getCustomerParam(paramName) != null && !"".equals(param.getCustomerParam(paramName))) {
            try {
                date = this.simpleDateFormat.parse(param.getCustomerParam(paramName));
            }
            catch (ParseException e) {
                logger.info((Object)e);
            }
        }
        return date;
    }
}

