/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.hr.affair.client.AbstractHRBizAffairFilterUI;
import com.kingdee.eas.hr.affair.client.HRAffairFilterUI;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class HRBizAffairFilterUI
extends AbstractHRBizAffairFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(HRAffairFilterUI.class);
    private String positionColName = "position";
    protected final String RES = "com.kingdee.eas.hr.base.HRBasedataResource";
    protected ListUI listUI;

    public HRBizAffairFilterUI() throws Exception {
    }

    public HRBizAffairFilterUI(CoreUIObject uiobj) throws Exception {
        if (uiobj instanceof ListUI) {
            this.listUI = (ListUI)uiobj;
        }
        this.initBizOrgPreChange();
    }

    public HRBizAffairFilterUI(String positionColName) throws Exception {
        this.positionColName = positionColName;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    public void clear() {
        super.clear();
        this.prmtOrg.setValue(null);
        this.prmtEmp.setValue(null);
        this.prmtPosition.setValue(null);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkIsSearch.setSelected(false);
        this.chkIsSearch.setEnabled(false);
        this.chkShowSealUp.setSelected(false);
        this.txFiledPerson.setEnabled(false);
        this.txFiledPerson.setVisible(false);
        this.kdradioOrg.setSelected(true);
        this.chkIsIncludeOrg.setEnabled(true);
        this.setSelect("org");
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtOrg);
        AdminByOrgRangePromptBox admin = (AdminByOrgRangePromptBox)this.prmtOrg.getSelector();
        admin.setIncludeSealUp("false");
        admin.showChkSealUp(true);
        register.registerPositionPromptBox2(this.prmtPosition, true);
        PositionPromptBox2 position = (PositionPromptBox2)this.prmtPosition.getSelector();
        position.showChkSealUp(true);
        position.setSealUp("false");
        register.registerEmployeeMultiF7PromptBox(this.prmtEmp, true);
    }

    private void initAllEditor() {
        this.chkIsSearch.setEnabled(false);
        this.txFiledPerson.setEditable(false);
        this.clear();
        this.kdradioOrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRBizAffairFilterUI.this.setSelect("org");
            }
        });
        this.kdRadioEmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRBizAffairFilterUI.this.setSelect("emp");
            }
        });
        this.kdRadioPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRBizAffairFilterUI.this.setSelect("position");
            }
        });
        this.chkIsSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HRBizAffairFilterUI.this.setSearchType();
            }
        });
    }

    private void setSelect(String selectType) {
        if ("org".equals(selectType) && this.kdradioOrg.isSelected()) {
            this.prmtOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.chkShowSealUp.setEnabled(true);
            this.prmtEmp.setData(null);
            this.prmtEmp.setEnabled(false);
            this.prmtEmp.setVisible(true);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
        if ("emp".equals(selectType) && this.kdRadioEmp.isSelected()) {
            this.prmtEmp.setEnabled(true);
            this.prmtEmp.setVisible(true);
            this.prmtOrg.setData(null);
            this.prmtOrg.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.chkShowSealUp.setSelected(false);
            this.chkShowSealUp.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
        if ("position".equals(selectType) && this.kdRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtOrg.setData(null);
            this.prmtOrg.setEnabled(false);
            this.prmtEmp.setData(null);
            this.prmtEmp.setEnabled(false);
            this.prmtEmp.setVisible(true);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.chkShowSealUp.setSelected(false);
            this.chkShowSealUp.setEnabled(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
    }

    private void setSearchType() {
        if (this.chkIsSearch.isSelected()) {
            this.prmtEmp.setValue(null);
            this.prmtEmp.setEnabled(false);
            this.prmtEmp.setVisible(false);
            this.txFiledPerson.setEnabled(true);
            this.txFiledPerson.setEditable(true);
            this.txFiledPerson.setVisible(true);
        } else {
            this.prmtEmp.setEnabled(true);
            this.prmtEmp.setVisible(true);
            this.txFiledPerson.setEditable(false);
            this.txFiledPerson.setText(null);
            this.txFiledPerson.setEnabled(false);
            this.txFiledPerson.setVisible(false);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.chkShowSealUp.setSelected(cp.getBoolean(this.chkShowSealUp.getName()));
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        if (this.kdradioOrg.isSelected()) {
            this.prmtOrg.setEnabled(true);
            this.prmtPosition.setEnabled(false);
            this.prmtEmp.setEnabled(false);
        } else if (this.kdRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtOrg.setEnabled(false);
            this.prmtEmp.setEnabled(false);
        } else if (this.kdRadioEmp.isSelected() && !this.chkIsSearch.isSelected()) {
            this.prmtEmp.setEnabled(true);
            this.prmtPosition.setEnabled(false);
            this.prmtOrg.setEnabled(false);
            this.chkIsSearch.setEnabled(true);
        } else {
            this.prmtEmp.setVisible(false);
            this.txFiledPerson.setVisible(true);
            this.txFiledPerson.setEnabled(true);
            this.prmtPosition.setEnabled(false);
            this.prmtOrg.setEnabled(false);
            this.chkIsSearch.setEnabled(true);
        }
    }

    public FilterInfo getFilterInfo() {
        PositionInfo positionInfo;
        FilterInfo filter = new FilterInfo();
        if (this.kdRadioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys." + this.positionColName + ".id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.kdRadioEmp.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String personNumberOrName = this.txFiledPerson.getText();
                if (personNumberOrName != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("entrys.person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                    filter.setMaskString("#0 or #1");
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtEmp.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kdradioOrg.isSelected()) {
            AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.prmtOrg.getData();
            if (orgUnit != null) {
                if (this.chkIsIncludeOrg.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                }
            }
            if (!this.chkShowSealUp.isSelected()) {
                FilterInfo sealUpFi = new FilterInfo();
                sealUpFi.getFilterItems().add(new FilterItemInfo("adminOrg.isSealUp", (Object)Boolean.FALSE));
                try {
                    filter.mergeFilter(sealUpFi, "and");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        } else {
            FilterInfo sealUpFi = new FilterInfo();
            sealUpFi.getFilterItems().add(new FilterItemInfo("adminOrg.isSealUp", (Object)Boolean.FALSE));
            try {
                filter.mergeFilter(sealUpFi, "and");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public void hidePostionAndJob() {
        this.kdRadioPosition.setVisible(false);
        this.kdRadioEmp.setVisible(false);
        this.contPosition.setVisible(false);
        this.kDLabelContainer1.setVisible(false);
        this.contEmployeeText.setVisible(false);
        this.chkIsSearch.setVisible(false);
    }

    private void initBizOrgPreChange() {
        this.prmtHROrg.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData() instanceof HROrgUnitInfo) {
                    try {
                        HRInitFactory.getRemoteInstance().isInitFinish((HROrgUnitInfo)e.getData());
                        if (e.getOldData() != null && e.getData() != null && !e.getOldData().equals(e.getData())) {
                            if (HRBizAffairFilterUI.this.listUI == null || HRBizAffairFilterUI.this.listUI.getDialog() == null) {
                                return;
                            }
                            KDTable selfDefTbl = HRBizAffairFilterUI.this.listUI.getDialog().getCommonFilterPanel().getKdtTable();
                            boolean hasFilterVal = false;
                            if (selfDefTbl.getRowCount() > 0) {
                                int i;
                                int size = selfDefTbl.getRowCount();
                                for (i = 0; i < size; ++i) {
                                    if (selfDefTbl.getRow(i).getCell(1).getValue() == null) continue;
                                    hasFilterVal = true;
                                    break;
                                }
                                if (hasFilterVal) {
                                    selfDefTbl.removeRows();
                                    for (i = 0; i < 10; ++i) {
                                        selfDefTbl.addRow();
                                    }
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        HRBizAffairFilterUI.this.handUIException(ex);
                    }
                }
            }
        });
    }
}

