/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.ReRetainBillEntryCollection;
import com.kingdee.eas.hr.affair.ReRetainBillEntryInfo;
import com.kingdee.eas.hr.affair.ReRetainBillFactory;
import com.kingdee.eas.hr.affair.ReRetainBillInfo;
import com.kingdee.eas.hr.affair.RetireBillEntryInfo;
import com.kingdee.eas.hr.affair.client.AbstractReRetainEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.base.EmployeeClassifyInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.util.EmpUIHandlerUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelCollection;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ReRetainEditUI
extends AbstractReRetainEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReRetainEditUI.class);
    private final String NAME_COL = "name";
    private final String NUMBER_COL = "number";
    private final String GENDER_COL = "gender";
    private final String ENDDEPT_COL = "endDept";
    private final String IS_CONTINUE_RERETAIN_COL = "isContinueReRetain";
    private final String RETIREDATE_COL = "retireDate";
    private final String DEPT_COL = "dept";
    private final String POSITION_COL = "position";
    private final String JOB_COL = "job";
    private final String JOBGRADE_COL = "jobGrade";
    private final String JOBLEVLE_COL = "jobLevel";
    private final String EMPTYPE_COL = "empType";
    private final String STARTDATE_COL = "startDate";
    private final String ENDDATE_COL = "endDate";
    private final String EFFECTDATE_COL = "effectDate";
    private final String REASON_COL = "reason";
    private final String REMARK_COL = "remark";
    KDBizPromptBox prmtPersonMulSel = new KDBizPromptBox();

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReRetainBillFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.gender"));
        sic.add(new SelectorItemInfo("entries.endDept"));
        sic.add(new SelectorItemInfo("entries.retireDate"));
        sic.add(new SelectorItemInfo("entries.isContinueReRetain"));
        sic.add(new SelectorItemInfo("entries.dept.id"));
        sic.add(new SelectorItemInfo("entries.dept.name"));
        sic.add(new SelectorItemInfo("entries.position.id"));
        sic.add(new SelectorItemInfo("entries.position.name"));
        sic.add(new SelectorItemInfo("entries.position.job.id"));
        sic.add(new SelectorItemInfo("entries.position.job.name"));
        sic.add(new SelectorItemInfo("entries.jobGrade.id"));
        sic.add(new SelectorItemInfo("entries.jobGrade.name"));
        sic.add(new SelectorItemInfo("entries.jobLevel.id"));
        sic.add(new SelectorItemInfo("entries.jobLevel.name"));
        sic.add(new SelectorItemInfo("entries.employeeClassify.id"));
        sic.add(new SelectorItemInfo("entries.employeeClassify.name"));
        sic.add(new SelectorItemInfo("entries.startDate"));
        sic.add(new SelectorItemInfo("entries.endDate"));
        sic.add(new SelectorItemInfo("entries.effectDate"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        return sic;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        IRow row = null;
        int j = this.kdtEntries.getRowCount();
        for (int i = 0; i < j; ++i) {
            row = this.kdtEntries.getRow(i);
            if (row.getCell(this.NAME_COL).getValue() == null) {
                throw new HRAffairException(HRAffairException.RERETAIN_PERSON_NOTNULL);
            }
            if (row.getCell(this.DEPT_COL).getValue() == null) {
                throw new HRAffairException(HRAffairException.RERETAIN_DEPT_NOTNULL);
            }
            if (row.getCell(this.POSITION_COL).getValue() == null) {
                throw new HRAffairException(HRAffairException.RERETAIN_POSITION_NOTNULL);
            }
            if (row.getCell(this.STARTDATE_COL).getValue() == null) {
                throw new HRAffairException(HRAffairException.RERETAIN_STATDATE_NOTNULL);
            }
            if (row.getCell(this.ENDDATE_COL).getValue() == null) {
                throw new HRAffairException(HRAffairException.RERETAIN_ENDDATE_NOTNULL);
            }
            Date stDate = (Date)row.getCell(this.STARTDATE_COL).getValue();
            Date endDate = (Date)row.getCell(this.ENDDATE_COL).getValue();
            if (stDate != null && endDate != null && stDate.getTime() > endDate.getTime()) {
                throw new HRAffairException(HRAffairException.RERETAIN_ENDDATE_LESS);
            }
            if (row.getCell(this.EFFECTDATE_COL).getValue() != null) continue;
            throw new HRAffairException(HRAffairException.RERETAIN_EFFECTEDDATE_NOTNULL);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getProposer() == null) {
            this.editData.setProposer(this.pInfo);
        }
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        IRow row = null;
        ReRetainBillEntryCollection reRetainEntryColl = new ReRetainBillEntryCollection();
        ReRetainBillEntryInfo reRetainEntryInfo = null;
        int j = this.kdtEntries.getRowCount();
        for (int i = 0; i < j; ++i) {
            row = this.kdtEntries.getRow(i);
            reRetainEntryInfo = new ReRetainBillEntryInfo();
            reRetainEntryInfo.setPerson((PersonInfo)row.getCell(this.NAME_COL).getValue());
            reRetainEntryInfo.setEndDept((String)row.getCell(this.ENDDEPT_COL).getValue());
            reRetainEntryInfo.setRetireDate((Date)row.getCell(this.RETIREDATE_COL).getValue());
            Boolean bo = (Boolean)row.getCell(this.IS_CONTINUE_RERETAIN_COL).getValue();
            reRetainEntryInfo.setIsContinueReRetain(bo);
            reRetainEntryInfo.setDept((AdminOrgUnitInfo)row.getCell(this.DEPT_COL).getValue());
            reRetainEntryInfo.setPosition((PositionInfo)row.getCell(this.POSITION_COL).getValue());
            reRetainEntryInfo.setJobGrade((JobGradeInfo)row.getCell(this.JOBGRADE_COL).getValue());
            reRetainEntryInfo.setJobLevel((JobLevelInfo)row.getCell(this.JOBLEVLE_COL).getValue());
            reRetainEntryInfo.setEmployeeClassify((EmployeeClassifyInfo)row.getCell(this.EMPTYPE_COL).getValue());
            reRetainEntryInfo.setStartDate(DateTimeUtils.truncateDate((Date)((Date)row.getCell(this.STARTDATE_COL).getValue())));
            reRetainEntryInfo.setEndDate(DateTimeUtils.truncateDate((Date)((Date)row.getCell(this.ENDDATE_COL).getValue())));
            reRetainEntryInfo.setEffectDate(DateTimeUtils.truncateDate((Date)((Date)row.getCell(this.EFFECTDATE_COL).getValue())));
            reRetainEntryInfo.setReason((String)row.getCell(this.REASON_COL).getValue());
            reRetainEntryInfo.setRemark((String)row.getCell(this.REMARK_COL).getValue());
            reRetainEntryColl.add(reRetainEntryInfo);
        }
        this.editData.put("entries", (Object)reRetainEntryColl);
        this.editData.setIsMultiEntry(true);
        if (this.editData.getApproveState().getValue() == 0) {
            this.editData.setExtendedProperty("ignoreWorkflow", "true");
        }
    }

    @Override
    protected IObjectValue createNewData() {
        ReRetainBillInfo info = new ReRetainBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        return info;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRowAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRowDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.prmtPersonMulSel.setName("personInfo");
        this.prmtPersonMulSel.setDisplayFormat("$name$");
        this.prmtPersonMulSel.setEditFormat("$number$");
        this.prmtPersonMulSel.setCommitFormat("$number$");
        this.prmtPersonMulSel.setQueryInfo("com.kingdee.eas.hr.affair.app.PersonNotWorkQuery");
        this.prmtPersonMulSel.setEditable(true);
        this.prmtPersonMulSel.setRequired(true);
        this.prmtPersonMulSel.setEnabledMultiSelection(true);
        this.setTableColor();
        this.kdtEntries.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ReRetainEditUI.this.showPersonInfo(e);
            }
        });
        if (OprtState.EDIT.equals(this.getOprtState())) {
            try {
                this.reLoadJobLevelInfo();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            int j = this.kdtEntries.getColumnCount();
            for (int i = 0; i < j; ++i) {
                this.kdtEntries.getColumn(i).getStyleAttributes().setLocked(true);
            }
        }
    }

    private void setTableColor() {
        Color color = new Color(252, 251, 223);
        this.kdtEntries.getColumn(this.NAME_COL).getStyleAttributes().setBackground(color);
        this.kdtEntries.getColumn(this.DEPT_COL).getStyleAttributes().setBackground(color);
        this.kdtEntries.getColumn(this.POSITION_COL).getStyleAttributes().setBackground(color);
        this.kdtEntries.getColumn(this.STARTDATE_COL).getStyleAttributes().setBackground(color);
        this.kdtEntries.getColumn(this.ENDDATE_COL).getStyleAttributes().setBackground(color);
        this.kdtEntries.getColumn(this.EFFECTDATE_COL).getStyleAttributes().setBackground(color);
    }

    private void showPersonInfo(KDTMouseEvent e) {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            int index = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (this.kdtEntries.getColumn(this.REASON_COL).getColumnIndex() == colIndex || this.kdtEntries.getColumn(this.REMARK_COL).getColumnIndex() == colIndex) {
                return;
            }
            PersonInfo personInfo = (PersonInfo)this.kdtEntries.getCell(index, this.NAME_COL).getValue();
            UIContext uiContext = new UIContext((Object)this);
            if (personInfo != null) {
                uiContext.put((Object)"ID", (Object)personInfo.getId().toString());
            }
            try {
                EmpUIHandlerUtil.invokeEmployeeInfoUI((UIContext)uiContext, (String)OprtState.VIEW);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    public void reLoadJobLevelInfo() throws Exception {
        IRow row = null;
        PositionInfo pInfo = null;
        KDComboBox combo = null;
        JobLevelInfo jInfo = null;
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntries.getRow(i);
            pInfo = (PositionInfo)row.getCell(this.POSITION_COL).getValue();
            if (pInfo == null) continue;
            combo = (KDComboBox)this.kdtEntries.getColumn(this.JOBLEVLE_COL).getEditor().getComponent();
            if (pInfo.getJob() != null) {
                combo.setModel((ComboBoxModel)HRAffairClientUtils.getComboModelByColl((AbstractObjectCollection)HRAffairClientUtils.getJobLvlsByJobId(pInfo.getJob().getId().toString())));
            }
            jInfo = (JobLevelInfo)row.getCell(this.JOBLEVLE_COL).getValue();
            HRAffairClientUtils.setComboSelectedItem(combo, (AbstractObjectValue)jInfo);
        }
    }

    @Override
    protected void setTableCellEditor() throws Exception {
        super.setTableCellEditor();
        KDBizPromptBox prmtPersonSingleSel = new KDBizPromptBox();
        prmtPersonSingleSel.setName("personInfo");
        prmtPersonSingleSel.setDisplayFormat("$name$");
        prmtPersonSingleSel.setEditFormat("$number$");
        prmtPersonSingleSel.setCommitFormat("$number$");
        prmtPersonSingleSel.setQueryInfo("com.kingdee.eas.hr.affair.app.PersonNotWorkQuery");
        prmtPersonSingleSel.setEditable(false);
        prmtPersonSingleSel.setRequired(true);
        prmtPersonSingleSel.setEnabledMultiSelection(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPersonSingleSel);
        this.kdtEntries.getColumn(this.NAME_COL).setEditor((ICellEditor)cellEditor);
        this.kdtEntries.getColumn(this.NAME_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.IS_CONTINUE_RERETAIN_COL).setEditor(EmployeeClientUtils.getBoolCellEditor());
        this.kdtEntries.getColumn(this.IS_CONTINUE_RERETAIN_COL).getStyleAttributes().setLocked(true);
        AdminByCurrentHROF7WithOrgRangeFilter f7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        this.kdtEntries.getColumn(this.DEPT_COL).setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)f7));
        this.kdtEntries.getColumn(this.DEPT_COL).getStyleAttributes().setLocked(false);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("ALL_ADMIN", Boolean.TRUE);
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)this, hashMap);
        this.kdtEntries.getColumn(this.POSITION_COL).setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)pmtNew));
        this.kdtEntries.getColumn(this.POSITION_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.JOBGRADE_COL).setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)new JobGradePromptBox((IUIObject)this)));
        this.kdtEntries.getColumn(this.JOBGRADE_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.JOBLEVLE_COL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox()));
        this.kdtEntries.getColumn(this.JOBLEVLE_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.EMPTYPE_COL).setEditor(EmployeeClientUtils.getF7CellEditor((String)"com.kingdee.eas.hr.base.app.EmployeeClassifyListQuery"));
        this.kdtEntries.getColumn(this.EMPTYPE_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.STARTDATE_COL).setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn(this.STARTDATE_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.STARTDATE_COL).getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn(this.ENDDATE_COL).setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn(this.ENDDATE_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.ENDDATE_COL).getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn(this.EFFECTDATE_COL).setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn(this.EFFECTDATE_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.EFFECTDATE_COL).getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn(this.REASON_COL).setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)1000));
        this.kdtEntries.getColumn(this.REASON_COL).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(this.REMARK_COL).setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)200));
        this.kdtEntries.getColumn(this.REMARK_COL).getStyleAttributes().setLocked(false);
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        this.modifyTablePersonInfo(e, this.kdtEntries.getRow(rowIndex));
    }

    @Override
    public void actionRowAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPersonMulSel.setDataBySelector();
        if (this.prmtPersonMulSel.getData() instanceof Object[]) {
            Object[] obj = (Object[])this.prmtPersonMulSel.getData();
            if (obj == null || obj.length <= 0) {
                return;
            }
            PersonInfo info = null;
            int size = obj.length;
            for (int i = 0; i < size; ++i) {
                info = (PersonInfo)obj[i];
                this.fillKdtEntryTable(info);
            }
            this.kdtEntries.getSelectManager().select(0, 0);
        }
    }

    private void fillKdtEntryTable(PersonInfo info) {
        if (info == null) {
            return;
        }
        if (!this.isRowExit(info, -1)) {
            IRow row = this.kdtEntries.addRow();
            this.setTableCellData(info, row);
        }
    }

    private void modifyTablePersonInfo(KDTEditEvent e, IRow row) {
        boolean boEditDate;
        PositionInfo positionInfo;
        Object ob = e.getValue();
        if (ob instanceof PersonInfo) {
            PersonInfo info = (PersonInfo)ob;
            if (this.isRowExit(info, e.getRowIndex())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.ReRetain_PersonExit"));
                row.getCell(this.NAME_COL).setValue(null);
            } else if (info != null) {
                this.setTableCellData(info, row);
            }
        }
        if (ob instanceof PositionInfo && (positionInfo = (PositionInfo)ob) != null) {
            if (positionInfo.getJob() != null) {
                row.getCell(this.JOB_COL).setValue((Object)positionInfo.getJob().getName());
            }
            KDComboBox combo = (KDComboBox)this.kdtEntries.getColumn(this.JOBLEVLE_COL).getEditor().getComponent();
            if (positionInfo.getJob() != null && positionInfo.getJob().getId() != null) {
                try {
                    JobLevelCollection jobLevelCollection = HRAffairClientUtils.getJobLvlsByJobId(positionInfo.getJob().getId().toString());
                    combo.setModel((ComboBoxModel)HRAffairClientUtils.getComboModelByColl((AbstractObjectCollection)jobLevelCollection));
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage());
                }
            }
        }
        boolean bl = boEditDate = this.kdtEntries.getColumn(this.STARTDATE_COL).getColumnIndex() == e.getColIndex() || this.kdtEntries.getColumn(this.ENDDATE_COL).getColumnIndex() == e.getColIndex();
        if (boEditDate) {
            Date stDate = (Date)row.getCell(this.STARTDATE_COL).getValue();
            Date endDate = (Date)row.getCell(this.ENDDATE_COL).getValue();
            if (stDate != null && endDate != null && stDate.getTime() > endDate.getTime()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.ReRetain_StartEndDate"));
                row.getCell(e.getColIndex()).setValue(e.getOldValue());
            }
        }
    }

    private void setTableCellData(PersonInfo info, IRow row) {
        if (info == null) {
            return;
        }
        row.getCell(this.NAME_COL).setValue((Object)info);
        row.getCell(this.NUMBER_COL).setValue((Object)info.getNumber());
        row.getCell(this.GENDER_COL).setValue((Object)info.getGender());
        try {
            String personDep = HRAffairClientUtils.getPersonDep(info.getId().toString());
            row.getCell(this.ENDDEPT_COL).setValue((Object)personDep);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (info.getEmployeeType() == null || !"ow02BQEPEADgAAM4wKgSCqKehbM=".equals(info.getEmployeeType().getId().toString())) {
            row.getCell(this.IS_CONTINUE_RERETAIN_COL).setValue((Object)false);
        } else {
            row.getCell(this.IS_CONTINUE_RERETAIN_COL).setValue((Object)true);
        }
        try {
            RetireBillEntryInfo retireBillEntryInfo = HRAffairClientUtils.getRetireBillEntryByPersonId(info.getId().toString());
            if (retireBillEntryInfo != null) {
                row.getCell(this.RETIREDATE_COL).setValue((Object)retireBillEntryInfo.getRetireDate().toString());
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private boolean isRowExit(PersonInfo info, int rowIndex) {
        boolean ret = false;
        ICell iCell = null;
        int length = this.kdtEntries.getRowCount();
        for (int i = 0; i < length; ++i) {
            if (i == rowIndex || (iCell = this.kdtEntries.getRow(i).getCell(this.NUMBER_COL)).getValue() == null || !iCell.getValue().toString().equalsIgnoreCase(info.getNumber())) continue;
            return true;
        }
        return ret;
    }
}

