/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.IRetireBill;
import com.kingdee.eas.hr.affair.RetireBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBillFactory;
import com.kingdee.eas.hr.affair.RetireBillInfo;
import com.kingdee.eas.hr.affair.client.AbstractRetireBillSelfEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.CustomerSettingsSwitch;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;

public class RetireBillSelfEditUI
extends AbstractRetireBillSelfEditUI {
    private KDNoteHelper appHlp = new KDNoteHelper();
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String RETIRE_FILENAME = "/HR/OrgUnit/RetireBill";
    private BOSUuid actPersonId;
    private BOSUuid actEntryId;
    private String billId;
    private boolean deleteFlag = false;
    protected BOSUuid entryId = null;

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.txtPhone.setEditable(false);
        this.comboRetireType.setEnabled(false);
        this.dateRetireDate.setEnabled(false);
        this.comboGender.setEnabled(false);
        this.txtRemark.setEditable(false);
        this.txtReason.setEditable(false);
        this.prmtNominalDept.setEnabled(false);
    }

    @Override
    protected IObjectValue createNewData() {
        RetireBillInfo info = new RetireBillInfo();
        info.setIsMultiEntry(false);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowDate != null) {
            info.setApplyDate(this.nowDate);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RetireBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        this.dateJobDate.setValue(null);
        super.loadFields();
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            RetireBillEntryInfo info = this.editData.getEntries().get(0);
            this.comboGender.setSelectedItem((Object)info.getGender());
            this.txtIDCardNO.setText(info.getIdCardNO());
            this.txtDegree.setText(info.getDegree());
            this.dateBirthday.setValue((Object)info.getBirthday());
            this.txtServiceYear.setText(String.valueOf(info.getServiceYear()));
            this.txtPosition.setText(info.getPosition());
            this.prmptPosition.setData((Object)info.getEposition());
            this.txtJobTitle.setText(info.getJobTitle());
            this.txtGraduateSchool.setText(info.getGraduateSchool());
            this.txtSpecialty.setText(info.getSpecialty());
            this.dateEnrollDate.setValue((Object)info.getEnrollDate());
            this.dateJobDate.setValue((Object)info.getJobStartDate());
            this.datePositionDate.setValue((Object)info.getPositionDate());
            this.dateRetireDate.setValue((Object)info.getRetireDate());
            this.txtRemark.setText(info.getRemark());
            this.comboRetireType.setSelectedItem((Object)info.getRetire());
            this.txtReason.setText(info.getReason());
            this.pInfo = info.getPerson();
            this.personId = this.pInfo.getId();
            this.entryId = info.getId();
            this.prmtNominalDept.setValue((Object)info.getNominalDept());
            this.actEntryId = info.getId();
            this.actPersonId = this.personId;
            if (this.editData.getId() != null) {
                this.billId = this.editData.getId().toString();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setIsMultiEntry(false);
        this.editData.setProposer(this.pInfo);
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        RetireBillEntryInfo info = null;
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            info = this.editData.getEntries().get(0);
        } else {
            info = new RetireBillEntryInfo();
            this.editData.getEntries().add(info);
        }
        info.setPerson(this.pInfo);
        if (this.comboGender.getSelectedItem() != null) {
            info.setGender((Genders)this.comboGender.getSelectedItem());
        }
        info.setBirthday((Date)this.dateBirthday.getValue());
        if (this.txtServiceYear.getText() != null && this.txtServiceYear.getText().trim().length() > 0) {
            info.setServiceYear(Integer.valueOf(this.txtServiceYear.getText()));
        }
        info.setIdCardNO(this.txtIDCardNO.getText());
        info.setPosition(this.txtPosition.getText());
        info.setEposition((PositionInfo)this.prmptPosition.getData());
        info.setJobTitle(this.txtJobTitle.getText());
        info.setGraduateSchool(this.txtGraduateSchool.getText());
        info.setDegree(this.txtDegree.getText());
        info.setSpecialty(this.txtSpecialty.getText());
        info.setPositionDate((Date)this.datePositionDate.getValue());
        info.setEnrollDate((Date)this.dateEnrollDate.getValue());
        if (this.dateJobDate.getValue() != null) {
            info.setJobStartDate((Date)this.dateJobDate.getValue());
        }
        info.setRetireDate((Date)this.dateRetireDate.getValue());
        info.setReason(this.txtReason.getText());
        if (this.comboRetireType.getSelectedItem() != null) {
            info.setRetire((EmployeeTypeInfo)this.comboRetireType.getSelectedItem());
        }
        if (this.entryId != null) {
            info.setId(this.entryId);
        }
        info.setRemark(this.txtRemark.getText());
        if (this.prmtNominalDept.getValue() != null) {
            info.setNominalDept((AdminOrgUnitInfo)this.prmtNominalDept.getValue());
        }
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (OprtState.VIEW.equals(this.getOprtState()) && this.editData.getBizState().equals((Object)HRAffairState.COMPLETE)) {
            if (versionStr != null) {
                if (versionStr.equals("hnjt")) {
                    this.btnAffairReg.setVisible(true);
                    this.btnAffairReg.setEnabled(true);
                } else {
                    this.btnAffairReg.setVisible(false);
                    this.btnAffairReg.setEnabled(true);
                }
            } else {
                this.btnAffairReg.setVisible(false);
                this.btnAffairReg.setEnabled(false);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.gender"));
        sic.add(new SelectorItemInfo("entries.retireDate"));
        sic.add(new SelectorItemInfo("entries.jobStartDate"));
        sic.add(new SelectorItemInfo("entries.retire.name"));
        sic.add(new SelectorItemInfo("entries.retire.id"));
        sic.add(new SelectorItemInfo("entries.phone"));
        sic.add(new SelectorItemInfo("entries.retireType"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.dept"));
        sic.add(new SelectorItemInfo("entries.position"));
        sic.add(new SelectorItemInfo("entries.jobTitle"));
        sic.add(new SelectorItemInfo("entries.idCardNO"));
        sic.add(new SelectorItemInfo("entries.birthday"));
        sic.add(new SelectorItemInfo("entries.graduateSchool"));
        sic.add(new SelectorItemInfo("entries.specialty"));
        sic.add(new SelectorItemInfo("entries.degree"));
        sic.add(new SelectorItemInfo("entries.enrollDate"));
        sic.add(new SelectorItemInfo("entries.positionDate"));
        sic.add(new SelectorItemInfo("entries.serviceYear"));
        sic.add(new SelectorItemInfo("entries.nominalDept.id"));
        sic.add(new SelectorItemInfo("entries.nominalDept.name"));
        sic.add(new SelectorItemInfo("entries.nominalDept.number"));
        sic.add(new SelectorItemInfo("entries.eposition.id"));
        sic.add(new SelectorItemInfo("entries.eposition.name"));
        sic.add(new SelectorItemInfo("entries.eposition.number"));
        return sic;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.comboRetireType.getSelectedItem() == null) {
            this.comboRetireType.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.RETIRE_TYPE_NOT_NULL);
        }
        if (this.promptOrg.getValue() == null) {
            this.promptOrg.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.NOMINALDEPT_NOT_NULL);
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().trim().length() == 0) {
            this.txtReason.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.RETIRE_REASON_NOT_NULL);
        }
        if (this.prmtNominalDept.getValue() == null) {
            this.prmtNominalDept.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.NOT_NULL, new Object[]{this.contNominalDept.getBoundLabelText()});
        }
        if (this.dateRetireDate.getValue() == null) {
            this.dateRetireDate.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.NOT_NULL, new Object[]{this.kDLabelContainer1.getBoundLabelText()});
        }
        if (HRAffairClientUtils.isDateBeforeEnrollDate(this.pInfo.getId().toString(), (Date)this.dateRetireDate.getValue())) {
            this.dateRetireDate.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.CAN_NOT_BEFORE_ENROLLDATE, new Object[]{this.lblRetireDate.getBoundLabelText(), ""});
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnCopySelect.setVisible(false);
        this.promptOrg.setEnabled(false);
    }

    protected void initOrgContextManager() {
    }

    @Override
    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        this.promptOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox((IUIObject)this));
        this.promptOrg.setEditable(false);
    }

    @Override
    public void onLoad() throws Exception {
        if (this.getOprtState() == null || "null".equalsIgnoreCase(this.getOprtState())) {
            this.setOprtState(OprtState.ADDNEW);
            this.getUIContext().put("ID", null);
        }
        this.comboGender.setModel((ComboBoxModel)HRAffairClientUtils.getGenderModel());
        EmployeeTypeCollection c = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection("select * where inService = 3");
        DefaultComboBoxModel<EmployeeTypeInfo> model = new DefaultComboBoxModel<EmployeeTypeInfo>();
        for (int i = 0; i < c.size(); ++i) {
            model.addElement(c.get(i));
        }
        if (c.size() != 0) {
            model.setSelectedItem(c.get(0));
        }
        this.comboRetireType.setModel(model);
        this.kdtEntries.setVisible(false);
        AdminByCurrentHROF7WithOrgRangeFilter f7 = new AdminByCurrentHROF7WithOrgRangeFilter((IUIObject)this);
        int param = CustomerSettingsSwitch.getInstance().getFunctionParamValue("RETIRE_BILL");
        if (0 == param) {
            f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        }
        this.prmtNominalDept.setSelector((KDPromptSelector)f7);
        this.prmtNominalDept.setEditable(false);
        super.onLoad();
        if (null == this.editData.getId()) {
            this.actionRemove.setEnabled(false);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            PersonPositionInfo ppInfo;
            HRAffairClientUtils.checkIsPersonInProcess(this.editData.getBOSType(), new RetireBillEntryInfo().getBOSType(), this.pInfo, "");
            String personId = this.pInfo.getId().toString();
            this.dateBirthday.setValue((Object)this.pInfo.getBirthday());
            this.txtIDCardNO.setText(this.pInfo.getIdCardNO());
            this.comboGender.setSelectedItem((Object)this.pInfo.getGender());
            ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(personId);
            if (degreeRelInfo != null) {
                this.txtDegree.setText((String)degreeRelInfo.get(0));
                this.txtGraduateSchool.setText((String)degreeRelInfo.get(1));
                this.txtSpecialty.setText((String)degreeRelInfo.get(2));
            }
            if ((ppInfo = HRAffairClientUtils.getPersonPositionInfo(personId)) != null && ppInfo.getEnterDate() != null) {
                this.dateEnrollDate.setValue((Object)ppInfo.getEnterDate());
                this.txtServiceYear.setText(HRAffairClientUtils.getYearDif(ppInfo.getEnterDate(), new Date()).toString());
            } else {
                this.dateEnrollDate.setValue(null);
            }
            if (ppInfo != null && ppInfo.getJobStartDate() != null) {
                this.dateJobDate.setValue((Object)ppInfo.getJobStartDate());
            } else {
                this.dateJobDate.setValue(null);
            }
            if (this.postRelInfo != null) {
                if (this.postRelInfo.getPosition() != null) {
                    this.txtPosition.setText(this.postRelInfo.getPosition().getName());
                    this.prmptPosition.setData((Object)this.postRelInfo.getPosition());
                }
                this.datePositionDate.setValue((Object)this.postRelInfo.getBeginDate());
                TechnicalPostInfo jobTitleInfo = HRAffairClientUtils.getJobTitle(personId);
                if (jobTitleInfo != null) {
                    this.txtJobTitle.setText(jobTitleInfo.getName());
                }
            }
        }
        this.kdtEntries.setColumnMoveable(true);
        this.setComboSubmitTypeValueByParam("Ret001");
    }

    public IObjectPK runSubmit() throws Exception {
        return ((IRetireBill)this.getBizInterface()).submit2((CoreBaseInfo)this.editData);
    }

    @Override
    protected BOSObjectType getBillBOSType() {
        return new RetireBillInfo().getBOSType();
    }

    @Override
    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.actPersonId != null && this.actEntryId != null && this.billId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(RETIRE_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.deleteFlag) {
            this.getUIWindow().close();
        }
    }

    @Override
    protected boolean confirmRemove() {
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            this.deleteFlag = true;
            return true;
        }
        this.deleteFlag = false;
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.put("kdtIsVisible", (Object)this.kdtEntries.isVisible());
        request.put("nowClientDate", (Object)this.nowDate);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    protected void handlePermissionForItemAction(ItemAction action) {
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                if (RetireBillSelfEditUI.this.billId != null) {
                    IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                    if (ds.getID() != null) {
                        if (ds.getID().equals("ds8")) {
                            return iAffairReg.getAffairBillRegByEntry(AffairTypeEnum.RETIRE, RetireBillSelfEditUI.this.actEntryId, BOSUuid.read((String)RetireBillSelfEditUI.this.billId));
                        }
                        if (ds.getID().equals("ds9")) {
                            return iAffairReg.getMultiApproveDecByPerson(AffairTypeEnum.RETIRE, RetireBillSelfEditUI.this.actPersonId, BOSUuid.read((String)RetireBillSelfEditUI.this.billId));
                        }
                    }
                }
            }
            catch (BOSException e) {
                RetireBillSelfEditUI.this.handUIException(e);
            }
            catch (EASBizException e) {
                RetireBillSelfEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

